# mypy-boto3-ec2-instance-connect

[![PyPI - mypy-boto3-ec2-instance-connect](https://img.shields.io/pypi/v/mypy-boto3-ec2-instance-connect.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2-instance-connect)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2-instance-connect.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2-instance-connect)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.EC2InstanceConnect 1.15.5](https://boto3.amazonaws.com/v1/documentation/api/1.15.5/reference/services/ec2-instance-connect.html#EC2InstanceConnect) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ec2-instance-connect](#mypy-boto3-ec2-instance-connect)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `EC2InstanceConnect` service.

```bash
python -m pip install boto3-stubs[ec2-instance-connect]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ec2-instance-connect]` in your environment: `python -m pip install 'boto3-stubs[ec2-instance-connect]'`

Both type checking and auto-complete should work for `EC2InstanceConnect` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[ec2-instance-connect]` in your environment: `python -m pip install 'boto3-stubs[ec2-instance-connect]'`

Both type checking and auto-complete should work for `EC2InstanceConnect` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ec2-instance-connect]` in your environment: `python -m pip install 'boto3-stubs[ec2-instance-connect]'`
- Run `mypy` as usual

Type checking should work for `EC2InstanceConnect` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ec2-instance-connect]` in your environment: `python -m pip install 'boto3-stubs[ec2-instance-connect]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `EC2InstanceConnect` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`EC2InstanceConnectClient` provides annotations for `boto3.client("ec2-instance-connect")`.

```python
import boto3

from mypy_boto3_ec2_instance_connect import EC2InstanceConnectClient

client: EC2InstanceConnectClient = boto3.client("ec2-instance-connect")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EC2InstanceConnectClient = session.client("ec2-instance-connect")
```








### Typed dictionations

`mypy_boto3_ec2_instance_connect.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_ec2_instance_connect.type_defs import SendSSHPublicKeyResponseTypeDef

def get_structure() -> SendSSHPublicKeyResponseTypeDef:
    return {
      ...
    }
```
