# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import awsx as _awsx
import pulumi_aws

__all__ = [
    'EC2ServiceTaskDefinitionArgs',
    'FargateServiceTaskDefinitionArgs',
    'TaskDefinitionContainerDefinitionArgs',
    'TaskDefinitionContainerDependencyArgs',
    'TaskDefinitionDeviceArgs',
    'TaskDefinitionEnvironmentFileArgs',
    'TaskDefinitionFirelensConfigurationArgs',
    'TaskDefinitionHealthCheckArgs',
    'TaskDefinitionHostEntryArgs',
    'TaskDefinitionKernelCapabilitiesArgs',
    'TaskDefinitionKeyValuePairArgs',
    'TaskDefinitionLinuxParametersArgs',
    'TaskDefinitionLogConfigurationArgs',
    'TaskDefinitionMountPointArgs',
    'TaskDefinitionPortMappingArgs',
    'TaskDefinitionRepositoryCredentialsArgs',
    'TaskDefinitionResourceRequirementArgs',
    'TaskDefinitionSecretArgs',
    'TaskDefinitionSystemControlArgs',
    'TaskDefinitionTmpfsArgs',
    'TaskDefinitionUlimitArgs',
    'TaskDefinitionVolumeFromArgs',
]

@pulumi.input_type
class EC2ServiceTaskDefinitionArgs:
    def __init__(__self__, *,
                 container: Optional['TaskDefinitionContainerDefinitionArgs'] = None,
                 containers: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']] = None,
                 cpu: Optional[pulumi.Input[str]] = None,
                 ephemeral_storage: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']] = None,
                 execution_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 log_group: Optional['_awsx.DefaultLogGroupArgs'] = None,
                 memory: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]] = None,
                 proxy_configuration: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']] = None,
                 runtime_platform: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]] = None):
        """
        Create a TaskDefinition resource with the given unique name, arguments, and options.
        Creates required log-group and task & execution roles.
        Presents required Service load balancers if target group included in port mappings.
        :param 'TaskDefinitionContainerDefinitionArgs' container: Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
               multiple containers, especially when creating a TaskDefinition to call [run] on.
               
               Either [container] or [containers] must be provided.
        :param Mapping[str, 'TaskDefinitionContainerDefinitionArgs'] containers: All the containers to make a TaskDefinition from.  Useful when creating a Service that will
               contain many containers within.
               
               Either [container] or [containers] must be provided.
        :param pulumi.Input[str] cpu: The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        :param '_awsx.DefaultRoleWithPolicyArgs' execution_role: The execution role that the Amazon ECS container agent and the Docker daemon can assume.
               Will be created automatically if not defined.
        :param pulumi.Input[str] family: An optional unique name for your task definition. If not specified, then a default will be created.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]] inference_accelerators: Configuration block(s) with Inference Accelerators settings. Detailed below.
        :param pulumi.Input[str] ipc_mode: IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        :param '_awsx.DefaultLogGroupArgs' log_group: A set of volume blocks that containers in your task may use.
        :param pulumi.Input[str] memory: The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
               based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input[str] network_mode: Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
        :param pulumi.Input[str] pid_mode: Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]] placement_constraints: Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs'] proxy_configuration: Configuration block for the App Mesh proxy. Detailed below.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs'] runtime_platform: Configuration block for runtime_platform that containers in your task may use.
        :param pulumi.Input[bool] skip_destroy: Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param '_awsx.DefaultRoleWithPolicyArgs' task_role: IAM role that allows your Amazon ECS container task to make calls to other AWS services.
               Will be created automatically if not defined.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]] volumes: Configuration block for volumes that containers in your task may use. Detailed below.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if inference_accelerators is not None:
            pulumi.set(__self__, "inference_accelerators", inference_accelerators)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_role is not None:
            pulumi.set(__self__, "task_role", task_role)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def container(self) -> Optional['TaskDefinitionContainerDefinitionArgs']:
        """
        Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
        multiple containers, especially when creating a TaskDefinition to call [run] on.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional['TaskDefinitionContainerDefinitionArgs']):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]:
        """
        All the containers to make a TaskDefinition from.  Useful when creating a Service that will
        contain many containers within.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        The execution role that the Amazon ECS container agent and the Docker daemon can assume.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        An optional unique name for your task definition. If not specified, then a default will be created.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]]]:
        """
        Configuration block(s) with Inference Accelerators settings. Detailed below.
        """
        return pulumi.get(self, "inference_accelerators")

    @inference_accelerators.setter
    def inference_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]]]):
        pulumi.set(self, "inference_accelerators", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[str]]:
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional['_awsx.DefaultLogGroupArgs']:
        """
        A set of volume blocks that containers in your task may use.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional['_awsx.DefaultLogGroupArgs']):
        pulumi.set(self, "log_group", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
        based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]:
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]:
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]:
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskRole")
    def task_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "task_role")

    @task_role.setter
    def task_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "task_role", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]:
        """
        Configuration block for volumes that containers in your task may use. Detailed below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class FargateServiceTaskDefinitionArgs:
    def __init__(__self__, *,
                 container: Optional['TaskDefinitionContainerDefinitionArgs'] = None,
                 containers: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']] = None,
                 cpu: Optional[pulumi.Input[str]] = None,
                 ephemeral_storage: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']] = None,
                 execution_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 log_group: Optional['_awsx.DefaultLogGroupArgs'] = None,
                 memory: Optional[pulumi.Input[str]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]] = None,
                 proxy_configuration: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']] = None,
                 runtime_platform: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_role: Optional['_awsx.DefaultRoleWithPolicyArgs'] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]] = None):
        """
        Create a TaskDefinition resource with the given unique name, arguments, and options.
        Creates required log-group and task & execution roles.
        Presents required Service load balancers if target group included in port mappings.
        :param 'TaskDefinitionContainerDefinitionArgs' container: Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
               multiple containers, especially when creating a TaskDefinition to call [run] on.
               
               Either [container] or [containers] must be provided.
        :param Mapping[str, 'TaskDefinitionContainerDefinitionArgs'] containers: All the containers to make a TaskDefinition from.  Useful when creating a Service that will
               contain many containers within.
               
               Either [container] or [containers] must be provided.
        :param pulumi.Input[str] cpu: The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs'] ephemeral_storage: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        :param '_awsx.DefaultRoleWithPolicyArgs' execution_role: The execution role that the Amazon ECS container agent and the Docker daemon can assume.
               Will be created automatically if not defined.
        :param pulumi.Input[str] family: An optional unique name for your task definition. If not specified, then a default will be created.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]] inference_accelerators: Configuration block(s) with Inference Accelerators settings. Detailed below.
        :param pulumi.Input[str] ipc_mode: IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        :param '_awsx.DefaultLogGroupArgs' log_group: A set of volume blocks that containers in your task may use.
        :param pulumi.Input[str] memory: The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
               based on the cumulative needs specified by [containerDefinitions]
        :param pulumi.Input[str] pid_mode: Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]] placement_constraints: Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs'] proxy_configuration: Configuration block for the App Mesh proxy. Detailed below.
        :param pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs'] runtime_platform: Configuration block for runtime_platform that containers in your task may use.
        :param pulumi.Input[bool] skip_destroy: Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param '_awsx.DefaultRoleWithPolicyArgs' task_role: IAM role that allows your Amazon ECS container task to make calls to other AWS services.
               Will be created automatically if not defined.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]] volumes: Configuration block for volumes that containers in your task may use. Detailed below.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if inference_accelerators is not None:
            pulumi.set(__self__, "inference_accelerators", inference_accelerators)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_role is not None:
            pulumi.set(__self__, "task_role", task_role)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def container(self) -> Optional['TaskDefinitionContainerDefinitionArgs']:
        """
        Single container to make a TaskDefinition from.  Useful for simple cases where there aren't
        multiple containers, especially when creating a TaskDefinition to call [run] on.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional['TaskDefinitionContainerDefinitionArgs']):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]:
        """
        All the containers to make a TaskDefinition from.  Useful when creating a Service that will
        contain many containers within.

        Either [container] or [containers] must be provided.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[Mapping[str, 'TaskDefinitionContainerDefinitionArgs']]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        The number of cpu units used by the task. If not provided, a default will be computed based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        The execution role that the Amazon ECS container agent and the Docker daemon can assume.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        An optional unique name for your task definition. If not specified, then a default will be created.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]]]:
        """
        Configuration block(s) with Inference Accelerators settings. Detailed below.
        """
        return pulumi.get(self, "inference_accelerators")

    @inference_accelerators.setter
    def inference_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionInferenceAcceleratorArgs']]]]):
        pulumi.set(self, "inference_accelerators", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[str]]:
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional['_awsx.DefaultLogGroupArgs']:
        """
        A set of volume blocks that containers in your task may use.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional['_awsx.DefaultLogGroupArgs']):
        pulumi.set(self, "log_group", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        The amount (in MiB) of memory used by the task.  If not provided, a default will be computed
        based on the cumulative needs specified by [containerDefinitions]
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]:
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]:
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]:
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['pulumi_aws.ecs.TaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to retain the old revision when the resource is destroyed or replacement is necessary. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskRole")
    def task_role(self) -> Optional['_awsx.DefaultRoleWithPolicyArgs']:
        """
        IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        Will be created automatically if not defined.
        """
        return pulumi.get(self, "task_role")

    @task_role.setter
    def task_role(self, value: Optional['_awsx.DefaultRoleWithPolicyArgs']):
        pulumi.set(self, "task_role", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]:
        """
        Configuration block for volumes that containers in your task may use. Detailed below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ecs.TaskDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class TaskDefinitionContainerDefinitionArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 depends_on: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgs']]]] = None,
                 disable_networking: Optional[pulumi.Input[bool]] = None,
                 dns_search_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 docker_labels: Optional[Any] = None,
                 docker_security_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 entry_point: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]]] = None,
                 environment_files: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]]] = None,
                 essential: Optional[pulumi.Input[bool]] = None,
                 extra_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgs']]]] = None,
                 firelens_configuration: Optional[pulumi.Input['TaskDefinitionFirelensConfigurationArgs']] = None,
                 health_check: Optional[pulumi.Input['TaskDefinitionHealthCheckArgs']] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 interactive: Optional[pulumi.Input[bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 linux_parameters: Optional[pulumi.Input['TaskDefinitionLinuxParametersArgs']] = None,
                 log_configuration: Optional[pulumi.Input['TaskDefinitionLogConfigurationArgs']] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 memory_reservation: Optional[pulumi.Input[int]] = None,
                 mount_points: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]]] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 pseudo_terminal: Optional[pulumi.Input[bool]] = None,
                 readonly_root_filesystem: Optional[pulumi.Input[bool]] = None,
                 repository_credentials: Optional[pulumi.Input['TaskDefinitionRepositoryCredentialsArgs']] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgs']]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]] = None,
                 start_timeout: Optional[pulumi.Input[int]] = None,
                 stop_timeout: Optional[pulumi.Input[int]] = None,
                 system_controls: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgs']]]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgs']]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 volumes_from: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgs']]]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None):
        """
        List of container definitions that are passed to the Docker daemon on a container instance
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]] environment: The environment variables to pass to a container
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]] environment_files: The list of one or more files that contain the environment variables to pass to a container
        :param pulumi.Input[str] image: The image used to start a container. This string is passed directly to the Docker daemon.
        :param pulumi.Input[int] memory: The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        :param pulumi.Input[str] name: The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]] port_mappings: Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if disable_networking is not None:
            pulumi.set(__self__, "disable_networking", disable_networking)
        if dns_search_domains is not None:
            pulumi.set(__self__, "dns_search_domains", dns_search_domains)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if docker_labels is not None:
            pulumi.set(__self__, "docker_labels", docker_labels)
        if docker_security_options is not None:
            pulumi.set(__self__, "docker_security_options", docker_security_options)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_files is not None:
            pulumi.set(__self__, "environment_files", environment_files)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if firelens_configuration is not None:
            pulumi.set(__self__, "firelens_configuration", firelens_configuration)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if interactive is not None:
            pulumi.set(__self__, "interactive", interactive)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_mappings is not None:
            pulumi.set(__self__, "port_mappings", port_mappings)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if pseudo_terminal is not None:
            pulumi.set(__self__, "pseudo_terminal", pseudo_terminal)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if start_timeout is not None:
            pulumi.set(__self__, "start_timeout", start_timeout)
        if stop_timeout is not None:
            pulumi.set(__self__, "stop_timeout", stop_timeout)
        if system_controls is not None:
            pulumi.set(__self__, "system_controls", system_controls)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if volumes_from is not None:
            pulumi.set(__self__, "volumes_from", volumes_from)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgs']]]]:
        return pulumi.get(self, "depends_on")

    @depends_on.setter
    def depends_on(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDependencyArgs']]]]):
        pulumi.set(self, "depends_on", value)

    @property
    @pulumi.getter(name="disableNetworking")
    def disable_networking(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "disable_networking")

    @disable_networking.setter
    def disable_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_networking", value)

    @property
    @pulumi.getter(name="dnsSearchDomains")
    def dns_search_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "dns_search_domains")

    @dns_search_domains.setter
    def dns_search_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_search_domains", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="dockerLabels")
    def docker_labels(self) -> Optional[Any]:
        return pulumi.get(self, "docker_labels")

    @docker_labels.setter
    def docker_labels(self, value: Optional[Any]):
        pulumi.set(self, "docker_labels", value)

    @property
    @pulumi.getter(name="dockerSecurityOptions")
    def docker_security_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "docker_security_options")

    @docker_security_options.setter
    def docker_security_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "docker_security_options", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]]]:
        """
        The environment variables to pass to a container
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionKeyValuePairArgs']]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="environmentFiles")
    def environment_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]]]:
        """
        The list of one or more files that contain the environment variables to pass to a container
        """
        return pulumi.get(self, "environment_files")

    @environment_files.setter
    def environment_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionEnvironmentFileArgs']]]]):
        pulumi.set(self, "environment_files", value)

    @property
    @pulumi.getter
    def essential(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "essential")

    @essential.setter
    def essential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "essential", value)

    @property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgs']]]]:
        return pulumi.get(self, "extra_hosts")

    @extra_hosts.setter
    def extra_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionHostEntryArgs']]]]):
        pulumi.set(self, "extra_hosts", value)

    @property
    @pulumi.getter(name="firelensConfiguration")
    def firelens_configuration(self) -> Optional[pulumi.Input['TaskDefinitionFirelensConfigurationArgs']]:
        return pulumi.get(self, "firelens_configuration")

    @firelens_configuration.setter
    def firelens_configuration(self, value: Optional[pulumi.Input['TaskDefinitionFirelensConfigurationArgs']]):
        pulumi.set(self, "firelens_configuration", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['TaskDefinitionHealthCheckArgs']]:
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['TaskDefinitionHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The image used to start a container. This string is passed directly to the Docker daemon.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def interactive(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "interactive")

    @interactive.setter
    def interactive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "interactive", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional[pulumi.Input['TaskDefinitionLinuxParametersArgs']]:
        return pulumi.get(self, "linux_parameters")

    @linux_parameters.setter
    def linux_parameters(self, value: Optional[pulumi.Input['TaskDefinitionLinuxParametersArgs']]):
        pulumi.set(self, "linux_parameters", value)

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['TaskDefinitionLogConfigurationArgs']]:
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['TaskDefinitionLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[int]]:
        """
        The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_reservation", value)

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgs']]]]:
        return pulumi.get(self, "mount_points")

    @mount_points.setter
    def mount_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionMountPointArgs']]]]):
        pulumi.set(self, "mount_points", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a container. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]]]:
        """
        Port mappings allow containers to access ports on the host container instance to send or receive traffic.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPortMappingArgs']]]]):
        pulumi.set(self, "port_mappings", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="pseudoTerminal")
    def pseudo_terminal(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "pseudo_terminal")

    @pseudo_terminal.setter
    def pseudo_terminal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pseudo_terminal", value)

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "readonly_root_filesystem")

    @readonly_root_filesystem.setter
    def readonly_root_filesystem(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "readonly_root_filesystem", value)

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional[pulumi.Input['TaskDefinitionRepositoryCredentialsArgs']]:
        return pulumi.get(self, "repository_credentials")

    @repository_credentials.setter
    def repository_credentials(self, value: Optional[pulumi.Input['TaskDefinitionRepositoryCredentialsArgs']]):
        pulumi.set(self, "repository_credentials", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgs']]]]:
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]:
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="startTimeout")
    def start_timeout(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "start_timeout")

    @start_timeout.setter
    def start_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_timeout", value)

    @property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "stop_timeout")

    @stop_timeout.setter
    def stop_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stop_timeout", value)

    @property
    @pulumi.getter(name="systemControls")
    def system_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgs']]]]:
        return pulumi.get(self, "system_controls")

    @system_controls.setter
    def system_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSystemControlArgs']]]]):
        pulumi.set(self, "system_controls", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgs']]]]:
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="volumesFrom")
    def volumes_from(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgs']]]]:
        return pulumi.get(self, "volumes_from")

    @volumes_from.setter
    def volumes_from(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeFromArgs']]]]):
        pulumi.set(self, "volumes_from", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class TaskDefinitionContainerDependencyArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None):
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)


@pulumi.input_type
class TaskDefinitionDeviceArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[str]] = None,
                 host_path: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class TaskDefinitionEnvironmentFileArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskDefinitionFirelensConfigurationArgs:
    def __init__(__self__, *,
                 options: Optional[Any] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if options is not None:
            pulumi.set(__self__, "options", options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[Any]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TaskDefinitionHealthCheckArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 start_period: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The health check command and associated configuration parameters for the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: A string array representing the command that the container runs to determine if it is healthy.
        :param pulumi.Input[int] interval: The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        :param pulumi.Input[int] retries: The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        :param pulumi.Input[int] start_period: The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        :param pulumi.Input[int] timeout: The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is three retries.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[pulumi.Input[int]]:
        """
        The optional grace period within which to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You may specify between 0 and 300 seconds. The startPeriod is disabled by default.
        """
        return pulumi.get(self, "start_period")

    @start_period.setter
    def start_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_period", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class TaskDefinitionHostEntryArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None):
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class TaskDefinitionKernelCapabilitiesArgs:
    def __init__(__self__, *,
                 add: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drop: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "add")

    @add.setter
    def add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "add", value)

    @property
    @pulumi.getter
    def drop(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "drop")

    @drop.setter
    def drop(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drop", value)


@pulumi.input_type
class TaskDefinitionKeyValuePairArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskDefinitionLinuxParametersArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input['TaskDefinitionKernelCapabilitiesArgs']] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgs']]]] = None,
                 init_process_enabled: Optional[pulumi.Input[bool]] = None,
                 max_swap: Optional[pulumi.Input[int]] = None,
                 shared_memory_size: Optional[pulumi.Input[int]] = None,
                 swappiness: Optional[pulumi.Input[int]] = None,
                 tmpfs: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgs']]]] = None):
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if init_process_enabled is not None:
            pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        if max_swap is not None:
            pulumi.set(__self__, "max_swap", max_swap)
        if shared_memory_size is not None:
            pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        if swappiness is not None:
            pulumi.set(__self__, "swappiness", swappiness)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['TaskDefinitionKernelCapabilitiesArgs']]:
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['TaskDefinitionKernelCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgs']]]]:
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "init_process_enabled")

    @init_process_enabled.setter
    def init_process_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "init_process_enabled", value)

    @property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_swap")

    @max_swap.setter
    def max_swap(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_swap", value)

    @property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "shared_memory_size")

    @shared_memory_size.setter
    def shared_memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shared_memory_size", value)

    @property
    @pulumi.getter
    def swappiness(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "swappiness")

    @swappiness.setter
    def swappiness(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "swappiness", value)

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgs']]]]:
        return pulumi.get(self, "tmpfs")

    @tmpfs.setter
    def tmpfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionTmpfsArgs']]]]):
        pulumi.set(self, "tmpfs", value)


@pulumi.input_type
class TaskDefinitionLogConfigurationArgs:
    def __init__(__self__, *,
                 log_driver: pulumi.Input[str],
                 options: Optional[Any] = None,
                 secret_options: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]] = None):
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> pulumi.Input[str]:
        return pulumi.get(self, "log_driver")

    @log_driver.setter
    def log_driver(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_driver", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[Any]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]:
        return pulumi.get(self, "secret_options")

    @secret_options.setter
    def secret_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionSecretArgs']]]]):
        pulumi.set(self, "secret_options", value)


@pulumi.input_type
class TaskDefinitionMountPointArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 source_volume: Optional[pulumi.Input[str]] = None):
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_volume")

    @source_volume.setter
    def source_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_volume", value)


@pulumi.input_type
class TaskDefinitionPortMappingArgs:
    def __init__(__self__, *,
                 container_port: Optional[pulumi.Input[int]] = None,
                 host_port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 target_group: Optional[pulumi.Input['pulumi_aws.lb.TargetGroup']] = None):
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if target_group is not None:
            pulumi.set(__self__, "target_group", target_group)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "host_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="targetGroup")
    def target_group(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroup']]:
        return pulumi.get(self, "target_group")

    @target_group.setter
    def target_group(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroup']]):
        pulumi.set(self, "target_group", value)


@pulumi.input_type
class TaskDefinitionRepositoryCredentialsArgs:
    def __init__(__self__, *,
                 credentials_parameter: Optional[pulumi.Input[str]] = None):
        if credentials_parameter is not None:
            pulumi.set(__self__, "credentials_parameter", credentials_parameter)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "credentials_parameter")

    @credentials_parameter.setter
    def credentials_parameter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_parameter", value)


@pulumi.input_type
class TaskDefinitionResourceRequirementArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskDefinitionSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value_from: pulumi.Input[str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value_from")

    @value_from.setter
    def value_from(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_from", value)


@pulumi.input_type
class TaskDefinitionSystemControlArgs:
    def __init__(__self__, *,
                 namespace: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskDefinitionTmpfsArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 container_path: Optional[pulumi.Input[str]] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        pulumi.set(__self__, "size", size)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)


@pulumi.input_type
class TaskDefinitionUlimitArgs:
    def __init__(__self__, *,
                 hard_limit: pulumi.Input[int],
                 name: pulumi.Input[str],
                 soft_limit: pulumi.Input[int]):
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> pulumi.Input[int]:
        return pulumi.get(self, "hard_limit")

    @hard_limit.setter
    def hard_limit(self, value: pulumi.Input[int]):
        pulumi.set(self, "hard_limit", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> pulumi.Input[int]:
        return pulumi.get(self, "soft_limit")

    @soft_limit.setter
    def soft_limit(self, value: pulumi.Input[int]):
        pulumi.set(self, "soft_limit", value)


@pulumi.input_type
class TaskDefinitionVolumeFromArgs:
    def __init__(__self__, *,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 source_container: Optional[pulumi.Input[str]] = None):
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_container is not None:
            pulumi.set(__self__, "source_container", source_container)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="sourceContainer")
    def source_container(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_container")

    @source_container.setter
    def source_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_container", value)


