# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: api/enterprise/enterprise.proto
# plugin: python-betterproto
# This file has been @generated
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpc


if TYPE_CHECKING:
    import grpc


class State(betterproto.Enum):
    NONE = 0
    ACTIVE = 1
    EXPIRED = 2
    HEARTBEAT_FAILED = 3


class PauseStatusResponsePauseStatus(betterproto.Enum):
    UNPAUSED = 0
    PARTIALLY_PAUSED = 1
    PAUSED = 2


@dataclass(eq=False, repr=False)
class LicenseRecord(betterproto.Message):
    """
    LicenseRecord is the record we store in etcd for a Pachyderm enterprise
    token that has been provided to a Pachyderm license server
    """

    activation_code: str = betterproto.string_field(1)
    expires: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EnterpriseConfig(betterproto.Message):
    """
    EnterpriseConfig is the configuration we store for heartbeating to the
    license server.
    """

    license_server: str = betterproto.string_field(1)
    """license_server is the address of the grpc license service"""

    id: str = betterproto.string_field(2)
    """
    id is the unique identifier for this pachd, which is registered with the
    license service
    """

    secret: str = betterproto.string_field(3)
    """secret is a shared secret between this pachd and the license service"""


@dataclass(eq=False, repr=False)
class EnterpriseRecord(betterproto.Message):
    """
    EnterpriseRecord is a protobuf we cache in etcd to store the enterprise
    status.
    """

    license: "LicenseRecord" = betterproto.message_field(1)
    """
    license is the cached LicenseRecord retrieved from the most recent
    heartbeat to the license server.
    """

    last_heartbeat: datetime = betterproto.message_field(2)
    """
    last_heartbeat is the timestamp of the last successful heartbeat to the
    license server
    """

    heartbeat_failed: bool = betterproto.bool_field(3)
    """
    heartbeat_failed is set if the license is still valid, but the pachd is no
    longer registered with an enterprise server. This is the same as the
    expired state, where auth is locked but not disabled.
    """


@dataclass(eq=False, repr=False)
class TokenInfo(betterproto.Message):
    """
    TokenInfo contains information about the currently active enterprise token
    """

    expires: datetime = betterproto.message_field(1)
    """
    expires indicates when the current token expires (unset if there is no
    current token)
    """


@dataclass(eq=False, repr=False)
class ActivateRequest(betterproto.Message):
    license_server: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    secret: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ActivateResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetStateRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetStateResponse(betterproto.Message):
    state: "State" = betterproto.enum_field(1)
    info: "TokenInfo" = betterproto.message_field(2)
    activation_code: str = betterproto.string_field(3)
    """
    activation_code will always be an empty string, call GetEnterpriseCode to
    get the activation code
    """


@dataclass(eq=False, repr=False)
class GetActivationCodeRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetActivationCodeResponse(betterproto.Message):
    state: "State" = betterproto.enum_field(1)
    info: "TokenInfo" = betterproto.message_field(2)
    activation_code: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class HeartbeatRequest(betterproto.Message):
    """
    Heartbeat in the enterprise service just triggers a heartbeat for testing
    purposes. The RPC used to communicate with the license service is defined
    in the license service.
    """

    pass


@dataclass(eq=False, repr=False)
class HeartbeatResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeactivateRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeactivateResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class PauseRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class PauseResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UnpauseRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UnpauseResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class PauseStatusRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class PauseStatusResponse(betterproto.Message):
    status: "PauseStatusResponsePauseStatus" = betterproto.enum_field(1)


class ApiStub:
    def __init__(self, channel: "grpc.Channel"):
        self.__rpc_activate = channel.unary_unary(
            "/enterprise_v2.API/Activate",
            request_serializer=ActivateRequest.SerializeToString,
            response_deserializer=ActivateResponse.FromString,
        )
        self.__rpc_get_state = channel.unary_unary(
            "/enterprise_v2.API/GetState",
            request_serializer=GetStateRequest.SerializeToString,
            response_deserializer=GetStateResponse.FromString,
        )
        self.__rpc_get_activation_code = channel.unary_unary(
            "/enterprise_v2.API/GetActivationCode",
            request_serializer=GetActivationCodeRequest.SerializeToString,
            response_deserializer=GetActivationCodeResponse.FromString,
        )
        self.__rpc_heartbeat = channel.unary_unary(
            "/enterprise_v2.API/Heartbeat",
            request_serializer=HeartbeatRequest.SerializeToString,
            response_deserializer=HeartbeatResponse.FromString,
        )
        self.__rpc_deactivate = channel.unary_unary(
            "/enterprise_v2.API/Deactivate",
            request_serializer=DeactivateRequest.SerializeToString,
            response_deserializer=DeactivateResponse.FromString,
        )
        self.__rpc_pause = channel.unary_unary(
            "/enterprise_v2.API/Pause",
            request_serializer=PauseRequest.SerializeToString,
            response_deserializer=PauseResponse.FromString,
        )
        self.__rpc_unpause = channel.unary_unary(
            "/enterprise_v2.API/Unpause",
            request_serializer=UnpauseRequest.SerializeToString,
            response_deserializer=UnpauseResponse.FromString,
        )
        self.__rpc_pause_status = channel.unary_unary(
            "/enterprise_v2.API/PauseStatus",
            request_serializer=PauseStatusRequest.SerializeToString,
            response_deserializer=PauseStatusResponse.FromString,
        )

    def activate(
        self, *, license_server: str = "", id: str = "", secret: str = ""
    ) -> "ActivateResponse":
        request = ActivateRequest()
        request.license_server = license_server
        request.id = id
        request.secret = secret

        return self.__rpc_activate(request)

    def get_state(self) -> "GetStateResponse":
        request = GetStateRequest()

        return self.__rpc_get_state(request)

    def get_activation_code(self) -> "GetActivationCodeResponse":
        request = GetActivationCodeRequest()

        return self.__rpc_get_activation_code(request)

    def heartbeat(self) -> "HeartbeatResponse":
        request = HeartbeatRequest()

        return self.__rpc_heartbeat(request)

    def deactivate(self) -> "DeactivateResponse":
        request = DeactivateRequest()

        return self.__rpc_deactivate(request)

    def pause(self) -> "PauseResponse":
        request = PauseRequest()

        return self.__rpc_pause(request)

    def unpause(self) -> "UnpauseResponse":
        request = UnpauseRequest()

        return self.__rpc_unpause(request)

    def pause_status(self) -> "PauseStatusResponse":
        request = PauseStatusRequest()

        return self.__rpc_pause_status(request)


class ApiBase:
    def activate(
        self, license_server: str, id: str, secret: str, context: "grpc.ServicerContext"
    ) -> "ActivateResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_state(self, context: "grpc.ServicerContext") -> "GetStateResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def get_activation_code(
        self, context: "grpc.ServicerContext"
    ) -> "GetActivationCodeResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def heartbeat(self, context: "grpc.ServicerContext") -> "HeartbeatResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def deactivate(self, context: "grpc.ServicerContext") -> "DeactivateResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def pause(self, context: "grpc.ServicerContext") -> "PauseResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def unpause(self, context: "grpc.ServicerContext") -> "UnpauseResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def pause_status(self, context: "grpc.ServicerContext") -> "PauseStatusResponse":
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    __proto_path__ = "enterprise_v2.API"

    @property
    def __rpc_methods__(self):
        return {
            "Activate": grpc.unary_unary_rpc_method_handler(
                self.activate,
                request_deserializer=ActivateRequest.FromString,
                response_serializer=ActivateRequest.SerializeToString,
            ),
            "GetState": grpc.unary_unary_rpc_method_handler(
                self.get_state,
                request_deserializer=GetStateRequest.FromString,
                response_serializer=GetStateRequest.SerializeToString,
            ),
            "GetActivationCode": grpc.unary_unary_rpc_method_handler(
                self.get_activation_code,
                request_deserializer=GetActivationCodeRequest.FromString,
                response_serializer=GetActivationCodeRequest.SerializeToString,
            ),
            "Heartbeat": grpc.unary_unary_rpc_method_handler(
                self.heartbeat,
                request_deserializer=HeartbeatRequest.FromString,
                response_serializer=HeartbeatRequest.SerializeToString,
            ),
            "Deactivate": grpc.unary_unary_rpc_method_handler(
                self.deactivate,
                request_deserializer=DeactivateRequest.FromString,
                response_serializer=DeactivateRequest.SerializeToString,
            ),
            "Pause": grpc.unary_unary_rpc_method_handler(
                self.pause,
                request_deserializer=PauseRequest.FromString,
                response_serializer=PauseRequest.SerializeToString,
            ),
            "Unpause": grpc.unary_unary_rpc_method_handler(
                self.unpause,
                request_deserializer=UnpauseRequest.FromString,
                response_serializer=UnpauseRequest.SerializeToString,
            ),
            "PauseStatus": grpc.unary_unary_rpc_method_handler(
                self.pause_status,
                request_deserializer=PauseStatusRequest.FromString,
                response_serializer=PauseStatusRequest.SerializeToString,
            ),
        }
