import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { Resource } from '@aws-cdk/core';
import * as cxapi from '@aws-cdk/cx-api';
import { Construct } from 'constructs';
import { IListenerAction } from './listener-action';
/**
 * Options for listener lookup.
 *
 * @stability stable
 */
export interface BaseListenerLookupOptions {
    /**
     * Filter listeners by associated load balancer arn.
     *
     * @default - does not filter by load balancer arn
     * @stability stable
     */
    readonly loadBalancerArn?: string;
    /**
     * Filter listeners by associated load balancer tags.
     *
     * @default - does not filter by load balancer tags
     * @stability stable
     */
    readonly loadBalancerTags?: Record<string, string>;
    /**
     * Filter listeners by listener port.
     *
     * @default - does not filter by listener port
     * @stability stable
     */
    readonly listenerPort?: number;
}
/**
 * Options for querying the load balancer listener context provider
 * @internal
 */
export interface ListenerQueryContextProviderOptions {
    /**
     * User's provided options
     */
    readonly userOptions: BaseListenerLookupOptions;
    /**
     * Type of load balancer expected
     */
    readonly loadBalancerType: cxschema.LoadBalancerType;
    /**
     * ARN of the listener to look up
     * @default - does not filter by listener arn
     */
    readonly listenerArn?: string;
    /**
     * Optional protocol of the listener to look up
     */
    readonly listenerProtocol?: cxschema.LoadBalancerListenerProtocol;
}
/**
 * Base class for listeners.
 *
 * @stability stable
 */
export declare abstract class BaseListener extends Resource {
    /**
     * Queries the load balancer listener context provider for load balancer
     * listener info.
     * @internal
     */
    protected static _queryContextProvider(scope: Construct, options: ListenerQueryContextProviderOptions): cxapi.LoadBalancerListenerContextResponse;
    /**
     * @stability stable
     * @attribute true
     */
    readonly listenerArn: string;
    private defaultAction?;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, additionalProps: any);
    /**
     * Validate this listener.
     *
     * @stability stable
     */
    protected validate(): string[];
    /**
     * Configure the default action
     *
     * @internal
     */
    protected _setDefaultAction(action: IListenerAction): void;
}
