function _aws_cdk_aws_cloudformation_CloudFormationCapabilities(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    print("@aws-cdk/aws-cloudformation.CloudFormationCapabilities", "use `core.CfnCapabilities`");
    const ns = require("./lib/cloud-formation-capabilities.js");
    if (Object.values(ns.CloudFormationCapabilities).filter(x => x === p).length > 1)
        return;
    if (p === ns.CloudFormationCapabilities.NONE)
        print("@aws-cdk/aws-cloudformation.CloudFormationCapabilities#NONE", "");
    if (p === ns.CloudFormationCapabilities.ANONYMOUS_IAM)
        print("@aws-cdk/aws-cloudformation.CloudFormationCapabilities#ANONYMOUS_IAM", "");
    if (p === ns.CloudFormationCapabilities.NAMED_IAM)
        print("@aws-cdk/aws-cloudformation.CloudFormationCapabilities#NAMED_IAM", "");
    if (p === ns.CloudFormationCapabilities.AUTO_EXPAND)
        print("@aws-cdk/aws-cloudformation.CloudFormationCapabilities#AUTO_EXPAND", "");
    visitedObjects.delete(p);
}
function _aws_cdk_aws_cloudformation_CustomResourceProviderConfig(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if ("serviceToken" in p)
        print("@aws-cdk/aws-cloudformation.CustomResourceProviderConfig#serviceToken", "used in {@link ICustomResourceProvider} which is now deprecated");
    visitedObjects.delete(p);
}
function _aws_cdk_aws_cloudformation_CfnCustomResourceProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnModuleVersionProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnModuleDefaultVersionProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnResourceDefaultVersionProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnWaitConditionProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnMacroProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnPublicTypeVersionProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnPublisherProps(p) {
}
function _aws_cdk_aws_cloudformation_ICustomResourceProvider(p) {
}
function _aws_cdk_aws_cloudformation_NestedStackProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if ("notifications" in p)
        print("@aws-cdk/aws-cloudformation.NestedStackProps#notifications", "use core.NestedStackProps instead");
    if (!visitedObjects.has(p.notifications))
        require("@aws-cdk/aws-sns/.warnings.jsii.js")._aws_cdk_aws_sns_ITopic(p.notifications);
    if ("parameters" in p)
        print("@aws-cdk/aws-cloudformation.NestedStackProps#parameters", "use core.NestedStackProps instead");
    if ("timeout" in p)
        print("@aws-cdk/aws-cloudformation.NestedStackProps#timeout", "use core.NestedStackProps instead");
    visitedObjects.delete(p);
}
function _aws_cdk_aws_cloudformation_CfnResourceVersionProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if (!visitedObjects.has(p.tags))
        require("@aws-cdk/core/.warnings.jsii.js")._aws_cdk_core_CfnTag(p.tags);
    visitedObjects.delete(p);
}
function _aws_cdk_aws_cloudformation_CustomResource(p) {
}
function _aws_cdk_aws_cloudformation_NestedStack(p) {
}
function _aws_cdk_aws_cloudformation_CfnTypeActivationProps(p) {
}
function _aws_cdk_aws_cloudformation_CfnWaitConditionHandle(p) {
}
function _aws_cdk_aws_cloudformation_CustomResourceProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if ("provider" in p)
        print("@aws-cdk/aws-cloudformation.CustomResourceProps#provider", "use `core.CustomResourceProps`");
    if (!visitedObjects.has(p.provider))
        _aws_cdk_aws_cloudformation_ICustomResourceProvider(p.provider);
    if ("properties" in p)
        print("@aws-cdk/aws-cloudformation.CustomResourceProps#properties", "use `core.CustomResourceProps`");
    if ("removalPolicy" in p)
        print("@aws-cdk/aws-cloudformation.CustomResourceProps#removalPolicy", "use `core.CustomResourceProps`");
    if ("resourceType" in p)
        print("@aws-cdk/aws-cloudformation.CustomResourceProps#resourceType", "use `core.CustomResourceProps`");
    visitedObjects.delete(p);
}
function _aws_cdk_aws_cloudformation_CfnModuleDefaultVersion(p) {
}
function _aws_cdk_aws_cloudformation_CfnMacro(p) {
}
function _aws_cdk_aws_cloudformation_CfnPublicTypeVersion(p) {
}
function _aws_cdk_aws_cloudformation_CfnCustomResource(p) {
}
function _aws_cdk_aws_cloudformation_CfnResourceDefaultVersion(p) {
}
function _aws_cdk_aws_cloudformation_CfnModuleVersion(p) {
}
function _aws_cdk_aws_cloudformation_CfnPublisher(p) {
}
function _aws_cdk_aws_cloudformation_CfnWaitCondition(p) {
}
function _aws_cdk_aws_cloudformation_CfnStack(p) {
}
function _aws_cdk_aws_cloudformation_CfnTypeActivation(p) {
}
function _aws_cdk_aws_cloudformation_CfnTypeActivation_LoggingConfigProperty(p) {
}
function _aws_cdk_aws_cloudformation_CfnResourceVersion(p) {
}
function _aws_cdk_aws_cloudformation_CfnResourceVersion_LoggingConfigProperty(p) {
}
function _aws_cdk_aws_cloudformation_CustomResourceProvider(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackSetProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    if (!visitedObjects.has(p.tags))
        require("@aws-cdk/core/.warnings.jsii.js")._aws_cdk_core_CfnTag(p.tags);
    visitedObjects.delete(p);
}
function _aws_cdk_aws_cloudformation_CfnStackSet(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackSet_ParameterProperty(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackSet_DeploymentTargetsProperty(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackSet_OperationPreferencesProperty(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackSet_AutoDeploymentProperty(p) {
}
function _aws_cdk_aws_cloudformation_CfnStackSet_StackInstancesProperty(p) {
}
function print(name, deprecationMessage) {
    const deprecated = process.env.JSII_DEPRECATED;
    const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
    const message = `${name} is deprecated.\n  ${deprecationMessage}\n  This API will be removed in the next major release.`;
    switch (deprecationMode) {
        case "fail":
            throw new DeprecationError(message);
        case "warn":
            console.warn("[WARNING]", message);
            break;
    }
}
const visitedObjects = new Set();
class DeprecationError extends Error {
}
module.exports = { print, _aws_cdk_aws_cloudformation_CloudFormationCapabilities, _aws_cdk_aws_cloudformation_CustomResourceProviderConfig, _aws_cdk_aws_cloudformation_CfnCustomResourceProps, _aws_cdk_aws_cloudformation_CfnModuleVersionProps, _aws_cdk_aws_cloudformation_CfnModuleDefaultVersionProps, _aws_cdk_aws_cloudformation_CfnResourceDefaultVersionProps, _aws_cdk_aws_cloudformation_CfnWaitConditionProps, _aws_cdk_aws_cloudformation_CfnMacroProps, _aws_cdk_aws_cloudformation_CfnPublicTypeVersionProps, _aws_cdk_aws_cloudformation_CfnPublisherProps, _aws_cdk_aws_cloudformation_ICustomResourceProvider, _aws_cdk_aws_cloudformation_NestedStackProps, _aws_cdk_aws_cloudformation_CfnResourceVersionProps, _aws_cdk_aws_cloudformation_CfnStackProps, _aws_cdk_aws_cloudformation_CustomResource, _aws_cdk_aws_cloudformation_NestedStack, _aws_cdk_aws_cloudformation_CfnTypeActivationProps, _aws_cdk_aws_cloudformation_CfnWaitConditionHandle, _aws_cdk_aws_cloudformation_CustomResourceProps, _aws_cdk_aws_cloudformation_CfnModuleDefaultVersion, _aws_cdk_aws_cloudformation_CfnMacro, _aws_cdk_aws_cloudformation_CfnPublicTypeVersion, _aws_cdk_aws_cloudformation_CfnCustomResource, _aws_cdk_aws_cloudformation_CfnResourceDefaultVersion, _aws_cdk_aws_cloudformation_CfnModuleVersion, _aws_cdk_aws_cloudformation_CfnPublisher, _aws_cdk_aws_cloudformation_CfnWaitCondition, _aws_cdk_aws_cloudformation_CfnStack, _aws_cdk_aws_cloudformation_CfnTypeActivation, _aws_cdk_aws_cloudformation_CfnTypeActivation_LoggingConfigProperty, _aws_cdk_aws_cloudformation_CfnResourceVersion, _aws_cdk_aws_cloudformation_CfnResourceVersion_LoggingConfigProperty, _aws_cdk_aws_cloudformation_CustomResourceProvider, _aws_cdk_aws_cloudformation_CfnStackSetProps, _aws_cdk_aws_cloudformation_CfnStackSet, _aws_cdk_aws_cloudformation_CfnStackSet_ParameterProperty, _aws_cdk_aws_cloudformation_CfnStackSet_DeploymentTargetsProperty, _aws_cdk_aws_cloudformation_CfnStackSet_OperationPreferencesProperty, _aws_cdk_aws_cloudformation_CfnStackSet_AutoDeploymentProperty, _aws_cdk_aws_cloudformation_CfnStackSet_StackInstancesProperty };
module.exports.DeprecationError = DeprecationError;
