# -*- coding: utf-8 -*-
#
# Copyright (C) 2020 TU Wien.
#
# Invenio-Theme-TUW is free software; you can redistribute it and/or modify
# it under the terms of the MIT License; see LICENSE file for more details.

"""JS/CSS Webpack bundles for TU Wien theme."""

from invenio_assets.webpack import WebpackThemeBundle

theme = WebpackThemeBundle(
    __name__,
    "assets",
    default="semantic-ui",
    themes={
        "semantic-ui": {
            "entry": {
                "invenio-theme-tuw-theme": "./less/invenio_theme_tuw/theme.less",
                "invenio-theme-tuw-tracking": "./js/invenio_theme_tuw/tracking/index.js",
                "invenio-theme-tuw-planned-features": "./js/invenio_theme_tuw/planned-features/index.js",
            },
            "dependencies": {},
        },
    },
)
