# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-12-12 16:30
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import re


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='VirtualPointOfSale',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, verbose_name='Nombre')),
                ('bank_name', models.CharField(max_length=128, verbose_name='Nombre de la entidad bancaria')),
                ('type', models.CharField(choices=[('ceca', 'TPV Virtual - Confederaci\xf3n Espa\xf1ola de Cajas de Ahorros (CECA)'), ('paypal', 'Paypal'), ('redsys', 'TPV Redsys'), ('santanderelavon', 'TPV Santander Elavon')], default='', max_length=16, verbose_name='Tipo de TPV')),
                ('distributor_name', models.CharField(blank=True, help_text='Raz\xf3n social del distribuidor de entradas.', max_length=512, verbose_name='Raz\xf3n social del distribuidor de entradas')),
                ('distributor_cif', models.CharField(blank=True, help_text='C.I.F. del distribuidor de entradas.', max_length=150, verbose_name='CIF del distribuidor de entradas')),
                ('environment', models.CharField(choices=[('testing', 'Pruebas'), ('production', 'Producci\xf3n')], default='testing', help_text="Entorno de ejecuci\xf3n en el que se encuentra el TPV. Una vez que el TPV est\xe9 en entorno de 'producci\xf3n' no cambie a entorno de 'pruebas' a no ser que est\xe9 seguro de lo que hace.", max_length=16, verbose_name='Entorno de ejecuci\xf3n del TPV')),
                ('has_partial_refunds', models.BooleanField(default=False, help_text='Indica si se pueden realizar devoluciones por un importe menor que el total de la venta (por ejemplo, para devolver tickets individuales).', verbose_name='Indica si tiene devoluciones parciales.')),
                ('has_total_refunds', models.BooleanField(default=False, help_text='Indica si se pueden realizar devoluciones por un importe igual al total de la venta.', verbose_name='Indica si tiene devoluciones totales.')),
                ('is_erased', models.BooleanField(default=False, help_text='Indica si el TPV est\xe1 eliminado de forma l\xf3gica.', verbose_name='Indica si el TPV est\xe1 eliminado.')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'virtual point of sale',
                'verbose_name_plural': 'virtual points of sale',
            },
        ),
        migrations.CreateModel(
            name='VPOSPaymentOperation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=6, verbose_name='Coste de la operaci\xf3n')),
                ('description', models.CharField(max_length=512, verbose_name='Descripci\xf3n de la venta')),
                ('url_ok', models.CharField(help_text='URL a la que redirige la pasarela bancaria cuando la compra ha sido un \xe9xito', max_length=255, verbose_name='URL de OK')),
                ('url_nok', models.CharField(help_text='URL a la que redirige la pasarela bancaria cuando la compra ha fallado', max_length=255, verbose_name='URL de NOK')),
                ('operation_number', models.CharField(max_length=255, verbose_name='N\xfamero de operaci\xf3n')),
                ('confirmation_code', models.CharField(max_length=255, null=True, verbose_name='C\xf3digo de confirmaci\xf3n enviado por el banco.')),
                ('confirmation_data', models.TextField(null=True, verbose_name='POST enviado por la pasarela bancaria al confirmar la compra.')),
                ('sale_code', models.CharField(help_text='C\xf3digo de la venta seg\xfan la aplicaci\xf3n.', max_length=512, verbose_name='C\xf3digo de la venta')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('completed', 'Completed'), ('failed', 'Failed')], max_length=64, verbose_name='Estado del pago')),
                ('creation_datetime', models.DateTimeField(verbose_name='Fecha de creaci\xf3n del objeto')),
                ('last_update_datetime', models.DateTimeField(verbose_name='Fecha de \xfaltima actualizaci\xf3n del objeto')),
                ('type', models.CharField(choices=[('ceca', 'TPV Virtual - Confederaci\xf3n Espa\xf1ola de Cajas de Ahorros (CECA)'), ('paypal', 'Paypal'), ('redsys', 'TPV Redsys'), ('santanderelavon', 'TPV Santander Elavon')], default='', max_length=16, verbose_name='Tipo de TPV')),
                ('virtual_point_of_sale', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, parent_link=True, related_name='+', to='djangovirtualpos.VirtualPointOfSale')),
            ],
        ),
        migrations.CreateModel(
            name='VPOSCeca',
            fields=[
                ('parent', models.OneToOneField(db_column='vpos_id', on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='+', serialize=False, to='djangovirtualpos.VirtualPointOfSale')),
                ('merchant_id', models.CharField(max_length=9, validators=[django.core.validators.MinLengthValidator(9), django.core.validators.MaxLengthValidator(9), django.core.validators.RegexValidator(message='Aseg\xfarese de que todos los caracteres son n\xfameros', regex=re.compile('^\\d*$'))], verbose_name='MerchantID')),
                ('acquirer_bin', models.CharField(max_length=10, validators=[django.core.validators.MinLengthValidator(10), django.core.validators.MaxLengthValidator(10), django.core.validators.RegexValidator(message='Aseg\xfarese de que todos los caracteres son n\xfameros', regex=re.compile('^\\d*$'))], verbose_name='AcquirerBIN')),
                ('terminal_id', models.CharField(max_length=8, validators=[django.core.validators.MinLengthValidator(8), django.core.validators.MaxLengthValidator(8), django.core.validators.RegexValidator(message='Aseg\xfarese de que todos los caracteres son n\xfameros', regex=re.compile('^\\d*$'))], verbose_name='TerminalID')),
                ('encryption_key_testing', models.CharField(max_length=10, validators=[django.core.validators.MinLengthValidator(8), django.core.validators.MaxLengthValidator(10)], verbose_name='Encryption Key para el entorno de pruebas')),
                ('encryption_key_production', models.CharField(blank=True, max_length=10, validators=[django.core.validators.MinLengthValidator(8), django.core.validators.MaxLengthValidator(10)], verbose_name='Encryption Key para el entorno de producci\xf3n')),
                ('operation_number_prefix', models.CharField(blank=True, max_length=20, validators=[django.core.validators.MinLengthValidator(0), django.core.validators.MaxLengthValidator(20), django.core.validators.RegexValidator(message='Aseg\xfarese de s\xf3lo use caracteres alfanum\xe9ricos', regex=re.compile('^[A-Za-z0-9]*$'))], verbose_name='Prefijo del n\xfamero de operaci\xf3n')),
            ],
            bases=('djangovirtualpos.virtualpointofsale',),
        ),
        migrations.CreateModel(
            name='VPOSPaypal',
            fields=[
                ('parent', models.OneToOneField(db_column='vpos_id', on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='+', serialize=False, to='djangovirtualpos.VirtualPointOfSale')),
                ('API_username', models.CharField(max_length=60, verbose_name='API_username')),
                ('API_password', models.CharField(max_length=60, verbose_name='API_password')),
                ('API_signature', models.CharField(max_length=60, verbose_name='API_signature')),
                ('Version', models.CharField(max_length=3, verbose_name='Version')),
            ],
            bases=('djangovirtualpos.virtualpointofsale',),
        ),
        migrations.CreateModel(
            name='VPOSRedsys',
            fields=[
                ('parent', models.OneToOneField(db_column='vpos_id', on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='+', serialize=False, to='djangovirtualpos.VirtualPointOfSale')),
                ('merchant_code', models.CharField(max_length=9, verbose_name='MerchantCode')),
                ('merchant_response_url', models.URLField(help_text='Confirmation URL that will be used by the virtual POS', max_length=64, verbose_name='MerchantURL')),
                ('terminal_id', models.CharField(max_length=3, verbose_name='TerminalID')),
                ('encryption_key_testing', models.CharField(default=None, max_length=20, null=True, verbose_name='Encryption Key para el entorno de pruebas (OBSOLETO)')),
                ('encryption_key_production', models.CharField(default=None, max_length=20, null=True, verbose_name='Encryption Key para el entorno de producci\xf3n (OBSOLETO)')),
                ('encryption_key_testing_sha256', models.CharField(default=None, max_length=64, null=True, verbose_name='Encryption Key SHA-256 para el entorno de pruebas')),
                ('encryption_key_production_sha256', models.CharField(default=None, max_length=64, null=True, verbose_name='Encryption Key SHA-256 para el entorno de producci\xf3n')),
                ('operation_number_prefix', models.CharField(blank=True, max_length=3, validators=[django.core.validators.MinLengthValidator(0), django.core.validators.MaxLengthValidator(3), django.core.validators.RegexValidator(message='Aseg\xfarese de s\xf3lo use caracteres num\xe9ricos', regex=re.compile('^\\d+$'))], verbose_name='Prefijo del n\xfamero de operaci\xf3n')),
            ],
            bases=('djangovirtualpos.virtualpointofsale',),
        ),
        migrations.CreateModel(
            name='VPOSSantanderElavon',
            fields=[
                ('parent', models.OneToOneField(db_column='vpos_id', on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='+', serialize=False, to='djangovirtualpos.VirtualPointOfSale')),
                ('merchant_id', models.CharField(max_length=50, validators=[django.core.validators.MinLengthValidator(1), django.core.validators.MaxLengthValidator(50), django.core.validators.RegexValidator(message='Aseg\xfarese de que todos los caracteres son alfanum\xe9ricos', regex=re.compile('^[a-zA-Z0-9]*$'))], verbose_name='MerchantID')),
                ('merchant_response_url', models.URLField(help_text='Confirmation URL that will be used by the virtual POS', max_length=64, verbose_name='MerchantURL')),
                ('account', models.CharField(max_length=30, validators=[django.core.validators.MinLengthValidator(0), django.core.validators.MaxLengthValidator(30), django.core.validators.RegexValidator(message='Aseg\xfarese de que todos los caracteres son alfanum\xe9ricos', regex=re.compile('^[a-zA-Z0-9.]*$'))], verbose_name='Account')),
                ('encryption_key', models.CharField(max_length=64, validators=[django.core.validators.MinLengthValidator(8), django.core.validators.MaxLengthValidator(10)], verbose_name='Clave secreta de cifrado')),
                ('operation_number_prefix', models.CharField(blank=True, max_length=20, validators=[django.core.validators.MinLengthValidator(0), django.core.validators.MaxLengthValidator(20), django.core.validators.RegexValidator(message='Aseg\xfarese de s\xf3lo use caracteres alfanum\xe9ricos', regex=re.compile('^[A-Za-z0-9]*$'))], verbose_name='Prefijo del n\xfamero de operaci\xf3n')),
            ],
            bases=('djangovirtualpos.virtualpointofsale',),
        ),
    ]
