# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from __future__ import annotations

from typing import List

from alibabacloud_cloudfw20171207 import models as main_models
from darabonba.model import DaraModel

class DescribeVulnerabilityProtectedListResponseBody(DaraModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        vuln_list: List[main_models.DescribeVulnerabilityProtectedListResponseBodyVulnList] = None,
        zero_resource_count: int = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The total number of vulnerabilities that are detected by Cloud Firewall.
        self.total_count = total_count
        # The vulnerabilities.
        self.vuln_list = vuln_list
        # The number of assets on which no vulnerabilities are detected.
        self.zero_resource_count = zero_resource_count

    def validate(self):
        if self.vuln_list:
            for v1 in self.vuln_list:
                 if v1:
                    v1.validate()

    def to_map(self):
        result = dict()
        _map = super().to_map()
        if _map is not None:
            result = _map
        if self.request_id is not None:
            result['RequestId'] = self.request_id

        if self.total_count is not None:
            result['TotalCount'] = self.total_count

        result['VulnList'] = []
        if self.vuln_list is not None:
            for k1 in self.vuln_list:
                result['VulnList'].append(k1.to_map() if k1 else None)

        if self.zero_resource_count is not None:
            result['ZeroResourceCount'] = self.zero_resource_count

        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')

        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')

        self.vuln_list = []
        if m.get('VulnList') is not None:
            for k1 in m.get('VulnList'):
                temp_model = main_models.DescribeVulnerabilityProtectedListResponseBodyVulnList()
                self.vuln_list.append(temp_model.from_map(k1))

        if m.get('ZeroResourceCount') is not None:
            self.zero_resource_count = m.get('ZeroResourceCount')

        return self

class DescribeVulnerabilityProtectedListResponseBodyVulnList(DaraModel):
    def __init__(
        self,
        attack_cnt: int = None,
        attack_type: int = None,
        basic_rule_ids: str = None,
        cve_id: str = None,
        first_time: int = None,
        highlight_tag: int = None,
        last_time: int = None,
        member_uid: str = None,
        need_open_basic_rule: bool = None,
        need_open_basic_rule_uuids: str = None,
        need_open_run_mode: bool = None,
        need_open_virtual_patche: bool = None,
        need_open_virtual_patche_uuids: str = None,
        need_rule_class: int = None,
        resource_cnt: int = None,
        resource_list: List[main_models.DescribeVulnerabilityProtectedListResponseBodyVulnListResourceList] = None,
        rule_tag: str = None,
        virtual_patche_ids: str = None,
        vuln_key: str = None,
        vuln_level: str = None,
        vuln_name: str = None,
        vuln_status: str = None,
        vuln_type: str = None,
    ):
        # The number of vulnerability attacks.
        self.attack_cnt = attack_cnt
        # The attack type of the vulnerability prevention event. Valid values:
        # 
        # *   **1**: suspicious connection
        # *   **2**: command execution
        # *   **3**: brute-force attack
        # *   **4**: scanning
        # *   **5**: others
        # *   **6**: information leakage
        # *   **7**: DoS attack
        # *   **8**: buffer overflow attack
        # *   **9**: web attack
        # *   **10**: webshell
        # *   **11**: computer worm
        # *   **12**: mining
        # *   **13**: reverse shell
        self.attack_type = attack_type
        # The IDs of associated basic protection policies.
        self.basic_rule_ids = basic_rule_ids
        # The CVE IDs.
        self.cve_id = cve_id
        # The time when the first attack was launched.
        self.first_time = first_time
        # Indicates whether you need to pay special attention to the vulnerability. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.highlight_tag = highlight_tag
        # The time when the last attack was launched.
        self.last_time = last_time
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # Indicates whether the basic protection policy that related to the vulnerability is enabled. Valid values:
        # 
        # *   **true**
        # *   **false**
        # 
        # >  If the value of this parameter is true, you must set the action of the basic protection policy related to the vulnerability to Block.
        self.need_open_basic_rule = need_open_basic_rule
        # The UUIDs of the basic protection policies for which the action needs to be changed to Block.
        self.need_open_basic_rule_uuids = need_open_basic_rule_uuids
        # Indicates whether Threat Engine Mode needs to be configured when you enable protection. Valid values:
        # 
        # *   **true**
        # *   **false**
        self.need_open_run_mode = need_open_run_mode
        # Indicates whether the virtual patching policy that related to the vulnerability is enabled. Valid values:
        # 
        # *   **true**
        # *   **false**
        # 
        # >  If the value of this parameter is true, you must set the action of the virtual patching policy that related to the vulnerability to Block.
        self.need_open_virtual_patche = need_open_virtual_patche
        # The UUIDs of the virtual patching policies for which the action needs to be changed to Block.
        self.need_open_virtual_patche_uuids = need_open_virtual_patche_uuids
        # The type of the rule group. Valid values:
        # 
        # *   **1** (default): loose
        # *   **2**: medium
        # *   **3**: strict
        self.need_rule_class = need_rule_class
        # The number of assets on which vulnerabilities are detected.
        self.resource_cnt = resource_cnt
        # The assets on which the vulnerability is detected.
        self.resource_list = resource_list
        # 漏洞标签，取值：
        # 
        # - **AI**： AI相关漏洞
        self.rule_tag = rule_tag
        # The IDs of associated virtual patching policies.
        self.virtual_patche_ids = virtual_patche_ids
        # The code of the vulnerability.
        self.vuln_key = vuln_key
        # The risk level of the vulnerability. Valid values:
        # 
        # *   **high**
        # *   **medium**
        # *   **low**
        self.vuln_level = vuln_level
        # The name of the vulnerability.
        self.vuln_name = vuln_name
        # The status of the vulnerability prevention feature. Valid values:
        # 
        # *   **partProtected**: enabled for partial assets
        # *   **protected**: enabled
        # *   **unProtected**: disabled
        self.vuln_status = vuln_status
        # The type of the vulnerability. Valid values:
        # 
        # *   **emg**: urgent vulnerability
        # *   **webcms**: Web-CMS vulnerability
        # *   **app**: application vulnerability
        self.vuln_type = vuln_type

    def validate(self):
        if self.resource_list:
            for v1 in self.resource_list:
                 if v1:
                    v1.validate()

    def to_map(self):
        result = dict()
        _map = super().to_map()
        if _map is not None:
            result = _map
        if self.attack_cnt is not None:
            result['AttackCnt'] = self.attack_cnt

        if self.attack_type is not None:
            result['AttackType'] = self.attack_type

        if self.basic_rule_ids is not None:
            result['BasicRuleIds'] = self.basic_rule_ids

        if self.cve_id is not None:
            result['CveId'] = self.cve_id

        if self.first_time is not None:
            result['FirstTime'] = self.first_time

        if self.highlight_tag is not None:
            result['HighlightTag'] = self.highlight_tag

        if self.last_time is not None:
            result['LastTime'] = self.last_time

        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid

        if self.need_open_basic_rule is not None:
            result['NeedOpenBasicRule'] = self.need_open_basic_rule

        if self.need_open_basic_rule_uuids is not None:
            result['NeedOpenBasicRuleUuids'] = self.need_open_basic_rule_uuids

        if self.need_open_run_mode is not None:
            result['NeedOpenRunMode'] = self.need_open_run_mode

        if self.need_open_virtual_patche is not None:
            result['NeedOpenVirtualPatche'] = self.need_open_virtual_patche

        if self.need_open_virtual_patche_uuids is not None:
            result['NeedOpenVirtualPatcheUuids'] = self.need_open_virtual_patche_uuids

        if self.need_rule_class is not None:
            result['NeedRuleClass'] = self.need_rule_class

        if self.resource_cnt is not None:
            result['ResourceCnt'] = self.resource_cnt

        result['ResourceList'] = []
        if self.resource_list is not None:
            for k1 in self.resource_list:
                result['ResourceList'].append(k1.to_map() if k1 else None)

        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag

        if self.virtual_patche_ids is not None:
            result['VirtualPatcheIds'] = self.virtual_patche_ids

        if self.vuln_key is not None:
            result['VulnKey'] = self.vuln_key

        if self.vuln_level is not None:
            result['VulnLevel'] = self.vuln_level

        if self.vuln_name is not None:
            result['VulnName'] = self.vuln_name

        if self.vuln_status is not None:
            result['VulnStatus'] = self.vuln_status

        if self.vuln_type is not None:
            result['VulnType'] = self.vuln_type

        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackCnt') is not None:
            self.attack_cnt = m.get('AttackCnt')

        if m.get('AttackType') is not None:
            self.attack_type = m.get('AttackType')

        if m.get('BasicRuleIds') is not None:
            self.basic_rule_ids = m.get('BasicRuleIds')

        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')

        if m.get('FirstTime') is not None:
            self.first_time = m.get('FirstTime')

        if m.get('HighlightTag') is not None:
            self.highlight_tag = m.get('HighlightTag')

        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')

        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')

        if m.get('NeedOpenBasicRule') is not None:
            self.need_open_basic_rule = m.get('NeedOpenBasicRule')

        if m.get('NeedOpenBasicRuleUuids') is not None:
            self.need_open_basic_rule_uuids = m.get('NeedOpenBasicRuleUuids')

        if m.get('NeedOpenRunMode') is not None:
            self.need_open_run_mode = m.get('NeedOpenRunMode')

        if m.get('NeedOpenVirtualPatche') is not None:
            self.need_open_virtual_patche = m.get('NeedOpenVirtualPatche')

        if m.get('NeedOpenVirtualPatcheUuids') is not None:
            self.need_open_virtual_patche_uuids = m.get('NeedOpenVirtualPatcheUuids')

        if m.get('NeedRuleClass') is not None:
            self.need_rule_class = m.get('NeedRuleClass')

        if m.get('ResourceCnt') is not None:
            self.resource_cnt = m.get('ResourceCnt')

        self.resource_list = []
        if m.get('ResourceList') is not None:
            for k1 in m.get('ResourceList'):
                temp_model = main_models.DescribeVulnerabilityProtectedListResponseBodyVulnListResourceList()
                self.resource_list.append(temp_model.from_map(k1))

        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')

        if m.get('VirtualPatcheIds') is not None:
            self.virtual_patche_ids = m.get('VirtualPatcheIds')

        if m.get('VulnKey') is not None:
            self.vuln_key = m.get('VulnKey')

        if m.get('VulnLevel') is not None:
            self.vuln_level = m.get('VulnLevel')

        if m.get('VulnName') is not None:
            self.vuln_name = m.get('VulnName')

        if m.get('VulnStatus') is not None:
            self.vuln_status = m.get('VulnStatus')

        if m.get('VulnType') is not None:
            self.vuln_type = m.get('VulnType')

        return self

class DescribeVulnerabilityProtectedListResponseBodyVulnListResourceList(DaraModel):
    def __init__(
        self,
        eip: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        region_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_type: str = None,
        vuln_status: str = None,
    ):
        # The elastic IP address (EIP) that is associated with the instance.
        self.eip = eip
        # The public IP address of the instance.
        self.internet_ip = internet_ip
        # The private IP address of the instance.
        self.intranet_ip = intranet_ip
        # The region ID of your Cloud Firewall.
        # 
        # >  For more information about Cloud Firewall supported regions, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        self.region_id = region_id
        # The ID of the instance.
        self.resource_id = resource_id
        # The name of the instance.
        self.resource_name = resource_name
        # The type of the asset. Valid values:
        # 
        # *   **SLB**
        # *   **EIP**
        # *   **ECS**
        self.resource_type = resource_type
        # The status of the vulnerability prevention feature. Valid values:
        # 
        # *   **partProtected**: enabled for partial assets
        # *   **protected**: enabled
        # *   **unProtected**: disabled
        self.vuln_status = vuln_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        _map = super().to_map()
        if _map is not None:
            result = _map
        if self.eip is not None:
            result['Eip'] = self.eip

        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip

        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip

        if self.region_id is not None:
            result['RegionId'] = self.region_id

        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id

        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name

        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type

        if self.vuln_status is not None:
            result['VulnStatus'] = self.vuln_status

        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Eip') is not None:
            self.eip = m.get('Eip')

        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')

        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')

        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')

        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')

        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')

        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')

        if m.get('VulnStatus') is not None:
            self.vuln_status = m.get('VulnStatus')

        return self

