import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerAnalysisNoteConfig extends cdktf.TerraformMetaArguments {
    /**
     * Time of expiration for this note. Leave empty if note does not expire.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#expiration_time ContainerAnalysisNote#expiration_time}
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * A detailed description of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#long_description ContainerAnalysisNote#long_description}
     *
     * @stability stable
     */
    readonly longDescription?: string;
    /**
     * The name of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#name ContainerAnalysisNote#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#project ContainerAnalysisNote#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Names of other notes related to this note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#related_note_names ContainerAnalysisNote#related_note_names}
     *
     * @stability stable
     */
    readonly relatedNoteNames?: string[];
    /**
     * A one sentence description of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#short_description ContainerAnalysisNote#short_description}
     *
     * @stability stable
     */
    readonly shortDescription?: string;
    /**
     * attestation_authority block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#attestation_authority ContainerAnalysisNote#attestation_authority}
     *
     * @stability stable
     */
    readonly attestationAuthority: ContainerAnalysisNoteAttestationAuthority;
    /**
     * related_url block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#related_url ContainerAnalysisNote#related_url}
     *
     * @stability stable
     */
    readonly relatedUrl?: ContainerAnalysisNoteRelatedUrl[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#timeouts ContainerAnalysisNote#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerAnalysisNoteTimeouts;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisNoteAttestationAuthorityHint {
    /**
     * The human readable name of this Attestation Authority, for example "qa".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#human_readable_name ContainerAnalysisNote#human_readable_name}
     *
     * @stability stable
     */
    readonly humanReadableName: string;
}
/**
 * @stability stable
 */
export declare class ContainerAnalysisNoteAttestationAuthorityHintOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _humanReadableName?;
    /**
     * @stability stable
     */
    get humanReadableName(): string;
    /**
     * @stability stable
     */
    set humanReadableName(value: string);
    /**
     * @stability stable
     */
    get humanReadableNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisNoteAttestationAuthority {
    /**
     * hint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#hint ContainerAnalysisNote#hint}
     *
     * @stability stable
     */
    readonly hint: ContainerAnalysisNoteAttestationAuthorityHint;
}
/**
 * @stability stable
 */
export declare class ContainerAnalysisNoteAttestationAuthorityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hint?;
    private __hintOutput;
    /**
     * @stability stable
     */
    get hint(): ContainerAnalysisNoteAttestationAuthorityHintOutputReference;
    /**
     * @stability stable
     */
    putHint(value: ContainerAnalysisNoteAttestationAuthorityHint): void;
    /**
     * @stability stable
     */
    get hintInput(): ContainerAnalysisNoteAttestationAuthorityHint | undefined;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisNoteRelatedUrl {
    /**
     * Label to describe usage of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#label ContainerAnalysisNote#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Specific URL associated with the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#url ContainerAnalysisNote#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisNoteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#create ContainerAnalysisNote#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#delete ContainerAnalysisNote#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#update ContainerAnalysisNote#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ContainerAnalysisNoteTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html google_container_analysis_note}.
 *
 * @stability stable
 */
export declare class ContainerAnalysisNote extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html google_container_analysis_note} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerAnalysisNoteConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _expirationTime?;
    /**
     * @stability stable
     */
    get expirationTime(): string | undefined;
    /**
     * @stability stable
     */
    set expirationTime(value: string | undefined);
    /**
     * @stability stable
     */
    resetExpirationTime(): void;
    /**
     * @stability stable
     */
    get expirationTimeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    private _longDescription?;
    /**
     * @stability stable
     */
    get longDescription(): string | undefined;
    /**
     * @stability stable
     */
    set longDescription(value: string | undefined);
    /**
     * @stability stable
     */
    resetLongDescription(): void;
    /**
     * @stability stable
     */
    get longDescriptionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _relatedNoteNames?;
    /**
     * @stability stable
     */
    get relatedNoteNames(): string[] | undefined;
    /**
     * @stability stable
     */
    set relatedNoteNames(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRelatedNoteNames(): void;
    /**
     * @stability stable
     */
    get relatedNoteNamesInput(): string[] | undefined;
    private _shortDescription?;
    /**
     * @stability stable
     */
    get shortDescription(): string | undefined;
    /**
     * @stability stable
     */
    set shortDescription(value: string | undefined);
    /**
     * @stability stable
     */
    resetShortDescription(): void;
    /**
     * @stability stable
     */
    get shortDescriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _attestationAuthority?;
    private __attestationAuthorityOutput;
    /**
     * @stability stable
     */
    get attestationAuthority(): ContainerAnalysisNoteAttestationAuthorityOutputReference;
    /**
     * @stability stable
     */
    putAttestationAuthority(value: ContainerAnalysisNoteAttestationAuthority): void;
    /**
     * @stability stable
     */
    get attestationAuthorityInput(): ContainerAnalysisNoteAttestationAuthority | undefined;
    private _relatedUrl?;
    /**
     * @stability stable
     */
    get relatedUrl(): ContainerAnalysisNoteRelatedUrl[] | undefined;
    /**
     * @stability stable
     */
    set relatedUrl(value: ContainerAnalysisNoteRelatedUrl[] | undefined);
    /**
     * @stability stable
     */
    resetRelatedUrl(): void;
    /**
     * @stability stable
     */
    get relatedUrlInput(): ContainerAnalysisNoteRelatedUrl[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ContainerAnalysisNoteTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerAnalysisNoteTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerAnalysisNoteTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
