import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleMonitoringAppEngineServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the App Engine module underlying this service.
     *
     * Corresponds to the 'moduleId' resource label for a 'gae_app'
     * monitored resource(see https://cloud.google.com/monitoring/api/resources#tag_gae_app)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html#module_id DataGoogleMonitoringAppEngineService#module_id}
     *
     * @stability stable
     */
    readonly moduleId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html#project DataGoogleMonitoringAppEngineService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleMonitoringAppEngineServiceTelemetry extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resourceName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html google_monitoring_app_engine_service}.
 *
 * @stability stable
 */
export declare class DataGoogleMonitoringAppEngineService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html google_monitoring_app_engine_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringAppEngineServiceConfig);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _moduleId?;
    /**
     * @stability stable
     */
    get moduleId(): string;
    /**
     * @stability stable
     */
    set moduleId(value: string);
    /**
     * @stability stable
     */
    get moduleIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceId(): string;
    /**
     * @stability stable
     */
    telemetry(index: string): DataGoogleMonitoringAppEngineServiceTelemetry;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
