# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Certificate']


class Certificate(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 certificate_dn: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 csr_pem: Optional[pulumi.Input[str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ecdsa_curve: Optional[pulumi.Input[str]] = None,
                 expiration_window: Optional[pulumi.Input[int]] = None,
                 issuer_hint: Optional[pulumi.Input[str]] = None,
                 key_password: Optional[pulumi.Input[str]] = None,
                 pkcs12: Optional[pulumi.Input[str]] = None,
                 private_key_pem: Optional[pulumi.Input[str]] = None,
                 rsa_bits: Optional[pulumi.Input[int]] = None,
                 san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 valid_days: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides access to TLS key and certificate data enrolled using Venafi. This can be used to define a
        certificate.

        The `Certificate` resource handles certificate renewals as long as a
        `pulumi up` is run within the `expiration_window` period. Keep in mind that the
        `expiration_window` in the provider configuration needs to align with the renewal
        window of the issuing CA to achieve the desired result.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_venafi as venafi

        webserver = venafi.Certificate("webserver",
            algorithm="RSA",
            common_name="web.venafi.example",
            custom_fields={
                "Cost Center": "AB1234",
                "Environment": "UAT|Staging",
            },
            key_password=var["pk_pass"],
            rsa_bits=2048,
            san_dns=[
                "web01.venafi.example",
                "web02.venafi.example",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: Key encryption algorithm, either `RSA` or `ECDSA`.
               Defaults to `RSA`.
        :param pulumi.Input[str] common_name: The common name of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_fields: Collection of Custom Field name-value pairs to
               assign to the certificate.
        :param pulumi.Input[str] ecdsa_curve: ECDSA curve to use when generating a key
        :param pulumi.Input[int] expiration_window: Number of hours before certificate expiry
               to request a new certificate.
        :param pulumi.Input[str] issuer_hint: Used with valid_days to indicate the target
               issuer when using Trust Protection Platform.  Relevant values are: "DigiCert",
               "Entrust", and "Microsoft".
        :param pulumi.Input[str] key_password: The password used to encrypt the private key.
        :param pulumi.Input[str] pkcs12: A base64-encoded PKCS#12 keystore secured by the `key_password`.
        :param pulumi.Input[str] private_key_pem: The private key in PEM format.
        :param pulumi.Input[int] rsa_bits: Number of bits to use when generating an RSA key.
               Applies when `algorithm=RSA`.  Defaults to `2048`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] san_dns: List of DNS names to use as alternative
               subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] san_emails: List of email addresses to use as
               alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] san_ips: List of IP addresses to use as alternative
               subjects of the certificate.
        :param pulumi.Input[int] valid_days: Desired number of days for which the new
               certificate will be valid.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['algorithm'] = algorithm
            __props__['certificate_dn'] = certificate_dn
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__['common_name'] = common_name
            __props__['csr_pem'] = csr_pem
            __props__['custom_fields'] = custom_fields
            __props__['ecdsa_curve'] = ecdsa_curve
            __props__['expiration_window'] = expiration_window
            __props__['issuer_hint'] = issuer_hint
            __props__['key_password'] = key_password
            __props__['pkcs12'] = pkcs12
            __props__['private_key_pem'] = private_key_pem
            __props__['rsa_bits'] = rsa_bits
            __props__['san_dns'] = san_dns
            __props__['san_emails'] = san_emails
            __props__['san_ips'] = san_ips
            __props__['valid_days'] = valid_days
            __props__['certificate'] = None
            __props__['chain'] = None
        super(Certificate, __self__).__init__(
            'venafi:index/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            certificate_dn: Optional[pulumi.Input[str]] = None,
            chain: Optional[pulumi.Input[str]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            csr_pem: Optional[pulumi.Input[str]] = None,
            custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ecdsa_curve: Optional[pulumi.Input[str]] = None,
            expiration_window: Optional[pulumi.Input[int]] = None,
            issuer_hint: Optional[pulumi.Input[str]] = None,
            key_password: Optional[pulumi.Input[str]] = None,
            pkcs12: Optional[pulumi.Input[str]] = None,
            private_key_pem: Optional[pulumi.Input[str]] = None,
            rsa_bits: Optional[pulumi.Input[int]] = None,
            san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            valid_days: Optional[pulumi.Input[int]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: Key encryption algorithm, either `RSA` or `ECDSA`.
               Defaults to `RSA`.
        :param pulumi.Input[str] certificate: The X509 certificate in PEM format.
        :param pulumi.Input[str] chain: The trust chain of X509 certificate authority certificates in PEM format
               concatenated together.
        :param pulumi.Input[str] common_name: The common name of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_fields: Collection of Custom Field name-value pairs to
               assign to the certificate.
        :param pulumi.Input[str] ecdsa_curve: ECDSA curve to use when generating a key
        :param pulumi.Input[int] expiration_window: Number of hours before certificate expiry
               to request a new certificate.
        :param pulumi.Input[str] issuer_hint: Used with valid_days to indicate the target
               issuer when using Trust Protection Platform.  Relevant values are: "DigiCert",
               "Entrust", and "Microsoft".
        :param pulumi.Input[str] key_password: The password used to encrypt the private key.
        :param pulumi.Input[str] pkcs12: A base64-encoded PKCS#12 keystore secured by the `key_password`.
        :param pulumi.Input[str] private_key_pem: The private key in PEM format.
        :param pulumi.Input[int] rsa_bits: Number of bits to use when generating an RSA key.
               Applies when `algorithm=RSA`.  Defaults to `2048`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] san_dns: List of DNS names to use as alternative
               subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] san_emails: List of email addresses to use as
               alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] san_ips: List of IP addresses to use as alternative
               subjects of the certificate.
        :param pulumi.Input[int] valid_days: Desired number of days for which the new
               certificate will be valid.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["algorithm"] = algorithm
        __props__["certificate"] = certificate
        __props__["certificate_dn"] = certificate_dn
        __props__["chain"] = chain
        __props__["common_name"] = common_name
        __props__["csr_pem"] = csr_pem
        __props__["custom_fields"] = custom_fields
        __props__["ecdsa_curve"] = ecdsa_curve
        __props__["expiration_window"] = expiration_window
        __props__["issuer_hint"] = issuer_hint
        __props__["key_password"] = key_password
        __props__["pkcs12"] = pkcs12
        __props__["private_key_pem"] = private_key_pem
        __props__["rsa_bits"] = rsa_bits
        __props__["san_dns"] = san_dns
        __props__["san_emails"] = san_emails
        __props__["san_ips"] = san_ips
        __props__["valid_days"] = valid_days
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Key encryption algorithm, either `RSA` or `ECDSA`.
        Defaults to `RSA`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The X509 certificate in PEM format.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateDn")
    def certificate_dn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "certificate_dn")

    @property
    @pulumi.getter
    def chain(self) -> pulumi.Output[str]:
        """
        The trust chain of X509 certificate authority certificates in PEM format
        concatenated together.
        """
        return pulumi.get(self, "chain")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[str]:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="csrPem")
    def csr_pem(self) -> pulumi.Output[str]:
        return pulumi.get(self, "csr_pem")

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Collection of Custom Field name-value pairs to
        assign to the certificate.
        """
        return pulumi.get(self, "custom_fields")

    @property
    @pulumi.getter(name="ecdsaCurve")
    def ecdsa_curve(self) -> pulumi.Output[Optional[str]]:
        """
        ECDSA curve to use when generating a key
        """
        return pulumi.get(self, "ecdsa_curve")

    @property
    @pulumi.getter(name="expirationWindow")
    def expiration_window(self) -> pulumi.Output[Optional[int]]:
        """
        Number of hours before certificate expiry
        to request a new certificate.
        """
        return pulumi.get(self, "expiration_window")

    @property
    @pulumi.getter(name="issuerHint")
    def issuer_hint(self) -> pulumi.Output[Optional[str]]:
        """
        Used with valid_days to indicate the target
        issuer when using Trust Protection Platform.  Relevant values are: "DigiCert",
        "Entrust", and "Microsoft".
        """
        return pulumi.get(self, "issuer_hint")

    @property
    @pulumi.getter(name="keyPassword")
    def key_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password used to encrypt the private key.
        """
        return pulumi.get(self, "key_password")

    @property
    @pulumi.getter
    def pkcs12(self) -> pulumi.Output[str]:
        """
        A base64-encoded PKCS#12 keystore secured by the `key_password`.
        """
        return pulumi.get(self, "pkcs12")

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> pulumi.Output[str]:
        """
        The private key in PEM format.
        """
        return pulumi.get(self, "private_key_pem")

    @property
    @pulumi.getter(name="rsaBits")
    def rsa_bits(self) -> pulumi.Output[Optional[int]]:
        """
        Number of bits to use when generating an RSA key.
        Applies when `algorithm=RSA`.  Defaults to `2048`.
        """
        return pulumi.get(self, "rsa_bits")

    @property
    @pulumi.getter(name="sanDns")
    def san_dns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of DNS names to use as alternative
        subjects of the certificate.
        """
        return pulumi.get(self, "san_dns")

    @property
    @pulumi.getter(name="sanEmails")
    def san_emails(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of email addresses to use as
        alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_emails")

    @property
    @pulumi.getter(name="sanIps")
    def san_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of IP addresses to use as alternative
        subjects of the certificate.
        """
        return pulumi.get(self, "san_ips")

    @property
    @pulumi.getter(name="validDays")
    def valid_days(self) -> pulumi.Output[Optional[int]]:
        """
        Desired number of days for which the new
        certificate will be valid.
        """
        return pulumi.get(self, "valid_days")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

