# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Provider']


class Provider(pulumi.ProviderResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 dev_mode: Optional[pulumi.Input[bool]] = None,
                 tpp_password: Optional[pulumi.Input[str]] = None,
                 tpp_username: Optional[pulumi.Input[str]] = None,
                 trust_bundle: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        The provider type for the venafi package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: Access token for TPP, user should use this for authentication
        :param pulumi.Input[str] api_key: API key for Venafi Cloud. Example: 142231b7-cvb0-412e-886b-6aeght0bc93d
        :param pulumi.Input[bool] dev_mode: When set to true, the resulting certificate will be issued by an ephemeral, no trust CA rather than enrolling using
               Venafi Cloud or Platform. Useful for development and testing.
        :param pulumi.Input[str] tpp_password: Password for WebSDK user. Example: password
        :param pulumi.Input[str] tpp_username: WebSDK user for Venafi Platform. Example: admin
        :param pulumi.Input[str] trust_bundle: Use to specify a PEM-formatted file that contains certificates to be trust anchors for all communications with the
               Venafi Web Service. Example: trust_bundle = "${file("chain.pem")}"
        :param pulumi.Input[str] url: The Venafi Web Service URL.. Example: https://tpp.venafi.example/vedsdk
        :param pulumi.Input[str] zone: DN of the Venafi Platform policy folder or name of the Venafi Cloud zone. Example for Platform: testpolicy\\vault
               Example for Venafi Cloud: Default
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['access_token'] = access_token
            __props__['api_key'] = api_key
            __props__['dev_mode'] = pulumi.Output.from_input(dev_mode).apply(pulumi.runtime.to_json) if dev_mode is not None else None
            if tpp_password is not None and not opts.urn:
                warnings.warn(""", please use access_token instead""", DeprecationWarning)
                pulumi.log.warn("""tpp_password is deprecated: , please use access_token instead""")
            __props__['tpp_password'] = tpp_password
            if tpp_username is not None and not opts.urn:
                warnings.warn(""", please use access_token instead""", DeprecationWarning)
                pulumi.log.warn("""tpp_username is deprecated: , please use access_token instead""")
            __props__['tpp_username'] = tpp_username
            __props__['trust_bundle'] = trust_bundle
            __props__['url'] = url
            __props__['zone'] = zone
        super(Provider, __self__).__init__(
            'venafi',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

