# AUTOGENERATED ON 2023-12-07 16:29:40.156487
## DO NOT MODIFY THIS FILE MANUALLY

from numpy import inf, nan

from autogoal.grammar import (
    ContinuousValue,
    DiscreteValue,
    CategoricalValue,
    BooleanValue,
)
from autogoal_sklearn._builder import SklearnEstimator, SklearnTransformer
from autogoal.kb import *

from sklearn.cluster._affinity_propagation import (
    AffinityPropagation as _AffinityPropagation,
)


class AffinityPropagation(_AffinityPropagation, SklearnEstimator):
    def __init__(
        self,
        convergence_iter: DiscreteValue(min=1, max=29),
        affinity: CategoricalValue("euclidean"),
    ):
        SklearnEstimator.__init__(self)
        _AffinityPropagation.__init__(
            self, convergence_iter=convergence_iter, affinity=affinity
        )
        self.init_params = {"convergence_iter": convergence_iter, "affinity": affinity}

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.cluster._agglomerative import FeatureAgglomeration as _FeatureAgglomeration


class FeatureAgglomeration(_FeatureAgglomeration, SklearnTransformer):
    def __init__(
        self,
        n_clusters: DiscreteValue(min=1, max=3),
        affinity: CategoricalValue("euclidean"),
        compute_full_tree: CategoricalValue("auto"),
        compute_distances: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _FeatureAgglomeration.__init__(
            self,
            n_clusters=n_clusters,
            affinity=affinity,
            compute_full_tree=compute_full_tree,
            compute_distances=compute_distances,
        )
        self.init_params = {
            "n_clusters": n_clusters,
            "affinity": affinity,
            "compute_full_tree": compute_full_tree,
            "compute_distances": compute_distances,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.cluster._birch import Birch as _Birch


class Birch(_Birch, SklearnEstimator):
    def __init__(
        self,
        threshold: ContinuousValue(min=-4.995, max=4.991),
        branching_factor: DiscreteValue(min=2, max=99),
        n_clusters: DiscreteValue(min=1, max=5),
        compute_labels: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _Birch.__init__(
            self,
            threshold=threshold,
            branching_factor=branching_factor,
            n_clusters=n_clusters,
            compute_labels=compute_labels,
        )
        self.init_params = {
            "threshold": threshold,
            "branching_factor": branching_factor,
            "n_clusters": n_clusters,
            "compute_labels": compute_labels,
        }

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.cluster._kmeans import KMeans as _KMeans


class KMeans(_KMeans, SklearnEstimator):
    def __init__(
        self, n_clusters: DiscreteValue(min=1, max=15), init: CategoricalValue("random")
    ):
        SklearnEstimator.__init__(self)
        _KMeans.__init__(self, n_clusters=n_clusters, init=init)
        self.init_params = {"n_clusters": n_clusters, "init": init}

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.cluster._kmeans import MiniBatchKMeans as _MiniBatchKMeans


class MiniBatchKMeans(_MiniBatchKMeans, SklearnEstimator):
    def __init__(
        self,
        n_clusters: DiscreteValue(min=1, max=15),
        init: CategoricalValue("random"),
        compute_labels: BooleanValue(),
        tol: ContinuousValue(min=-0.992, max=0.992),
        max_no_improvement: DiscreteValue(min=1, max=19),
        reassignment_ratio: ContinuousValue(min=0.003, max=0.094),
    ):
        SklearnEstimator.__init__(self)
        _MiniBatchKMeans.__init__(
            self,
            n_clusters=n_clusters,
            init=init,
            compute_labels=compute_labels,
            tol=tol,
            max_no_improvement=max_no_improvement,
            reassignment_ratio=reassignment_ratio,
        )
        self.init_params = {
            "n_clusters": n_clusters,
            "init": init,
            "compute_labels": compute_labels,
            "tol": tol,
            "max_no_improvement": max_no_improvement,
            "reassignment_ratio": reassignment_ratio,
        }

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.cluster._mean_shift import MeanShift as _MeanShift


class MeanShift(_MeanShift, SklearnEstimator):
    def __init__(self, bin_seeding: BooleanValue(), cluster_all: BooleanValue()):
        SklearnEstimator.__init__(self)
        _MeanShift.__init__(self, bin_seeding=bin_seeding, cluster_all=cluster_all)
        self.init_params = {"bin_seeding": bin_seeding, "cluster_all": cluster_all}

    def run(self, input: MatrixContinuousDense) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.decomposition._factor_analysis import FactorAnalysis as _FactorAnalysis


class FactorAnalysis(_FactorAnalysis, SklearnTransformer):
    def __init__(
        self,
        tol: ContinuousValue(min=-0.093, max=0.094),
        svd_method: CategoricalValue("lapack", "randomized"),
        iterated_power: DiscreteValue(min=1, max=5),
    ):
        SklearnTransformer.__init__(self)
        _FactorAnalysis.__init__(
            self, tol=tol, svd_method=svd_method, iterated_power=iterated_power
        )
        self.init_params = {
            "tol": tol,
            "svd_method": svd_method,
            "iterated_power": iterated_power,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._fastica import FastICA as _FastICA


class FastICA(_FastICA, SklearnTransformer):
    def __init__(
        self,
        algorithm: CategoricalValue("deflation", "parallel"),
        whiten: BooleanValue(),
        fun: CategoricalValue("cube", "exp", "logcosh"),
    ):
        SklearnTransformer.__init__(self)
        _FastICA.__init__(self, algorithm=algorithm, whiten=whiten, fun=fun)
        self.init_params = {"algorithm": algorithm, "whiten": whiten, "fun": fun}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._incremental_pca import IncrementalPCA as _IncrementalPCA


class IncrementalPCA(_IncrementalPCA, SklearnTransformer):
    def __init__(self, whiten: BooleanValue()):
        SklearnTransformer.__init__(self)
        _IncrementalPCA.__init__(self, whiten=whiten)
        self.init_params = {"whiten": whiten}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._kernel_pca import KernelPCA as _KernelPCA


class KernelPCA(_KernelPCA, SklearnTransformer):
    def __init__(
        self,
        kernel: CategoricalValue("cosine", "linear", "poly", "rbf"),
        degree: DiscreteValue(min=1, max=5),
        alpha: ContinuousValue(min=-9.995, max=9.991),
        fit_inverse_transform: BooleanValue(),
        eigen_solver: CategoricalValue("arpack", "auto", "dense", "randomized"),
        tol: DiscreteValue(min=-99, max=99),
        iterated_power: CategoricalValue("auto", "randomized"),
        remove_zero_eig: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _KernelPCA.__init__(
            self,
            kernel=kernel,
            degree=degree,
            alpha=alpha,
            fit_inverse_transform=fit_inverse_transform,
            eigen_solver=eigen_solver,
            tol=tol,
            iterated_power=iterated_power,
            remove_zero_eig=remove_zero_eig,
        )
        self.init_params = {
            "kernel": kernel,
            "degree": degree,
            "alpha": alpha,
            "fit_inverse_transform": fit_inverse_transform,
            "eigen_solver": eigen_solver,
            "tol": tol,
            "iterated_power": iterated_power,
            "remove_zero_eig": remove_zero_eig,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._lda import (
    LatentDirichletAllocation as _LatentDirichletAllocation,
)


class LatentDirichletAllocation(_LatentDirichletAllocation, SklearnTransformer):
    def __init__(
        self,
    ):
        SklearnTransformer.__init__(self)
        _LatentDirichletAllocation.__init__(
            self,
        )
        self.init_params = {}

    def run(self, input: MatrixContinuous) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._nmf import NMF as _NMF


class NMF(_NMF, SklearnTransformer):
    def __init__(
        self,
        alpha_W: ContinuousValue(min=0.0, max=0.0),
        l1_ratio: ContinuousValue(min=0.0, max=0.0),
        shuffle: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _NMF.__init__(self, alpha_W=alpha_W, l1_ratio=l1_ratio, shuffle=shuffle)
        self.init_params = {
            "alpha_W": alpha_W,
            "l1_ratio": l1_ratio,
            "shuffle": shuffle,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._pca import PCA as _PCA


class PCA(_PCA, SklearnTransformer):
    def __init__(
        self,
        whiten: BooleanValue(),
        svd_solver: CategoricalValue("arpack", "auto", "full", "randomized"),
        tol: ContinuousValue(min=-0.992, max=0.992),
        iterated_power: CategoricalValue("auto", "randomized"),
    ):
        SklearnTransformer.__init__(self)
        _PCA.__init__(
            self,
            whiten=whiten,
            svd_solver=svd_solver,
            tol=tol,
            iterated_power=iterated_power,
        )
        self.init_params = {
            "whiten": whiten,
            "svd_solver": svd_solver,
            "tol": tol,
            "iterated_power": iterated_power,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.decomposition._truncated_svd import TruncatedSVD as _TruncatedSVD


class TruncatedSVD(_TruncatedSVD, SklearnTransformer):
    def __init__(
        self,
        n_components: DiscreteValue(min=1, max=100) = 100,
        algorithm: CategoricalValue("arpack", "randomized") = "arpack",
        n_iter: DiscreteValue(min=1, max=9) = 5,
        tol: ContinuousValue(min=-0.992, max=0.992) = 0.0,
    ):
        SklearnTransformer.__init__(self)
        _TruncatedSVD.__init__(
            self, n_components=n_components, algorithm=algorithm, n_iter=n_iter, tol=tol
        )
        self.init_params = {
            "n_components": n_components,
            "algorithm": algorithm,
            "n_iter": n_iter,
            "tol": tol,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import CountVectorizer as _CountVectorizer


class CountVectorizer(_CountVectorizer, SklearnTransformer):
    def __init__(self, lowercase: BooleanValue(), binary: BooleanValue()):
        SklearnTransformer.__init__(self)
        _CountVectorizer.__init__(self, lowercase=lowercase, binary=binary)
        self.init_params = {"lowercase": lowercase, "binary": binary}

    def run(self, input: Seq[Sentence]) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import HashingVectorizer as _HashingVectorizer


class HashingVectorizer(_HashingVectorizer, SklearnTransformer):
    def __init__(
        self,
        lowercase: BooleanValue(),
        n_features: DiscreteValue(min=1, max=2097151),
        binary: BooleanValue(),
        norm: CategoricalValue("l1"),
        alternate_sign: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _HashingVectorizer.__init__(
            self,
            lowercase=lowercase,
            n_features=n_features,
            binary=binary,
            norm=norm,
            alternate_sign=alternate_sign,
        )
        self.init_params = {
            "lowercase": lowercase,
            "n_features": n_features,
            "binary": binary,
            "norm": norm,
            "alternate_sign": alternate_sign,
        }

    def run(self, input: Seq[Sentence]) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import TfidfTransformer as _TfidfTransformer


class TfidfTransformer(_TfidfTransformer, SklearnTransformer):
    def __init__(
        self,
        norm: CategoricalValue("l1", "l2"),
        use_idf: BooleanValue(),
        smooth_idf: BooleanValue(),
        sublinear_tf: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _TfidfTransformer.__init__(
            self,
            norm=norm,
            use_idf=use_idf,
            smooth_idf=smooth_idf,
            sublinear_tf=sublinear_tf,
        )
        self.init_params = {
            "norm": norm,
            "use_idf": use_idf,
            "smooth_idf": smooth_idf,
            "sublinear_tf": sublinear_tf,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.feature_extraction.text import TfidfVectorizer as _TfidfVectorizer


class TfidfVectorizer(_TfidfVectorizer, SklearnTransformer):
    def __init__(
        self,
        lowercase: BooleanValue(),
        binary: BooleanValue(),
        use_idf: BooleanValue(),
        smooth_idf: BooleanValue(),
        sublinear_tf: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _TfidfVectorizer.__init__(
            self,
            lowercase=lowercase,
            binary=binary,
            use_idf=use_idf,
            smooth_idf=smooth_idf,
            sublinear_tf=sublinear_tf,
        )
        self.init_params = {
            "lowercase": lowercase,
            "binary": binary,
            "use_idf": use_idf,
            "smooth_idf": smooth_idf,
            "sublinear_tf": sublinear_tf,
        }

    def run(self, input: Seq[Sentence]) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.impute._knn import KNNImputer as _KNNImputer


class KNNImputer(_KNNImputer, SklearnTransformer):
    def __init__(
        self,
        n_neighbors: DiscreteValue(min=1, max=9),
        weights: CategoricalValue("distance", "uniform"),
        metric: CategoricalValue("nan_euclidean"),
        add_indicator: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _KNNImputer.__init__(
            self,
            n_neighbors=n_neighbors,
            weights=weights,
            metric=metric,
            add_indicator=add_indicator,
        )
        self.init_params = {
            "n_neighbors": n_neighbors,
            "weights": weights,
            "metric": metric,
            "add_indicator": add_indicator,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.linear_model._base import LinearRegression as _LinearRegression


class LinearRegression(_LinearRegression, SklearnEstimator):
    def __init__(self, fit_intercept: BooleanValue(), positive: BooleanValue()):
        SklearnEstimator.__init__(self)
        _LinearRegression.__init__(self, fit_intercept=fit_intercept, positive=positive)
        self.init_params = {"fit_intercept": fit_intercept, "positive": positive}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._bayes import ARDRegression as _ARDRegression


class ARDRegression(_ARDRegression, SklearnEstimator):
    def __init__(
        self,
        n_iter: DiscreteValue(min=1, max=599),
        tol: ContinuousValue(min=-0.005, max=0.001),
        compute_score: BooleanValue(),
        threshold_lambda: ContinuousValue(min=-99999.993, max=99999.995),
        fit_intercept: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _ARDRegression.__init__(
            self,
            n_iter=n_iter,
            tol=tol,
            compute_score=compute_score,
            threshold_lambda=threshold_lambda,
            fit_intercept=fit_intercept,
        )
        self.init_params = {
            "n_iter": n_iter,
            "tol": tol,
            "compute_score": compute_score,
            "threshold_lambda": threshold_lambda,
            "fit_intercept": fit_intercept,
        }

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._bayes import BayesianRidge as _BayesianRidge


class BayesianRidge(_BayesianRidge, SklearnEstimator):
    def __init__(
        self,
        n_iter: DiscreteValue(min=1, max=599),
        tol: ContinuousValue(min=-0.005, max=0.001),
        compute_score: BooleanValue(),
        fit_intercept: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _BayesianRidge.__init__(
            self,
            n_iter=n_iter,
            tol=tol,
            compute_score=compute_score,
            fit_intercept=fit_intercept,
        )
        self.init_params = {
            "n_iter": n_iter,
            "tol": tol,
            "compute_score": compute_score,
            "fit_intercept": fit_intercept,
        }

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._coordinate_descent import ElasticNet as _ElasticNet


class ElasticNet(_ElasticNet, SklearnEstimator):
    def __init__(
        self,
        alpha: ContinuousValue(min=-9.995, max=9.991),
        fit_intercept: BooleanValue(),
        precompute: BooleanValue(),
        positive: BooleanValue(),
        selection: CategoricalValue("cyclic", "random"),
    ):
        SklearnEstimator.__init__(self)
        _ElasticNet.__init__(
            self,
            alpha=alpha,
            fit_intercept=fit_intercept,
            precompute=precompute,
            positive=positive,
            selection=selection,
        )
        self.init_params = {
            "alpha": alpha,
            "fit_intercept": fit_intercept,
            "precompute": precompute,
            "positive": positive,
            "selection": selection,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._coordinate_descent import Lasso as _Lasso


class Lasso(_Lasso, SklearnEstimator):
    def __init__(
        self,
        alpha: ContinuousValue(min=-9.995, max=9.991),
        fit_intercept: BooleanValue(),
        precompute: BooleanValue(),
        positive: BooleanValue(),
        selection: CategoricalValue("cyclic", "random"),
    ):
        SklearnEstimator.__init__(self)
        _Lasso.__init__(
            self,
            alpha=alpha,
            fit_intercept=fit_intercept,
            precompute=precompute,
            positive=positive,
            selection=selection,
        )
        self.init_params = {
            "alpha": alpha,
            "fit_intercept": fit_intercept,
            "precompute": precompute,
            "positive": positive,
            "selection": selection,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._glm.glm import GammaRegressor as _GammaRegressor


class GammaRegressor(_GammaRegressor, SklearnEstimator):
    def __init__(self, fit_intercept: BooleanValue()):
        SklearnEstimator.__init__(self)
        _GammaRegressor.__init__(self, fit_intercept=fit_intercept)
        self.init_params = {"fit_intercept": fit_intercept}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._glm.glm import (
    GeneralizedLinearRegressor as _GeneralizedLinearRegressor,
)


class GeneralizedLinearRegressor(_GeneralizedLinearRegressor, SklearnEstimator):
    def __init__(
        self,
        alpha: ContinuousValue(min=0.0, max=9.991),
        fit_intercept: BooleanValue(),
        family: CategoricalValue("normal", "poisson"),
        link: CategoricalValue("auto", "identity", "log"),
        solver: CategoricalValue("lbfgs"),
    ):
        SklearnEstimator.__init__(self)
        _GeneralizedLinearRegressor.__init__(
            self,
            alpha=alpha,
            fit_intercept=fit_intercept,
            family=family,
            link=link,
            solver=solver,
        )
        self.init_params = {
            "alpha": alpha,
            "fit_intercept": fit_intercept,
            "family": family,
            "link": link,
            "solver": solver,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._glm.glm import PoissonRegressor as _PoissonRegressor


class PoissonRegressor(_PoissonRegressor, SklearnEstimator):
    def __init__(
        self, alpha: ContinuousValue(min=0.0, max=9.991), fit_intercept: BooleanValue()
    ):
        SklearnEstimator.__init__(self)
        _PoissonRegressor.__init__(self, alpha=alpha, fit_intercept=fit_intercept)
        self.init_params = {"alpha": alpha, "fit_intercept": fit_intercept}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._glm.glm import TweedieRegressor as _TweedieRegressor


class TweedieRegressor(_TweedieRegressor, SklearnEstimator):
    def __init__(
        self,
        power: ContinuousValue(min=-0.992, max=0.0),
        alpha: ContinuousValue(min=0.0, max=9.991),
        fit_intercept: BooleanValue(),
        link: CategoricalValue("auto", "identity", "log"),
    ):
        SklearnEstimator.__init__(self)
        _TweedieRegressor.__init__(
            self, power=power, alpha=alpha, fit_intercept=fit_intercept, link=link
        )
        self.init_params = {
            "power": power,
            "alpha": alpha,
            "fit_intercept": fit_intercept,
            "link": link,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._huber import HuberRegressor as _HuberRegressor


class HuberRegressor(_HuberRegressor, SklearnEstimator):
    def __init__(
        self,
        epsilon: ContinuousValue(min=1.002, max=13.494),
        fit_intercept: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _HuberRegressor.__init__(self, epsilon=epsilon, fit_intercept=fit_intercept)
        self.init_params = {"epsilon": epsilon, "fit_intercept": fit_intercept}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._least_angle import Lars as _Lars


class Lars(_Lars, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: BooleanValue(),
        precompute: CategoricalValue("auto"),
        n_nonzero_coefs: DiscreteValue(min=1, max=999),
        fit_path: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _Lars.__init__(
            self,
            fit_intercept=fit_intercept,
            precompute=precompute,
            n_nonzero_coefs=n_nonzero_coefs,
            fit_path=fit_path,
        )
        self.init_params = {
            "fit_intercept": fit_intercept,
            "precompute": precompute,
            "n_nonzero_coefs": n_nonzero_coefs,
            "fit_path": fit_path,
        }

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._least_angle import LassoLars as _LassoLars


class LassoLars(_LassoLars, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: BooleanValue(),
        precompute: CategoricalValue("auto"),
        fit_path: BooleanValue(),
        positive: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _LassoLars.__init__(
            self,
            fit_intercept=fit_intercept,
            precompute=precompute,
            fit_path=fit_path,
            positive=positive,
        )
        self.init_params = {
            "fit_intercept": fit_intercept,
            "precompute": precompute,
            "fit_path": fit_path,
            "positive": positive,
        }

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._least_angle import LassoLarsIC as _LassoLarsIC


class LassoLarsIC(_LassoLarsIC, SklearnEstimator):
    def __init__(
        self,
        criterion: CategoricalValue("aic", "bic"),
        fit_intercept: BooleanValue(),
        precompute: CategoricalValue("auto"),
        positive: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _LassoLarsIC.__init__(
            self,
            criterion=criterion,
            fit_intercept=fit_intercept,
            precompute=precompute,
            positive=positive,
        )
        self.init_params = {
            "criterion": criterion,
            "fit_intercept": fit_intercept,
            "precompute": precompute,
            "positive": positive,
        }

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._logistic import LogisticRegression as _LogisticRegression


class LogisticRegression(_LogisticRegression, SklearnEstimator):
    def __init__(
        self,
        penalty: CategoricalValue("l2", "none"),
        dual: BooleanValue(),
        C: ContinuousValue(min=0.005, max=9.991),
        fit_intercept: BooleanValue(),
        multi_class: CategoricalValue("auto", "multinomial", "ovr"),
    ):
        SklearnEstimator.__init__(self)
        _LogisticRegression.__init__(
            self,
            penalty=penalty,
            dual=dual,
            C=C,
            fit_intercept=fit_intercept,
            multi_class=multi_class,
        )
        self.init_params = {
            "penalty": penalty,
            "dual": dual,
            "C": C,
            "fit_intercept": fit_intercept,
            "multi_class": multi_class,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._omp import (
    OrthogonalMatchingPursuit as _OrthogonalMatchingPursuit,
)


class OrthogonalMatchingPursuit(_OrthogonalMatchingPursuit, SklearnEstimator):
    def __init__(
        self, fit_intercept: BooleanValue(), precompute: CategoricalValue("auto")
    ):
        SklearnEstimator.__init__(self)
        _OrthogonalMatchingPursuit.__init__(
            self, fit_intercept=fit_intercept, precompute=precompute
        )
        self.init_params = {"fit_intercept": fit_intercept, "precompute": precompute}

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._passive_aggressive import (
    PassiveAggressiveClassifier as _PassiveAggressiveClassifier,
)


class PassiveAggressiveClassifier(_PassiveAggressiveClassifier, SklearnEstimator):
    def __init__(
        self,
        C: ContinuousValue(min=-9.995, max=9.991),
        fit_intercept: BooleanValue(),
        tol: ContinuousValue(min=-0.005, max=0.001),
        early_stopping: BooleanValue(),
        validation_fraction: ContinuousValue(min=0.006, max=0.993),
        n_iter_no_change: DiscreteValue(min=1, max=9),
        shuffle: BooleanValue(),
        average: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _PassiveAggressiveClassifier.__init__(
            self,
            C=C,
            fit_intercept=fit_intercept,
            tol=tol,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            shuffle=shuffle,
            average=average,
        )
        self.init_params = {
            "C": C,
            "fit_intercept": fit_intercept,
            "tol": tol,
            "early_stopping": early_stopping,
            "validation_fraction": validation_fraction,
            "n_iter_no_change": n_iter_no_change,
            "shuffle": shuffle,
            "average": average,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._passive_aggressive import (
    PassiveAggressiveRegressor as _PassiveAggressiveRegressor,
)


class PassiveAggressiveRegressor(_PassiveAggressiveRegressor, SklearnEstimator):
    def __init__(
        self,
        C: ContinuousValue(min=-9.995, max=9.991),
        fit_intercept: BooleanValue(),
        tol: ContinuousValue(min=-0.005, max=0.001),
        early_stopping: BooleanValue(),
        validation_fraction: ContinuousValue(min=0.006, max=0.993),
        n_iter_no_change: DiscreteValue(min=1, max=9),
        shuffle: BooleanValue(),
        epsilon: ContinuousValue(min=-0.992, max=0.993),
        average: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _PassiveAggressiveRegressor.__init__(
            self,
            C=C,
            fit_intercept=fit_intercept,
            tol=tol,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            shuffle=shuffle,
            epsilon=epsilon,
            average=average,
        )
        self.init_params = {
            "C": C,
            "fit_intercept": fit_intercept,
            "tol": tol,
            "early_stopping": early_stopping,
            "validation_fraction": validation_fraction,
            "n_iter_no_change": n_iter_no_change,
            "shuffle": shuffle,
            "epsilon": epsilon,
            "average": average,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._perceptron import Perceptron as _Perceptron


class Perceptron(_Perceptron, SklearnEstimator):
    def __init__(
        self,
        l1_ratio: ContinuousValue(min=0.001, max=0.999),
        fit_intercept: BooleanValue(),
        tol: ContinuousValue(min=-0.005, max=0.001),
        shuffle: BooleanValue(),
        eta0: ContinuousValue(min=0.005, max=9.991),
        early_stopping: BooleanValue(),
        validation_fraction: ContinuousValue(min=0.006, max=0.993),
        n_iter_no_change: DiscreteValue(min=1, max=9),
    ):
        SklearnEstimator.__init__(self)
        _Perceptron.__init__(
            self,
            l1_ratio=l1_ratio,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            eta0=eta0,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
        )
        self.init_params = {
            "l1_ratio": l1_ratio,
            "fit_intercept": fit_intercept,
            "tol": tol,
            "shuffle": shuffle,
            "eta0": eta0,
            "early_stopping": early_stopping,
            "validation_fraction": validation_fraction,
            "n_iter_no_change": n_iter_no_change,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._quantile import QuantileRegressor as _QuantileRegressor


class QuantileRegressor(_QuantileRegressor, SklearnEstimator):
    def __init__(
        self,
        alpha: ContinuousValue(min=0.0, max=9.991),
        fit_intercept: BooleanValue(),
        solver: CategoricalValue("highs"),
    ):
        SklearnEstimator.__init__(self)
        _QuantileRegressor.__init__(
            self, alpha=alpha, fit_intercept=fit_intercept, solver=solver
        )
        self.init_params = {
            "alpha": alpha,
            "fit_intercept": fit_intercept,
            "solver": solver,
        }

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._ridge import Ridge as _Ridge


class Ridge(_Ridge, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: BooleanValue(),
        solver: CategoricalValue("lsqr", "sag", "saga", "sparse_cg", "svd"),
        positive: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _Ridge.__init__(
            self, fit_intercept=fit_intercept, solver=solver, positive=positive
        )
        self.init_params = {
            "fit_intercept": fit_intercept,
            "solver": solver,
            "positive": positive,
        }

    def run(
        self, X: MatrixContinuousSparse, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._ridge import RidgeClassifier as _RidgeClassifier


class RidgeClassifier(_RidgeClassifier, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: BooleanValue(),
        solver: CategoricalValue("lsqr", "sag", "saga", "sparse_cg", "svd"),
        positive: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _RidgeClassifier.__init__(
            self, fit_intercept=fit_intercept, solver=solver, positive=positive
        )
        self.init_params = {
            "fit_intercept": fit_intercept,
            "solver": solver,
            "positive": positive,
        }

    def run(
        self, X: MatrixContinuousSparse, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._stochastic_gradient import SGDClassifier as _SGDClassifier


class SGDClassifier(_SGDClassifier, SklearnEstimator):
    def __init__(
        self,
        loss: CategoricalValue(
            "epsilon_insensitive",
            "hinge",
            "huber",
            "log",
            "modified_huber",
            "perceptron",
            "squared_epsilon_insensitive",
            "squared_error",
            "squared_hinge",
            "squared_loss",
        ),
        penalty: CategoricalValue("elasticnet", "l1", "l2"),
        l1_ratio: ContinuousValue(min=0.001, max=0.999),
        fit_intercept: BooleanValue(),
        tol: ContinuousValue(min=-0.005, max=0.001),
        shuffle: BooleanValue(),
        epsilon: ContinuousValue(min=-0.992, max=0.993),
        learning_rate: CategoricalValue("optimal"),
        eta0: ContinuousValue(min=-0.992, max=0.992),
        power_t: ContinuousValue(min=-4.995, max=4.991),
        early_stopping: BooleanValue(),
        validation_fraction: ContinuousValue(min=0.006, max=0.993),
        n_iter_no_change: DiscreteValue(min=1, max=9),
        average: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _SGDClassifier.__init__(
            self,
            loss=loss,
            penalty=penalty,
            l1_ratio=l1_ratio,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            epsilon=epsilon,
            learning_rate=learning_rate,
            eta0=eta0,
            power_t=power_t,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            average=average,
        )
        self.init_params = {
            "loss": loss,
            "penalty": penalty,
            "l1_ratio": l1_ratio,
            "fit_intercept": fit_intercept,
            "tol": tol,
            "shuffle": shuffle,
            "epsilon": epsilon,
            "learning_rate": learning_rate,
            "eta0": eta0,
            "power_t": power_t,
            "early_stopping": early_stopping,
            "validation_fraction": validation_fraction,
            "n_iter_no_change": n_iter_no_change,
            "average": average,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._stochastic_gradient import SGDOneClassSVM as _SGDOneClassSVM


class SGDOneClassSVM(_SGDOneClassSVM, SklearnEstimator):
    def __init__(
        self,
        fit_intercept: BooleanValue(),
        tol: ContinuousValue(min=-0.005, max=0.001),
        shuffle: BooleanValue(),
        learning_rate: CategoricalValue("optimal"),
        eta0: ContinuousValue(min=-0.992, max=0.992),
        power_t: ContinuousValue(min=-4.995, max=4.991),
        average: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _SGDOneClassSVM.__init__(
            self,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            learning_rate=learning_rate,
            eta0=eta0,
            power_t=power_t,
            average=average,
        )
        self.init_params = {
            "fit_intercept": fit_intercept,
            "tol": tol,
            "shuffle": shuffle,
            "learning_rate": learning_rate,
            "eta0": eta0,
            "power_t": power_t,
            "average": average,
        }

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.linear_model._stochastic_gradient import SGDRegressor as _SGDRegressor


class SGDRegressor(_SGDRegressor, SklearnEstimator):
    def __init__(
        self,
        loss: CategoricalValue(
            "epsilon_insensitive",
            "huber",
            "squared_epsilon_insensitive",
            "squared_error",
            "squared_loss",
        ),
        penalty: CategoricalValue("elasticnet", "l1", "l2"),
        l1_ratio: ContinuousValue(min=0.001, max=0.999),
        fit_intercept: BooleanValue(),
        tol: ContinuousValue(min=-0.005, max=0.001),
        shuffle: BooleanValue(),
        epsilon: ContinuousValue(min=-0.992, max=0.993),
        learning_rate: CategoricalValue(
            "adaptive", "constant", "invscaling", "optimal"
        ),
        eta0: ContinuousValue(min=0.003, max=0.094),
        power_t: ContinuousValue(min=-2.494, max=2.491),
        early_stopping: BooleanValue(),
        validation_fraction: ContinuousValue(min=0.006, max=0.993),
        n_iter_no_change: DiscreteValue(min=1, max=9),
        average: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _SGDRegressor.__init__(
            self,
            loss=loss,
            penalty=penalty,
            l1_ratio=l1_ratio,
            fit_intercept=fit_intercept,
            tol=tol,
            shuffle=shuffle,
            epsilon=epsilon,
            learning_rate=learning_rate,
            eta0=eta0,
            power_t=power_t,
            early_stopping=early_stopping,
            validation_fraction=validation_fraction,
            n_iter_no_change=n_iter_no_change,
            average=average,
        )
        self.init_params = {
            "loss": loss,
            "penalty": penalty,
            "l1_ratio": l1_ratio,
            "fit_intercept": fit_intercept,
            "tol": tol,
            "shuffle": shuffle,
            "epsilon": epsilon,
            "learning_rate": learning_rate,
            "eta0": eta0,
            "power_t": power_t,
            "early_stopping": early_stopping,
            "validation_fraction": validation_fraction,
            "n_iter_no_change": n_iter_no_change,
            "average": average,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.linear_model._theil_sen import TheilSenRegressor as _TheilSenRegressor


class TheilSenRegressor(_TheilSenRegressor, SklearnEstimator):
    def __init__(
        self, fit_intercept: BooleanValue(), tol: ContinuousValue(min=-0.005, max=0.001)
    ):
        SklearnEstimator.__init__(self)
        _TheilSenRegressor.__init__(self, fit_intercept=fit_intercept, tol=tol)
        self.init_params = {"fit_intercept": fit_intercept, "tol": tol}

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.manifold._isomap import Isomap as _Isomap


class Isomap(_Isomap, SklearnTransformer):
    def __init__(
        self,
        n_neighbors: DiscreteValue(min=1, max=9),
        n_components: DiscreteValue(min=1, max=3),
        eigen_solver: CategoricalValue("arpack", "auto", "dense"),
        tol: DiscreteValue(min=-99, max=99),
        path_method: CategoricalValue("auto"),
        neighbors_algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        p: DiscreteValue(min=1, max=3),
    ):
        SklearnTransformer.__init__(self)
        _Isomap.__init__(
            self,
            n_neighbors=n_neighbors,
            n_components=n_components,
            eigen_solver=eigen_solver,
            tol=tol,
            path_method=path_method,
            neighbors_algorithm=neighbors_algorithm,
            p=p,
        )
        self.init_params = {
            "n_neighbors": n_neighbors,
            "n_components": n_components,
            "eigen_solver": eigen_solver,
            "tol": tol,
            "path_method": path_method,
            "neighbors_algorithm": neighbors_algorithm,
            "p": p,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.naive_bayes import BernoulliNB as _BernoulliNB


class BernoulliNB(_BernoulliNB, SklearnEstimator):
    def __init__(
        self,
        alpha: ContinuousValue(min=0.0, max=9.991),
        binarize: ContinuousValue(min=-0.992, max=0.992),
        fit_prior: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _BernoulliNB.__init__(self, alpha=alpha, binarize=binarize, fit_prior=fit_prior)
        self.init_params = {
            "alpha": alpha,
            "binarize": binarize,
            "fit_prior": fit_prior,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.naive_bayes import CategoricalNB as _CategoricalNB


class CategoricalNB(_CategoricalNB, SklearnEstimator):
    def __init__(self, fit_prior: BooleanValue()):
        SklearnEstimator.__init__(self)
        _CategoricalNB.__init__(self, fit_prior=fit_prior)
        self.init_params = {"fit_prior": fit_prior}

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.naive_bayes import ComplementNB as _ComplementNB


class ComplementNB(_ComplementNB, SklearnEstimator):
    def __init__(self, fit_prior: BooleanValue(), norm: BooleanValue()):
        SklearnEstimator.__init__(self)
        _ComplementNB.__init__(self, fit_prior=fit_prior, norm=norm)
        self.init_params = {"fit_prior": fit_prior, "norm": norm}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.naive_bayes import GaussianNB as _GaussianNB


class GaussianNB(_GaussianNB, SklearnEstimator):
    def __init__(
        self,
    ):
        SklearnEstimator.__init__(self)
        _GaussianNB.__init__(
            self,
        )
        self.init_params = {}

    def run(
        self, X: MatrixContinuousDense, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.naive_bayes import MultinomialNB as _MultinomialNB


class MultinomialNB(_MultinomialNB, SklearnEstimator):
    def __init__(self, fit_prior: BooleanValue()):
        SklearnEstimator.__init__(self)
        _MultinomialNB.__init__(self, fit_prior=fit_prior)
        self.init_params = {"fit_prior": fit_prior}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.neighbors._classification import (
    KNeighborsClassifier as _KNeighborsClassifier,
)


class KNeighborsClassifier(_KNeighborsClassifier, SklearnEstimator):
    def __init__(
        self,
        n_neighbors: DiscreteValue(min=1, max=9),
        weights: CategoricalValue("distance", "uniform"),
        algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: DiscreteValue(min=1, max=59),
        p: DiscreteValue(min=1, max=3),
        metric: CategoricalValue("cityblock", "cosine", "haversine", "minkowski", "l1", "l2", "manhattan", "nan_euclidean"),
    ):
        SklearnEstimator.__init__(self)
        _KNeighborsClassifier.__init__(
            self,
            n_neighbors=n_neighbors,
            weights=weights,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
            metric=metric,
        )
        self.init_params = {
            "n_neighbors": n_neighbors,
            "weights": weights,
            "algorithm": algorithm,
            "leaf_size": leaf_size,
            "p": p,
            "metric": metric,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.neighbors._graph import KNeighborsTransformer as _KNeighborsTransformer


class KNeighborsTransformer(_KNeighborsTransformer, SklearnTransformer):
    def __init__(
        self,
        mode: CategoricalValue("connectivity", "distance"),
        n_neighbors: DiscreteValue(min=1, max=9),
        algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: DiscreteValue(min=1, max=59),
        p: DiscreteValue(min=1, max=3),
    ):
        SklearnTransformer.__init__(self)
        _KNeighborsTransformer.__init__(
            self,
            mode=mode,
            n_neighbors=n_neighbors,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
        )
        self.init_params = {
            "mode": mode,
            "n_neighbors": n_neighbors,
            "algorithm": algorithm,
            "leaf_size": leaf_size,
            "p": p,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.neighbors._graph import (
    RadiusNeighborsTransformer as _RadiusNeighborsTransformer,
)


class RadiusNeighborsTransformer(_RadiusNeighborsTransformer, SklearnTransformer):
    def __init__(
        self,
        mode: CategoricalValue("connectivity", "distance"),
        radius: ContinuousValue(min=-9.995, max=9.991),
        algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: DiscreteValue(min=1, max=59),
        p: DiscreteValue(min=1, max=3),
    ):
        SklearnTransformer.__init__(self)
        _RadiusNeighborsTransformer.__init__(
            self,
            mode=mode,
            radius=radius,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
        )
        self.init_params = {
            "mode": mode,
            "radius": radius,
            "algorithm": algorithm,
            "leaf_size": leaf_size,
            "p": p,
        }

    def run(self, input: MatrixContinuous) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.neighbors._lof import LocalOutlierFactor as _LocalOutlierFactor


class LocalOutlierFactor(_LocalOutlierFactor, SklearnEstimator):
    def __init__(
        self,
        n_neighbors: DiscreteValue(min=1, max=39),
        algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: DiscreteValue(min=1, max=59),
        p: DiscreteValue(min=1, max=3),
        contamination: CategoricalValue("auto"),
        novelty: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _LocalOutlierFactor.__init__(
            self,
            n_neighbors=n_neighbors,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
            contamination=contamination,
            novelty=novelty,
        )
        self.init_params = {
            "n_neighbors": n_neighbors,
            "algorithm": algorithm,
            "leaf_size": leaf_size,
            "p": p,
            "contamination": contamination,
            "novelty": novelty,
        }

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.neighbors._nearest_centroid import NearestCentroid as _NearestCentroid


class NearestCentroid(_NearestCentroid, SklearnEstimator):
    def __init__(
        self,
    ):
        SklearnEstimator.__init__(self)
        _NearestCentroid.__init__(
            self,
        )
        self.init_params = {}

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.neighbors._regression import KNeighborsRegressor as _KNeighborsRegressor


class KNeighborsRegressor(_KNeighborsRegressor, SklearnEstimator):
    def __init__(
        self,
        n_neighbors: DiscreteValue(min=1, max=9),
        weights: CategoricalValue("distance", "uniform"),
        algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: DiscreteValue(min=1, max=59),
        p: DiscreteValue(min=1, max=3),
        metric: CategoricalValue("minkowski"),
    ):
        SklearnEstimator.__init__(self)
        _KNeighborsRegressor.__init__(
            self,
            n_neighbors=n_neighbors,
            weights=weights,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
            metric=metric,
        )
        self.init_params = {
            "n_neighbors": n_neighbors,
            "weights": weights,
            "algorithm": algorithm,
            "leaf_size": leaf_size,
            "p": p,
            "metric": metric,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.neighbors._regression import (
    RadiusNeighborsRegressor as _RadiusNeighborsRegressor,
)


class RadiusNeighborsRegressor(_RadiusNeighborsRegressor, SklearnEstimator):
    def __init__(
        self,
        radius: ContinuousValue(min=-9.995, max=9.991),
        weights: CategoricalValue("distance", "uniform"),
        algorithm: CategoricalValue("auto", "ball_tree", "brute", "kd_tree"),
        leaf_size: DiscreteValue(min=1, max=59),
        p: DiscreteValue(min=1, max=3),
    ):
        SklearnEstimator.__init__(self)
        _RadiusNeighborsRegressor.__init__(
            self,
            radius=radius,
            weights=weights,
            algorithm=algorithm,
            leaf_size=leaf_size,
            p=p,
        )
        self.init_params = {
            "radius": radius,
            "weights": weights,
            "algorithm": algorithm,
            "leaf_size": leaf_size,
            "p": p,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.preprocessing._data import KernelCenterer as _KernelCenterer


class KernelCenterer(_KernelCenterer, SklearnTransformer):
    def __init__(
        self,
    ):
        SklearnTransformer.__init__(self)
        _KernelCenterer.__init__(
            self,
        )
        self.init_params = {}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import MinMaxScaler as _MinMaxScaler


class MinMaxScaler(_MinMaxScaler, SklearnTransformer):
    def __init__(self, clip: BooleanValue()):
        SklearnTransformer.__init__(self)
        _MinMaxScaler.__init__(self, clip=clip)
        self.init_params = {"clip": clip}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import PowerTransformer as _PowerTransformer


class PowerTransformer(_PowerTransformer, SklearnTransformer):
    def __init__(self, standardize: BooleanValue()):
        SklearnTransformer.__init__(self)
        _PowerTransformer.__init__(self, standardize=standardize)
        self.init_params = {"standardize": standardize}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import RobustScaler as _RobustScaler


class RobustScaler(_RobustScaler, SklearnTransformer):
    def __init__(
        self,
        with_centering: BooleanValue(),
        with_scaling: BooleanValue(),
        unit_variance: BooleanValue(),
    ):
        SklearnTransformer.__init__(self)
        _RobustScaler.__init__(
            self,
            with_centering=with_centering,
            with_scaling=with_scaling,
            unit_variance=unit_variance,
        )
        self.init_params = {
            "with_centering": with_centering,
            "with_scaling": with_scaling,
            "unit_variance": unit_variance,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._data import StandardScaler as _StandardScaler


class StandardScaler(_StandardScaler, SklearnTransformer):
    def __init__(self, with_mean: BooleanValue(), with_std: BooleanValue()):
        SklearnTransformer.__init__(self)
        _StandardScaler.__init__(self, with_mean=with_mean, with_std=with_std)
        self.init_params = {"with_mean": with_mean, "with_std": with_std}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._discretization import KBinsDiscretizer as _KBinsDiscretizer


class KBinsDiscretizer(_KBinsDiscretizer, SklearnTransformer):
    def __init__(
        self,
        n_bins: DiscreteValue(min=2, max=9),
        encode: CategoricalValue("onehot", "ordinal"),
        strategy: CategoricalValue("kmeans", "quantile", "uniform"),
    ):
        SklearnTransformer.__init__(self)
        _KBinsDiscretizer.__init__(
            self, n_bins=n_bins, encode=encode, strategy=strategy
        )
        self.init_params = {"n_bins": n_bins, "encode": encode, "strategy": strategy}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._encoders import OneHotEncoder as _OneHotEncoder


class OneHotEncoder(_OneHotEncoder, SklearnTransformer):
    def __init__(
        self,
        categories: CategoricalValue("auto"),
        sparse: BooleanValue(),
        handle_unknown: CategoricalValue("error", "ignore"),
    ):
        SklearnTransformer.__init__(self)
        _OneHotEncoder.__init__(
            self, categories=categories, sparse=sparse, handle_unknown=handle_unknown
        )
        self.init_params = {
            "categories": categories,
            "sparse": sparse,
            "handle_unknown": handle_unknown,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousSparse:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._encoders import OrdinalEncoder as _OrdinalEncoder


class OrdinalEncoder(_OrdinalEncoder, SklearnTransformer):
    def __init__(
        self,
        categories: CategoricalValue("auto"),
        handle_unknown: CategoricalValue("error"),
    ):
        SklearnTransformer.__init__(self)
        _OrdinalEncoder.__init__(
            self, categories=categories, handle_unknown=handle_unknown
        )
        self.init_params = {"categories": categories, "handle_unknown": handle_unknown}

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._label import LabelBinarizer as _LabelBinarizer


class LabelBinarizer(_LabelBinarizer, SklearnTransformer):
    def __init__(self, sparse_output: BooleanValue()):
        SklearnTransformer.__init__(self)
        _LabelBinarizer.__init__(self, sparse_output=sparse_output)
        self.init_params = {"sparse_output": sparse_output}

    def run(self, input: Seq[Label]) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.preprocessing._polynomial import SplineTransformer as _SplineTransformer


class SplineTransformer(_SplineTransformer, SklearnTransformer):
    def __init__(
        self,
        n_knots: DiscreteValue(min=2, max=9),
        degree: DiscreteValue(min=1, max=5),
        knots: CategoricalValue("quantile", "uniform"),
        extrapolation: CategoricalValue(
            "constant", "continue", "error", "linear", "periodic"
        ),
        include_bias: BooleanValue(),
        order: CategoricalValue("c", "f"),
    ):
        SklearnTransformer.__init__(self)
        _SplineTransformer.__init__(
            self,
            n_knots=n_knots,
            degree=degree,
            knots=knots,
            extrapolation=extrapolation,
            include_bias=include_bias,
            order=order,
        )
        self.init_params = {
            "n_knots": n_knots,
            "degree": degree,
            "knots": knots,
            "extrapolation": extrapolation,
            "include_bias": include_bias,
            "order": order,
        }

    def run(self, input: MatrixContinuousDense) -> MatrixContinuousDense:
        return SklearnTransformer.run(self, input)


from sklearn.svm._classes import LinearSVC as _LinearSVC


class LinearSVC(_LinearSVC, SklearnEstimator):
    def __init__(
        self,
        penalty: CategoricalValue("l2"),
        loss: CategoricalValue("hinge", "squared_hinge"),
        dual: BooleanValue(),
        C: ContinuousValue(min=0.005, max=9.991),
        multi_class: CategoricalValue("crammer_singer", "ovr"),
        fit_intercept: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _LinearSVC.__init__(
            self,
            penalty=penalty,
            loss=loss,
            dual=dual,
            C=C,
            multi_class=multi_class,
            fit_intercept=fit_intercept,
        )
        self.init_params = {
            "penalty": penalty,
            "loss": loss,
            "dual": dual,
            "C": C,
            "multi_class": multi_class,
            "fit_intercept": fit_intercept,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.svm._classes import LinearSVR as _LinearSVR


class LinearSVR(_LinearSVR, SklearnEstimator):
    def __init__(
        self,
        epsilon: ContinuousValue(min=0.0, max=0.992),
        C: ContinuousValue(min=0.005, max=9.991),
        loss: CategoricalValue("epsilon_insensitive", "squared_epsilon_insensitive"),
        fit_intercept: BooleanValue(),
        intercept_scaling: ContinuousValue(min=0.005, max=9.991),
        dual: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _LinearSVR.__init__(
            self,
            epsilon=epsilon,
            C=C,
            loss=loss,
            fit_intercept=fit_intercept,
            intercept_scaling=intercept_scaling,
            dual=dual,
        )
        self.init_params = {
            "epsilon": epsilon,
            "C": C,
            "loss": loss,
            "fit_intercept": fit_intercept,
            "intercept_scaling": intercept_scaling,
            "dual": dual,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.svm._classes import NuSVC as _NuSVC


class NuSVC(_NuSVC, SklearnEstimator):
    def __init__(
        self,
        kernel: CategoricalValue("linear", "poly", "rbf", "sigmoid"),
        degree: DiscreteValue(min=1, max=5),
        gamma: CategoricalValue("auto", "scale"),
        coef0: ContinuousValue(min=-0.992, max=0.992),
        shrinking: BooleanValue(),
        probability: BooleanValue(),
        cache_size: DiscreteValue(min=1, max=399),
        decision_function_shape: CategoricalValue("ovo", "ovr"),
        break_ties: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _NuSVC.__init__(
            self,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            probability=probability,
            cache_size=cache_size,
            decision_function_shape=decision_function_shape,
            break_ties=break_ties,
        )
        self.init_params = {
            "kernel": kernel,
            "degree": degree,
            "gamma": gamma,
            "coef0": coef0,
            "shrinking": shrinking,
            "probability": probability,
            "cache_size": cache_size,
            "decision_function_shape": decision_function_shape,
            "break_ties": break_ties,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.svm._classes import NuSVR as _NuSVR


class NuSVR(_NuSVR, SklearnEstimator):
    def __init__(
        self,
        C: ContinuousValue(min=0.005, max=9.991),
        kernel: CategoricalValue("linear", "poly", "rbf", "sigmoid"),
        degree: DiscreteValue(min=1, max=5),
        gamma: CategoricalValue("auto", "scale"),
        coef0: ContinuousValue(min=-0.992, max=0.992),
        shrinking: BooleanValue(),
        cache_size: DiscreteValue(min=1, max=399),
    ):
        SklearnEstimator.__init__(self)
        _NuSVR.__init__(
            self,
            C=C,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            cache_size=cache_size,
        )
        self.init_params = {
            "C": C,
            "kernel": kernel,
            "degree": degree,
            "gamma": gamma,
            "coef0": coef0,
            "shrinking": shrinking,
            "cache_size": cache_size,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.svm._classes import OneClassSVM as _OneClassSVM


class OneClassSVM(_OneClassSVM, SklearnEstimator):
    def __init__(
        self,
        kernel: CategoricalValue("linear", "poly", "rbf", "sigmoid"),
        degree: DiscreteValue(min=1, max=5),
        gamma: CategoricalValue("auto", "scale"),
        coef0: ContinuousValue(min=-0.992, max=0.992),
        shrinking: BooleanValue(),
        cache_size: DiscreteValue(min=1, max=399),
    ):
        SklearnEstimator.__init__(self)
        _OneClassSVM.__init__(
            self,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            cache_size=cache_size,
        )
        self.init_params = {
            "kernel": kernel,
            "degree": degree,
            "gamma": gamma,
            "coef0": coef0,
            "shrinking": shrinking,
            "cache_size": cache_size,
        }

    def run(self, input: MatrixContinuous) -> VectorDiscrete:
        return SklearnEstimator.run(self, input)


from sklearn.svm._classes import SVC as _SVC


class SVC(_SVC, SklearnEstimator):
    def __init__(
        self,
        C: ContinuousValue(min=0.005, max=9.991),
        degree: DiscreteValue(min=1, max=5),
        gamma: CategoricalValue("auto", "scale"),
        coef0: ContinuousValue(min=-0.992, max=0.992),
        shrinking: BooleanValue(),
        probability: BooleanValue(),
        cache_size: DiscreteValue(min=1, max=399),
        decision_function_shape: CategoricalValue("ovo", "ovr"),
        break_ties: BooleanValue(),
    ):
        SklearnEstimator.__init__(self)
        _SVC.__init__(
            self,
            C=C,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            shrinking=shrinking,
            probability=probability,
            cache_size=cache_size,
            decision_function_shape=decision_function_shape,
            break_ties=break_ties,
        )
        self.init_params = {
            "C": C,
            "degree": degree,
            "gamma": gamma,
            "coef0": coef0,
            "shrinking": shrinking,
            "probability": probability,
            "cache_size": cache_size,
            "decision_function_shape": decision_function_shape,
            "break_ties": break_ties,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.svm._classes import SVR as _SVR


class SVR(_SVR, SklearnEstimator):
    def __init__(
        self,
        kernel: CategoricalValue("linear", "poly", "rbf", "sigmoid"),
        degree: DiscreteValue(min=1, max=5),
        gamma: CategoricalValue("auto", "scale"),
        coef0: ContinuousValue(min=-0.992, max=0.992),
        C: ContinuousValue(min=0.005, max=9.991),
        epsilon: ContinuousValue(min=0.006, max=0.993),
        shrinking: BooleanValue(),
        cache_size: DiscreteValue(min=1, max=399),
    ):
        SklearnEstimator.__init__(self)
        _SVR.__init__(
            self,
            kernel=kernel,
            degree=degree,
            gamma=gamma,
            coef0=coef0,
            C=C,
            epsilon=epsilon,
            shrinking=shrinking,
            cache_size=cache_size,
        )
        self.init_params = {
            "kernel": kernel,
            "degree": degree,
            "gamma": gamma,
            "coef0": coef0,
            "C": C,
            "epsilon": epsilon,
            "shrinking": shrinking,
            "cache_size": cache_size,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.tree._classes import DecisionTreeClassifier as _DecisionTreeClassifier


class DecisionTreeClassifier(_DecisionTreeClassifier, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: DiscreteValue(min=2, max=3),
        min_weight_fraction_leaf: ContinuousValue(min=0.0, max=0.5),
        min_impurity_decrease: ContinuousValue(min=0.0, max=0.992),
        ccp_alpha: ContinuousValue(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _DecisionTreeClassifier.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )
        self.init_params = {
            "min_samples_split": min_samples_split,
            "min_weight_fraction_leaf": min_weight_fraction_leaf,
            "min_impurity_decrease": min_impurity_decrease,
            "ccp_alpha": ccp_alpha,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.tree._classes import DecisionTreeRegressor as _DecisionTreeRegressor


class DecisionTreeRegressor(_DecisionTreeRegressor, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: DiscreteValue(min=2, max=3),
        min_weight_fraction_leaf: ContinuousValue(min=0.0, max=0.5),
        min_impurity_decrease: ContinuousValue(min=0.0, max=0.992),
        ccp_alpha: ContinuousValue(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _DecisionTreeRegressor.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )
        self.init_params = {
            "min_samples_split": min_samples_split,
            "min_weight_fraction_leaf": min_weight_fraction_leaf,
            "min_impurity_decrease": min_impurity_decrease,
            "ccp_alpha": ccp_alpha,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)


from sklearn.tree._classes import ExtraTreeClassifier as _ExtraTreeClassifier


class ExtraTreeClassifier(_ExtraTreeClassifier, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: DiscreteValue(min=2, max=3),
        min_weight_fraction_leaf: ContinuousValue(min=0.0, max=0.5),
        min_impurity_decrease: ContinuousValue(min=0.0, max=0.992),
        ccp_alpha: ContinuousValue(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _ExtraTreeClassifier.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )
        self.init_params = {
            "min_samples_split": min_samples_split,
            "min_weight_fraction_leaf": min_weight_fraction_leaf,
            "min_impurity_decrease": min_impurity_decrease,
            "ccp_alpha": ccp_alpha,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorCategorical]
    ) -> VectorCategorical:
        return SklearnEstimator.run(self, X, y)


from sklearn.tree._classes import ExtraTreeRegressor as _ExtraTreeRegressor


class ExtraTreeRegressor(_ExtraTreeRegressor, SklearnEstimator):
    def __init__(
        self,
        min_samples_split: DiscreteValue(min=2, max=3),
        min_weight_fraction_leaf: ContinuousValue(min=0.0, max=0.5),
        min_impurity_decrease: ContinuousValue(min=0.0, max=0.992),
        ccp_alpha: ContinuousValue(min=0.0, max=0.992),
    ):
        SklearnEstimator.__init__(self)
        _ExtraTreeRegressor.__init__(
            self,
            min_samples_split=min_samples_split,
            min_weight_fraction_leaf=min_weight_fraction_leaf,
            min_impurity_decrease=min_impurity_decrease,
            ccp_alpha=ccp_alpha,
        )
        self.init_params = {
            "min_samples_split": min_samples_split,
            "min_weight_fraction_leaf": min_weight_fraction_leaf,
            "min_impurity_decrease": min_impurity_decrease,
            "ccp_alpha": ccp_alpha,
        }

    def run(
        self, X: MatrixContinuous, y: Supervised[VectorContinuous]
    ) -> VectorContinuous:
        return SklearnEstimator.run(self, X, y)
