# Generated by Django 4.2.2 on 2023-09-09 19:23

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("artd_location", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Position",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("status", models.BooleanField(default=True, verbose_name="status")),
                (
                    "name",
                    models.CharField(
                        help_text="Name of position",
                        max_length=150,
                        verbose_name="name",
                    ),
                ),
            ],
            options={
                "verbose_name": "Position",
                "verbose_name_plural": "Positions",
            },
        ),
        migrations.CreateModel(
            name="Partner",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("status", models.BooleanField(default=True, verbose_name="status")),
                (
                    "partner_slug",
                    models.SlugField(
                        help_text="Slug of headquarter",
                        max_length=150,
                        verbose_name="slug",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of partner", max_length=150, verbose_name="name"
                    ),
                ),
                (
                    "dni",
                    models.CharField(
                        help_text="DNI of partner", max_length=20, verbose_name="dni"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        help_text="Email of partner",
                        max_length=254,
                        verbose_name="email",
                    ),
                ),
                (
                    "address",
                    models.CharField(
                        help_text="Address of partner",
                        max_length=250,
                        verbose_name="address",
                    ),
                ),
                (
                    "city",
                    models.ForeignKey(
                        help_text="City of partner",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_location.city",
                        verbose_name="city",
                    ),
                ),
            ],
            options={
                "verbose_name": "Partner",
                "verbose_name_plural": "Partners",
            },
        ),
        migrations.CreateModel(
            name="Headquarter",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("status", models.BooleanField(default=True, verbose_name="status")),
                (
                    "name",
                    models.CharField(
                        help_text="Name of headquarter",
                        max_length=150,
                        verbose_name="name",
                    ),
                ),
                (
                    "address",
                    models.CharField(
                        help_text="Address of headquarter",
                        max_length=250,
                        verbose_name="address",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        help_text="Phone of headquarter",
                        max_length=20,
                        verbose_name="phone",
                    ),
                ),
                (
                    "city",
                    models.ForeignKey(
                        help_text="City of headquarter",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_location.city",
                        verbose_name="city",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner of headquarter",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Headquarter",
                "verbose_name_plural": "Headquarters",
            },
        ),
        migrations.CreateModel(
            name="Coworker",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("status", models.BooleanField(default=True, verbose_name="status")),
                (
                    "first_name",
                    models.CharField(
                        help_text="First name of coworker",
                        max_length=150,
                        verbose_name="first_name",
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        help_text="Last name of coworker",
                        max_length=150,
                        verbose_name="last_name",
                    ),
                ),
                (
                    "dni",
                    models.CharField(
                        help_text="DNI of coworker", max_length=20, verbose_name="dni"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        help_text="Email of coworker",
                        max_length=254,
                        verbose_name="email",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        help_text="Phone of coworker",
                        max_length=20,
                        verbose_name="phone",
                    ),
                ),
                (
                    "headquarter",
                    models.ForeignKey(
                        help_text="Headquarter of coworker",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.headquarter",
                        verbose_name="headquarter",
                    ),
                ),
                (
                    "position",
                    models.ForeignKey(
                        help_text="Position of coworker",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.position",
                        verbose_name="position",
                    ),
                ),
            ],
            options={
                "verbose_name": "Coworker",
                "verbose_name_plural": "Coworkers",
            },
        ),
    ]
