"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBCluster; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBCluster`
 */
class DBCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBCluster = new polardb_generated_1.RosDBCluster(this, id, {
            defaultTimeZone: props.defaultTimeZone,
            cloneDataPoint: props.cloneDataPoint === undefined || props.cloneDataPoint === null ? 'LATEST' : props.cloneDataPoint,
            gdnId: props.gdnId,
            resourceGroupId: props.resourceGroupId,
            backupRetentionPolicyOnClusterDeletion: props.backupRetentionPolicyOnClusterDeletion,
            sourceResourceId: props.sourceResourceId,
            dbType: props.dbType,
            dbVersion: props.dbVersion,
            clusterNetworkType: props.clusterNetworkType === undefined || props.clusterNetworkType === null ? 'VPC' : props.clusterNetworkType,
            securityIpList: props.securityIpList,
            dbClusterParameters: props.dbClusterParameters,
            maintainTime: props.maintainTime,
            tags: props.tags,
            lowerCaseTableNames: props.lowerCaseTableNames,
            autoRenewPeriod: props.autoRenewPeriod === undefined || props.autoRenewPeriod === null ? 1 : props.autoRenewPeriod,
            tdeStatus: props.tdeStatus,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            renewalStatus: props.renewalStatus === undefined || props.renewalStatus === null ? 'Normal' : props.renewalStatus,
            dbClusterDescription: props.dbClusterDescription,
            period: props.period,
            payType: props.payType,
            creationCategory: props.creationCategory,
            securityGroupIds: props.securityGroupIds,
            dbNodeClass: props.dbNodeClass,
            creationOption: props.creationOption === undefined || props.creationOption === null ? 'Normal' : props.creationOption,
            vpcId: props.vpcId,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrClusterConnectionString = rosDBCluster.attrClusterConnectionString;
        this.attrClusterEndpointId = rosDBCluster.attrClusterEndpointId;
        this.attrCustomConnectionStrings = rosDBCluster.attrCustomConnectionStrings;
        this.attrCustomEndpointIds = rosDBCluster.attrCustomEndpointIds;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrDbNodeIds = rosDBCluster.attrDbNodeIds;
        this.attrOrderId = rosDBCluster.attrOrderId;
        this.attrPrimaryConnectionString = rosDBCluster.attrPrimaryConnectionString;
        this.attrPrimaryEndpointId = rosDBCluster.attrPrimaryEndpointId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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