# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegrationEndpoint']


class ServiceIntegrationEndpoint(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]] = None,
                 external_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]] = None,
                 jolokia_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']]] = None,
                 rsyslog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']]] = None,
                 signalfx_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Service Integration Endpoint Resource

        The Service Integration Endpoint resource allows the creation and management of Aiven Service Integration Endpoints.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        myendpoint = aiven.ServiceIntegrationEndpoint("myendpoint",
            datadog_user_config=aiven.ServiceIntegrationEndpointDatadogUserConfigArgs(
                datadog_api_key="<DATADOG_API_KEY>",
            ),
            endpoint_name="<ENDPOINT_NAME>",
            endpoint_type="datadog",
            project=aiven_project["myproject"]["project"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[str] endpoint_name: is the name of the endpoint. This value has no effect beyond being used
               to identify different integration endpoints.
        :param pulumi.Input[str] endpoint_type: is the type of the external service this endpoint is associated with.
               By the time of writing the only available option is `datadog`.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] external_aws_cloudwatch_logs_user_config: external AWS CloudWatch Logs specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] external_google_cloud_logging_user_config: external Google Cloud Logginig specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] external_kafka_user_config: external Kafka specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] external_schema_registry_user_config: External schema registry specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']] jolokia_user_config: Jolokia specific user configurable settings
        :param pulumi.Input[str] project: defines the project the endpoint is associated with.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']] rsyslog_user_config: rsyslog specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']] signalfx_user_config: Signalfx specific user configurable settings
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['datadog_user_config'] = datadog_user_config
            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__['endpoint_name'] = endpoint_name
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__['endpoint_type'] = endpoint_type
            __props__['external_aws_cloudwatch_logs_user_config'] = external_aws_cloudwatch_logs_user_config
            __props__['external_elasticsearch_logs_user_config'] = external_elasticsearch_logs_user_config
            __props__['external_google_cloud_logging_user_config'] = external_google_cloud_logging_user_config
            __props__['external_kafka_user_config'] = external_kafka_user_config
            __props__['external_schema_registry_user_config'] = external_schema_registry_user_config
            __props__['jolokia_user_config'] = jolokia_user_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['prometheus_user_config'] = prometheus_user_config
            __props__['rsyslog_user_config'] = rsyslog_user_config
            __props__['signalfx_user_config'] = signalfx_user_config
            __props__['endpoint_config'] = None
        super(ServiceIntegrationEndpoint, __self__).__init__(
            'aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']]] = None,
            endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]] = None,
            external_elasticsearch_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]] = None,
            external_google_cloud_logging_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]] = None,
            external_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]] = None,
            external_schema_registry_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]] = None,
            jolokia_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            prometheus_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']]] = None,
            rsyslog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']]] = None,
            signalfx_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']]] = None) -> 'ServiceIntegrationEndpoint':
        """
        Get an existing ServiceIntegrationEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointDatadogUserConfigArgs']] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoint_config: Integration endpoint specific backend configuration
        :param pulumi.Input[str] endpoint_name: is the name of the endpoint. This value has no effect beyond being used
               to identify different integration endpoints.
        :param pulumi.Input[str] endpoint_type: is the type of the external service this endpoint is associated with.
               By the time of writing the only available option is `datadog`.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] external_aws_cloudwatch_logs_user_config: external AWS CloudWatch Logs specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] external_google_cloud_logging_user_config: external Google Cloud Logginig specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] external_kafka_user_config: external Kafka specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] external_schema_registry_user_config: External schema registry specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointJolokiaUserConfigArgs']] jolokia_user_config: Jolokia specific user configurable settings
        :param pulumi.Input[str] project: defines the project the endpoint is associated with.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointPrometheusUserConfigArgs']] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointRsyslogUserConfigArgs']] rsyslog_user_config: rsyslog specific user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationEndpointSignalfxUserConfigArgs']] signalfx_user_config: Signalfx specific user configurable settings
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["datadog_user_config"] = datadog_user_config
        __props__["endpoint_config"] = endpoint_config
        __props__["endpoint_name"] = endpoint_name
        __props__["endpoint_type"] = endpoint_type
        __props__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
        __props__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
        __props__["external_google_cloud_logging_user_config"] = external_google_cloud_logging_user_config
        __props__["external_kafka_user_config"] = external_kafka_user_config
        __props__["external_schema_registry_user_config"] = external_schema_registry_user_config
        __props__["jolokia_user_config"] = jolokia_user_config
        __props__["project"] = project
        __props__["prometheus_user_config"] = prometheus_user_config
        __props__["rsyslog_user_config"] = rsyslog_user_config
        __props__["signalfx_user_config"] = signalfx_user_config
        return ServiceIntegrationEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointDatadogUserConfig']]:
        """
        Datadog specific user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Integration endpoint specific backend configuration
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        is the name of the endpoint. This value has no effect beyond being used
        to identify different integration endpoints.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        is the type of the external service this endpoint is associated with.
        By the time of writing the only available option is `datadog`.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig']]:
        """
        external AWS CloudWatch Logs specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig']]:
        """
        external elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig']]:
        """
        external Google Cloud Logginig specific user configurable settings
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalKafkaUserConfig']]:
        """
        external Kafka specific user configurable settings
        """
        return pulumi.get(self, "external_kafka_user_config")

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfig']]:
        """
        External schema registry specific user configurable settings
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointJolokiaUserConfig']]:
        """
        Jolokia specific user configurable settings
        """
        return pulumi.get(self, "jolokia_user_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        defines the project the endpoint is associated with.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointPrometheusUserConfig']]:
        """
        Prometheus specific user configurable settings
        """
        return pulumi.get(self, "prometheus_user_config")

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointRsyslogUserConfig']]:
        """
        rsyslog specific user configurable settings
        """
        return pulumi.get(self, "rsyslog_user_config")

    @property
    @pulumi.getter(name="signalfxUserConfig")
    def signalfx_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointSignalfxUserConfig']]:
        """
        Signalfx specific user configurable settings
        """
        return pulumi.get(self, "signalfx_user_config")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

