# This file is generated by autd_wrapper_generator (https://github.com/shinolab/autd-wrapper-generator)

import threading
import ctypes
import os
from enum import IntEnum
from ctypes import c_void_p, c_bool, c_int, POINTER, c_double, c_char_p, c_ubyte, c_uint, c_ulong, c_ushort, CFUNCTYPE

ErrorHandlerFunc = CFUNCTYPE(None, c_char_p)


class GainMode(IntEnum):
    DUTY_PHASE_FULL = 1
    PHASE_FULL = 2
    PHASE_HALF = 4


class Singleton(type):
    _instances = {}
    _lock = threading.Lock()

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            with cls._lock:
                if cls not in cls._instances:
                    cls._instances[cls] = super(Singleton, cls).__call__(*args, **kwargs)
        return cls._instances[cls]


class Nativemethods(metaclass=Singleton):
    def init_dll(self, bin_location, bin_prefix, bin_ext):
        self._bin_location = bin_location
        self._bin_prefix = bin_prefix
        self._bin_ext = bin_ext

    def init_autd3capi(self):
        if hasattr(self, 'autd3capi'):
            return
        self.autd3capi = ctypes.CDLL(os.path.join(self._bin_location, self._bin_prefix + "autd3capi_1.8.1" + self._bin_ext))
        self.autd3capi.AUTDCreateController.argtypes = [POINTER(c_void_p)]
        self.autd3capi.AUTDCreateController.restype = None

        self.autd3capi.AUTDOpenController.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDOpenController.restype = c_bool

        self.autd3capi.AUTDAddDevice.argtypes = [c_void_p, c_double, c_double, c_double, c_double, c_double, c_double, c_int]
        self.autd3capi.AUTDAddDevice.restype = c_int

        self.autd3capi.AUTDAddDeviceQuaternion.argtypes = [c_void_p, c_double, c_double, c_double, c_double, c_double, c_double, c_double, c_int]
        self.autd3capi.AUTDAddDeviceQuaternion.restype = c_int

        self.autd3capi.AUTDDeleteDevice.argtypes = [c_void_p, c_int]
        self.autd3capi.AUTDDeleteDevice.restype = c_int

        self.autd3capi.AUTDClearDevices.argtypes = [c_void_p]
        self.autd3capi.AUTDClearDevices.restype = None

        self.autd3capi.AUTDCloseController.argtypes = [c_void_p]
        self.autd3capi.AUTDCloseController.restype = c_int

        self.autd3capi.AUTDClear.argtypes = [c_void_p]
        self.autd3capi.AUTDClear.restype = c_int

        self.autd3capi.AUTDFreeController.argtypes = [c_void_p]
        self.autd3capi.AUTDFreeController.restype = None

        self.autd3capi.AUTDIsOpen.argtypes = [c_void_p]
        self.autd3capi.AUTDIsOpen.restype = c_bool

        self.autd3capi.AUTDIsSilentMode.argtypes = [c_void_p]
        self.autd3capi.AUTDIsSilentMode.restype = c_bool

        self.autd3capi.AUTDIsForceFan.argtypes = [c_void_p]
        self.autd3capi.AUTDIsForceFan.restype = c_bool

        self.autd3capi.AUTDIsReadsFPGAInfo.argtypes = [c_void_p]
        self.autd3capi.AUTDIsReadsFPGAInfo.restype = c_bool

        self.autd3capi.AUTDIsOutputBalance.argtypes = [c_void_p]
        self.autd3capi.AUTDIsOutputBalance.restype = c_bool

        self.autd3capi.AUTDIsCheckAck.argtypes = [c_void_p]
        self.autd3capi.AUTDIsCheckAck.restype = c_bool

        self.autd3capi.AUTDSetSilentMode.argtypes = [c_void_p, c_bool]
        self.autd3capi.AUTDSetSilentMode.restype = None

        self.autd3capi.AUTDSetReadsFPGAInfo.argtypes = [c_void_p, c_bool]
        self.autd3capi.AUTDSetReadsFPGAInfo.restype = None

        self.autd3capi.AUTDSetOutputBalance.argtypes = [c_void_p, c_bool]
        self.autd3capi.AUTDSetOutputBalance.restype = None

        self.autd3capi.AUTDSetCheckAck.argtypes = [c_void_p, c_bool]
        self.autd3capi.AUTDSetCheckAck.restype = None

        self.autd3capi.AUTDSetForceFan.argtypes = [c_void_p, c_bool]
        self.autd3capi.AUTDSetForceFan.restype = None

        self.autd3capi.AUTDGetWavelength.argtypes = [c_void_p]
        self.autd3capi.AUTDGetWavelength.restype = c_double

        self.autd3capi.AUTDGetAttenuation.argtypes = [c_void_p]
        self.autd3capi.AUTDGetAttenuation.restype = c_double

        self.autd3capi.AUTDSetWavelength.argtypes = [c_void_p, c_double]
        self.autd3capi.AUTDSetWavelength.restype = None

        self.autd3capi.AUTDSetAttenuation.argtypes = [c_void_p, c_double]
        self.autd3capi.AUTDSetAttenuation.restype = None

        self.autd3capi.AUTDGetFPGAInfo.argtypes = [c_void_p, POINTER(c_ubyte)]
        self.autd3capi.AUTDGetFPGAInfo.restype = c_bool

        self.autd3capi.AUTDUpdateCtrlFlags.argtypes = [c_void_p]
        self.autd3capi.AUTDUpdateCtrlFlags.restype = c_int

        self.autd3capi.AUTDSetOutputDelay.argtypes = [c_void_p, POINTER(c_ubyte)]
        self.autd3capi.AUTDSetOutputDelay.restype = c_int

        self.autd3capi.AUTDSetDutyOffset.argtypes = [c_void_p, POINTER(c_ubyte)]
        self.autd3capi.AUTDSetDutyOffset.restype = c_int

        self.autd3capi.AUTDSetDelayOffset.argtypes = [c_void_p, POINTER(c_ubyte), POINTER(c_ubyte)]
        self.autd3capi.AUTDSetDelayOffset.restype = c_int

        self.autd3capi.AUTDGetLastError.argtypes = [c_char_p]
        self.autd3capi.AUTDGetLastError.restype = c_int

        self.autd3capi.AUTDNumDevices.argtypes = [c_void_p]
        self.autd3capi.AUTDNumDevices.restype = c_int

        self.autd3capi.AUTDNumTransducers.argtypes = [c_void_p]
        self.autd3capi.AUTDNumTransducers.restype = c_int

        self.autd3capi.AUTDDeviceIdxForTransIdx.argtypes = [c_void_p, c_int]
        self.autd3capi.AUTDDeviceIdxForTransIdx.restype = c_int

        self.autd3capi.AUTDTransPositionByGlobal.argtypes = [c_void_p, c_int, POINTER(c_double), POINTER(c_double), POINTER(c_double)]
        self.autd3capi.AUTDTransPositionByGlobal.restype = None

        self.autd3capi.AUTDTransPositionByLocal.argtypes = [c_void_p, c_int, c_int, POINTER(c_double), POINTER(c_double), POINTER(c_double)]
        self.autd3capi.AUTDTransPositionByLocal.restype = None

        self.autd3capi.AUTDDeviceXDirection.argtypes = [c_void_p, c_int, POINTER(c_double), POINTER(c_double), POINTER(c_double)]
        self.autd3capi.AUTDDeviceXDirection.restype = None

        self.autd3capi.AUTDDeviceYDirection.argtypes = [c_void_p, c_int, POINTER(c_double), POINTER(c_double), POINTER(c_double)]
        self.autd3capi.AUTDDeviceYDirection.restype = None

        self.autd3capi.AUTDDeviceZDirection.argtypes = [c_void_p, c_int, POINTER(c_double), POINTER(c_double), POINTER(c_double)]
        self.autd3capi.AUTDDeviceZDirection.restype = None

        self.autd3capi.AUTDGetFirmwareInfoListPointer.argtypes = [c_void_p, POINTER(c_void_p)]
        self.autd3capi.AUTDGetFirmwareInfoListPointer.restype = c_int

        self.autd3capi.AUTDGetFirmwareInfo.argtypes = [c_void_p, c_int, c_char_p, c_char_p]
        self.autd3capi.AUTDGetFirmwareInfo.restype = None

        self.autd3capi.AUTDFreeFirmwareInfoListPointer.argtypes = [c_void_p]
        self.autd3capi.AUTDFreeFirmwareInfoListPointer.restype = None

        self.autd3capi.AUTDGainNull.argtypes = [POINTER(c_void_p)]
        self.autd3capi.AUTDGainNull.restype = None

        self.autd3capi.AUTDGainGrouped.argtypes = [POINTER(c_void_p)]
        self.autd3capi.AUTDGainGrouped.restype = None

        self.autd3capi.AUTDGainGroupedAdd.argtypes = [c_void_p, c_int, c_void_p]
        self.autd3capi.AUTDGainGroupedAdd.restype = None

        self.autd3capi.AUTDGainFocalPoint.argtypes = [POINTER(c_void_p), c_double, c_double, c_double, c_ubyte]
        self.autd3capi.AUTDGainFocalPoint.restype = None

        self.autd3capi.AUTDGainBesselBeam.argtypes = [
            POINTER(c_void_p),
            c_double,
            c_double,
            c_double,
            c_double,
            c_double,
            c_double,
            c_double,
            c_ubyte]
        self.autd3capi.AUTDGainBesselBeam.restype = None

        self.autd3capi.AUTDGainPlaneWave.argtypes = [POINTER(c_void_p), c_double, c_double, c_double, c_ubyte]
        self.autd3capi.AUTDGainPlaneWave.restype = None

        self.autd3capi.AUTDGainCustom.argtypes = [POINTER(c_void_p), POINTER(c_ushort), c_int]
        self.autd3capi.AUTDGainCustom.restype = None

        self.autd3capi.AUTDGainTransducerTest.argtypes = [POINTER(c_void_p), c_int, c_ubyte, c_ubyte]
        self.autd3capi.AUTDGainTransducerTest.restype = None

        self.autd3capi.AUTDDeleteGain.argtypes = [c_void_p]
        self.autd3capi.AUTDDeleteGain.restype = None

        self.autd3capi.AUTDModulationStatic.argtypes = [POINTER(c_void_p), c_ubyte]
        self.autd3capi.AUTDModulationStatic.restype = None

        self.autd3capi.AUTDModulationCustom.argtypes = [POINTER(c_void_p), POINTER(c_ubyte), c_uint]
        self.autd3capi.AUTDModulationCustom.restype = None

        self.autd3capi.AUTDModulationSine.argtypes = [POINTER(c_void_p), c_int, c_double, c_double]
        self.autd3capi.AUTDModulationSine.restype = None

        self.autd3capi.AUTDModulationSinePressure.argtypes = [POINTER(c_void_p), c_int, c_double, c_double]
        self.autd3capi.AUTDModulationSinePressure.restype = None

        self.autd3capi.AUTDModulationSineLegacy.argtypes = [POINTER(c_void_p), c_double, c_double, c_double]
        self.autd3capi.AUTDModulationSineLegacy.restype = None

        self.autd3capi.AUTDModulationSquare.argtypes = [POINTER(c_void_p), c_int, c_ubyte, c_ubyte, c_double]
        self.autd3capi.AUTDModulationSquare.restype = None

        self.autd3capi.AUTDDeleteModulation.argtypes = [c_void_p]
        self.autd3capi.AUTDDeleteModulation.restype = None

        self.autd3capi.AUTDSequence.argtypes = [POINTER(c_void_p)]
        self.autd3capi.AUTDSequence.restype = None

        self.autd3capi.AUTDGainSequence.argtypes = [POINTER(c_void_p), c_ushort]
        self.autd3capi.AUTDGainSequence.restype = None

        self.autd3capi.AUTDSequenceAddPoint.argtypes = [c_void_p, c_double, c_double, c_double, c_ubyte]
        self.autd3capi.AUTDSequenceAddPoint.restype = c_bool

        self.autd3capi.AUTDSequenceAddPoints.argtypes = [c_void_p, POINTER(c_double), c_ulong, POINTER(c_ubyte), c_ulong]
        self.autd3capi.AUTDSequenceAddPoints.restype = c_bool

        self.autd3capi.AUTDSequenceAddGain.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDSequenceAddGain.restype = c_bool

        self.autd3capi.AUTDSequenceSetFreq.argtypes = [c_void_p, c_double]
        self.autd3capi.AUTDSequenceSetFreq.restype = c_double

        self.autd3capi.AUTDSequenceFreq.argtypes = [c_void_p]
        self.autd3capi.AUTDSequenceFreq.restype = c_double

        self.autd3capi.AUTDSequencePeriod.argtypes = [c_void_p]
        self.autd3capi.AUTDSequencePeriod.restype = c_uint

        self.autd3capi.AUTDSequenceSamplingPeriod.argtypes = [c_void_p]
        self.autd3capi.AUTDSequenceSamplingPeriod.restype = c_uint

        self.autd3capi.AUTDSequenceSamplingFreq.argtypes = [c_void_p]
        self.autd3capi.AUTDSequenceSamplingFreq.restype = c_double

        self.autd3capi.AUTDSequenceSamplingFreqDiv.argtypes = [c_void_p]
        self.autd3capi.AUTDSequenceSamplingFreqDiv.restype = c_ushort

        self.autd3capi.AUTDCircumSequence.argtypes = [
            POINTER(c_void_p),
            c_double,
            c_double,
            c_double,
            c_double,
            c_double,
            c_double,
            c_double,
            c_ulong]
        self.autd3capi.AUTDCircumSequence.restype = None

        self.autd3capi.AUTDDeleteSequence.argtypes = [c_void_p]
        self.autd3capi.AUTDDeleteSequence.restype = None

        self.autd3capi.AUTDStop.argtypes = [c_void_p]
        self.autd3capi.AUTDStop.restype = c_int

        self.autd3capi.AUTDPause.argtypes = [c_void_p]
        self.autd3capi.AUTDPause.restype = c_int

        self.autd3capi.AUTDResume.argtypes = [c_void_p]
        self.autd3capi.AUTDResume.restype = c_int

        self.autd3capi.AUTDSendGain.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDSendGain.restype = c_int

        self.autd3capi.AUTDSendModulation.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDSendModulation.restype = c_int

        self.autd3capi.AUTDSendGainModulation.argtypes = [c_void_p, c_void_p, c_void_p]
        self.autd3capi.AUTDSendGainModulation.restype = c_int

        self.autd3capi.AUTDSendSequence.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDSendSequence.restype = c_int

        self.autd3capi.AUTDSendGainSequence.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDSendGainSequence.restype = c_int

        self.autd3capi.AUTDSTMController.argtypes = [POINTER(c_void_p), c_void_p]
        self.autd3capi.AUTDSTMController.restype = None

        self.autd3capi.AUTDAddSTMGain.argtypes = [c_void_p, c_void_p]
        self.autd3capi.AUTDAddSTMGain.restype = c_bool

        self.autd3capi.AUTDStartSTM.argtypes = [c_void_p, c_double]
        self.autd3capi.AUTDStartSTM.restype = c_bool

        self.autd3capi.AUTDStopSTM.argtypes = [c_void_p]
        self.autd3capi.AUTDStopSTM.restype = c_bool

        self.autd3capi.AUTDFinishSTM.argtypes = [c_void_p]
        self.autd3capi.AUTDFinishSTM.restype = c_bool

    def init_autd3capi_emulator_link(self):
        if hasattr(self, 'autd3capi_emulator_link'):
            return
        self.autd3capi_emulator_link = ctypes.CDLL(
            os.path.join(
                self._bin_location,
                self._bin_prefix +
                "autd3capi_1.8.1-emulator-link" +
                self._bin_ext))
        self.autd3capi_emulator_link.AUTDLinkEmulator.argtypes = [POINTER(c_void_p), c_ushort, c_void_p]
        self.autd3capi_emulator_link.AUTDLinkEmulator.restype = None

    def init_autd3capi_from_file_modulation(self):
        if hasattr(self, 'autd3capi_from_file_modulation'):
            return
        self.autd3capi_from_file_modulation = ctypes.CDLL(
            os.path.join(
                self._bin_location,
                self._bin_prefix +
                "autd3capi_1.8.1-from-file-modulation" +
                self._bin_ext))
        self.autd3capi_from_file_modulation.AUTDModulationRawPCM.argtypes = [POINTER(c_void_p), c_char_p, c_double, c_ushort]
        self.autd3capi_from_file_modulation.AUTDModulationRawPCM.restype = None

        self.autd3capi_from_file_modulation.AUTDModulationWav.argtypes = [POINTER(c_void_p), c_char_p, c_ushort]
        self.autd3capi_from_file_modulation.AUTDModulationWav.restype = None

    def init_autd3capi_holo_gain(self):
        if hasattr(self, 'autd3capi_holo_gain'):
            return
        self.autd3capi_holo_gain = ctypes.CDLL(os.path.join(self._bin_location, self._bin_prefix + "autd3capi_1.8.1-holo-gain" + self._bin_ext))
        self.autd3capi_holo_gain.AUTDEigen3Backend.argtypes = [POINTER(c_void_p)]
        self.autd3capi_holo_gain.AUTDEigen3Backend.restype = None

        self.autd3capi_holo_gain.AUTDDeleteBackend.argtypes = [c_void_p]
        self.autd3capi_holo_gain.AUTDDeleteBackend.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloSDP.argtypes = [POINTER(c_void_p), c_void_p, POINTER(
            c_double), POINTER(c_double), c_int, c_double, c_double, c_ulong, c_bool]
        self.autd3capi_holo_gain.AUTDGainHoloSDP.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloEVD.argtypes = [
            POINTER(c_void_p), c_void_p, POINTER(c_double), POINTER(c_double), c_int, c_double, c_bool]
        self.autd3capi_holo_gain.AUTDGainHoloEVD.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloNaive.argtypes = [POINTER(c_void_p), c_void_p, POINTER(c_double), POINTER(c_double), c_int]
        self.autd3capi_holo_gain.AUTDGainHoloNaive.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloGS.argtypes = [POINTER(c_void_p), c_void_p, POINTER(c_double), POINTER(c_double), c_int, c_ulong]
        self.autd3capi_holo_gain.AUTDGainHoloGS.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloGSPAT.argtypes = [POINTER(c_void_p), c_void_p, POINTER(c_double), POINTER(c_double), c_int, c_ulong]
        self.autd3capi_holo_gain.AUTDGainHoloGSPAT.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloLM.argtypes = [POINTER(c_void_p), c_void_p, POINTER(
            c_double), POINTER(c_double), c_int, c_double, c_double, c_double, c_ulong, POINTER(c_double), c_int]
        self.autd3capi_holo_gain.AUTDGainHoloLM.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloGaussNewton.argtypes = [POINTER(c_void_p), c_void_p, POINTER(
            c_double), POINTER(c_double), c_int, c_double, c_double, c_ulong, POINTER(c_double), c_int]
        self.autd3capi_holo_gain.AUTDGainHoloGaussNewton.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloGradientDescent.argtypes = [POINTER(c_void_p), c_void_p, POINTER(
            c_double), POINTER(c_double), c_int, c_double, c_double, c_ulong, POINTER(c_double), c_int]
        self.autd3capi_holo_gain.AUTDGainHoloGradientDescent.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloAPO.argtypes = [
            POINTER(c_void_p),
            c_void_p,
            POINTER(c_double),
            POINTER(c_double),
            c_int,
            c_double,
            c_double,
            c_ulong]
        self.autd3capi_holo_gain.AUTDGainHoloAPO.restype = None

        self.autd3capi_holo_gain.AUTDGainHoloGreedy.argtypes = [POINTER(c_void_p), c_void_p, POINTER(c_double), POINTER(c_double), c_int, c_int]
        self.autd3capi_holo_gain.AUTDGainHoloGreedy.restype = None

    def init_autd3capi_remote_twincat_link(self):
        if hasattr(self, 'autd3capi_remote_twincat_link'):
            return
        self.autd3capi_remote_twincat_link = ctypes.CDLL(
            os.path.join(
                self._bin_location,
                self._bin_prefix +
                "autd3capi_1.8.1-remote-twincat-link" +
                self._bin_ext))
        self.autd3capi_remote_twincat_link.AUTDLinkRemoteTwinCAT.argtypes = [POINTER(c_void_p), c_char_p, c_char_p, c_char_p]
        self.autd3capi_remote_twincat_link.AUTDLinkRemoteTwinCAT.restype = None

    def init_autd3capi_soem_link(self):
        if hasattr(self, 'autd3capi_soem_link'):
            return
        self.autd3capi_soem_link = ctypes.CDLL(os.path.join(self._bin_location, self._bin_prefix + "autd3capi_1.8.1-soem-link" + self._bin_ext))
        self.autd3capi_soem_link.AUTDGetAdapterPointer.argtypes = [POINTER(c_void_p)]
        self.autd3capi_soem_link.AUTDGetAdapterPointer.restype = c_int

        self.autd3capi_soem_link.AUTDGetAdapter.argtypes = [c_void_p, c_int, c_char_p, c_char_p]
        self.autd3capi_soem_link.AUTDGetAdapter.restype = None

        self.autd3capi_soem_link.AUTDFreeAdapterPointer.argtypes = [c_void_p]
        self.autd3capi_soem_link.AUTDFreeAdapterPointer.restype = None

        self.autd3capi_soem_link.AUTDLinkSOEM.argtypes = [POINTER(c_void_p), c_char_p, c_int, c_uint, c_void_p]
        self.autd3capi_soem_link.AUTDLinkSOEM.restype = None

    def init_autd3capi_twincat_link(self):
        if hasattr(self, 'autd3capi_twincat_link'):
            return
        self.autd3capi_twincat_link = ctypes.CDLL(os.path.join(self._bin_location, self._bin_prefix + "autd3capi_1.8.1-twincat-link" + self._bin_ext))
        self.autd3capi_twincat_link.AUTDLinkTwinCAT.argtypes = [POINTER(c_void_p)]
        self.autd3capi_twincat_link.AUTDLinkTwinCAT.restype = None

    def init_autd3capi_arrayfire_backend(self):
        if hasattr(self, 'autd3capi_arrayfire_backend'):
            return
        self.autd3capi_arrayfire_backend = ctypes.CDLL(
            os.path.join(
                self._bin_location,
                self._bin_prefix +
                "autd3capi_1.8.1-arrayfire-backend" +
                self._bin_ext))
        self.autd3capi_arrayfire_backend.AUTDArrayFireBackend.argtypes = [POINTER(c_void_p)]
        self.autd3capi_arrayfire_backend.AUTDArrayFireBackend.restype = None

    def init_autd3capi_blas_backend(self):
        if hasattr(self, 'autd3capi_blas_backend'):
            return
        self.autd3capi_blas_backend = ctypes.CDLL(os.path.join(self._bin_location, self._bin_prefix + "autd3capi_1.8.1-blas-backend" + self._bin_ext))
        self.autd3capi_blas_backend.AUTDBLASBackend.argtypes = [POINTER(c_void_p)]
        self.autd3capi_blas_backend.AUTDBLASBackend.restype = None

    def init_autd3capi_cuda_backend(self):
        if hasattr(self, 'autd3capi_cuda_backend'):
            return
        self.autd3capi_cuda_backend = ctypes.CDLL(os.path.join(self._bin_location, self._bin_prefix + "autd3capi_1.8.1-cuda-backend" + self._bin_ext))
        self.autd3capi_cuda_backend.AUTDCUDABackend.argtypes = [POINTER(c_void_p)]
        self.autd3capi_cuda_backend.AUTDCUDABackend.restype = None
