(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "Scalar_Singlet_BFM";

M$Information = {
  Authors      -> {"J. Santiago"}, 
  Version      -> "1.0",
  Date         -> "03. 12. 2018",
  Institutions -> {"CAFPE and Universidad de Granada"},
  Emails       -> {"jsantiago@ugr.es"}
};

FeynmanGauge = True;

(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {


  S[105] == {
    ClassName        -> sphi,
    SelfConjugate    -> True,
    Mass             -> Msphi,
    FullName        -> "heavy",
    Width            -> 0
  }

};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)

  (* Internal Parameters *)
  aprime == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  kappaprime == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  muprime == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  lambdaphi == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  Msphi == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  }

};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

gotoBFM={G[a__]->G[a]+GQuantum[a],Wi[a__]->Wi[a]+WiQuantum[a],B[a__]->B[a]+BQuantum[a]};

LNP := Block[{mu,ii,jj},
    del[sphi,mu]*del[sphi,mu]/2-Msphi^2 sphi^2/2
    -aprime Phibar[ii] Phi[ii] sphi
    -kappaprime/2 Phibar[ii] Phi[ii] sphi^2
    -muprime/6 sphi^3
    -lambdaphi/24 sphi^4]


Ltot := LSM + LNP;


