"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HcsProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/hcs hcs}
*/
class HcsProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hcs hcs} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HcsProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'hcs',
            terraformGeneratorMetadata: {
                providerName: 'hcs',
                providerVersion: '0.5.1',
                providerVersionConstraint: '~> 0.5'
            },
            terraformProviderSource: 'hcs'
        });
        this._azureClientCertificatePassword = config.azureClientCertificatePassword;
        this._azureClientCertificatePath = config.azureClientCertificatePath;
        this._azureClientId = config.azureClientId;
        this._azureClientSecret = config.azureClientSecret;
        this._azureEnvironment = config.azureEnvironment;
        this._azureMetadataHost = config.azureMetadataHost;
        this._azureMsiEndpoint = config.azureMsiEndpoint;
        this._azureSubscriptionId = config.azureSubscriptionId;
        this._azureTenantId = config.azureTenantId;
        this._azureUseMsi = config.azureUseMsi;
        this._hcpApiDomain = config.hcpApiDomain;
        this._hcsMarketplaceProductName = config.hcsMarketplaceProductName;
        this._alias = config.alias;
    }
    get azureClientCertificatePassword() {
        return this._azureClientCertificatePassword;
    }
    set azureClientCertificatePassword(value) {
        this._azureClientCertificatePassword = value;
    }
    resetAzureClientCertificatePassword() {
        this._azureClientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientCertificatePasswordInput() {
        return this._azureClientCertificatePassword;
    }
    get azureClientCertificatePath() {
        return this._azureClientCertificatePath;
    }
    set azureClientCertificatePath(value) {
        this._azureClientCertificatePath = value;
    }
    resetAzureClientCertificatePath() {
        this._azureClientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientCertificatePathInput() {
        return this._azureClientCertificatePath;
    }
    get azureClientId() {
        return this._azureClientId;
    }
    set azureClientId(value) {
        this._azureClientId = value;
    }
    resetAzureClientId() {
        this._azureClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientIdInput() {
        return this._azureClientId;
    }
    get azureClientSecret() {
        return this._azureClientSecret;
    }
    set azureClientSecret(value) {
        this._azureClientSecret = value;
    }
    resetAzureClientSecret() {
        this._azureClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureClientSecretInput() {
        return this._azureClientSecret;
    }
    get azureEnvironment() {
        return this._azureEnvironment;
    }
    set azureEnvironment(value) {
        this._azureEnvironment = value;
    }
    resetAzureEnvironment() {
        this._azureEnvironment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureEnvironmentInput() {
        return this._azureEnvironment;
    }
    get azureMetadataHost() {
        return this._azureMetadataHost;
    }
    set azureMetadataHost(value) {
        this._azureMetadataHost = value;
    }
    resetAzureMetadataHost() {
        this._azureMetadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureMetadataHostInput() {
        return this._azureMetadataHost;
    }
    get azureMsiEndpoint() {
        return this._azureMsiEndpoint;
    }
    set azureMsiEndpoint(value) {
        this._azureMsiEndpoint = value;
    }
    resetAzureMsiEndpoint() {
        this._azureMsiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureMsiEndpointInput() {
        return this._azureMsiEndpoint;
    }
    get azureSubscriptionId() {
        return this._azureSubscriptionId;
    }
    set azureSubscriptionId(value) {
        this._azureSubscriptionId = value;
    }
    resetAzureSubscriptionId() {
        this._azureSubscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureSubscriptionIdInput() {
        return this._azureSubscriptionId;
    }
    get azureTenantId() {
        return this._azureTenantId;
    }
    set azureTenantId(value) {
        this._azureTenantId = value;
    }
    resetAzureTenantId() {
        this._azureTenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureTenantIdInput() {
        return this._azureTenantId;
    }
    get azureUseMsi() {
        return this._azureUseMsi;
    }
    set azureUseMsi(value) {
        this._azureUseMsi = value;
    }
    resetAzureUseMsi() {
        this._azureUseMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureUseMsiInput() {
        return this._azureUseMsi;
    }
    get hcpApiDomain() {
        return this._hcpApiDomain;
    }
    set hcpApiDomain(value) {
        this._hcpApiDomain = value;
    }
    resetHcpApiDomain() {
        this._hcpApiDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hcpApiDomainInput() {
        return this._hcpApiDomain;
    }
    get hcsMarketplaceProductName() {
        return this._hcsMarketplaceProductName;
    }
    set hcsMarketplaceProductName(value) {
        this._hcsMarketplaceProductName = value;
    }
    resetHcsMarketplaceProductName() {
        this._hcsMarketplaceProductName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hcsMarketplaceProductNameInput() {
        return this._hcsMarketplaceProductName;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            azure_client_certificate_password: cdktf.stringToTerraform(this._azureClientCertificatePassword),
            azure_client_certificate_path: cdktf.stringToTerraform(this._azureClientCertificatePath),
            azure_client_id: cdktf.stringToTerraform(this._azureClientId),
            azure_client_secret: cdktf.stringToTerraform(this._azureClientSecret),
            azure_environment: cdktf.stringToTerraform(this._azureEnvironment),
            azure_metadata_host: cdktf.stringToTerraform(this._azureMetadataHost),
            azure_msi_endpoint: cdktf.stringToTerraform(this._azureMsiEndpoint),
            azure_subscription_id: cdktf.stringToTerraform(this._azureSubscriptionId),
            azure_tenant_id: cdktf.stringToTerraform(this._azureTenantId),
            azure_use_msi: cdktf.booleanToTerraform(this._azureUseMsi),
            hcp_api_domain: cdktf.stringToTerraform(this._hcpApiDomain),
            hcs_marketplace_product_name: cdktf.stringToTerraform(this._hcsMarketplaceProductName),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.HcsProvider = HcsProvider;
_a = JSII_RTTI_SYMBOL_1;
HcsProvider[_a] = { fqn: "@cdktf/provider-hcs.provider.HcsProvider", version: "1.0.0" };
// =================
// STATIC PROPERTIES
// =================
HcsProvider.tfResourceType = "hcs";
//# sourceMappingURL=data:application/json;base64,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