""" m delete Entrypoint """
import argparse
from typing import List, Optional

from mcli.cli.m_delete.delete import delete_environment_variable, delete_platform, delete_secret


def delete(parser, **kwargs) -> int:
    del kwargs
    parser.print_help()
    return 0


def configure_argparser(parser: argparse.ArgumentParser,
                        parents: List[argparse.ArgumentParser]) -> argparse.ArgumentParser:
    subparsers = parser.add_subparsers()
    parser.set_defaults(func=delete, parser=parser)

    # TODO: Delete Projects

    platform_parser = subparsers.add_parser(
        'platform',
        aliases=['platforms'],
        help='Delete a Platform',
        parents=parents,
    )
    platform_parser.add_argument('platform_name', help='The name of the platform to delete')
    platform_parser.set_defaults(func=delete_platform)

    environment_parser = subparsers.add_parser(
        'env',
        aliases=['environment-variable'],
        help='Delete an Environment Variable',
    )
    environment_parser.add_argument('variable_name', help='The name of the environment variable to delete')
    environment_parser.set_defaults(func=delete_environment_variable)

    secrets_parser = subparsers.add_parser(
        'secrets',
        aliases=['secret'],
        help='Delete a Secret',
    )
    secrets_parser.add_argument('secret_name', help='The name of the secret to delete')
    secrets_parser.set_defaults(func=delete_secret)

    return parser


def add_delete_argparser(subparser: argparse._SubParsersAction,
                         parents: Optional[List[argparse.ArgumentParser]] = None) -> argparse.ArgumentParser:
    if not parents:
        parents = []

    common = argparse.ArgumentParser(add_help=False)
    common.add_argument('-y',
                        '--force',
                        dest='force',
                        action='store_true',
                        help='Skip confirmation dialog before deleting. Please be careful!')
    parents.append(common)

    delete_parser: argparse.ArgumentParser = subparser.add_parser(
        'delete',
        aliases=['del'],
        help='Configure your local project',
        parents=parents,
    )
    delete_parser = configure_argparser(parser=delete_parser, parents=parents)
    return delete_parser
