import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Relative name of the domain serving the application. Example: example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#domain_name AppEngineDomainMapping#domain_name}
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Whether the domain creation should override any existing mappings for this domain.
     *
     * By default, overrides are rejected. Default value: "STRICT" Possible values: ["STRICT", "OVERRIDE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#override_strategy AppEngineDomainMapping#override_strategy}
     *
     * @stability stable
     */
    readonly overrideStrategy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#project AppEngineDomainMapping#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * ssl_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#ssl_settings AppEngineDomainMapping#ssl_settings}
     *
     * @stability stable
     */
    readonly sslSettings?: AppEngineDomainMappingSslSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#timeouts AppEngineDomainMapping#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineDomainMappingTimeouts;
}
/**
 * @stability stable
 */
export declare class AppEngineDomainMappingResourceRecords extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get rrdata(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface AppEngineDomainMappingSslSettings {
    /**
     * ID of the AuthorizedCertificate resource configuring SSL for the application.
     *
     * Clearing this field will
     * remove SSL support.
     * By default, a managed certificate is automatically created for every domain mapping. To omit SSL support
     * or to configure SSL manually, specify 'SslManagementType.MANUAL' on a 'CREATE' or 'UPDATE' request. You must be
     * authorized to administer the 'AuthorizedCertificate' resource to manually map it to a DomainMapping resource.
     * Example: 12345.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#certificate_id AppEngineDomainMapping#certificate_id}
     *
     * @stability stable
     */
    readonly certificateId?: string;
    /**
     * SSL management type for this domain.
     *
     * If 'AUTOMATIC', a managed certificate is automatically provisioned.
     * If 'MANUAL', 'certificateId' must be manually specified in order to configure SSL for this domain. Possible values: ["AUTOMATIC", "MANUAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#ssl_management_type AppEngineDomainMapping#ssl_management_type}
     *
     * @stability stable
     */
    readonly sslManagementType: string;
}
export declare function appEngineDomainMappingSslSettingsToTerraform(struct?: AppEngineDomainMappingSslSettingsOutputReference | AppEngineDomainMappingSslSettings): any;
/**
 * @stability stable
 */
export declare class AppEngineDomainMappingSslSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineDomainMappingSslSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineDomainMappingSslSettings | undefined);
    private _certificateId?;
    /**
     * @stability stable
     */
    get certificateId(): string;
    /**
     * @stability stable
     */
    set certificateId(value: string);
    /**
     * @stability stable
     */
    resetCertificateId(): void;
    /**
     * @stability stable
     */
    get certificateIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get pendingManagedCertificateId(): string;
    private _sslManagementType?;
    /**
     * @stability stable
     */
    get sslManagementType(): string;
    /**
     * @stability stable
     */
    set sslManagementType(value: string);
    /**
     * @stability stable
     */
    get sslManagementTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineDomainMappingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#create AppEngineDomainMapping#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#delete AppEngineDomainMapping#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping#update AppEngineDomainMapping#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appEngineDomainMappingTimeoutsToTerraform(struct?: AppEngineDomainMappingTimeoutsOutputReference | AppEngineDomainMappingTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppEngineDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineDomainMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineDomainMappingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping google_app_engine_domain_mapping}.
 *
 * @stability stable
 */
export declare class AppEngineDomainMapping extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_domain_mapping google_app_engine_domain_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineDomainMappingConfig);
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _overrideStrategy?;
    /**
     * @stability stable
     */
    get overrideStrategy(): string;
    /**
     * @stability stable
     */
    set overrideStrategy(value: string);
    /**
     * @stability stable
     */
    resetOverrideStrategy(): void;
    /**
     * @stability stable
     */
    get overrideStrategyInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    resourceRecords(index: string): AppEngineDomainMappingResourceRecords;
    private _sslSettings;
    /**
     * @stability stable
     */
    get sslSettings(): AppEngineDomainMappingSslSettingsOutputReference;
    /**
     * @stability stable
     */
    putSslSettings(value: AppEngineDomainMappingSslSettings): void;
    /**
     * @stability stable
     */
    resetSslSettings(): void;
    /**
     * @stability stable
     */
    get sslSettingsInput(): AppEngineDomainMappingSslSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineDomainMappingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppEngineDomainMappingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineDomainMappingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
