import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AssuredWorkloadsWorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
     * Required.
     *
     * Input only. The billing account used for the resources which are direct children of workload. This billing account is initially associated with the resources created as part of Workload creation. After the initial creation of these resources, the customer can change the assigned billing account. The resource name has the form `billingAccounts/{billing_account_id}`. For example, 'billingAccounts/012345-567890-ABCDEF`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#billing_account AssuredWorkloadsWorkload#billing_account}
     *
     * @stability stable
     */
    readonly billingAccount: string;
    /**
     * Required. Immutable. Compliance Regime associated with this workload. Possible values: COMPLIANCE_REGIME_UNSPECIFIED, IL4, CJIS, FEDRAMP_HIGH, FEDRAMP_MODERATE, US_REGIONAL_ACCESS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#compliance_regime AssuredWorkloadsWorkload#compliance_regime}
     *
     * @stability stable
     */
    readonly complianceRegime: string;
    /**
     * Required.
     *
     * The user-assigned display name of the Workload. When present it must be between 4 to 30 characters. Allowed characters are: lowercase and uppercase letters, numbers, hyphen, and spaces. Example: My Workload
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#display_name AssuredWorkloadsWorkload#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Optional. Labels applied to the workload.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#labels AssuredWorkloadsWorkload#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#location AssuredWorkloadsWorkload#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The organization for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#organization AssuredWorkloadsWorkload#organization}
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * Input only.
     *
     * The parent resource for the resources managed by this Assured Workload. May be either an organization or a folder. Must be the same or a child of the Workload parent. If not specified all resources are created under the Workload parent. Formats: folders/{folder_id}, organizations/{organization_id}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#provisioned_resources_parent AssuredWorkloadsWorkload#provisioned_resources_parent}
     *
     * @stability stable
     */
    readonly provisionedResourcesParent?: string;
    /**
     * kms_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#kms_settings AssuredWorkloadsWorkload#kms_settings}
     *
     * @stability stable
     */
    readonly kmsSettings?: AssuredWorkloadsWorkloadKmsSettings;
    /**
     * resource_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#resource_settings AssuredWorkloadsWorkload#resource_settings}
     *
     * @stability stable
     */
    readonly resourceSettings?: AssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#timeouts AssuredWorkloadsWorkload#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AssuredWorkloadsWorkloadTimeouts;
}
/**
 * @stability stable
 */
export declare class AssuredWorkloadsWorkloadResources extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resourceId(): number;
    /**
     * @stability stable
     */
    get resourceType(): string;
}
/**
 * @stability stable
 */
export interface AssuredWorkloadsWorkloadKmsSettings {
    /**
     * Required.
     *
     * Input only. Immutable. The time at which the Key Management Service will automatically create a new version of the crypto key and mark it as the primary.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#next_rotation_time AssuredWorkloadsWorkload#next_rotation_time}
     *
     * @stability stable
     */
    readonly nextRotationTime: string;
    /**
     * Required.
     *
     * Input only. Immutable. will be advanced by this period when the Key Management Service automatically rotates a key. Must be at least 24 hours and at most 876,000 hours.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#rotation_period AssuredWorkloadsWorkload#rotation_period}
     *
     * @stability stable
     */
    readonly rotationPeriod: string;
}
export declare function assuredWorkloadsWorkloadKmsSettingsToTerraform(struct?: AssuredWorkloadsWorkloadKmsSettingsOutputReference | AssuredWorkloadsWorkloadKmsSettings): any;
/**
 * @stability stable
 */
export declare class AssuredWorkloadsWorkloadKmsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AssuredWorkloadsWorkloadKmsSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AssuredWorkloadsWorkloadKmsSettings | undefined);
    private _nextRotationTime?;
    /**
     * @stability stable
     */
    get nextRotationTime(): string;
    /**
     * @stability stable
     */
    set nextRotationTime(value: string);
    /**
     * @stability stable
     */
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    /**
     * @stability stable
     */
    get rotationPeriod(): string;
    /**
     * @stability stable
     */
    set rotationPeriod(value: string);
    /**
     * @stability stable
     */
    get rotationPeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AssuredWorkloadsWorkloadResourceSettings {
    /**
     * Resource identifier. For a project this represents project_number. If the project is already taken, the workload creation will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#resource_id AssuredWorkloadsWorkload#resource_id}
     *
     * @stability stable
     */
    readonly resourceId?: string;
    /**
     * Indicates the type of resource.
     *
     * This field should be specified to correspond the id to the right project type (CONSUMER_PROJECT or ENCRYPTION_KEYS_PROJECT) Possible values: RESOURCE_TYPE_UNSPECIFIED, CONSUMER_PROJECT, ENCRYPTION_KEYS_PROJECT, KEYRING, CONSUMER_FOLDER
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#resource_type AssuredWorkloadsWorkload#resource_type}
     *
     * @stability stable
     */
    readonly resourceType?: string;
}
export declare function assuredWorkloadsWorkloadResourceSettingsToTerraform(struct?: AssuredWorkloadsWorkloadResourceSettings | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface AssuredWorkloadsWorkloadTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#create AssuredWorkloadsWorkload#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#delete AssuredWorkloadsWorkload#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#update AssuredWorkloadsWorkload#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function assuredWorkloadsWorkloadTimeoutsToTerraform(struct?: AssuredWorkloadsWorkloadTimeoutsOutputReference | AssuredWorkloadsWorkloadTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AssuredWorkloadsWorkloadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AssuredWorkloadsWorkloadTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AssuredWorkloadsWorkloadTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload google_assured_workloads_workload}.
 *
 * @stability stable
 */
export declare class AssuredWorkloadsWorkload extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload google_assured_workloads_workload} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AssuredWorkloadsWorkloadConfig);
    private _billingAccount?;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    set billingAccount(value: string);
    /**
     * @stability stable
     */
    get billingAccountInput(): string | undefined;
    private _complianceRegime?;
    /**
     * @stability stable
     */
    get complianceRegime(): string;
    /**
     * @stability stable
     */
    set complianceRegime(value: string);
    /**
     * @stability stable
     */
    get complianceRegimeInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _provisionedResourcesParent?;
    /**
     * @stability stable
     */
    get provisionedResourcesParent(): string;
    /**
     * @stability stable
     */
    set provisionedResourcesParent(value: string);
    /**
     * @stability stable
     */
    resetProvisionedResourcesParent(): void;
    /**
     * @stability stable
     */
    get provisionedResourcesParentInput(): string | undefined;
    /**
     * @stability stable
     */
    resources(index: string): AssuredWorkloadsWorkloadResources;
    private _kmsSettings;
    /**
     * @stability stable
     */
    get kmsSettings(): AssuredWorkloadsWorkloadKmsSettingsOutputReference;
    /**
     * @stability stable
     */
    putKmsSettings(value: AssuredWorkloadsWorkloadKmsSettings): void;
    /**
     * @stability stable
     */
    resetKmsSettings(): void;
    /**
     * @stability stable
     */
    get kmsSettingsInput(): AssuredWorkloadsWorkloadKmsSettings | undefined;
    private _resourceSettings?;
    /**
     * @stability stable
     */
    get resourceSettings(): AssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set resourceSettings(value: AssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetResourceSettings(): void;
    /**
     * @stability stable
     */
    get resourceSettingsInput(): cdktf.IResolvable | AssuredWorkloadsWorkloadResourceSettings[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AssuredWorkloadsWorkloadTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AssuredWorkloadsWorkloadTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AssuredWorkloadsWorkloadTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
