import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique ID for this dataset, without the project name.
     *
     * The ID
     * must contain only letters (a-z, A-Z), numbers (0-9), or
     * underscores (_). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#dataset_id BigqueryDataset#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The default partition expiration for all partitioned tables in the dataset, in milliseconds.
     *
     * Once this property is set, all newly-created partitioned tables in
     * the dataset will have an 'expirationMs' property in the 'timePartitioning'
     * settings set to this value, and changing the value will only
     * affect new tables, not existing ones. The storage in a partition will
     * have an expiration time of its partition time plus this value.
     * Setting this property overrides the use of 'defaultTableExpirationMs'
     * for partitioned tables: only one of 'defaultTableExpirationMs' and
     * 'defaultPartitionExpirationMs' will be used for any new partitioned
     * table. If you provide an explicit 'timePartitioning.expirationMs' when
     * creating or updating a partitioned table, that value takes precedence
     * over the default partition expiration time indicated by this property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#default_partition_expiration_ms BigqueryDataset#default_partition_expiration_ms}
     *
     * @stability stable
     */
    readonly defaultPartitionExpirationMs?: number;
    /**
     * The default lifetime of all tables in the dataset, in milliseconds. The minimum value is 3600000 milliseconds (one hour).
     *
     * Once this property is set, all newly-created tables in the dataset
     * will have an 'expirationTime' property set to the creation time plus
     * the value in this property, and changing the value will only affect
     * new tables, not existing ones. When the 'expirationTime' for a given
     * table is reached, that table will be deleted automatically.
     * If a table's 'expirationTime' is modified or removed before the
     * table expires, or if you provide an explicit 'expirationTime' when
     * creating a table, that value takes precedence over the default
     * expiration time indicated by this property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#default_table_expiration_ms BigqueryDataset#default_table_expiration_ms}
     *
     * @stability stable
     */
    readonly defaultTableExpirationMs?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#delete_contents_on_destroy BigqueryDataset#delete_contents_on_destroy}.
     *
     * @stability stable
     */
    readonly deleteContentsOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * A user-friendly description of the dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#description BigqueryDataset#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A descriptive name for the dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#friendly_name BigqueryDataset#friendly_name}
     *
     * @stability stable
     */
    readonly friendlyName?: string;
    /**
     * The labels associated with this dataset. You can use these to organize and group your datasets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#labels BigqueryDataset#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The geographic location where the dataset should reside. See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
     *
     * There are two types of locations, regional or multi-regional. A regional
     * location is a specific geographic place, such as Tokyo, and a multi-regional
     * location is a large geographic area, such as the United States, that
     * contains at least two geographic places.
     *
     *
     * The default value is multi-regional location 'US'.
     * Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#location BigqueryDataset#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#project BigqueryDataset#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * access block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#access BigqueryDataset#access}
     *
     * @stability stable
     */
    readonly access?: BigqueryDatasetAccess[] | cdktf.IResolvable;
    /**
     * default_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#default_encryption_configuration BigqueryDataset#default_encryption_configuration}
     *
     * @stability stable
     */
    readonly defaultEncryptionConfiguration?: BigqueryDatasetDefaultEncryptionConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#timeouts BigqueryDataset#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryDatasetTimeouts;
}
/**
 * @stability stable
 */
export interface BigqueryDatasetAccessView {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#dataset_id BigqueryDataset#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#project_id BigqueryDataset#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The ID of the table.
     *
     * The ID must contain only letters (a-z,
     * A-Z), numbers (0-9), or underscores (_). The maximum length
     * is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#table_id BigqueryDataset#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function bigqueryDatasetAccessViewToTerraform(struct?: BigqueryDatasetAccessViewOutputReference | BigqueryDatasetAccessView): any;
/**
 * @stability stable
 */
export declare class BigqueryDatasetAccessViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryDatasetAccessView | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryDatasetAccessView | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryDatasetAccess {
    /**
     * A domain to grant access to. Any users signed in with the domain specified will be granted the specified access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#domain BigqueryDataset#domain}
     *
     * @stability stable
     */
    readonly domain?: string;
    /**
     * An email address of a Google Group to grant access to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#group_by_email BigqueryDataset#group_by_email}
     *
     * @stability stable
     */
    readonly groupByEmail?: string;
    /**
     * Describes the rights granted to the user specified by the other member of the access object.
     *
     * Basic, predefined, and custom roles
     * are supported. Predefined roles that have equivalent basic roles
     * are swapped by the API to their basic counterparts. See
     * [official docs](https://cloud.google.com/bigquery/docs/access-control).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#role BigqueryDataset#role}
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * A special group to grant access to. Possible values include:.
     *
     * 'projectOwners': Owners of the enclosing project.
     *
     *
     * 'projectReaders': Readers of the enclosing project.
     *
     *
     * 'projectWriters': Writers of the enclosing project.
     *
     *
     * 'allAuthenticatedUsers': All authenticated BigQuery users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#special_group BigqueryDataset#special_group}
     *
     * @stability stable
     */
    readonly specialGroup?: string;
    /**
     * An email address of a user to grant access to. For example: fred@example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#user_by_email BigqueryDataset#user_by_email}
     *
     * @stability stable
     */
    readonly userByEmail?: string;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#view BigqueryDataset#view}
     *
     * @stability stable
     */
    readonly view?: BigqueryDatasetAccessView;
}
export declare function bigqueryDatasetAccessToTerraform(struct?: BigqueryDatasetAccess | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface BigqueryDatasetDefaultEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires
     * access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#kms_key_name BigqueryDataset#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function bigqueryDatasetDefaultEncryptionConfigurationToTerraform(struct?: BigqueryDatasetDefaultEncryptionConfigurationOutputReference | BigqueryDatasetDefaultEncryptionConfiguration): any;
/**
 * @stability stable
 */
export declare class BigqueryDatasetDefaultEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryDatasetDefaultEncryptionConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryDatasetDefaultEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryDatasetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#create BigqueryDataset#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#delete BigqueryDataset#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset#update BigqueryDataset#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function bigqueryDatasetTimeoutsToTerraform(struct?: BigqueryDatasetTimeoutsOutputReference | BigqueryDatasetTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class BigqueryDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryDatasetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryDatasetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset google_bigquery_dataset}.
 *
 * @stability stable
 */
export declare class BigqueryDataset extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset google_bigquery_dataset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryDatasetConfig);
    /**
     * @stability stable
     */
    get creationTime(): number;
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _defaultPartitionExpirationMs?;
    /**
     * @stability stable
     */
    get defaultPartitionExpirationMs(): number;
    /**
     * @stability stable
     */
    set defaultPartitionExpirationMs(value: number);
    /**
     * @stability stable
     */
    resetDefaultPartitionExpirationMs(): void;
    /**
     * @stability stable
     */
    get defaultPartitionExpirationMsInput(): number | undefined;
    private _defaultTableExpirationMs?;
    /**
     * @stability stable
     */
    get defaultTableExpirationMs(): number;
    /**
     * @stability stable
     */
    set defaultTableExpirationMs(value: number);
    /**
     * @stability stable
     */
    resetDefaultTableExpirationMs(): void;
    /**
     * @stability stable
     */
    get defaultTableExpirationMsInput(): number | undefined;
    private _deleteContentsOnDestroy?;
    /**
     * @stability stable
     */
    get deleteContentsOnDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteContentsOnDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteContentsOnDestroy(): void;
    /**
     * @stability stable
     */
    get deleteContentsOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    private _friendlyName?;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    set friendlyName(value: string);
    /**
     * @stability stable
     */
    resetFriendlyName(): void;
    /**
     * @stability stable
     */
    get friendlyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get lastModifiedTime(): number;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _access?;
    /**
     * @stability stable
     */
    get access(): BigqueryDatasetAccess[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set access(value: BigqueryDatasetAccess[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccess(): void;
    /**
     * @stability stable
     */
    get accessInput(): cdktf.IResolvable | BigqueryDatasetAccess[] | undefined;
    private _defaultEncryptionConfiguration;
    /**
     * @stability stable
     */
    get defaultEncryptionConfiguration(): BigqueryDatasetDefaultEncryptionConfigurationOutputReference;
    /**
     * @stability stable
     */
    putDefaultEncryptionConfiguration(value: BigqueryDatasetDefaultEncryptionConfiguration): void;
    /**
     * @stability stable
     */
    resetDefaultEncryptionConfiguration(): void;
    /**
     * @stability stable
     */
    get defaultEncryptionConfigurationInput(): BigqueryDatasetDefaultEncryptionConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryDatasetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BigqueryDatasetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryDatasetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
