import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BinaryAuthorizationAttestorConfig extends cdktf.TerraformMetaArguments {
    /**
     * A descriptive comment. This field may be updated. The field may be displayed in chooser dialogs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#description BinaryAuthorizationAttestor#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The resource name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#name BinaryAuthorizationAttestor#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#project BinaryAuthorizationAttestor#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * attestation_authority_note block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#attestation_authority_note BinaryAuthorizationAttestor#attestation_authority_note}
     *
     * @stability stable
     */
    readonly attestationAuthorityNote: BinaryAuthorizationAttestorAttestationAuthorityNote;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#timeouts BinaryAuthorizationAttestor#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BinaryAuthorizationAttestorTimeouts;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey {
    /**
     * A PEM-encoded public key, as described in 'https://tools.ietf.org/html/rfc7468#section-13'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#public_key_pem BinaryAuthorizationAttestor#public_key_pem}
     *
     * @stability stable
     */
    readonly publicKeyPem?: string;
    /**
     * The signature algorithm used to verify a message against a signature using this key.
     *
     * These signature algorithm must
     * match the structure and any object identifiers encoded in
     * publicKeyPem (i.e. this algorithm must match that of the
     * public key).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#signature_algorithm BinaryAuthorizationAttestor#signature_algorithm}
     *
     * @stability stable
     */
    readonly signatureAlgorithm?: string;
}
export declare function binaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyToTerraform(struct?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference | BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey): any;
/**
 * @stability stable
 */
export declare class BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined);
    private _publicKeyPem?;
    /**
     * @stability stable
     */
    get publicKeyPem(): string;
    /**
     * @stability stable
     */
    set publicKeyPem(value: string);
    /**
     * @stability stable
     */
    resetPublicKeyPem(): void;
    /**
     * @stability stable
     */
    get publicKeyPemInput(): string | undefined;
    private _signatureAlgorithm?;
    /**
     * @stability stable
     */
    get signatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set signatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get signatureAlgorithmInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys {
    /**
     * ASCII-armored representation of a PGP public key, as the entire output by the command 'gpg --export --armor foo@example.com' (either LF or CRLF line endings). When using this field, id should be left blank. The BinAuthz API handlers will calculate the ID and fill it in automatically. BinAuthz computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as upper-case hex. If id is provided by the caller, it will be overwritten by the API-calculated ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#ascii_armored_pgp_public_key BinaryAuthorizationAttestor#ascii_armored_pgp_public_key}
     *
     * @stability stable
     */
    readonly asciiArmoredPgpPublicKey?: string;
    /**
     * A descriptive comment. This field may be updated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#comment BinaryAuthorizationAttestor#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The ID of this public key.
     *
     * Signatures verified by BinAuthz
     * must include the ID of the public key that can be used to
     * verify them, and that ID must match the contents of this
     * field exactly. Additional restrictions on this field can
     * be imposed based on which public key type is encapsulated.
     * See the documentation on publicKey cases below for details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#id BinaryAuthorizationAttestor#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * pkix_public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#pkix_public_key BinaryAuthorizationAttestor#pkix_public_key}
     *
     * @stability stable
     */
    readonly pkixPublicKey?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey;
}
export declare function binaryAuthorizationAttestorAttestationAuthorityNotePublicKeysToTerraform(struct?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface BinaryAuthorizationAttestorAttestationAuthorityNote {
    /**
     * The resource name of a ATTESTATION_AUTHORITY Note, created by the user.
     *
     * If the Note is in a different project from the Attestor, it
     * should be specified in the format 'projects/*\/notes/*' (or the legacy
     * 'providers/*\/notes/*'). This field may not be updated.
     * An attestation by this attestor is stored as a Container Analysis
     * ATTESTATION_AUTHORITY Occurrence that names a container image
     * and that links to this Note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#note_reference BinaryAuthorizationAttestor#note_reference}
     *
     * @stability stable
     */
    readonly noteReference: string;
    /**
     * public_keys block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#public_keys BinaryAuthorizationAttestor#public_keys}
     *
     * @stability stable
     */
    readonly publicKeys?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable;
}
export declare function binaryAuthorizationAttestorAttestationAuthorityNoteToTerraform(struct?: BinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference | BinaryAuthorizationAttestorAttestationAuthorityNote): any;
/**
 * @stability stable
 */
export declare class BinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BinaryAuthorizationAttestorAttestationAuthorityNote | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BinaryAuthorizationAttestorAttestationAuthorityNote | undefined);
    /**
     * @stability stable
     */
    get delegationServiceAccountEmail(): string;
    private _noteReference?;
    /**
     * @stability stable
     */
    get noteReference(): string;
    /**
     * @stability stable
     */
    set noteReference(value: string);
    /**
     * @stability stable
     */
    get noteReferenceInput(): string | undefined;
    private _publicKeys?;
    /**
     * @stability stable
     */
    get publicKeys(): BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicKeys(value: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicKeys(): void;
    /**
     * @stability stable
     */
    get publicKeysInput(): cdktf.IResolvable | BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | undefined;
}
/**
 * @stability stable
 */
export interface BinaryAuthorizationAttestorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#create BinaryAuthorizationAttestor#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#delete BinaryAuthorizationAttestor#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#update BinaryAuthorizationAttestor#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function binaryAuthorizationAttestorTimeoutsToTerraform(struct?: BinaryAuthorizationAttestorTimeoutsOutputReference | BinaryAuthorizationAttestorTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class BinaryAuthorizationAttestorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BinaryAuthorizationAttestorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BinaryAuthorizationAttestorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor google_binary_authorization_attestor}.
 *
 * @stability stable
 */
export declare class BinaryAuthorizationAttestor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor google_binary_authorization_attestor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationAttestorConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _attestationAuthorityNote;
    /**
     * @stability stable
     */
    get attestationAuthorityNote(): BinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference;
    /**
     * @stability stable
     */
    putAttestationAuthorityNote(value: BinaryAuthorizationAttestorAttestationAuthorityNote): void;
    /**
     * @stability stable
     */
    get attestationAuthorityNoteInput(): BinaryAuthorizationAttestorAttestationAuthorityNote | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BinaryAuthorizationAttestorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BinaryAuthorizationAttestorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BinaryAuthorizationAttestorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
