import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudAssetFolderFeedConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of the full names of the assets to receive updates.
     *
     * You must specify either or both of
     * assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
     * exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
     * See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#asset_names CloudAssetFolderFeed#asset_names}
     *
     * @stability stable
     */
    readonly assetNames?: string[];
    /**
     * A list of types of the assets to receive updates.
     *
     * You must specify either or both of assetNames
     * and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
     * the feed. For example: "compute.googleapis.com/Disk"
     * See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
     * supported asset types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#asset_types CloudAssetFolderFeed#asset_types}
     *
     * @stability stable
     */
    readonly assetTypes?: string[];
    /**
     * The project whose identity will be used when sending messages to the destination pubsub topic.
     *
     * It also specifies the project for API
     * enablement check, quota, and billing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#billing_project CloudAssetFolderFeed#billing_project}
     *
     * @stability stable
     */
    readonly billingProject: string;
    /**
     * Asset content type.
     *
     * If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#content_type CloudAssetFolderFeed#content_type}
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#feed_id CloudAssetFolderFeed#feed_id}
     *
     * @stability stable
     */
    readonly feedId: string;
    /**
     * The folder this feed should be created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#folder CloudAssetFolderFeed#folder}
     *
     * @stability stable
     */
    readonly folder: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#condition CloudAssetFolderFeed#condition}
     *
     * @stability stable
     */
    readonly condition?: CloudAssetFolderFeedCondition;
    /**
     * feed_output_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#feed_output_config CloudAssetFolderFeed#feed_output_config}
     *
     * @stability stable
     */
    readonly feedOutputConfig: CloudAssetFolderFeedFeedOutputConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#timeouts CloudAssetFolderFeed#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudAssetFolderFeedTimeouts;
}
/**
 * @stability stable
 */
export interface CloudAssetFolderFeedCondition {
    /**
     * Description of the expression.
     *
     * This is a longer text which describes the expression,
     * e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#description CloudAssetFolderFeed#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#expression CloudAssetFolderFeed#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file  name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#location CloudAssetFolderFeed#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#title CloudAssetFolderFeed#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
export declare function cloudAssetFolderFeedConditionToTerraform(struct?: CloudAssetFolderFeedConditionOutputReference | CloudAssetFolderFeedCondition): any;
/**
 * @stability stable
 */
export declare class CloudAssetFolderFeedConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetFolderFeedCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetFolderFeedCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudAssetFolderFeedFeedOutputConfigPubsubDestination {
    /**
     * Destination on Cloud Pubsub topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#topic CloudAssetFolderFeed#topic}
     *
     * @stability stable
     */
    readonly topic: string;
}
export declare function cloudAssetFolderFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference | CloudAssetFolderFeedFeedOutputConfigPubsubDestination): any;
/**
 * @stability stable
 */
export declare class CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudAssetFolderFeedFeedOutputConfig {
    /**
     * pubsub_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#pubsub_destination CloudAssetFolderFeed#pubsub_destination}
     *
     * @stability stable
     */
    readonly pubsubDestination: CloudAssetFolderFeedFeedOutputConfigPubsubDestination;
}
export declare function cloudAssetFolderFeedFeedOutputConfigToTerraform(struct?: CloudAssetFolderFeedFeedOutputConfigOutputReference | CloudAssetFolderFeedFeedOutputConfig): any;
/**
 * @stability stable
 */
export declare class CloudAssetFolderFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetFolderFeedFeedOutputConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetFolderFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    /**
     * @stability stable
     */
    get pubsubDestination(): CloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference;
    /**
     * @stability stable
     */
    putPubsubDestination(value: CloudAssetFolderFeedFeedOutputConfigPubsubDestination): void;
    /**
     * @stability stable
     */
    get pubsubDestinationInput(): CloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
}
/**
 * @stability stable
 */
export interface CloudAssetFolderFeedTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#create CloudAssetFolderFeed#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#delete CloudAssetFolderFeed#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed#update CloudAssetFolderFeed#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudAssetFolderFeedTimeoutsToTerraform(struct?: CloudAssetFolderFeedTimeoutsOutputReference | CloudAssetFolderFeedTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class CloudAssetFolderFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudAssetFolderFeedTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudAssetFolderFeedTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed google_cloud_asset_folder_feed}.
 *
 * @stability stable
 */
export declare class CloudAssetFolderFeed extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_folder_feed google_cloud_asset_folder_feed} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudAssetFolderFeedConfig);
    private _assetNames?;
    /**
     * @stability stable
     */
    get assetNames(): string[];
    /**
     * @stability stable
     */
    set assetNames(value: string[]);
    /**
     * @stability stable
     */
    resetAssetNames(): void;
    /**
     * @stability stable
     */
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    /**
     * @stability stable
     */
    get assetTypes(): string[];
    /**
     * @stability stable
     */
    set assetTypes(value: string[]);
    /**
     * @stability stable
     */
    resetAssetTypes(): void;
    /**
     * @stability stable
     */
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    /**
     * @stability stable
     */
    get billingProject(): string;
    /**
     * @stability stable
     */
    set billingProject(value: string);
    /**
     * @stability stable
     */
    get billingProjectInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _feedId?;
    /**
     * @stability stable
     */
    get feedId(): string;
    /**
     * @stability stable
     */
    set feedId(value: string);
    /**
     * @stability stable
     */
    get feedIdInput(): string | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get folderId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): CloudAssetFolderFeedConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: CloudAssetFolderFeedCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): CloudAssetFolderFeedCondition | undefined;
    private _feedOutputConfig;
    /**
     * @stability stable
     */
    get feedOutputConfig(): CloudAssetFolderFeedFeedOutputConfigOutputReference;
    /**
     * @stability stable
     */
    putFeedOutputConfig(value: CloudAssetFolderFeedFeedOutputConfig): void;
    /**
     * @stability stable
     */
    get feedOutputConfigInput(): CloudAssetFolderFeedFeedOutputConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudAssetFolderFeedTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudAssetFolderFeedTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudAssetFolderFeedTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
