import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Group to create this membership in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#group CloudIdentityGroupMembership#group}
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * preferred_member_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#preferred_member_key CloudIdentityGroupMembership#preferred_member_key}
     *
     * @stability stable
     */
    readonly preferredMemberKey?: CloudIdentityGroupMembershipPreferredMemberKey;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#roles CloudIdentityGroupMembership#roles}
     *
     * @stability stable
     */
    readonly roles: CloudIdentityGroupMembershipRoles[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#timeouts CloudIdentityGroupMembership#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudIdentityGroupMembershipTimeouts;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipPreferredMemberKey {
    /**
     * The ID of the entity.
     *
     * For Google-managed entities, the id must be the email address of an existing
     * group or user.
     *
     * For external-identity-mapped entities, the id must be a string conforming
     * to the Identity Source's requirements.
     *
     * Must be unique within a namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#id CloudIdentityGroupMembership#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The namespace in which the entity exists.
     *
     * If not specified, the EntityKey represents a Google-managed entity
     * such as a Google user or a Google Group.
     *
     * If specified, the EntityKey represents an external-identity-mapped group.
     * The namespace must correspond to an identity source created in Admin Console
     * and must be in the form of 'identitysources/{identity_source_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#namespace CloudIdentityGroupMembership#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
export declare function cloudIdentityGroupMembershipPreferredMemberKeyToTerraform(struct?: CloudIdentityGroupMembershipPreferredMemberKeyOutputReference | CloudIdentityGroupMembershipPreferredMemberKey): any;
/**
 * @stability stable
 */
export declare class CloudIdentityGroupMembershipPreferredMemberKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudIdentityGroupMembershipPreferredMemberKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudIdentityGroupMembershipPreferredMemberKey | undefined);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    resetNamespace(): void;
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipRoles {
    /**
     * The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER. Possible values: ["OWNER", "MANAGER", "MEMBER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#name CloudIdentityGroupMembership#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function cloudIdentityGroupMembershipRolesToTerraform(struct?: CloudIdentityGroupMembershipRoles | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface CloudIdentityGroupMembershipTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#create CloudIdentityGroupMembership#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#delete CloudIdentityGroupMembership#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership#update CloudIdentityGroupMembership#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudIdentityGroupMembershipTimeoutsToTerraform(struct?: CloudIdentityGroupMembershipTimeoutsOutputReference | CloudIdentityGroupMembershipTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class CloudIdentityGroupMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudIdentityGroupMembershipTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudIdentityGroupMembershipTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership google_cloud_identity_group_membership}.
 *
 * @stability stable
 */
export declare class CloudIdentityGroupMembership extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group_membership google_cloud_identity_group_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudIdentityGroupMembershipConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _preferredMemberKey;
    /**
     * @stability stable
     */
    get preferredMemberKey(): CloudIdentityGroupMembershipPreferredMemberKeyOutputReference;
    /**
     * @stability stable
     */
    putPreferredMemberKey(value: CloudIdentityGroupMembershipPreferredMemberKey): void;
    /**
     * @stability stable
     */
    resetPreferredMemberKey(): void;
    /**
     * @stability stable
     */
    get preferredMemberKeyInput(): CloudIdentityGroupMembershipPreferredMemberKey | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): CloudIdentityGroupMembershipRoles[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set roles(value: CloudIdentityGroupMembershipRoles[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get rolesInput(): cdktf.IResolvable | CloudIdentityGroupMembershipRoles[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudIdentityGroupMembershipTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudIdentityGroupMembershipTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudIdentityGroupMembershipTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
