import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeExternalVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#description ComputeExternalVpnGateway#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#name ComputeExternalVpnGateway#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#project ComputeExternalVpnGateway#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Indicates the redundancy type of this external VPN gateway Possible values: ["FOUR_IPS_REDUNDANCY", "SINGLE_IP_INTERNALLY_REDUNDANT", "TWO_IPS_REDUNDANCY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#redundancy_type ComputeExternalVpnGateway#redundancy_type}
     *
     * @stability stable
     */
    readonly redundancyType?: string;
    /**
     * interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#interface ComputeExternalVpnGateway#interface}
     *
     * @stability stable
     */
    readonly interface?: ComputeExternalVpnGatewayInterface[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#timeouts ComputeExternalVpnGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeExternalVpnGatewayTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeExternalVpnGatewayInterface {
    /**
     * The numeric ID for this interface.
     *
     * Allowed values are based on the redundancy type
     * of this external VPN gateway
     * '0 - SINGLE_IP_INTERNALLY_REDUNDANT'
     * '0, 1 - TWO_IPS_REDUNDANCY'
     * '0, 1, 2, 3 - FOUR_IPS_REDUNDANCY'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#id ComputeExternalVpnGateway#id}
     *
     * @stability stable
     */
    readonly id?: number;
    /**
     * IP address of the interface in the external VPN gateway.
     *
     * Only IPv4 is supported. This IP address can be either from
     * your on-premise gateway or another Cloud provider's VPN gateway,
     * it cannot be an IP address from Google Compute Engine.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#ip_address ComputeExternalVpnGateway#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
}
export declare function computeExternalVpnGatewayInterfaceToTerraform(struct?: ComputeExternalVpnGatewayInterface | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ComputeExternalVpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#create ComputeExternalVpnGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway#delete ComputeExternalVpnGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeExternalVpnGatewayTimeoutsToTerraform(struct?: ComputeExternalVpnGatewayTimeoutsOutputReference | ComputeExternalVpnGatewayTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeExternalVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeExternalVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeExternalVpnGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway google_compute_external_vpn_gateway}.
 *
 * @stability stable
 */
export declare class ComputeExternalVpnGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway google_compute_external_vpn_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeExternalVpnGatewayConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _redundancyType?;
    /**
     * @stability stable
     */
    get redundancyType(): string;
    /**
     * @stability stable
     */
    set redundancyType(value: string);
    /**
     * @stability stable
     */
    resetRedundancyType(): void;
    /**
     * @stability stable
     */
    get redundancyTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _interface?;
    /**
     * @stability stable
     */
    get interface(): ComputeExternalVpnGatewayInterface[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set interface(value: ComputeExternalVpnGatewayInterface[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInterface(): void;
    /**
     * @stability stable
     */
    get interfaceInput(): cdktf.IResolvable | ComputeExternalVpnGatewayInterface[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeExternalVpnGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeExternalVpnGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeExternalVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
