import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeFirewallPolicyAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The target that the firewall policy is attached to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association#attachment_target ComputeFirewallPolicyAssociation#attachment_target}
     *
     * @stability stable
     */
    readonly attachmentTarget: string;
    /**
     * The firewall policy ID of the association.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association#firewall_policy ComputeFirewallPolicyAssociation#firewall_policy}
     *
     * @stability stable
     */
    readonly firewallPolicy: string;
    /**
     * The name for an association.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association#name ComputeFirewallPolicyAssociation#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association#timeouts ComputeFirewallPolicyAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeFirewallPolicyAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeFirewallPolicyAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association#create ComputeFirewallPolicyAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association#delete ComputeFirewallPolicyAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeFirewallPolicyAssociationTimeoutsToTerraform(struct?: ComputeFirewallPolicyAssociationTimeoutsOutputReference | ComputeFirewallPolicyAssociationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeFirewallPolicyAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeFirewallPolicyAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeFirewallPolicyAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association google_compute_firewall_policy_association}.
 *
 * @stability stable
 */
export declare class ComputeFirewallPolicyAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association google_compute_firewall_policy_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeFirewallPolicyAssociationConfig);
    private _attachmentTarget?;
    /**
     * @stability stable
     */
    get attachmentTarget(): string;
    /**
     * @stability stable
     */
    set attachmentTarget(value: string);
    /**
     * @stability stable
     */
    get attachmentTargetInput(): string | undefined;
    private _firewallPolicy?;
    /**
     * @stability stable
     */
    get firewallPolicy(): string;
    /**
     * @stability stable
     */
    set firewallPolicy(value: string);
    /**
     * @stability stable
     */
    get firewallPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get shortName(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeFirewallPolicyAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeFirewallPolicyAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeFirewallPolicyAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
