import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#description ComputeResourcePolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The resource name must be 1-63 characters long, and comply
     * with RFC1035. Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
     * first character must be a lowercase letter, and all following characters
     * must be a dash, lowercase letter, or digit, except the last character,
     * which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#name ComputeResourcePolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#project ComputeResourcePolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where resource policy resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#region ComputeResourcePolicy#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * group_placement_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#group_placement_policy ComputeResourcePolicy#group_placement_policy}
     *
     * @stability stable
     */
    readonly groupPlacementPolicy?: ComputeResourcePolicyGroupPlacementPolicy;
    /**
     * instance_schedule_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#instance_schedule_policy ComputeResourcePolicy#instance_schedule_policy}
     *
     * @stability stable
     */
    readonly instanceSchedulePolicy?: ComputeResourcePolicyInstanceSchedulePolicy;
    /**
     * snapshot_schedule_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#snapshot_schedule_policy ComputeResourcePolicy#snapshot_schedule_policy}
     *
     * @stability stable
     */
    readonly snapshotSchedulePolicy?: ComputeResourcePolicySnapshotSchedulePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#timeouts ComputeResourcePolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeResourcePolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyGroupPlacementPolicy {
    /**
     * The number of availability domains instances will be spread across.
     *
     * If two instances are in different
     * availability domain, they will not be put in the same low latency network
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#availability_domain_count ComputeResourcePolicy#availability_domain_count}
     *
     * @stability stable
     */
    readonly availabilityDomainCount?: number;
    /**
     * Collocation specifies whether to place VMs inside the same availability domain on the same low-latency network.
     *
     * Specify 'COLLOCATED' to enable collocation. Can only be specified with 'vm_count'. If compute instances are created
     * with a COLLOCATED policy, then exactly 'vm_count' instances must be created at the same time with the resource policy
     * attached. Possible values: ["COLLOCATED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#collocation ComputeResourcePolicy#collocation}
     *
     * @stability stable
     */
    readonly collocation?: string;
    /**
     * Number of vms in this placement group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#vm_count ComputeResourcePolicy#vm_count}
     *
     * @stability stable
     */
    readonly vmCount?: number;
}
export declare function computeResourcePolicyGroupPlacementPolicyToTerraform(struct?: ComputeResourcePolicyGroupPlacementPolicyOutputReference | ComputeResourcePolicyGroupPlacementPolicy): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicyGroupPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicyGroupPlacementPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicyGroupPlacementPolicy | undefined);
    private _availabilityDomainCount?;
    /**
     * @stability stable
     */
    get availabilityDomainCount(): number;
    /**
     * @stability stable
     */
    set availabilityDomainCount(value: number);
    /**
     * @stability stable
     */
    resetAvailabilityDomainCount(): void;
    /**
     * @stability stable
     */
    get availabilityDomainCountInput(): number | undefined;
    private _collocation?;
    /**
     * @stability stable
     */
    get collocation(): string;
    /**
     * @stability stable
     */
    set collocation(value: string);
    /**
     * @stability stable
     */
    resetCollocation(): void;
    /**
     * @stability stable
     */
    get collocationInput(): string | undefined;
    private _vmCount?;
    /**
     * @stability stable
     */
    get vmCount(): number;
    /**
     * @stability stable
     */
    set vmCount(value: number);
    /**
     * @stability stable
     */
    resetVmCount(): void;
    /**
     * @stability stable
     */
    get vmCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule {
    /**
     * Specifies the frequency for the operation, using the unix-cron format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#schedule ComputeResourcePolicy#schedule}
     *
     * @stability stable
     */
    readonly schedule: string;
}
export declare function computeResourcePolicyInstanceSchedulePolicyVmStartScheduleToTerraform(struct?: ComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference | ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined);
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): string;
    /**
     * @stability stable
     */
    set schedule(value: string);
    /**
     * @stability stable
     */
    get scheduleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule {
    /**
     * Specifies the frequency for the operation, using the unix-cron format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#schedule ComputeResourcePolicy#schedule}
     *
     * @stability stable
     */
    readonly schedule: string;
}
export declare function computeResourcePolicyInstanceSchedulePolicyVmStopScheduleToTerraform(struct?: ComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference | ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined);
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): string;
    /**
     * @stability stable
     */
    set schedule(value: string);
    /**
     * @stability stable
     */
    get scheduleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyInstanceSchedulePolicy {
    /**
     * The expiration time of the schedule. The timestamp is an RFC3339 string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#expiration_time ComputeResourcePolicy#expiration_time}
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * The start time of the schedule. The timestamp is an RFC3339 string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Specifies the time zone to be used in interpreting the schedule.
     *
     * The value of this field must be a time zone name
     * from the tz database: http://en.wikipedia.org/wiki/Tz_database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#time_zone ComputeResourcePolicy#time_zone}
     *
     * @stability stable
     */
    readonly timeZone: string;
    /**
     * vm_start_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#vm_start_schedule ComputeResourcePolicy#vm_start_schedule}
     *
     * @stability stable
     */
    readonly vmStartSchedule?: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule;
    /**
     * vm_stop_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#vm_stop_schedule ComputeResourcePolicy#vm_stop_schedule}
     *
     * @stability stable
     */
    readonly vmStopSchedule?: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule;
}
export declare function computeResourcePolicyInstanceSchedulePolicyToTerraform(struct?: ComputeResourcePolicyInstanceSchedulePolicyOutputReference | ComputeResourcePolicyInstanceSchedulePolicy): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicyInstanceSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicyInstanceSchedulePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicyInstanceSchedulePolicy | undefined);
    private _expirationTime?;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    set expirationTime(value: string);
    /**
     * @stability stable
     */
    resetExpirationTime(): void;
    /**
     * @stability stable
     */
    get expirationTimeInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _timeZone?;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    set timeZone(value: string);
    /**
     * @stability stable
     */
    get timeZoneInput(): string | undefined;
    private _vmStartSchedule;
    /**
     * @stability stable
     */
    get vmStartSchedule(): ComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference;
    /**
     * @stability stable
     */
    putVmStartSchedule(value: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): void;
    /**
     * @stability stable
     */
    resetVmStartSchedule(): void;
    /**
     * @stability stable
     */
    get vmStartScheduleInput(): ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    private _vmStopSchedule;
    /**
     * @stability stable
     */
    get vmStopSchedule(): ComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference;
    /**
     * @stability stable
     */
    putVmStopSchedule(value: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): void;
    /**
     * @stability stable
     */
    resetVmStopSchedule(): void;
    /**
     * @stability stable
     */
    get vmStopScheduleInput(): ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy {
    /**
     * Maximum age of the snapshot that is allowed to be kept.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#max_retention_days ComputeResourcePolicy#max_retention_days}
     *
     * @stability stable
     */
    readonly maxRetentionDays: number;
    /**
     * Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
     *
     * Default value: "KEEP_AUTO_SNAPSHOTS" Possible values: ["KEEP_AUTO_SNAPSHOTS", "APPLY_RETENTION_POLICY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#on_source_disk_delete ComputeResourcePolicy#on_source_disk_delete}
     *
     * @stability stable
     */
    readonly onSourceDiskDelete?: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyRetentionPolicyToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference | ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined);
    private _maxRetentionDays?;
    /**
     * @stability stable
     */
    get maxRetentionDays(): number;
    /**
     * @stability stable
     */
    set maxRetentionDays(value: number);
    /**
     * @stability stable
     */
    get maxRetentionDaysInput(): number | undefined;
    private _onSourceDiskDelete?;
    /**
     * @stability stable
     */
    get onSourceDiskDelete(): string;
    /**
     * @stability stable
     */
    set onSourceDiskDelete(value: string);
    /**
     * @stability stable
     */
    resetOnSourceDiskDelete(): void;
    /**
     * @stability stable
     */
    get onSourceDiskDeleteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule {
    /**
     * The number of days between snapshots.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#days_in_cycle ComputeResourcePolicy#days_in_cycle}
     *
     * @stability stable
     */
    readonly daysInCycle: number;
    /**
     * This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00.
     *
     * For example,
     * both 13:00-5 and 08:00 are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined);
    private _daysInCycle?;
    /**
     * @stability stable
     */
    get daysInCycle(): number;
    /**
     * @stability stable
     */
    set daysInCycle(value: number);
    /**
     * @stability stable
     */
    get daysInCycleInput(): number | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule {
    /**
     * The number of hours between snapshots.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#hours_in_cycle ComputeResourcePolicy#hours_in_cycle}
     *
     * @stability stable
     */
    readonly hoursInCycle: number;
    /**
     * Time within the window to start the operations.
     *
     * It must be in an hourly format "HH:MM",
     * where HH : [00-23] and MM : [00] GMT.
     * eg: 21:00
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined);
    private _hoursInCycle?;
    /**
     * @stability stable
     */
    get hoursInCycle(): number;
    /**
     * @stability stable
     */
    set hoursInCycle(value: number);
    /**
     * @stability stable
     */
    get hoursInCycleInput(): number | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks {
    /**
     * The day of the week to create the snapshot.
     *
     * e.g. MONDAY Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#day ComputeResourcePolicy#day}
     *
     * @stability stable
     */
    readonly day: string;
    /**
     * Time within the window to start the operations.
     *
     * It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule {
    /**
     * day_of_weeks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#day_of_weeks ComputeResourcePolicy#day_of_weeks}
     *
     * @stability stable
     */
    readonly dayOfWeeks: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined);
    private _dayOfWeeks?;
    /**
     * @stability stable
     */
    get dayOfWeeks(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dayOfWeeks(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get dayOfWeeksInput(): cdktf.IResolvable | ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicySchedule {
    /**
     * daily_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#daily_schedule ComputeResourcePolicy#daily_schedule}
     *
     * @stability stable
     */
    readonly dailySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule;
    /**
     * hourly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#hourly_schedule ComputeResourcePolicy#hourly_schedule}
     *
     * @stability stable
     */
    readonly hourlySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule;
    /**
     * weekly_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#weekly_schedule ComputeResourcePolicy#weekly_schedule}
     *
     * @stability stable
     */
    readonly weeklySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicySchedule): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicySchedule | undefined);
    private _dailySchedule;
    /**
     * @stability stable
     */
    get dailySchedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference;
    /**
     * @stability stable
     */
    putDailySchedule(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): void;
    /**
     * @stability stable
     */
    resetDailySchedule(): void;
    /**
     * @stability stable
     */
    get dailyScheduleInput(): ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    private _hourlySchedule;
    /**
     * @stability stable
     */
    get hourlySchedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference;
    /**
     * @stability stable
     */
    putHourlySchedule(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): void;
    /**
     * @stability stable
     */
    resetHourlySchedule(): void;
    /**
     * @stability stable
     */
    get hourlyScheduleInput(): ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    private _weeklySchedule;
    /**
     * @stability stable
     */
    get weeklySchedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference;
    /**
     * @stability stable
     */
    putWeeklySchedule(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): void;
    /**
     * @stability stable
     */
    resetWeeklySchedule(): void;
    /**
     * @stability stable
     */
    get weeklyScheduleInput(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties {
    /**
     * Whether to perform a 'guest aware' snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#guest_flush ComputeResourcePolicy#guest_flush}
     *
     * @stability stable
     */
    readonly guestFlush?: boolean | cdktf.IResolvable;
    /**
     * A set of key-value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#labels ComputeResourcePolicy#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Cloud Storage bucket location to store the auto snapshot (regional or multi-regional).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#storage_locations ComputeResourcePolicy#storage_locations}
     *
     * @stability stable
     */
    readonly storageLocations?: string[];
}
export declare function computeResourcePolicySnapshotSchedulePolicySnapshotPropertiesToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference | ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined);
    private _guestFlush?;
    /**
     * @stability stable
     */
    get guestFlush(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set guestFlush(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGuestFlush(): void;
    /**
     * @stability stable
     */
    get guestFlushInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _storageLocations?;
    /**
     * @stability stable
     */
    get storageLocations(): string[];
    /**
     * @stability stable
     */
    set storageLocations(value: string[]);
    /**
     * @stability stable
     */
    resetStorageLocations(): void;
    /**
     * @stability stable
     */
    get storageLocationsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicySnapshotSchedulePolicy {
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#retention_policy ComputeResourcePolicy#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#schedule ComputeResourcePolicy#schedule}
     *
     * @stability stable
     */
    readonly schedule: ComputeResourcePolicySnapshotSchedulePolicySchedule;
    /**
     * snapshot_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#snapshot_properties ComputeResourcePolicy#snapshot_properties}
     *
     * @stability stable
     */
    readonly snapshotProperties?: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties;
}
export declare function computeResourcePolicySnapshotSchedulePolicyToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyOutputReference | ComputeResourcePolicySnapshotSchedulePolicy): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicySnapshotSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicy | undefined);
    private _retentionPolicy;
    /**
     * @stability stable
     */
    get retentionPolicy(): ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetentionPolicy(value: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: ComputeResourcePolicySnapshotSchedulePolicySchedule): void;
    /**
     * @stability stable
     */
    get scheduleInput(): ComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    private _snapshotProperties;
    /**
     * @stability stable
     */
    get snapshotProperties(): ComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference;
    /**
     * @stability stable
     */
    putSnapshotProperties(value: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): void;
    /**
     * @stability stable
     */
    resetSnapshotProperties(): void;
    /**
     * @stability stable
     */
    get snapshotPropertiesInput(): ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
}
/**
 * @stability stable
 */
export interface ComputeResourcePolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#create ComputeResourcePolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#delete ComputeResourcePolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeResourcePolicyTimeoutsToTerraform(struct?: ComputeResourcePolicyTimeoutsOutputReference | ComputeResourcePolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeResourcePolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeResourcePolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeResourcePolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy google_compute_resource_policy}.
 *
 * @stability stable
 */
export declare class ComputeResourcePolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy google_compute_resource_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeResourcePolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _groupPlacementPolicy;
    /**
     * @stability stable
     */
    get groupPlacementPolicy(): ComputeResourcePolicyGroupPlacementPolicyOutputReference;
    /**
     * @stability stable
     */
    putGroupPlacementPolicy(value: ComputeResourcePolicyGroupPlacementPolicy): void;
    /**
     * @stability stable
     */
    resetGroupPlacementPolicy(): void;
    /**
     * @stability stable
     */
    get groupPlacementPolicyInput(): ComputeResourcePolicyGroupPlacementPolicy | undefined;
    private _instanceSchedulePolicy;
    /**
     * @stability stable
     */
    get instanceSchedulePolicy(): ComputeResourcePolicyInstanceSchedulePolicyOutputReference;
    /**
     * @stability stable
     */
    putInstanceSchedulePolicy(value: ComputeResourcePolicyInstanceSchedulePolicy): void;
    /**
     * @stability stable
     */
    resetInstanceSchedulePolicy(): void;
    /**
     * @stability stable
     */
    get instanceSchedulePolicyInput(): ComputeResourcePolicyInstanceSchedulePolicy | undefined;
    private _snapshotSchedulePolicy;
    /**
     * @stability stable
     */
    get snapshotSchedulePolicy(): ComputeResourcePolicySnapshotSchedulePolicyOutputReference;
    /**
     * @stability stable
     */
    putSnapshotSchedulePolicy(value: ComputeResourcePolicySnapshotSchedulePolicy): void;
    /**
     * @stability stable
     */
    resetSnapshotSchedulePolicy(): void;
    /**
     * @stability stable
     */
    get snapshotSchedulePolicyInput(): ComputeResourcePolicySnapshotSchedulePolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeResourcePolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeResourcePolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeResourcePolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
