import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeServiceAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The connection preference to use for this service attachment. Valid values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#connection_preference ComputeServiceAttachment#connection_preference}
     *
     * @stability stable
     */
    readonly connectionPreference: string;
    /**
     * An array of projects that are not allowed to connect to this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#consumer_reject_lists ComputeServiceAttachment#consumer_reject_lists}
     *
     * @stability stable
     */
    readonly consumerRejectLists?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#description ComputeServiceAttachment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#enable_proxy_protocol ComputeServiceAttachment#enable_proxy_protocol}
     *
     * @stability stable
     */
    readonly enableProxyProtocol: boolean | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#name ComputeServiceAttachment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * An array of subnets that is provided for NAT in this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#nat_subnets ComputeServiceAttachment#nat_subnets}
     *
     * @stability stable
     */
    readonly natSubnets: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#project ComputeServiceAttachment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * URL of the region where the resource resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#region ComputeServiceAttachment#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The URL of a forwarding rule that represents the service identified by this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#target_service ComputeServiceAttachment#target_service}
     *
     * @stability stable
     */
    readonly targetService: string;
    /**
     * consumer_accept_lists block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#consumer_accept_lists ComputeServiceAttachment#consumer_accept_lists}
     *
     * @stability stable
     */
    readonly consumerAcceptLists?: ComputeServiceAttachmentConsumerAcceptLists[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#timeouts ComputeServiceAttachment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeServiceAttachmentTimeouts;
}
/**
 * @stability stable
 */
export declare class ComputeServiceAttachmentConnectedEndpoints extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * @stability stable
 */
export interface ComputeServiceAttachmentConsumerAcceptLists {
    /**
     * The number of consumer forwarding rules the consumer project can create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#connection_limit ComputeServiceAttachment#connection_limit}
     *
     * @stability stable
     */
    readonly connectionLimit: number;
    /**
     * A project that is allowed to connect to this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#project_id_or_num ComputeServiceAttachment#project_id_or_num}
     *
     * @stability stable
     */
    readonly projectIdOrNum: string;
}
export declare function computeServiceAttachmentConsumerAcceptListsToTerraform(struct?: ComputeServiceAttachmentConsumerAcceptLists | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ComputeServiceAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#create ComputeServiceAttachment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#delete ComputeServiceAttachment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment#update ComputeServiceAttachment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeServiceAttachmentTimeoutsToTerraform(struct?: ComputeServiceAttachmentTimeoutsOutputReference | ComputeServiceAttachmentTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeServiceAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeServiceAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeServiceAttachmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment google_compute_service_attachment}.
 *
 * @stability stable
 */
export declare class ComputeServiceAttachment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment google_compute_service_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeServiceAttachmentConfig);
    /**
     * @stability stable
     */
    connectedEndpoints(index: string): ComputeServiceAttachmentConnectedEndpoints;
    private _connectionPreference?;
    /**
     * @stability stable
     */
    get connectionPreference(): string;
    /**
     * @stability stable
     */
    set connectionPreference(value: string);
    /**
     * @stability stable
     */
    get connectionPreferenceInput(): string | undefined;
    private _consumerRejectLists?;
    /**
     * @stability stable
     */
    get consumerRejectLists(): string[];
    /**
     * @stability stable
     */
    set consumerRejectLists(value: string[]);
    /**
     * @stability stable
     */
    resetConsumerRejectLists(): void;
    /**
     * @stability stable
     */
    get consumerRejectListsInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableProxyProtocol?;
    /**
     * @stability stable
     */
    get enableProxyProtocol(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableProxyProtocol(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _natSubnets?;
    /**
     * @stability stable
     */
    get natSubnets(): string[];
    /**
     * @stability stable
     */
    set natSubnets(value: string[]);
    /**
     * @stability stable
     */
    get natSubnetsInput(): string[] | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _targetService?;
    /**
     * @stability stable
     */
    get targetService(): string;
    /**
     * @stability stable
     */
    set targetService(value: string);
    /**
     * @stability stable
     */
    get targetServiceInput(): string | undefined;
    private _consumerAcceptLists?;
    /**
     * @stability stable
     */
    get consumerAcceptLists(): ComputeServiceAttachmentConsumerAcceptLists[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set consumerAcceptLists(value: ComputeServiceAttachmentConsumerAcceptLists[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetConsumerAcceptLists(): void;
    /**
     * @stability stable
     */
    get consumerAcceptListsInput(): cdktf.IResolvable | ComputeServiceAttachmentConsumerAcceptLists[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeServiceAttachmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeServiceAttachmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeServiceAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
