import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Provide this property when
     * you create the resource. This field can be set only at resource
     * creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#description ComputeSubnetwork#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The range of internal addresses that are owned by this subnetwork.
     *
     * Provide this property when you create the subnetwork. For example,
     * 10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
     * non-overlapping within a network. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#ip_cidr_range ComputeSubnetwork#ip_cidr_range}
     *
     * @stability stable
     */
    readonly ipCidrRange: string;
    /**
     * The access type of IPv6 address this subnet holds.
     *
     * It's immutable and can only be specified during creation
     * or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
     * cannot enable direct path. Possible values: ["EXTERNAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#ipv6_access_type ComputeSubnetwork#ipv6_access_type}
     *
     * @stability stable
     */
    readonly ipv6AccessType?: string;
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
     * means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#name ComputeSubnetwork#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The network this subnet belongs to. Only networks that are in the distributed mode can have subnetworks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#network ComputeSubnetwork#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * When enabled, VMs in this subnetwork without external IP addresses can access Google APIs and services by using Private Google Access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#private_ip_google_access ComputeSubnetwork#private_ip_google_access}
     *
     * @stability stable
     */
    readonly privateIpGoogleAccess?: boolean | cdktf.IResolvable;
    /**
     * The private IPv6 google access type for the VMs in this subnet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#private_ipv6_google_access ComputeSubnetwork#private_ipv6_google_access}
     *
     * @stability stable
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#project ComputeSubnetwork#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The purpose of the resource.
     *
     * This field can be either PRIVATE
     * or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to
     * INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
     * reserved for Internal HTTP(S) Load Balancing. If unspecified, the
     * purpose defaults to PRIVATE.
     *
     * If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set 'role'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#purpose ComputeSubnetwork#purpose}
     *
     * @stability stable
     */
    readonly purpose?: string;
    /**
     * The GCP region for this subnetwork.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#region ComputeSubnetwork#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The role of subnetwork.
     *
     * Currently, this field is only used when
     * purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
     * or BACKUP. An ACTIVE subnetwork is one that is currently being used
     * for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
     * is ready to be promoted to ACTIVE or is currently draining. Possible values: ["ACTIVE", "BACKUP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#role ComputeSubnetwork#role}
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork.
     *
     * The primary IP of such VM must belong
     * to the primary ipCidrRange of the subnetwork. The alias IPs may belong
     * to either primary or secondary ranges.
     *
     * *Note**: This field uses [attr-as-block mode](https://www.terraform.io/docs/configuration/attr-as-blocks.html) to avoid
     * breaking users during the 0.12 upgrade. To explicitly send a list
     * of zero objects you must use the following syntax:
     * 'example=[]'
     * For more details about this behavior, see [this section](https://www.terraform.io/docs/configuration/attr-as-blocks.html#defining-a-fixed-object-collection-value).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#secondary_ip_range ComputeSubnetwork#secondary_ip_range}
     *
     * @stability stable
     */
    readonly secondaryIpRange?: ComputeSubnetworkSecondaryIpRange[] | cdktf.IResolvable;
    /**
     * The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified IPV4_ONLY will be used. Possible values: ["IPV4_ONLY", "IPV4_IPV6"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#stack_type ComputeSubnetwork#stack_type}
     *
     * @stability stable
     */
    readonly stackType?: string;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#log_config ComputeSubnetwork#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeSubnetworkLogConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#timeouts ComputeSubnetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSubnetworkTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSubnetworkSecondaryIpRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#ip_cidr_range ComputeSubnetwork#ip_cidr_range}.
     *
     * @stability stable
     */
    readonly ipCidrRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#range_name ComputeSubnetwork#range_name}.
     *
     * @stability stable
     */
    readonly rangeName?: string;
}
export declare function computeSubnetworkSecondaryIpRangeToTerraform(struct?: ComputeSubnetworkSecondaryIpRange | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ComputeSubnetworkLogConfig {
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * Toggles the aggregation interval for collecting flow logs. Increasing the
     * interval time will reduce the amount of generated flow logs for long
     * lasting connections. Default is an interval of 5 seconds per connection. Default value: "INTERVAL_5_SEC" Possible values: ["INTERVAL_5_SEC", "INTERVAL_30_SEC", "INTERVAL_1_MIN", "INTERVAL_5_MIN", "INTERVAL_10_MIN", "INTERVAL_15_MIN"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#aggregation_interval ComputeSubnetwork#aggregation_interval}
     *
     * @stability stable
     */
    readonly aggregationInterval?: string;
    /**
     * Export filter used to define which VPC flow logs should be logged, as as CEL expression.
     *
     * See
     * https://cloud.google.com/vpc/docs/flow-logs#filtering for details on how to format this field.
     * The default value is 'true', which evaluates to include everything.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#filter_expr ComputeSubnetwork#filter_expr}
     *
     * @stability stable
     */
    readonly filterExpr?: string;
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * The value of the field must be in [0, 1]. Set the sampling rate of VPC
     * flow logs within the subnetwork where 1.0 means all collected logs are
     * reported and 0.0 means no logs are reported. Default is 0.5 which means
     * half of all collected logs are reported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#flow_sampling ComputeSubnetwork#flow_sampling}
     *
     * @stability stable
     */
    readonly flowSampling?: number;
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * Configures whether metadata fields should be added to the reported VPC
     * flow logs. Default value: "INCLUDE_ALL_METADATA" Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA", "CUSTOM_METADATA"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#metadata ComputeSubnetwork#metadata}
     *
     * @stability stable
     */
    readonly metadata?: string;
    /**
     * List of metadata fields that should be added to reported logs.
     *
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" is set to CUSTOM_METADATA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#metadata_fields ComputeSubnetwork#metadata_fields}
     *
     * @stability stable
     */
    readonly metadataFields?: string[];
}
export declare function computeSubnetworkLogConfigToTerraform(struct?: ComputeSubnetworkLogConfigOutputReference | ComputeSubnetworkLogConfig): any;
/**
 * @stability stable
 */
export declare class ComputeSubnetworkLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSubnetworkLogConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSubnetworkLogConfig | undefined);
    private _aggregationInterval?;
    /**
     * @stability stable
     */
    get aggregationInterval(): string;
    /**
     * @stability stable
     */
    set aggregationInterval(value: string);
    /**
     * @stability stable
     */
    resetAggregationInterval(): void;
    /**
     * @stability stable
     */
    get aggregationIntervalInput(): string | undefined;
    private _filterExpr?;
    /**
     * @stability stable
     */
    get filterExpr(): string;
    /**
     * @stability stable
     */
    set filterExpr(value: string);
    /**
     * @stability stable
     */
    resetFilterExpr(): void;
    /**
     * @stability stable
     */
    get filterExprInput(): string | undefined;
    private _flowSampling?;
    /**
     * @stability stable
     */
    get flowSampling(): number;
    /**
     * @stability stable
     */
    set flowSampling(value: number);
    /**
     * @stability stable
     */
    resetFlowSampling(): void;
    /**
     * @stability stable
     */
    get flowSamplingInput(): number | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
    private _metadataFields?;
    /**
     * @stability stable
     */
    get metadataFields(): string[];
    /**
     * @stability stable
     */
    set metadataFields(value: string[]);
    /**
     * @stability stable
     */
    resetMetadataFields(): void;
    /**
     * @stability stable
     */
    get metadataFieldsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeSubnetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#create ComputeSubnetwork#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#delete ComputeSubnetwork#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork#update ComputeSubnetwork#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeSubnetworkTimeoutsToTerraform(struct?: ComputeSubnetworkTimeoutsOutputReference | ComputeSubnetworkTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeSubnetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSubnetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSubnetworkTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork google_compute_subnetwork}.
 *
 * @stability stable
 */
export declare class ComputeSubnetwork extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork google_compute_subnetwork} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSubnetworkConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get externalIpv6Prefix(): string;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get gatewayAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipCidrRange?;
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    /**
     * @stability stable
     */
    set ipCidrRange(value: string);
    /**
     * @stability stable
     */
    get ipCidrRangeInput(): string | undefined;
    private _ipv6AccessType?;
    /**
     * @stability stable
     */
    get ipv6AccessType(): string;
    /**
     * @stability stable
     */
    set ipv6AccessType(value: string);
    /**
     * @stability stable
     */
    resetIpv6AccessType(): void;
    /**
     * @stability stable
     */
    get ipv6AccessTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get ipv6CidrRange(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _privateIpGoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpGoogleAccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateIpGoogleAccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateIpGoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpGoogleAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpv6GoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccess(): string;
    /**
     * @stability stable
     */
    set privateIpv6GoogleAccess(value: string);
    /**
     * @stability stable
     */
    resetPrivateIpv6GoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _purpose?;
    /**
     * @stability stable
     */
    get purpose(): string;
    /**
     * @stability stable
     */
    set purpose(value: string);
    /**
     * @stability stable
     */
    resetPurpose(): void;
    /**
     * @stability stable
     */
    get purposeInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    resetRole(): void;
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _secondaryIpRange?;
    /**
     * @stability stable
     */
    get secondaryIpRange(): ComputeSubnetworkSecondaryIpRange[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secondaryIpRange(value: ComputeSubnetworkSecondaryIpRange[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecondaryIpRange(): void;
    /**
     * @stability stable
     */
    get secondaryIpRangeInput(): cdktf.IResolvable | ComputeSubnetworkSecondaryIpRange[] | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _stackType?;
    /**
     * @stability stable
     */
    get stackType(): string;
    /**
     * @stability stable
     */
    set stackType(value: string);
    /**
     * @stability stable
     */
    resetStackType(): void;
    /**
     * @stability stable
     */
    get stackTypeInput(): string | undefined;
    private _logConfig;
    /**
     * @stability stable
     */
    get logConfig(): ComputeSubnetworkLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeSubnetworkLogConfig): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeSubnetworkLogConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSubnetworkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeSubnetworkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSubnetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
