import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The analysis note associated with this occurrence, in the form of projects/[PROJECT]/notes/[NOTE_ID].
     *
     * This field can be used as a
     * filter in list requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#note_name ContainerAnalysisOccurrence#note_name}
     *
     * @stability stable
     */
    readonly noteName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#project ContainerAnalysisOccurrence#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A description of actions that can be taken to remedy the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#remediation ContainerAnalysisOccurrence#remediation}
     *
     * @stability stable
     */
    readonly remediation?: string;
    /**
     * Required. Immutable. A URI that represents the resource for which the occurrence applies. For example, https://gcr.io/project/image@sha256:123abc for a Docker image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#resource_uri ContainerAnalysisOccurrence#resource_uri}
     *
     * @stability stable
     */
    readonly resourceUri: string;
    /**
     * attestation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#attestation ContainerAnalysisOccurrence#attestation}
     *
     * @stability stable
     */
    readonly attestation: ContainerAnalysisOccurrenceAttestation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#timeouts ContainerAnalysisOccurrence#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerAnalysisOccurrenceTimeouts;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceAttestationSignatures {
    /**
     * The identifier for the public key that verifies this signature.
     *
     * MUST be an RFC3986 conformant
     * URI. * When possible, the key id should be an
     * immutable reference, such as a cryptographic digest.
     * Examples of valid values:
     *
     * OpenPGP V4 public key fingerprint. See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr
     * for more details on this scheme.
     *  'openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA'
     * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization):
     *  "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#public_key_id ContainerAnalysisOccurrence#public_key_id}
     *
     * @stability stable
     */
    readonly publicKeyId: string;
    /**
     * The content of the signature, an opaque bytestring.
     *
     * The payload that this signature verifies MUST be
     * unambiguously provided with the Signature during
     * verification. A wrapper message might provide the
     * payload explicitly. Alternatively, a message might
     * have a canonical serialization that can always be
     * unambiguously computed to derive the payload.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#signature ContainerAnalysisOccurrence#signature}
     *
     * @stability stable
     */
    readonly signature?: string;
}
export declare function containerAnalysisOccurrenceAttestationSignaturesToTerraform(struct?: ContainerAnalysisOccurrenceAttestationSignatures | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceAttestation {
    /**
     * The serialized payload that is verified by one or more signatures. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#serialized_payload ContainerAnalysisOccurrence#serialized_payload}
     *
     * @stability stable
     */
    readonly serializedPayload: string;
    /**
     * signatures block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#signatures ContainerAnalysisOccurrence#signatures}
     *
     * @stability stable
     */
    readonly signatures: ContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable;
}
export declare function containerAnalysisOccurrenceAttestationToTerraform(struct?: ContainerAnalysisOccurrenceAttestationOutputReference | ContainerAnalysisOccurrenceAttestation): any;
/**
 * @stability stable
 */
export declare class ContainerAnalysisOccurrenceAttestationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerAnalysisOccurrenceAttestation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerAnalysisOccurrenceAttestation | undefined);
    private _serializedPayload?;
    /**
     * @stability stable
     */
    get serializedPayload(): string;
    /**
     * @stability stable
     */
    set serializedPayload(value: string);
    /**
     * @stability stable
     */
    get serializedPayloadInput(): string | undefined;
    private _signatures?;
    /**
     * @stability stable
     */
    get signatures(): ContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set signatures(value: ContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get signaturesInput(): cdktf.IResolvable | ContainerAnalysisOccurrenceAttestationSignatures[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerAnalysisOccurrenceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#create ContainerAnalysisOccurrence#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#delete ContainerAnalysisOccurrence#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence#update ContainerAnalysisOccurrence#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function containerAnalysisOccurrenceTimeoutsToTerraform(struct?: ContainerAnalysisOccurrenceTimeoutsOutputReference | ContainerAnalysisOccurrenceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ContainerAnalysisOccurrenceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerAnalysisOccurrenceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerAnalysisOccurrenceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence google_container_analysis_occurrence}.
 *
 * @stability stable
 */
export declare class ContainerAnalysisOccurrence extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_analysis_occurrence google_container_analysis_occurrence} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerAnalysisOccurrenceConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _noteName?;
    /**
     * @stability stable
     */
    get noteName(): string;
    /**
     * @stability stable
     */
    set noteName(value: string);
    /**
     * @stability stable
     */
    get noteNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _remediation?;
    /**
     * @stability stable
     */
    get remediation(): string;
    /**
     * @stability stable
     */
    set remediation(value: string);
    /**
     * @stability stable
     */
    resetRemediation(): void;
    /**
     * @stability stable
     */
    get remediationInput(): string | undefined;
    private _resourceUri?;
    /**
     * @stability stable
     */
    get resourceUri(): string;
    /**
     * @stability stable
     */
    set resourceUri(value: string);
    /**
     * @stability stable
     */
    get resourceUriInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _attestation;
    /**
     * @stability stable
     */
    get attestation(): ContainerAnalysisOccurrenceAttestationOutputReference;
    /**
     * @stability stable
     */
    putAttestation(value: ContainerAnalysisOccurrenceAttestation): void;
    /**
     * @stability stable
     */
    get attestationInput(): ContainerAnalysisOccurrenceAttestation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ContainerAnalysisOccurrenceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerAnalysisOccurrenceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerAnalysisOccurrenceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
