import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataCatalogEntryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Entry description, which can consist of several sentences or paragraphs that describe entry contents.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#description DataCatalogEntry#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Display information such as title and description.
     *
     * A short name to identify the entry,
     * for example, "Analytics Data - Jan 2011".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#display_name DataCatalogEntry#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The name of the entry group this entry is in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#entry_group DataCatalogEntry#entry_group}
     *
     * @stability stable
     */
    readonly entryGroup: string;
    /**
     * The id of the entry to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#entry_id DataCatalogEntry#entry_id}
     *
     * @stability stable
     */
    readonly entryId: string;
    /**
     * The resource this metadata entry refers to.
     *
     * For Google Cloud Platform resources, linkedResource is the full name of the resource.
     * For example, the linkedResource for a table resource from BigQuery is:
     * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
     * this field is optional and defaults to an empty string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#linked_resource DataCatalogEntry#linked_resource}
     *
     * @stability stable
     */
    readonly linkedResource?: string;
    /**
     * Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema attached to it. See https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema for what fields this schema can contain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#schema DataCatalogEntry#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * The type of the entry.
     *
     * Only used for Entries with types in the EntryType enum.
     * Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType. Possible values: ["FILESET"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#type DataCatalogEntry#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * This field indicates the entry's source system that Data Catalog does not integrate with.
     *
     * userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
     * and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#user_specified_system DataCatalogEntry#user_specified_system}
     *
     * @stability stable
     */
    readonly userSpecifiedSystem?: string;
    /**
     * Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
     *
     * When creating an entry, users should check the enum values first, if nothing matches the entry
     * to be created, then provide a custom value, for example "my_special_type".
     * userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
     * numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#user_specified_type DataCatalogEntry#user_specified_type}
     *
     * @stability stable
     */
    readonly userSpecifiedType?: string;
    /**
     * gcs_fileset_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#gcs_fileset_spec DataCatalogEntry#gcs_fileset_spec}
     *
     * @stability stable
     */
    readonly gcsFilesetSpec?: DataCatalogEntryGcsFilesetSpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#timeouts DataCatalogEntry#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataCatalogEntryTimeouts;
}
/**
 * @stability stable
 */
export declare class DataCatalogEntryBigqueryDateShardedSpec extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dataset(): string;
    /**
     * @stability stable
     */
    get shardCount(): number;
    /**
     * @stability stable
     */
    get tablePrefix(): string;
}
/**
 * @stability stable
 */
export declare class DataCatalogEntryBigqueryTableSpecTableSpec extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get groupedEntry(): string;
}
/**
 * @stability stable
 */
export declare class DataCatalogEntryBigqueryTableSpecViewSpec extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get viewQuery(): string;
}
/**
 * @stability stable
 */
export declare class DataCatalogEntryBigqueryTableSpec extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get tableSourceType(): string;
    /**
     * @stability stable
     */
    get tableSpec(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get viewSpec(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    get sizeBytes(): number;
}
/**
 * @stability stable
 */
export interface DataCatalogEntryGcsFilesetSpec {
    /**
     * Patterns to identify a set of files in Google Cloud Storage.
     *
     * See [Cloud Storage documentation](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames)
     * for more information. Note that bucket wildcards are currently not supported. Examples of valid filePatterns:
     *
     * gs://bucket_name/dir/*: matches all files within bucket_name/dir directory.
     * gs://bucket_name/dir/**: matches all files in bucket_name/dir spanning all subdirectories.
     * gs://bucket_name/file*: matches files prefixed by file in bucket_name
     * gs://bucket_name/??.txt: matches files with two characters followed by .txt in bucket_name
     * gs://bucket_name/[aeiou].txt: matches files that contain a single vowel character followed by .txt in bucket_name
     * gs://bucket_name/[a-m].txt: matches files that contain a, b, ... or m followed by .txt in bucket_name
     * gs://bucket_name/a/*\/b: matches all files in bucket_name that match a/*\/b pattern, such as a/c/b, a/d/b
     * gs://another_bucket/a.txt: matches gs://another_bucket/a.txt
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#file_patterns DataCatalogEntry#file_patterns}
     *
     * @stability stable
     */
    readonly filePatterns: string[];
}
export declare function dataCatalogEntryGcsFilesetSpecToTerraform(struct?: DataCatalogEntryGcsFilesetSpecOutputReference | DataCatalogEntryGcsFilesetSpec): any;
/**
 * @stability stable
 */
export declare class DataCatalogEntryGcsFilesetSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataCatalogEntryGcsFilesetSpec | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataCatalogEntryGcsFilesetSpec | undefined);
    private _filePatterns?;
    /**
     * @stability stable
     */
    get filePatterns(): string[];
    /**
     * @stability stable
     */
    set filePatterns(value: string[]);
    /**
     * @stability stable
     */
    get filePatternsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    sampleGcsFileSpecs(index: string): DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs;
}
/**
 * @stability stable
 */
export interface DataCatalogEntryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#create DataCatalogEntry#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#delete DataCatalogEntry#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#update DataCatalogEntry#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataCatalogEntryTimeoutsToTerraform(struct?: DataCatalogEntryTimeoutsOutputReference | DataCatalogEntryTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataCatalogEntryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataCatalogEntryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataCatalogEntryTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry google_data_catalog_entry}.
 *
 * @stability stable
 */
export declare class DataCatalogEntry extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry google_data_catalog_entry} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataCatalogEntryConfig);
    /**
     * @stability stable
     */
    bigqueryDateShardedSpec(index: string): DataCatalogEntryBigqueryDateShardedSpec;
    /**
     * @stability stable
     */
    bigqueryTableSpec(index: string): DataCatalogEntryBigqueryTableSpec;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _entryGroup?;
    /**
     * @stability stable
     */
    get entryGroup(): string;
    /**
     * @stability stable
     */
    set entryGroup(value: string);
    /**
     * @stability stable
     */
    get entryGroupInput(): string | undefined;
    private _entryId?;
    /**
     * @stability stable
     */
    get entryId(): string;
    /**
     * @stability stable
     */
    set entryId(value: string);
    /**
     * @stability stable
     */
    get entryIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get integratedSystem(): string;
    private _linkedResource?;
    /**
     * @stability stable
     */
    get linkedResource(): string;
    /**
     * @stability stable
     */
    set linkedResource(value: string);
    /**
     * @stability stable
     */
    resetLinkedResource(): void;
    /**
     * @stability stable
     */
    get linkedResourceInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userSpecifiedSystem?;
    /**
     * @stability stable
     */
    get userSpecifiedSystem(): string;
    /**
     * @stability stable
     */
    set userSpecifiedSystem(value: string);
    /**
     * @stability stable
     */
    resetUserSpecifiedSystem(): void;
    /**
     * @stability stable
     */
    get userSpecifiedSystemInput(): string | undefined;
    private _userSpecifiedType?;
    /**
     * @stability stable
     */
    get userSpecifiedType(): string;
    /**
     * @stability stable
     */
    set userSpecifiedType(value: string);
    /**
     * @stability stable
     */
    resetUserSpecifiedType(): void;
    /**
     * @stability stable
     */
    get userSpecifiedTypeInput(): string | undefined;
    private _gcsFilesetSpec;
    /**
     * @stability stable
     */
    get gcsFilesetSpec(): DataCatalogEntryGcsFilesetSpecOutputReference;
    /**
     * @stability stable
     */
    putGcsFilesetSpec(value: DataCatalogEntryGcsFilesetSpec): void;
    /**
     * @stability stable
     */
    resetGcsFilesetSpec(): void;
    /**
     * @stability stable
     */
    get gcsFilesetSpecInput(): DataCatalogEntryGcsFilesetSpec | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataCatalogEntryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataCatalogEntryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataCatalogEntryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
