import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeRouterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#name DataGoogleComputeRouter#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A reference to the network to which this router belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#network DataGoogleComputeRouter#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#project DataGoogleComputeRouter#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the router resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#region DataGoogleComputeRouter#region}
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeRouterBgpAdvertisedIpRanges extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get range(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeRouterBgp extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get advertiseMode(): string;
    /**
     * @stability stable
     */
    get advertisedGroups(): string[];
    /**
     * @stability stable
     */
    get advertisedIpRanges(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get asn(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_router google_compute_router}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeRouter extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_router google_compute_router} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRouterConfig);
    /**
     * @stability stable
     */
    bgp(index: string): DataGoogleComputeRouterBgp;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
