import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleGameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
     * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/game_services_game_server_deployment_rollout#deployment_id DataGoogleGameServicesGameServerDeploymentRollout#deployment_id}
     *
     * @stability stable
     */
    readonly deploymentId: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get realms(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get configVersion(): string;
    /**
     * @stability stable
     */
    get realmsSelector(): cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout}.
 *
 * @stability stable
 */
export declare class DataGoogleGameServicesGameServerDeploymentRollout extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleGameServicesGameServerDeploymentRolloutConfig);
    /**
     * @stability stable
     */
    get defaultGameServerConfig(): string;
    private _deploymentId?;
    /**
     * @stability stable
     */
    get deploymentId(): string;
    /**
     * @stability stable
     */
    set deploymentId(value: string);
    /**
     * @stability stable
     */
    get deploymentIdInput(): string | undefined;
    /**
     * @stability stable
     */
    gameServerConfigOverrides(index: string): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
