import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleMonitoringIstioCanonicalServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the canonical service underlying this service..                       Corresponds to the destination_service_name metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#canonical_service DataGoogleMonitoringIstioCanonicalService#canonical_service}
     *
     * @stability stable
     */
    readonly canonicalService: string;
    /**
     * The namespace of the canonical service underlying this service.
     *
     * Corresponds to the destination_service_namespace metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#canonical_service_namespace DataGoogleMonitoringIstioCanonicalService#canonical_service_namespace}
     *
     * @stability stable
     */
    readonly canonicalServiceNamespace: string;
    /**
     * Identifier for the Istio mesh in which this canonical service is defined.
     *
     * Corresponds to the meshUid metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#mesh_uid DataGoogleMonitoringIstioCanonicalService#mesh_uid}
     *
     * @stability stable
     */
    readonly meshUid: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service#project DataGoogleMonitoringIstioCanonicalService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleMonitoringIstioCanonicalServiceTelemetry extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resourceName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service google_monitoring_istio_canonical_service}.
 *
 * @stability stable
 */
export declare class DataGoogleMonitoringIstioCanonicalService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_istio_canonical_service google_monitoring_istio_canonical_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringIstioCanonicalServiceConfig);
    private _canonicalService?;
    /**
     * @stability stable
     */
    get canonicalService(): string;
    /**
     * @stability stable
     */
    set canonicalService(value: string);
    /**
     * @stability stable
     */
    get canonicalServiceInput(): string | undefined;
    private _canonicalServiceNamespace?;
    /**
     * @stability stable
     */
    get canonicalServiceNamespace(): string;
    /**
     * @stability stable
     */
    set canonicalServiceNamespace(value: string);
    /**
     * @stability stable
     */
    get canonicalServiceNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _meshUid?;
    /**
     * @stability stable
     */
    get meshUid(): string;
    /**
     * @stability stable
     */
    set meshUid(value: string);
    /**
     * @stability stable
     */
    get meshUidInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceId(): string;
    /**
     * @stability stable
     */
    telemetry(index: string): DataGoogleMonitoringIstioCanonicalServiceTelemetry;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
