import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the inspect template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#description DataLossPreventionInspectTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * User set display name of the inspect template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#display_name DataLossPreventionInspectTemplate#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The parent of the inspect template in any of the following formats:.
     *
     * 'projects/{{project}}'
     * 'projects/{{project}}/locations/{{location}}'
     * 'organizations/{{organization_id}}'
     * 'organizations/{{organization_id}}/locations/{{location}}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#parent DataLossPreventionInspectTemplate#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * inspect_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#inspect_config DataLossPreventionInspectTemplate#inspect_config}
     *
     * @stability stable
     */
    readonly inspectConfig?: DataLossPreventionInspectTemplateInspectConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#timeouts DataLossPreventionInspectTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLossPreventionInspectTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#path DataLossPreventionInspectTemplate#path}
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePathToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePathOutputReference | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#words DataLossPreventionInspectTemplate#words}
     *
     * @stability stable
     */
    readonly words: string[];
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordListToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordListOutputReference | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList | undefined);
    private _words?;
    /**
     * @stability stable
     */
    get words(): string[];
    /**
     * @stability stable
     */
    set words(value: string[]);
    /**
     * @stability stable
     */
    get wordsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#cloud_storage_path DataLossPreventionInspectTemplate#cloud_storage_path}
     *
     * @stability stable
     */
    readonly cloudStoragePath?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath;
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#word_list DataLossPreventionInspectTemplate#word_list}
     *
     * @stability stable
     */
    readonly wordList?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList;
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryOutputReference | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary | undefined);
    private _cloudStoragePath;
    /**
     * @stability stable
     */
    get cloudStoragePath(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePathOutputReference;
    /**
     * @stability stable
     */
    putCloudStoragePath(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath): void;
    /**
     * @stability stable
     */
    resetCloudStoragePath(): void;
    /**
     * @stability stable
     */
    get cloudStoragePathInput(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath | undefined;
    private _wordList;
    /**
     * @stability stable
     */
    get wordList(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordListOutputReference;
    /**
     * @stability stable
     */
    putWordList(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList): void;
    /**
     * @stability stable
     */
    resetWordList(): void;
    /**
     * @stability stable
     */
    get wordListInput(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names
     * listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoTypeToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoTypeOutputReference | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#pattern DataLossPreventionInspectTemplate#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegexToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegexOutputReference | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex | undefined);
    private _groupIndexes?;
    /**
     * @stability stable
     */
    get groupIndexes(): number[];
    /**
     * @stability stable
     */
    set groupIndexes(value: number[]);
    /**
     * @stability stable
     */
    resetGroupIndexes(): void;
    /**
     * @stability stable
     */
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType {
    /**
     * Resource name of the requested StoredInfoType, for example 'organizations/433245324/storedInfoTypes/432452342' or 'projects/project-id/storedInfoTypes/432452342'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredTypeToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredTypeOutputReference | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes {
    /**
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding to be returned.
     *
     * It still can be used for rules matching. Possible values: ["EXCLUSION_TYPE_EXCLUDE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#exclusion_type DataLossPreventionInspectTemplate#exclusion_type}
     *
     * @stability stable
     */
    readonly exclusionType?: string;
    /**
     * Likelihood to return for this CustomInfoType.
     *
     * This base value can be altered by a detection rule if the finding meets the criteria
     * specified by the rule. Default value: "VERY_LIKELY" Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#likelihood DataLossPreventionInspectTemplate#likelihood}
     *
     * @stability stable
     */
    readonly likelihood?: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#dictionary DataLossPreventionInspectTemplate#dictionary}
     *
     * @stability stable
     */
    readonly dictionary?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary;
    /**
     * info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#info_type DataLossPreventionInspectTemplate#info_type}
     *
     * @stability stable
     */
    readonly infoType: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType;
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#regex DataLossPreventionInspectTemplate#regex}
     *
     * @stability stable
     */
    readonly regex?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex;
    /**
     * stored_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#stored_type DataLossPreventionInspectTemplate#stored_type}
     *
     * @stability stable
     */
    readonly storedType?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType;
}
export declare function dataLossPreventionInspectTemplateInspectConfigCustomInfoTypesToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigInfoTypesToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigInfoTypes | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoTypeToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoTypeOutputReference | DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType {
    /**
     * Max findings limit for the given infoType.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#max_findings DataLossPreventionInspectTemplate#max_findings}
     *
     * @stability stable
     */
    readonly maxFindings: number;
    /**
     * info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#info_type DataLossPreventionInspectTemplate#info_type}
     *
     * @stability stable
     */
    readonly infoType: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType;
}
export declare function dataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigLimits {
    /**
     * Max number of findings that will be returned for each item scanned. The maximum returned is 2000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#max_findings_per_item DataLossPreventionInspectTemplate#max_findings_per_item}
     *
     * @stability stable
     */
    readonly maxFindingsPerItem: number;
    /**
     * Max number of findings that will be returned per request/job. The maximum returned is 2000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#max_findings_per_request DataLossPreventionInspectTemplate#max_findings_per_request}
     *
     * @stability stable
     */
    readonly maxFindingsPerRequest: number;
    /**
     * max_findings_per_info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#max_findings_per_info_type DataLossPreventionInspectTemplate#max_findings_per_info_type}
     *
     * @stability stable
     */
    readonly maxFindingsPerInfoType?: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | cdktf.IResolvable;
}
export declare function dataLossPreventionInspectTemplateInspectConfigLimitsToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigLimitsOutputReference | DataLossPreventionInspectTemplateInspectConfigLimits): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigLimits | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigLimits | undefined);
    private _maxFindingsPerItem?;
    /**
     * @stability stable
     */
    get maxFindingsPerItem(): number;
    /**
     * @stability stable
     */
    set maxFindingsPerItem(value: number);
    /**
     * @stability stable
     */
    get maxFindingsPerItemInput(): number | undefined;
    private _maxFindingsPerRequest?;
    /**
     * @stability stable
     */
    get maxFindingsPerRequest(): number;
    /**
     * @stability stable
     */
    set maxFindingsPerRequest(value: number);
    /**
     * @stability stable
     */
    get maxFindingsPerRequestInput(): number | undefined;
    private _maxFindingsPerInfoType?;
    /**
     * @stability stable
     */
    get maxFindingsPerInfoType(): DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set maxFindingsPerInfoType(value: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMaxFindingsPerInfoType(): void;
    /**
     * @stability stable
     */
    get maxFindingsPerInfoTypeInput(): cdktf.IResolvable | DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypesToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#path DataLossPreventionInspectTemplate#path}
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePathToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePathOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#words DataLossPreventionInspectTemplate#words}
     *
     * @stability stable
     */
    readonly words: string[];
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordListToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordListOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList | undefined);
    private _words?;
    /**
     * @stability stable
     */
    get words(): string[];
    /**
     * @stability stable
     */
    set words(value: string[]);
    /**
     * @stability stable
     */
    get wordsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#cloud_storage_path DataLossPreventionInspectTemplate#cloud_storage_path}
     *
     * @stability stable
     */
    readonly cloudStoragePath?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath;
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#word_list DataLossPreventionInspectTemplate#word_list}
     *
     * @stability stable
     */
    readonly wordList?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary | undefined);
    private _cloudStoragePath;
    /**
     * @stability stable
     */
    get cloudStoragePath(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePathOutputReference;
    /**
     * @stability stable
     */
    putCloudStoragePath(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath): void;
    /**
     * @stability stable
     */
    resetCloudStoragePath(): void;
    /**
     * @stability stable
     */
    get cloudStoragePathInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath | undefined;
    private _wordList;
    /**
     * @stability stable
     */
    get wordList(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordListOutputReference;
    /**
     * @stability stable
     */
    putWordList(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList): void;
    /**
     * @stability stable
     */
    resetWordList(): void;
    /**
     * @stability stable
     */
    get wordListInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#name DataLossPreventionInspectTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypesToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes {
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#info_types DataLossPreventionInspectTemplate#info_types}
     *
     * @stability stable
     */
    readonly infoTypes: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[] | cdktf.IResolvable;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes | undefined);
    private _infoTypes?;
    /**
     * @stability stable
     */
    get infoTypes(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infoTypes(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get infoTypesInput(): cdktf.IResolvable | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#pattern DataLossPreventionInspectTemplate#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegexToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegexOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex | undefined);
    private _groupIndexes?;
    /**
     * @stability stable
     */
    get groupIndexes(): number[];
    /**
     * @stability stable
     */
    set groupIndexes(value: number[]);
    /**
     * @stability stable
     */
    resetGroupIndexes(): void;
    /**
     * @stability stable
     */
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule {
    /**
     * How the rule is applied. See the documentation for more information: https://cloud.google.com/dlp/docs/reference/rest/v2/InspectConfig#MatchingType Possible values: ["MATCHING_TYPE_FULL_MATCH", "MATCHING_TYPE_PARTIAL_MATCH", "MATCHING_TYPE_INVERSE_MATCH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#matching_type DataLossPreventionInspectTemplate#matching_type}
     *
     * @stability stable
     */
    readonly matchingType: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#dictionary DataLossPreventionInspectTemplate#dictionary}
     *
     * @stability stable
     */
    readonly dictionary?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary;
    /**
     * exclude_info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#exclude_info_types DataLossPreventionInspectTemplate#exclude_info_types}
     *
     * @stability stable
     */
    readonly excludeInfoTypes?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes;
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#regex DataLossPreventionInspectTemplate#regex}
     *
     * @stability stable
     */
    readonly regex?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule | undefined);
    private _matchingType?;
    /**
     * @stability stable
     */
    get matchingType(): string;
    /**
     * @stability stable
     */
    set matchingType(value: string);
    /**
     * @stability stable
     */
    get matchingTypeInput(): string | undefined;
    private _dictionary;
    /**
     * @stability stable
     */
    get dictionary(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryOutputReference;
    /**
     * @stability stable
     */
    putDictionary(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary): void;
    /**
     * @stability stable
     */
    resetDictionary(): void;
    /**
     * @stability stable
     */
    get dictionaryInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary | undefined;
    private _excludeInfoTypes;
    /**
     * @stability stable
     */
    get excludeInfoTypes(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesOutputReference;
    /**
     * @stability stable
     */
    putExcludeInfoTypes(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes): void;
    /**
     * @stability stable
     */
    resetExcludeInfoTypes(): void;
    /**
     * @stability stable
     */
    get excludeInfoTypesInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes | undefined;
    private _regex;
    /**
     * @stability stable
     */
    get regex(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegexOutputReference;
    /**
     * @stability stable
     */
    putRegex(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex): void;
    /**
     * @stability stable
     */
    resetRegex(): void;
    /**
     * @stability stable
     */
    get regexInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified,
     * the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#pattern DataLossPreventionInspectTemplate#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegexToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegexOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex | undefined);
    private _groupIndexes?;
    /**
     * @stability stable
     */
    get groupIndexes(): number[];
    /**
     * @stability stable
     */
    set groupIndexes(value: number[]);
    /**
     * @stability stable
     */
    resetGroupIndexes(): void;
    /**
     * @stability stable
     */
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment {
    /**
     * Set the likelihood of a finding to a fixed value.
     *
     * Either this or relative_likelihood can be set. Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#fixed_likelihood DataLossPreventionInspectTemplate#fixed_likelihood}
     *
     * @stability stable
     */
    readonly fixedLikelihood?: string;
    /**
     * Increase or decrease the likelihood by the specified number of levels.
     *
     * For example,
     * if a finding would be POSSIBLE without the detection rule and relativeLikelihood is 1,
     * then it is upgraded to LIKELY, while a value of -1 would downgrade it to UNLIKELY.
     * Likelihood may never drop below VERY_UNLIKELY or exceed VERY_LIKELY, so applying an
     * adjustment of 1 followed by an adjustment of -1 when base likelihood is VERY_LIKELY
     * will result in a final likelihood of LIKELY. Either this or fixed_likelihood can be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#relative_likelihood DataLossPreventionInspectTemplate#relative_likelihood}
     *
     * @stability stable
     */
    readonly relativeLikelihood?: number;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustmentToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustmentOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment | undefined);
    private _fixedLikelihood?;
    /**
     * @stability stable
     */
    get fixedLikelihood(): string;
    /**
     * @stability stable
     */
    set fixedLikelihood(value: string);
    /**
     * @stability stable
     */
    resetFixedLikelihood(): void;
    /**
     * @stability stable
     */
    get fixedLikelihoodInput(): string | undefined;
    private _relativeLikelihood?;
    /**
     * @stability stable
     */
    get relativeLikelihood(): number;
    /**
     * @stability stable
     */
    set relativeLikelihood(value: number);
    /**
     * @stability stable
     */
    resetRelativeLikelihood(): void;
    /**
     * @stability stable
     */
    get relativeLikelihoodInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity {
    /**
     * Number of characters after the finding to consider. Either this or window_before must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#window_after DataLossPreventionInspectTemplate#window_after}
     *
     * @stability stable
     */
    readonly windowAfter?: number;
    /**
     * Number of characters before the finding to consider. Either this or window_after must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#window_before DataLossPreventionInspectTemplate#window_before}
     *
     * @stability stable
     */
    readonly windowBefore?: number;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximityToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximityOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity | undefined);
    private _windowAfter?;
    /**
     * @stability stable
     */
    get windowAfter(): number;
    /**
     * @stability stable
     */
    set windowAfter(value: number);
    /**
     * @stability stable
     */
    resetWindowAfter(): void;
    /**
     * @stability stable
     */
    get windowAfterInput(): number | undefined;
    private _windowBefore?;
    /**
     * @stability stable
     */
    get windowBefore(): number;
    /**
     * @stability stable
     */
    set windowBefore(value: number);
    /**
     * @stability stable
     */
    resetWindowBefore(): void;
    /**
     * @stability stable
     */
    get windowBeforeInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule {
    /**
     * hotword_regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#hotword_regex DataLossPreventionInspectTemplate#hotword_regex}
     *
     * @stability stable
     */
    readonly hotwordRegex: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex;
    /**
     * likelihood_adjustment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#likelihood_adjustment DataLossPreventionInspectTemplate#likelihood_adjustment}
     *
     * @stability stable
     */
    readonly likelihoodAdjustment: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment;
    /**
     * proximity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#proximity DataLossPreventionInspectTemplate#proximity}
     *
     * @stability stable
     */
    readonly proximity: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleOutputReference | DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule | undefined);
    private _hotwordRegex;
    /**
     * @stability stable
     */
    get hotwordRegex(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegexOutputReference;
    /**
     * @stability stable
     */
    putHotwordRegex(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex): void;
    /**
     * @stability stable
     */
    get hotwordRegexInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex | undefined;
    private _likelihoodAdjustment;
    /**
     * @stability stable
     */
    get likelihoodAdjustment(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustmentOutputReference;
    /**
     * @stability stable
     */
    putLikelihoodAdjustment(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment): void;
    /**
     * @stability stable
     */
    get likelihoodAdjustmentInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment | undefined;
    private _proximity;
    /**
     * @stability stable
     */
    get proximity(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximityOutputReference;
    /**
     * @stability stable
     */
    putProximity(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity): void;
    /**
     * @stability stable
     */
    get proximityInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRules {
    /**
     * exclusion_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#exclusion_rule DataLossPreventionInspectTemplate#exclusion_rule}
     *
     * @stability stable
     */
    readonly exclusionRule?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule;
    /**
     * hotword_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#hotword_rule DataLossPreventionInspectTemplate#hotword_rule}
     *
     * @stability stable
     */
    readonly hotwordRule?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetRulesToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSetRules | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfigRuleSet {
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#info_types DataLossPreventionInspectTemplate#info_types}
     *
     * @stability stable
     */
    readonly infoTypes: DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes[] | cdktf.IResolvable;
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#rules DataLossPreventionInspectTemplate#rules}
     *
     * @stability stable
     */
    readonly rules: DataLossPreventionInspectTemplateInspectConfigRuleSetRules[] | cdktf.IResolvable;
}
export declare function dataLossPreventionInspectTemplateInspectConfigRuleSetToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigRuleSet | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateInspectConfig {
    /**
     * List of options defining data content to scan.
     *
     * If empty, text, images, and other content will be included. Possible values: ["CONTENT_TEXT", "CONTENT_IMAGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#content_options DataLossPreventionInspectTemplate#content_options}
     *
     * @stability stable
     */
    readonly contentOptions?: string[];
    /**
     * When true, excludes type information of the findings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#exclude_info_types DataLossPreventionInspectTemplate#exclude_info_types}
     *
     * @stability stable
     */
    readonly excludeInfoTypes?: boolean | cdktf.IResolvable;
    /**
     * When true, a contextual quote from the data that triggered a finding is included in the response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#include_quote DataLossPreventionInspectTemplate#include_quote}
     *
     * @stability stable
     */
    readonly includeQuote?: boolean | cdktf.IResolvable;
    /**
     * Only returns findings equal or above this threshold.
     *
     * See https://cloud.google.com/dlp/docs/likelihood for more info Default value: "POSSIBLE" Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#min_likelihood DataLossPreventionInspectTemplate#min_likelihood}
     *
     * @stability stable
     */
    readonly minLikelihood?: string;
    /**
     * custom_info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#custom_info_types DataLossPreventionInspectTemplate#custom_info_types}
     *
     * @stability stable
     */
    readonly customInfoTypes?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | cdktf.IResolvable;
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#info_types DataLossPreventionInspectTemplate#info_types}
     *
     * @stability stable
     */
    readonly infoTypes?: DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | cdktf.IResolvable;
    /**
     * limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#limits DataLossPreventionInspectTemplate#limits}
     *
     * @stability stable
     */
    readonly limits?: DataLossPreventionInspectTemplateInspectConfigLimits;
    /**
     * rule_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#rule_set DataLossPreventionInspectTemplate#rule_set}
     *
     * @stability stable
     */
    readonly ruleSet?: DataLossPreventionInspectTemplateInspectConfigRuleSet[] | cdktf.IResolvable;
}
export declare function dataLossPreventionInspectTemplateInspectConfigToTerraform(struct?: DataLossPreventionInspectTemplateInspectConfigOutputReference | DataLossPreventionInspectTemplateInspectConfig): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateInspectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateInspectConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateInspectConfig | undefined);
    private _contentOptions?;
    /**
     * @stability stable
     */
    get contentOptions(): string[];
    /**
     * @stability stable
     */
    set contentOptions(value: string[]);
    /**
     * @stability stable
     */
    resetContentOptions(): void;
    /**
     * @stability stable
     */
    get contentOptionsInput(): string[] | undefined;
    private _excludeInfoTypes?;
    /**
     * @stability stable
     */
    get excludeInfoTypes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set excludeInfoTypes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExcludeInfoTypes(): void;
    /**
     * @stability stable
     */
    get excludeInfoTypesInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQuote?;
    /**
     * @stability stable
     */
    get includeQuote(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeQuote(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeQuote(): void;
    /**
     * @stability stable
     */
    get includeQuoteInput(): boolean | cdktf.IResolvable | undefined;
    private _minLikelihood?;
    /**
     * @stability stable
     */
    get minLikelihood(): string;
    /**
     * @stability stable
     */
    set minLikelihood(value: string);
    /**
     * @stability stable
     */
    resetMinLikelihood(): void;
    /**
     * @stability stable
     */
    get minLikelihoodInput(): string | undefined;
    private _customInfoTypes?;
    /**
     * @stability stable
     */
    get customInfoTypes(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customInfoTypes(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomInfoTypes(): void;
    /**
     * @stability stable
     */
    get customInfoTypesInput(): cdktf.IResolvable | DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | undefined;
    private _infoTypes?;
    /**
     * @stability stable
     */
    get infoTypes(): DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infoTypes(value: DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInfoTypes(): void;
    /**
     * @stability stable
     */
    get infoTypesInput(): cdktf.IResolvable | DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | undefined;
    private _limits;
    /**
     * @stability stable
     */
    get limits(): DataLossPreventionInspectTemplateInspectConfigLimitsOutputReference;
    /**
     * @stability stable
     */
    putLimits(value: DataLossPreventionInspectTemplateInspectConfigLimits): void;
    /**
     * @stability stable
     */
    resetLimits(): void;
    /**
     * @stability stable
     */
    get limitsInput(): DataLossPreventionInspectTemplateInspectConfigLimits | undefined;
    private _ruleSet?;
    /**
     * @stability stable
     */
    get ruleSet(): DataLossPreventionInspectTemplateInspectConfigRuleSet[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ruleSet(value: DataLossPreventionInspectTemplateInspectConfigRuleSet[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRuleSet(): void;
    /**
     * @stability stable
     */
    get ruleSetInput(): cdktf.IResolvable | DataLossPreventionInspectTemplateInspectConfigRuleSet[] | undefined;
}
/**
 * @stability stable
 */
export interface DataLossPreventionInspectTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#create DataLossPreventionInspectTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#delete DataLossPreventionInspectTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template#update DataLossPreventionInspectTemplate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataLossPreventionInspectTemplateTimeoutsToTerraform(struct?: DataLossPreventionInspectTemplateTimeoutsOutputReference | DataLossPreventionInspectTemplateTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLossPreventionInspectTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLossPreventionInspectTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template google_data_loss_prevention_inspect_template}.
 *
 * @stability stable
 */
export declare class DataLossPreventionInspectTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template google_data_loss_prevention_inspect_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionInspectTemplateConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _inspectConfig;
    /**
     * @stability stable
     */
    get inspectConfig(): DataLossPreventionInspectTemplateInspectConfigOutputReference;
    /**
     * @stability stable
     */
    putInspectConfig(value: DataLossPreventionInspectTemplateInspectConfig): void;
    /**
     * @stability stable
     */
    resetInspectConfig(): void;
    /**
     * @stability stable
     */
    get inspectConfigInput(): DataLossPreventionInspectTemplateInspectConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataLossPreventionInspectTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataLossPreventionInspectTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLossPreventionInspectTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
