import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optional.
     *
     * Timeout duration for the DAG of jobs, expressed in seconds (see [JSON representation of duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). The timeout duration must be from 10 minutes ("600s") to 24 hours ("86400s"). The timer begins when the first job is submitted. If the workflow is running at the end of the timeout period, any remaining jobs are cancelled, the workflow is ended, and if the workflow was running on a [managed cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster), the cluster is deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#dag_timeout DataprocWorkflowTemplate#dag_timeout}
     *
     * @stability stable
     */
    readonly dagTimeout?: string;
    /**
     * Optional.
     *
     * The labels to associate with this template. These labels will be propagated to all jobs and clusters created by the workflow instance. Label **keys** must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but, if present, must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#labels DataprocWorkflowTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#location DataprocWorkflowTemplate#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Output only.
     *
     * The resource name of the workflow template, as described in https://cloud.google.com/apis/design/resource_names. * For `projects.regions.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}` * For `projects.locations.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#name DataprocWorkflowTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The project for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#project DataprocWorkflowTemplate#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Output only. The current version of this workflow template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#version DataprocWorkflowTemplate#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * jobs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jobs DataprocWorkflowTemplate#jobs}
     *
     * @stability stable
     */
    readonly jobs: DataprocWorkflowTemplateJobs[] | cdktf.IResolvable;
    /**
     * parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#parameters DataprocWorkflowTemplate#parameters}
     *
     * @stability stable
     */
    readonly parameters?: DataprocWorkflowTemplateParameters[] | cdktf.IResolvable;
    /**
     * placement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#placement DataprocWorkflowTemplate#placement}
     *
     * @stability stable
     */
    readonly placement: DataprocWorkflowTemplatePlacement;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#timeouts DataprocWorkflowTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataprocWorkflowTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHadoopJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsHadoopJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsHadoopJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHadoopJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * The name of the driver's main class.
     *
     * The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_class DataprocWorkflowTemplate#main_class}
     *
     * @stability stable
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}
     *
     * @stability stable
     */
    readonly mainJarFileUri?: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsHadoopJobToTerraform(struct?: DataprocWorkflowTemplateJobsHadoopJobOutputReference | DataprocWorkflowTemplateJobsHadoopJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsHadoopJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsHadoopJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsHadoopJob | undefined);
    private _archiveUris?;
    /**
     * @stability stable
     */
    get archiveUris(): string[];
    /**
     * @stability stable
     */
    set archiveUris(value: string[]);
    /**
     * @stability stable
     */
    resetArchiveUris(): void;
    /**
     * @stability stable
     */
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    /**
     * @stability stable
     */
    get args(): string[];
    /**
     * @stability stable
     */
    set args(value: string[]);
    /**
     * @stability stable
     */
    resetArgs(): void;
    /**
     * @stability stable
     */
    get argsInput(): string[] | undefined;
    private _fileUris?;
    /**
     * @stability stable
     */
    get fileUris(): string[];
    /**
     * @stability stable
     */
    set fileUris(value: string[]);
    /**
     * @stability stable
     */
    resetFileUris(): void;
    /**
     * @stability stable
     */
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    /**
     * @stability stable
     */
    get jarFileUris(): string[];
    /**
     * @stability stable
     */
    set jarFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetJarFileUris(): void;
    /**
     * @stability stable
     */
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    /**
     * @stability stable
     */
    get mainClass(): string;
    /**
     * @stability stable
     */
    set mainClass(value: string);
    /**
     * @stability stable
     */
    resetMainClass(): void;
    /**
     * @stability stable
     */
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    /**
     * @stability stable
     */
    get mainJarFileUri(): string;
    /**
     * @stability stable
     */
    set mainJarFileUri(value: string);
    /**
     * @stability stable
     */
    resetMainJarFileUri(): void;
    /**
     * @stability stable
     */
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHiveJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
     *
     * @stability stable
     */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsHiveJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference | DataprocWorkflowTemplateJobsHiveJobQueryList): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsHiveJobQueryList | undefined);
    private _queries?;
    /**
     * @stability stable
     */
    get queries(): string[];
    /**
     * @stability stable
     */
    set queries(value: string[]);
    /**
     * @stability stable
     */
    get queriesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsHiveJob {
    /**
     * Optional.
     *
     * Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * Optional.
     *
     * HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Optional.
     *
     * A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * The HCFS URI of the script that contains Hive queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * Optional. Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#script_variables DataprocWorkflowTemplate#script_variables}
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsHiveJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsHiveJobToTerraform(struct?: DataprocWorkflowTemplateJobsHiveJobOutputReference | DataprocWorkflowTemplateJobsHiveJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsHiveJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsHiveJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsHiveJob | undefined);
    private _continueOnFailure?;
    /**
     * @stability stable
     */
    get continueOnFailure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContinueOnFailure(): void;
    /**
     * @stability stable
     */
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    /**
     * @stability stable
     */
    get jarFileUris(): string[];
    /**
     * @stability stable
     */
    set jarFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetJarFileUris(): void;
    /**
     * @stability stable
     */
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    /**
     * @stability stable
     */
    get queryFileUri(): string;
    /**
     * @stability stable
     */
    set queryFileUri(value: string);
    /**
     * @stability stable
     */
    resetQueryFileUri(): void;
    /**
     * @stability stable
     */
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    /**
     * @stability stable
     */
    get scriptVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set scriptVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetScriptVariables(): void;
    /**
     * @stability stable
     */
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryList;
    /**
     * @stability stable
     */
    get queryList(): DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference;
    /**
     * @stability stable
     */
    putQueryList(value: DataprocWorkflowTemplateJobsHiveJobQueryList): void;
    /**
     * @stability stable
     */
    resetQueryList(): void;
    /**
     * @stability stable
     */
    get queryListInput(): DataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPigJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsPigJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsPigJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPigJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
     *
     * @stability stable
     */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsPigJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsPigJobQueryListOutputReference | DataprocWorkflowTemplateJobsPigJobQueryList): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPigJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPigJobQueryList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPigJobQueryList | undefined);
    private _queries?;
    /**
     * @stability stable
     */
    get queries(): string[];
    /**
     * @stability stable
     */
    set queries(value: string[]);
    /**
     * @stability stable
     */
    get queriesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPigJob {
    /**
     * Optional.
     *
     * Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * Optional.
     *
     * HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * The HCFS URI of the script that contains the Pig queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * Optional. Mapping of query variable names to values (equivalent to the Pig command: `name=[value]`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#script_variables DataprocWorkflowTemplate#script_variables}
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPigJobLoggingConfig;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsPigJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsPigJobToTerraform(struct?: DataprocWorkflowTemplateJobsPigJobOutputReference | DataprocWorkflowTemplateJobsPigJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPigJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPigJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPigJob | undefined);
    private _continueOnFailure?;
    /**
     * @stability stable
     */
    get continueOnFailure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContinueOnFailure(): void;
    /**
     * @stability stable
     */
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    /**
     * @stability stable
     */
    get jarFileUris(): string[];
    /**
     * @stability stable
     */
    set jarFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetJarFileUris(): void;
    /**
     * @stability stable
     */
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    /**
     * @stability stable
     */
    get queryFileUri(): string;
    /**
     * @stability stable
     */
    set queryFileUri(value: string);
    /**
     * @stability stable
     */
    resetQueryFileUri(): void;
    /**
     * @stability stable
     */
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    /**
     * @stability stable
     */
    get scriptVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set scriptVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetScriptVariables(): void;
    /**
     * @stability stable
     */
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPigJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    private _queryList;
    /**
     * @stability stable
     */
    get queryList(): DataprocWorkflowTemplateJobsPigJobQueryListOutputReference;
    /**
     * @stability stable
     */
    putQueryList(value: DataprocWorkflowTemplateJobsPigJobQueryList): void;
    /**
     * @stability stable
     */
    resetQueryList(): void;
    /**
     * @stability stable
     */
    get queryListInput(): DataprocWorkflowTemplateJobsPigJobQueryList | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPrestoJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsPrestoJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsPrestoJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPrestoJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
     *
     * @stability stable
     */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsPrestoJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference | DataprocWorkflowTemplateJobsPrestoJobQueryList): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined);
    private _queries?;
    /**
     * @stability stable
     */
    get queries(): string[];
    /**
     * @stability stable
     */
    set queries(value: string[]);
    /**
     * @stability stable
     */
    get queriesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPrestoJob {
    /**
     * Optional. Presto client tags to attach to this query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#client_tags DataprocWorkflowTemplate#client_tags}
     *
     * @stability stable
     */
    readonly clientTags?: string[];
    /**
     * Optional.
     *
     * Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
     *
     * @stability stable
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#output_format DataprocWorkflowTemplate#output_format}
     *
     * @stability stable
     */
    readonly outputFormat?: string;
    /**
     * Optional.
     *
     * A mapping of property names to values. Used to set Presto [session properties](https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * The HCFS URI of the script that contains SQL queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsPrestoJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsPrestoJobToTerraform(struct?: DataprocWorkflowTemplateJobsPrestoJobOutputReference | DataprocWorkflowTemplateJobsPrestoJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPrestoJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPrestoJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPrestoJob | undefined);
    private _clientTags?;
    /**
     * @stability stable
     */
    get clientTags(): string[];
    /**
     * @stability stable
     */
    set clientTags(value: string[]);
    /**
     * @stability stable
     */
    resetClientTags(): void;
    /**
     * @stability stable
     */
    get clientTagsInput(): string[] | undefined;
    private _continueOnFailure?;
    /**
     * @stability stable
     */
    get continueOnFailure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContinueOnFailure(): void;
    /**
     * @stability stable
     */
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _outputFormat?;
    /**
     * @stability stable
     */
    get outputFormat(): string;
    /**
     * @stability stable
     */
    set outputFormat(value: string);
    /**
     * @stability stable
     */
    resetOutputFormat(): void;
    /**
     * @stability stable
     */
    get outputFormatInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    /**
     * @stability stable
     */
    get queryFileUri(): string;
    /**
     * @stability stable
     */
    set queryFileUri(value: string);
    /**
     * @stability stable
     */
    resetQueryFileUri(): void;
    /**
     * @stability stable
     */
    get queryFileUriInput(): string | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    private _queryList;
    /**
     * @stability stable
     */
    get queryList(): DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference;
    /**
     * @stability stable
     */
    putQueryList(value: DataprocWorkflowTemplateJobsPrestoJobQueryList): void;
    /**
     * @stability stable
     */
    resetQueryList(): void;
    /**
     * @stability stable
     */
    get queryListInput(): DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPysparkJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsPysparkJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsPysparkJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsPysparkJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_python_file_uri DataprocWorkflowTemplate#main_python_file_uri}
     *
     * @stability stable
     */
    readonly mainPythonFileUri: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Optional.
     *
     * HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#python_file_uris DataprocWorkflowTemplate#python_file_uris}
     *
     * @stability stable
     */
    readonly pythonFileUris?: string[];
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsPysparkJobToTerraform(struct?: DataprocWorkflowTemplateJobsPysparkJobOutputReference | DataprocWorkflowTemplateJobsPysparkJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsPysparkJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsPysparkJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsPysparkJob | undefined);
    private _archiveUris?;
    /**
     * @stability stable
     */
    get archiveUris(): string[];
    /**
     * @stability stable
     */
    set archiveUris(value: string[]);
    /**
     * @stability stable
     */
    resetArchiveUris(): void;
    /**
     * @stability stable
     */
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    /**
     * @stability stable
     */
    get args(): string[];
    /**
     * @stability stable
     */
    set args(value: string[]);
    /**
     * @stability stable
     */
    resetArgs(): void;
    /**
     * @stability stable
     */
    get argsInput(): string[] | undefined;
    private _fileUris?;
    /**
     * @stability stable
     */
    get fileUris(): string[];
    /**
     * @stability stable
     */
    set fileUris(value: string[]);
    /**
     * @stability stable
     */
    resetFileUris(): void;
    /**
     * @stability stable
     */
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    /**
     * @stability stable
     */
    get jarFileUris(): string[];
    /**
     * @stability stable
     */
    set jarFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetJarFileUris(): void;
    /**
     * @stability stable
     */
    get jarFileUrisInput(): string[] | undefined;
    private _mainPythonFileUri?;
    /**
     * @stability stable
     */
    get mainPythonFileUri(): string;
    /**
     * @stability stable
     */
    set mainPythonFileUri(value: string);
    /**
     * @stability stable
     */
    get mainPythonFileUriInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonFileUris?;
    /**
     * @stability stable
     */
    get pythonFileUris(): string[];
    /**
     * @stability stable
     */
    set pythonFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetPythonFileUris(): void;
    /**
     * @stability stable
     */
    get pythonFileUrisInput(): string[] | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsScheduling {
    /**
     * Optional.
     *
     * Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#max_failures_per_hour DataprocWorkflowTemplate#max_failures_per_hour}
     *
     * @stability stable
     */
    readonly maxFailuresPerHour?: number;
    /**
     * Optional.
     *
     * Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#max_failures_total DataprocWorkflowTemplate#max_failures_total}
     *
     * @stability stable
     */
    readonly maxFailuresTotal?: number;
}
export declare function dataprocWorkflowTemplateJobsSchedulingToTerraform(struct?: DataprocWorkflowTemplateJobsSchedulingOutputReference | DataprocWorkflowTemplateJobsScheduling): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsScheduling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsScheduling | undefined);
    private _maxFailuresPerHour?;
    /**
     * @stability stable
     */
    get maxFailuresPerHour(): number;
    /**
     * @stability stable
     */
    set maxFailuresPerHour(value: number);
    /**
     * @stability stable
     */
    resetMaxFailuresPerHour(): void;
    /**
     * @stability stable
     */
    get maxFailuresPerHourInput(): number | undefined;
    private _maxFailuresTotal?;
    /**
     * @stability stable
     */
    get maxFailuresTotal(): number;
    /**
     * @stability stable
     */
    set maxFailuresTotal(value: number);
    /**
     * @stability stable
     */
    resetMaxFailuresTotal(): void;
    /**
     * @stability stable
     */
    get maxFailuresTotalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsSparkJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsSparkJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * The name of the driver's main class.
     *
     * The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_class DataprocWorkflowTemplate#main_class}
     *
     * @stability stable
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of the jar file that contains the main class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}
     *
     * @stability stable
     */
    readonly mainJarFileUri?: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsSparkJobToTerraform(struct?: DataprocWorkflowTemplateJobsSparkJobOutputReference | DataprocWorkflowTemplateJobsSparkJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkJob | undefined);
    private _archiveUris?;
    /**
     * @stability stable
     */
    get archiveUris(): string[];
    /**
     * @stability stable
     */
    set archiveUris(value: string[]);
    /**
     * @stability stable
     */
    resetArchiveUris(): void;
    /**
     * @stability stable
     */
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    /**
     * @stability stable
     */
    get args(): string[];
    /**
     * @stability stable
     */
    set args(value: string[]);
    /**
     * @stability stable
     */
    resetArgs(): void;
    /**
     * @stability stable
     */
    get argsInput(): string[] | undefined;
    private _fileUris?;
    /**
     * @stability stable
     */
    get fileUris(): string[];
    /**
     * @stability stable
     */
    set fileUris(value: string[]);
    /**
     * @stability stable
     */
    resetFileUris(): void;
    /**
     * @stability stable
     */
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    /**
     * @stability stable
     */
    get jarFileUris(): string[];
    /**
     * @stability stable
     */
    set jarFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetJarFileUris(): void;
    /**
     * @stability stable
     */
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    /**
     * @stability stable
     */
    get mainClass(): string;
    /**
     * @stability stable
     */
    set mainClass(value: string);
    /**
     * @stability stable
     */
    resetMainClass(): void;
    /**
     * @stability stable
     */
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    /**
     * @stability stable
     */
    get mainJarFileUri(): string;
    /**
     * @stability stable
     */
    set mainJarFileUri(value: string);
    /**
     * @stability stable
     */
    resetMainJarFileUri(): void;
    /**
     * @stability stable
     */
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkRJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsSparkRJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsSparkRJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkRJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#archive_uris DataprocWorkflowTemplate#archive_uris}
     *
     * @stability stable
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#args DataprocWorkflowTemplate#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#file_uris DataprocWorkflowTemplate#file_uris}
     *
     * @stability stable
     */
    readonly fileUris?: string[];
    /**
     * Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#main_r_file_uri DataprocWorkflowTemplate#main_r_file_uri}
     *
     * @stability stable
     */
    readonly mainRFileUri: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig;
}
export declare function dataprocWorkflowTemplateJobsSparkRJobToTerraform(struct?: DataprocWorkflowTemplateJobsSparkRJobOutputReference | DataprocWorkflowTemplateJobsSparkRJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkRJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkRJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkRJob | undefined);
    private _archiveUris?;
    /**
     * @stability stable
     */
    get archiveUris(): string[];
    /**
     * @stability stable
     */
    set archiveUris(value: string[]);
    /**
     * @stability stable
     */
    resetArchiveUris(): void;
    /**
     * @stability stable
     */
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    /**
     * @stability stable
     */
    get args(): string[];
    /**
     * @stability stable
     */
    set args(value: string[]);
    /**
     * @stability stable
     */
    resetArgs(): void;
    /**
     * @stability stable
     */
    get argsInput(): string[] | undefined;
    private _fileUris?;
    /**
     * @stability stable
     */
    get fileUris(): string[];
    /**
     * @stability stable
     */
    set fileUris(value: string[]);
    /**
     * @stability stable
     */
    resetFileUris(): void;
    /**
     * @stability stable
     */
    get fileUrisInput(): string[] | undefined;
    private _mainRFileUri?;
    /**
     * @stability stable
     */
    get mainRFileUri(): string;
    /**
     * @stability stable
     */
    set mainRFileUri(value: string);
    /**
     * @stability stable
     */
    get mainRFileUriInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     *
     * @stability stable
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigToTerraform(struct?: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference | DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined);
    private _driverLogLevels?;
    /**
     * @stability stable
     */
    get driverLogLevels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set driverLogLevels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetDriverLogLevels(): void;
    /**
     * @stability stable
     */
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkSqlJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#queries DataprocWorkflowTemplate#queries}
     *
     * @stability stable
     */
    readonly queries: string[];
}
export declare function dataprocWorkflowTemplateJobsSparkSqlJobQueryListToTerraform(struct?: DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference | DataprocWorkflowTemplateJobsSparkSqlJobQueryList): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined);
    private _queries?;
    /**
     * @stability stable
     */
    get queries(): string[];
    /**
     * @stability stable
     */
    set queries(value: string[]);
    /**
     * @stability stable
     */
    get queriesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobsSparkSqlJob {
    /**
     * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     *
     * @stability stable
     */
    readonly jarFileUris?: string[];
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * The HCFS URI of the script that contains SQL queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     *
     * @stability stable
     */
    readonly queryFileUri?: string;
    /**
     * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#script_variables DataprocWorkflowTemplate#script_variables}
     *
     * @stability stable
     */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#logging_config DataprocWorkflowTemplate#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#query_list DataprocWorkflowTemplate#query_list}
     *
     * @stability stable
     */
    readonly queryList?: DataprocWorkflowTemplateJobsSparkSqlJobQueryList;
}
export declare function dataprocWorkflowTemplateJobsSparkSqlJobToTerraform(struct?: DataprocWorkflowTemplateJobsSparkSqlJobOutputReference | DataprocWorkflowTemplateJobsSparkSqlJob): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateJobsSparkSqlJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateJobsSparkSqlJob | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateJobsSparkSqlJob | undefined);
    private _jarFileUris?;
    /**
     * @stability stable
     */
    get jarFileUris(): string[];
    /**
     * @stability stable
     */
    set jarFileUris(value: string[]);
    /**
     * @stability stable
     */
    resetJarFileUris(): void;
    /**
     * @stability stable
     */
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    /**
     * @stability stable
     */
    get queryFileUri(): string;
    /**
     * @stability stable
     */
    set queryFileUri(value: string);
    /**
     * @stability stable
     */
    resetQueryFileUri(): void;
    /**
     * @stability stable
     */
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    /**
     * @stability stable
     */
    get scriptVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set scriptVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetScriptVariables(): void;
    /**
     * @stability stable
     */
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    private _queryList;
    /**
     * @stability stable
     */
    get queryList(): DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference;
    /**
     * @stability stable
     */
    putQueryList(value: DataprocWorkflowTemplateJobsSparkSqlJobQueryList): void;
    /**
     * @stability stable
     */
    resetQueryList(): void;
    /**
     * @stability stable
     */
    get queryListInput(): DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateJobs {
    /**
     * Optional.
     *
     * The labels to associate with this job. Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#labels DataprocWorkflowTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Optional.
     *
     * The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#prerequisite_step_ids DataprocWorkflowTemplate#prerequisite_step_ids}
     *
     * @stability stable
     */
    readonly prerequisiteStepIds?: string[];
    /**
     * Required.
     *
     * The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in prerequisiteStepIds field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#step_id DataprocWorkflowTemplate#step_id}
     *
     * @stability stable
     */
    readonly stepId: string;
    /**
     * hadoop_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#hadoop_job DataprocWorkflowTemplate#hadoop_job}
     *
     * @stability stable
     */
    readonly hadoopJob?: DataprocWorkflowTemplateJobsHadoopJob;
    /**
     * hive_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#hive_job DataprocWorkflowTemplate#hive_job}
     *
     * @stability stable
     */
    readonly hiveJob?: DataprocWorkflowTemplateJobsHiveJob;
    /**
     * pig_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#pig_job DataprocWorkflowTemplate#pig_job}
     *
     * @stability stable
     */
    readonly pigJob?: DataprocWorkflowTemplateJobsPigJob;
    /**
     * presto_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#presto_job DataprocWorkflowTemplate#presto_job}
     *
     * @stability stable
     */
    readonly prestoJob?: DataprocWorkflowTemplateJobsPrestoJob;
    /**
     * pyspark_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#pyspark_job DataprocWorkflowTemplate#pyspark_job}
     *
     * @stability stable
     */
    readonly pysparkJob?: DataprocWorkflowTemplateJobsPysparkJob;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#scheduling DataprocWorkflowTemplate#scheduling}
     *
     * @stability stable
     */
    readonly scheduling?: DataprocWorkflowTemplateJobsScheduling;
    /**
     * spark_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#spark_job DataprocWorkflowTemplate#spark_job}
     *
     * @stability stable
     */
    readonly sparkJob?: DataprocWorkflowTemplateJobsSparkJob;
    /**
     * spark_r_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#spark_r_job DataprocWorkflowTemplate#spark_r_job}
     *
     * @stability stable
     */
    readonly sparkRJob?: DataprocWorkflowTemplateJobsSparkRJob;
    /**
     * spark_sql_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#spark_sql_job DataprocWorkflowTemplate#spark_sql_job}
     *
     * @stability stable
     */
    readonly sparkSqlJob?: DataprocWorkflowTemplateJobsSparkSqlJob;
}
export declare function dataprocWorkflowTemplateJobsToTerraform(struct?: DataprocWorkflowTemplateJobs | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParametersValidationRegex {
    /**
     * Required.
     *
     * RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#regexes DataprocWorkflowTemplate#regexes}
     *
     * @stability stable
     */
    readonly regexes: string[];
}
export declare function dataprocWorkflowTemplateParametersValidationRegexToTerraform(struct?: DataprocWorkflowTemplateParametersValidationRegexOutputReference | DataprocWorkflowTemplateParametersValidationRegex): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateParametersValidationRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateParametersValidationRegex | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateParametersValidationRegex | undefined);
    private _regexes?;
    /**
     * @stability stable
     */
    get regexes(): string[];
    /**
     * @stability stable
     */
    set regexes(value: string[]);
    /**
     * @stability stable
     */
    get regexesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParametersValidationValues {
    /**
     * Required. List of allowed values for the parameter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#values DataprocWorkflowTemplate#values}
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function dataprocWorkflowTemplateParametersValidationValuesToTerraform(struct?: DataprocWorkflowTemplateParametersValidationValuesOutputReference | DataprocWorkflowTemplateParametersValidationValues): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateParametersValidationValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateParametersValidationValues | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateParametersValidationValues | undefined);
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParametersValidation {
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#regex DataprocWorkflowTemplate#regex}
     *
     * @stability stable
     */
    readonly regex?: DataprocWorkflowTemplateParametersValidationRegex;
    /**
     * values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#values DataprocWorkflowTemplate#values}
     *
     * @stability stable
     */
    readonly values?: DataprocWorkflowTemplateParametersValidationValues;
}
export declare function dataprocWorkflowTemplateParametersValidationToTerraform(struct?: DataprocWorkflowTemplateParametersValidationOutputReference | DataprocWorkflowTemplateParametersValidation): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateParametersValidationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateParametersValidation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateParametersValidation | undefined);
    private _regex;
    /**
     * @stability stable
     */
    get regex(): DataprocWorkflowTemplateParametersValidationRegexOutputReference;
    /**
     * @stability stable
     */
    putRegex(value: DataprocWorkflowTemplateParametersValidationRegex): void;
    /**
     * @stability stable
     */
    resetRegex(): void;
    /**
     * @stability stable
     */
    get regexInput(): DataprocWorkflowTemplateParametersValidationRegex | undefined;
    private _values;
    /**
     * @stability stable
     */
    get values(): DataprocWorkflowTemplateParametersValidationValuesOutputReference;
    /**
     * @stability stable
     */
    putValues(value: DataprocWorkflowTemplateParametersValidationValues): void;
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): DataprocWorkflowTemplateParametersValidationValues | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateParameters {
    /**
     * Optional. Brief description of the parameter. Must not exceed 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#description DataprocWorkflowTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Required.
     *
     * Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as `placement.clusterSelector.zone`. Also, field paths can reference fields using the following syntax: * Values in maps can be referenced by key: * labels['key'] * placement.clusterSelector.clusterLabels['key'] * placement.managedCluster.labels['key'] * placement.clusterSelector.clusterLabels['key'] * jobs['step-id'].labels['key'] * Jobs in the jobs list can be referenced by step-id: * jobs['step-id'].hadoopJob.mainJarFileUri * jobs['step-id'].hiveJob.queryFileUri * jobs['step-id'].pySparkJob.mainPythonFileUri * jobs['step-id'].hadoopJob.jarFileUris[0] * jobs['step-id'].hadoopJob.archiveUris[0] * jobs['step-id'].hadoopJob.fileUris[0] * jobs['step-id'].pySparkJob.pythonFileUris[0] * Items in repeated fields can be referenced by a zero-based index: * jobs['step-id'].sparkJob.args[0] * Other examples: * jobs['step-id'].hadoopJob.properties['key'] * jobs['step-id'].hadoopJob.args[0] * jobs['step-id'].hiveJob.scriptVariables['key'] * jobs['step-id'].hadoopJob.mainJarFileUri * placement.clusterSelector.zone It may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: - placement.clusterSelector.clusterLabels - jobs['step-id'].sparkJob.args
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#fields DataprocWorkflowTemplate#fields}
     *
     * @stability stable
     */
    readonly fields: string[];
    /**
     * Required.
     *
     * Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#name DataprocWorkflowTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * validation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#validation DataprocWorkflowTemplate#validation}
     *
     * @stability stable
     */
    readonly validation?: DataprocWorkflowTemplateParametersValidation;
}
export declare function dataprocWorkflowTemplateParametersToTerraform(struct?: DataprocWorkflowTemplateParameters | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementClusterSelector {
    /**
     * Required. The cluster labels. Cluster must have all labels to match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cluster_labels DataprocWorkflowTemplate#cluster_labels}
     *
     * @stability stable
     */
    readonly clusterLabels: {
        [key: string]: string;
    };
    /**
     * Optional.
     *
     * The zone where workflow process executes. This parameter does not affect the selection of the cluster. If unspecified, the zone of the first cluster matching the selector is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#zone DataprocWorkflowTemplate#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
export declare function dataprocWorkflowTemplatePlacementClusterSelectorToTerraform(struct?: DataprocWorkflowTemplatePlacementClusterSelectorOutputReference | DataprocWorkflowTemplatePlacementClusterSelector): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementClusterSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementClusterSelector | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementClusterSelector | undefined);
    private _clusterLabels?;
    /**
     * @stability stable
     */
    get clusterLabels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set clusterLabels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    get clusterLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig {
    /**
     * Optional.
     *
     * The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` * `projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` Note that the policy must be in the same project and Dataproc region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#policy DataprocWorkflowTemplate#policy}
     *
     * @stability stable
     */
    readonly policy?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined);
    private _policy?;
    /**
     * @stability stable
     */
    get policy(): string;
    /**
     * @stability stable
     */
    set policy(value: string);
    /**
     * @stability stable
     */
    resetPolicy(): void;
    /**
     * @stability stable
     */
    get policyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig {
    /**
     * Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#gce_pd_kms_key_name DataprocWorkflowTemplate#gce_pd_kms_key_name}
     *
     * @stability stable
     */
    readonly gcePdKmsKeyName?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined);
    private _gcePdKmsKeyName?;
    /**
     * @stability stable
     */
    get gcePdKmsKeyName(): string;
    /**
     * @stability stable
     */
    set gcePdKmsKeyName(value: string);
    /**
     * @stability stable
     */
    resetGcePdKmsKeyName(): void;
    /**
     * @stability stable
     */
    get gcePdKmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig {
    /**
     * Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#enable_http_port_access DataprocWorkflowTemplate#enable_http_port_access}
     *
     * @stability stable
     */
    readonly enableHttpPortAccess?: boolean | cdktf.IResolvable;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined);
    private _enableHttpPortAccess?;
    /**
     * @stability stable
     */
    get enableHttpPortAccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableHttpPortAccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableHttpPortAccess(): void;
    /**
     * @stability stable
     */
    get enableHttpPortAccessInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    httpPorts(key: string): string | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity {
    /**
     * Required.
     *
     * The URI of a sole-tenant [node group resource](https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on. A full URL, partial URI, or node group name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#node_group DataprocWorkflowTemplate#node_group}
     *
     * @stability stable
     */
    readonly nodeGroup: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined);
    private _nodeGroup?;
    /**
     * @stability stable
     */
    get nodeGroup(): string;
    /**
     * @stability stable
     */
    set nodeGroup(value: string);
    /**
     * @stability stable
     */
    get nodeGroupInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity {
    /**
     * Optional. Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#consume_reservation_type DataprocWorkflowTemplate#consume_reservation_type}
     *
     * @stability stable
     */
    readonly consumeReservationType?: string;
    /**
     * Optional. Corresponds to the label key of reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#key DataprocWorkflowTemplate#key}
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Optional. Corresponds to the label values of reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#values DataprocWorkflowTemplate#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    /**
     * @stability stable
     */
    get consumeReservationType(): string;
    /**
     * @stability stable
     */
    set consumeReservationType(value: string);
    /**
     * @stability stable
     */
    resetConsumeReservationType(): void;
    /**
     * @stability stable
     */
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    resetKey(): void;
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig {
    /**
     * Optional.
     *
     * If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#internal_ip_only DataprocWorkflowTemplate#internal_ip_only}
     *
     * @stability stable
     */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
     * The Compute Engine metadata entries to add to all instances (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#metadata DataprocWorkflowTemplate#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * Optional.
     *
     * The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for more information). A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default` * `projects/[project_id]/regions/global/default` * `default`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#network DataprocWorkflowTemplate#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Optional. The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#private_ipv6_google_access DataprocWorkflowTemplate#private_ipv6_google_access}
     *
     * @stability stable
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * Optional.
     *
     * The [Dataproc service account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see [VM Data Plane identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#service_account DataprocWorkflowTemplate#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * Optional.
     *
     * The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#service_account_scopes DataprocWorkflowTemplate#service_account_scopes}
     *
     * @stability stable
     */
    readonly serviceAccountScopes?: string[];
    /**
     * Optional.
     *
     * The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0` * `projects/[project_id]/regions/us-east1/subnetworks/sub0` * `sub0`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#subnetwork DataprocWorkflowTemplate#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The Compute Engine tags to add to all instances (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#tags DataprocWorkflowTemplate#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Optional.
     *
     * The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]` * `projects/[project_id]/zones/[zone]` * `us-central1-f`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#zone DataprocWorkflowTemplate#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * node_group_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#node_group_affinity DataprocWorkflowTemplate#node_group_affinity}
     *
     * @stability stable
     */
    readonly nodeGroupAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity;
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#reservation_affinity DataprocWorkflowTemplate#reservation_affinity}
     *
     * @stability stable
     */
    readonly reservationAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined);
    private _internalIpOnly?;
    /**
     * @stability stable
     */
    get internalIpOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternalIpOnly(): void;
    /**
     * @stability stable
     */
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _privateIpv6GoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccess(): string;
    /**
     * @stability stable
     */
    set privateIpv6GoogleAccess(value: string);
    /**
     * @stability stable
     */
    resetPrivateIpv6GoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    /**
     * @stability stable
     */
    get serviceAccountScopes(): string[];
    /**
     * @stability stable
     */
    set serviceAccountScopes(value: string[]);
    /**
     * @stability stable
     */
    resetServiceAccountScopes(): void;
    /**
     * @stability stable
     */
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _nodeGroupAffinity;
    /**
     * @stability stable
     */
    get nodeGroupAffinity(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference;
    /**
     * @stability stable
     */
    putNodeGroupAffinity(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity): void;
    /**
     * @stability stable
     */
    resetNodeGroupAffinity(): void;
    /**
     * @stability stable
     */
    get nodeGroupAffinityInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    private _reservationAffinity;
    /**
     * @stability stable
     */
    get reservationAffinity(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference;
    /**
     * @stability stable
     */
    putReservationAffinity(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity): void;
    /**
     * @stability stable
     */
    resetReservationAffinity(): void;
    /**
     * @stability stable
     */
    get reservationAffinityInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions {
    /**
     * Required. Cloud Storage URI of executable file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#executable_file DataprocWorkflowTemplate#executable_file}
     *
     * @stability stable
     */
    readonly executableFile?: string;
    /**
     * Optional.
     *
     * Amount of time executable has to complete. Default is 10 minutes (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#execution_timeout DataprocWorkflowTemplate#execution_timeout}
     *
     * @stability stable
     */
    readonly executionTimeout?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig {
    /**
     * Optional. The time when cluster will be auto-deleted (see JSON representation of [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#auto_delete_time DataprocWorkflowTemplate#auto_delete_time}
     *
     * @stability stable
     */
    readonly autoDeleteTime?: string;
    /**
     * Optional.
     *
     * The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#auto_delete_ttl DataprocWorkflowTemplate#auto_delete_ttl}
     *
     * @stability stable
     */
    readonly autoDeleteTtl?: string;
    /**
     * Optional.
     *
     * The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#idle_delete_ttl DataprocWorkflowTemplate#idle_delete_ttl}
     *
     * @stability stable
     */
    readonly idleDeleteTtl?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined);
    private _autoDeleteTime?;
    /**
     * @stability stable
     */
    get autoDeleteTime(): string;
    /**
     * @stability stable
     */
    set autoDeleteTime(value: string);
    /**
     * @stability stable
     */
    resetAutoDeleteTime(): void;
    /**
     * @stability stable
     */
    get autoDeleteTimeInput(): string | undefined;
    private _autoDeleteTtl?;
    /**
     * @stability stable
     */
    get autoDeleteTtl(): string;
    /**
     * @stability stable
     */
    set autoDeleteTtl(value: string);
    /**
     * @stability stable
     */
    resetAutoDeleteTtl(): void;
    /**
     * @stability stable
     */
    get autoDeleteTtlInput(): string | undefined;
    private _idleDeleteTtl?;
    /**
     * @stability stable
     */
    get idleDeleteTtl(): string;
    /**
     * @stability stable
     */
    set idleDeleteTtl(value: string);
    /**
     * @stability stable
     */
    resetIdleDeleteTtl(): void;
    /**
     * @stability stable
     */
    get idleDeleteTtlInput(): string | undefined;
    /**
     * @stability stable
     */
    get idleStartTime(): string;
}
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get instanceGroupManagerName(): string;
    /**
     * @stability stable
     */
    get instanceTemplateName(): string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_count DataprocWorkflowTemplate#accelerator_count}
     *
     * @stability stable
     */
    readonly acceleratorCount?: number;
    /**
     * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance.
     *
     * See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_type DataprocWorkflowTemplate#accelerator_type}
     *
     * @stability stable
     */
    readonly acceleratorType?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig {
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Optional.
     *
     * Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Optional.
     *
     * Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
     *
     * @stability stable
     */
    readonly numLocalSsds?: number;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    /**
     * @stability stable
     */
    get bootDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set bootDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetBootDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    /**
     * @stability stable
     */
    get bootDiskType(): string;
    /**
     * @stability stable
     */
    set bootDiskType(value: string);
    /**
     * @stability stable
     */
    resetBootDiskType(): void;
    /**
     * @stability stable
     */
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    /**
     * @stability stable
     */
    get numLocalSsds(): number;
    /**
     * @stability stable
     */
    set numLocalSsds(value: number);
    /**
     * @stability stable
     */
    resetNumLocalSsds(): void;
    /**
     * @stability stable
     */
    get numLocalSsdsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig {
    /**
     * Optional.
     *
     * The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image DataprocWorkflowTemplate#image}
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Optional.
     *
     * The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#machine_type DataprocWorkflowTemplate#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * Optional.
     *
     * The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_instances DataprocWorkflowTemplate#num_instances}
     *
     * @stability stable
     */
    readonly numInstances?: number;
    /**
     * Optional.
     *
     * Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#preemptibility DataprocWorkflowTemplate#preemptibility}
     *
     * @stability stable
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerators DataprocWorkflowTemplate#accelerators}
     *
     * @stability stable
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#disk_config DataprocWorkflowTemplate#disk_config}
     *
     * @stability stable
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined);
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    /**
     * @stability stable
     */
    get instanceNames(): string[];
    /**
     * @stability stable
     */
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    managedGroupConfig(index: string): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    /**
     * @stability stable
     */
    get numInstances(): number;
    /**
     * @stability stable
     */
    set numInstances(value: number);
    /**
     * @stability stable
     */
    resetNumInstances(): void;
    /**
     * @stability stable
     */
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    /**
     * @stability stable
     */
    get preemptibility(): string;
    /**
     * @stability stable
     */
    set preemptibility(value: string);
    /**
     * @stability stable
     */
    resetPreemptibility(): void;
    /**
     * @stability stable
     */
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    /**
     * @stability stable
     */
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccelerators(): void;
    /**
     * @stability stable
     */
    get acceleratorsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig;
    /**
     * @stability stable
     */
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference;
    /**
     * @stability stable
     */
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig): void;
    /**
     * @stability stable
     */
    resetDiskConfig(): void;
    /**
     * @stability stable
     */
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
}
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get instanceGroupManagerName(): string;
    /**
     * @stability stable
     */
    get instanceTemplateName(): string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_count DataprocWorkflowTemplate#accelerator_count}
     *
     * @stability stable
     */
    readonly acceleratorCount?: number;
    /**
     * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance.
     *
     * See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_type DataprocWorkflowTemplate#accelerator_type}
     *
     * @stability stable
     */
    readonly acceleratorType?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig {
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Optional.
     *
     * Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Optional.
     *
     * Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
     *
     * @stability stable
     */
    readonly numLocalSsds?: number;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    /**
     * @stability stable
     */
    get bootDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set bootDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetBootDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    /**
     * @stability stable
     */
    get bootDiskType(): string;
    /**
     * @stability stable
     */
    set bootDiskType(value: string);
    /**
     * @stability stable
     */
    resetBootDiskType(): void;
    /**
     * @stability stable
     */
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    /**
     * @stability stable
     */
    get numLocalSsds(): number;
    /**
     * @stability stable
     */
    set numLocalSsds(value: number);
    /**
     * @stability stable
     */
    resetNumLocalSsds(): void;
    /**
     * @stability stable
     */
    get numLocalSsdsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig {
    /**
     * Optional.
     *
     * The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image DataprocWorkflowTemplate#image}
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Optional.
     *
     * The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#machine_type DataprocWorkflowTemplate#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * Optional.
     *
     * The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_instances DataprocWorkflowTemplate#num_instances}
     *
     * @stability stable
     */
    readonly numInstances?: number;
    /**
     * Optional.
     *
     * Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#preemptibility DataprocWorkflowTemplate#preemptibility}
     *
     * @stability stable
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerators DataprocWorkflowTemplate#accelerators}
     *
     * @stability stable
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#disk_config DataprocWorkflowTemplate#disk_config}
     *
     * @stability stable
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined);
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    /**
     * @stability stable
     */
    get instanceNames(): string[];
    /**
     * @stability stable
     */
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    managedGroupConfig(index: string): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    /**
     * @stability stable
     */
    get numInstances(): number;
    /**
     * @stability stable
     */
    set numInstances(value: number);
    /**
     * @stability stable
     */
    resetNumInstances(): void;
    /**
     * @stability stable
     */
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    /**
     * @stability stable
     */
    get preemptibility(): string;
    /**
     * @stability stable
     */
    set preemptibility(value: string);
    /**
     * @stability stable
     */
    resetPreemptibility(): void;
    /**
     * @stability stable
     */
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    /**
     * @stability stable
     */
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccelerators(): void;
    /**
     * @stability stable
     */
    get acceleratorsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    /**
     * @stability stable
     */
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference;
    /**
     * @stability stable
     */
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig): void;
    /**
     * @stability stable
     */
    resetDiskConfig(): void;
    /**
     * @stability stable
     */
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig {
    /**
     * Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_admin_server DataprocWorkflowTemplate#cross_realm_trust_admin_server}
     *
     * @stability stable
     */
    readonly crossRealmTrustAdminServer?: string;
    /**
     * Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_kdc DataprocWorkflowTemplate#cross_realm_trust_kdc}
     *
     * @stability stable
     */
    readonly crossRealmTrustKdc?: string;
    /**
     * Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_realm DataprocWorkflowTemplate#cross_realm_trust_realm}
     *
     * @stability stable
     */
    readonly crossRealmTrustRealm?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cross_realm_trust_shared_password DataprocWorkflowTemplate#cross_realm_trust_shared_password}
     *
     * @stability stable
     */
    readonly crossRealmTrustSharedPassword?: string;
    /**
     * Optional.
     *
     * Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#enable_kerberos DataprocWorkflowTemplate#enable_kerberos}
     *
     * @stability stable
     */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
     * Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#kdc_db_key DataprocWorkflowTemplate#kdc_db_key}
     *
     * @stability stable
     */
    readonly kdcDbKey?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#key_password DataprocWorkflowTemplate#key_password}
     *
     * @stability stable
     */
    readonly keyPassword?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#keystore DataprocWorkflowTemplate#keystore}
     *
     * @stability stable
     */
    readonly keystore?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#keystore_password DataprocWorkflowTemplate#keystore_password}
     *
     * @stability stable
     */
    readonly keystorePassword?: string;
    /**
     * Optional. The uri of the KMS key used to encrypt various sensitive files.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#kms_key DataprocWorkflowTemplate#kms_key}
     *
     * @stability stable
     */
    readonly kmsKey?: string;
    /**
     * Optional.
     *
     * The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#realm DataprocWorkflowTemplate#realm}
     *
     * @stability stable
     */
    readonly realm?: string;
    /**
     * Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#root_principal_password DataprocWorkflowTemplate#root_principal_password}
     *
     * @stability stable
     */
    readonly rootPrincipalPassword?: string;
    /**
     * Optional.
     *
     * The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#tgt_lifetime_hours DataprocWorkflowTemplate#tgt_lifetime_hours}
     *
     * @stability stable
     */
    readonly tgtLifetimeHours?: number;
    /**
     * Optional.
     *
     * The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#truststore DataprocWorkflowTemplate#truststore}
     *
     * @stability stable
     */
    readonly truststore?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#truststore_password DataprocWorkflowTemplate#truststore_password}
     *
     * @stability stable
     */
    readonly truststorePassword?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined);
    private _crossRealmTrustAdminServer?;
    /**
     * @stability stable
     */
    get crossRealmTrustAdminServer(): string;
    /**
     * @stability stable
     */
    set crossRealmTrustAdminServer(value: string);
    /**
     * @stability stable
     */
    resetCrossRealmTrustAdminServer(): void;
    /**
     * @stability stable
     */
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    /**
     * @stability stable
     */
    get crossRealmTrustKdc(): string;
    /**
     * @stability stable
     */
    set crossRealmTrustKdc(value: string);
    /**
     * @stability stable
     */
    resetCrossRealmTrustKdc(): void;
    /**
     * @stability stable
     */
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    /**
     * @stability stable
     */
    get crossRealmTrustRealm(): string;
    /**
     * @stability stable
     */
    set crossRealmTrustRealm(value: string);
    /**
     * @stability stable
     */
    resetCrossRealmTrustRealm(): void;
    /**
     * @stability stable
     */
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPassword?;
    /**
     * @stability stable
     */
    get crossRealmTrustSharedPassword(): string;
    /**
     * @stability stable
     */
    set crossRealmTrustSharedPassword(value: string);
    /**
     * @stability stable
     */
    resetCrossRealmTrustSharedPassword(): void;
    /**
     * @stability stable
     */
    get crossRealmTrustSharedPasswordInput(): string | undefined;
    private _enableKerberos?;
    /**
     * @stability stable
     */
    get enableKerberos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableKerberos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableKerberos(): void;
    /**
     * @stability stable
     */
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKey?;
    /**
     * @stability stable
     */
    get kdcDbKey(): string;
    /**
     * @stability stable
     */
    set kdcDbKey(value: string);
    /**
     * @stability stable
     */
    resetKdcDbKey(): void;
    /**
     * @stability stable
     */
    get kdcDbKeyInput(): string | undefined;
    private _keyPassword?;
    /**
     * @stability stable
     */
    get keyPassword(): string;
    /**
     * @stability stable
     */
    set keyPassword(value: string);
    /**
     * @stability stable
     */
    resetKeyPassword(): void;
    /**
     * @stability stable
     */
    get keyPasswordInput(): string | undefined;
    private _keystore?;
    /**
     * @stability stable
     */
    get keystore(): string;
    /**
     * @stability stable
     */
    set keystore(value: string);
    /**
     * @stability stable
     */
    resetKeystore(): void;
    /**
     * @stability stable
     */
    get keystoreInput(): string | undefined;
    private _keystorePassword?;
    /**
     * @stability stable
     */
    get keystorePassword(): string;
    /**
     * @stability stable
     */
    set keystorePassword(value: string);
    /**
     * @stability stable
     */
    resetKeystorePassword(): void;
    /**
     * @stability stable
     */
    get keystorePasswordInput(): string | undefined;
    private _kmsKey?;
    /**
     * @stability stable
     */
    get kmsKey(): string;
    /**
     * @stability stable
     */
    set kmsKey(value: string);
    /**
     * @stability stable
     */
    resetKmsKey(): void;
    /**
     * @stability stable
     */
    get kmsKeyInput(): string | undefined;
    private _realm?;
    /**
     * @stability stable
     */
    get realm(): string;
    /**
     * @stability stable
     */
    set realm(value: string);
    /**
     * @stability stable
     */
    resetRealm(): void;
    /**
     * @stability stable
     */
    get realmInput(): string | undefined;
    private _rootPrincipalPassword?;
    /**
     * @stability stable
     */
    get rootPrincipalPassword(): string;
    /**
     * @stability stable
     */
    set rootPrincipalPassword(value: string);
    /**
     * @stability stable
     */
    resetRootPrincipalPassword(): void;
    /**
     * @stability stable
     */
    get rootPrincipalPasswordInput(): string | undefined;
    private _tgtLifetimeHours?;
    /**
     * @stability stable
     */
    get tgtLifetimeHours(): number;
    /**
     * @stability stable
     */
    set tgtLifetimeHours(value: number);
    /**
     * @stability stable
     */
    resetTgtLifetimeHours(): void;
    /**
     * @stability stable
     */
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststore?;
    /**
     * @stability stable
     */
    get truststore(): string;
    /**
     * @stability stable
     */
    set truststore(value: string);
    /**
     * @stability stable
     */
    resetTruststore(): void;
    /**
     * @stability stable
     */
    get truststoreInput(): string | undefined;
    private _truststorePassword?;
    /**
     * @stability stable
     */
    get truststorePassword(): string;
    /**
     * @stability stable
     */
    set truststorePassword(value: string);
    /**
     * @stability stable
     */
    resetTruststorePassword(): void;
    /**
     * @stability stable
     */
    get truststorePasswordInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig {
    /**
     * kerberos_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#kerberos_config DataprocWorkflowTemplate#kerberos_config}
     *
     * @stability stable
     */
    readonly kerberosConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined);
    private _kerberosConfig;
    /**
     * @stability stable
     */
    get kerberosConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference;
    /**
     * @stability stable
     */
    putKerberosConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig): void;
    /**
     * @stability stable
     */
    resetKerberosConfig(): void;
    /**
     * @stability stable
     */
    get kerberosConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig {
    /**
     * Optional.
     *
     * The version of software inside the cluster. It must be one of the supported [Dataproc Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the ["preview" version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image_version DataprocWorkflowTemplate#image_version}
     *
     * @stability stable
     */
    readonly imageVersion?: string;
    /**
     * Optional. The set of components to activate on the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#optional_components DataprocWorkflowTemplate#optional_components}
     *
     * @stability stable
     */
    readonly optionalComponents?: string[];
    /**
     * Optional.
     *
     * The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#properties DataprocWorkflowTemplate#properties}
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined);
    private _imageVersion?;
    /**
     * @stability stable
     */
    get imageVersion(): string;
    /**
     * @stability stable
     */
    set imageVersion(value: string);
    /**
     * @stability stable
     */
    resetImageVersion(): void;
    /**
     * @stability stable
     */
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    /**
     * @stability stable
     */
    get optionalComponents(): string[];
    /**
     * @stability stable
     */
    set optionalComponents(value: string[]);
    /**
     * @stability stable
     */
    resetOptionalComponents(): void;
    /**
     * @stability stable
     */
    get optionalComponentsInput(): string[] | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get instanceGroupManagerName(): string;
    /**
     * @stability stable
     */
    get instanceTemplateName(): string;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_count DataprocWorkflowTemplate#accelerator_count}
     *
     * @stability stable
     */
    readonly acceleratorCount?: number;
    /**
     * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance.
     *
     * See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerator_type DataprocWorkflowTemplate#accelerator_type}
     *
     * @stability stable
     */
    readonly acceleratorType?: string;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig {
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
     *
     * @stability stable
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Optional.
     *
     * Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
     *
     * @stability stable
     */
    readonly bootDiskType?: string;
    /**
     * Optional.
     *
     * Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
     *
     * @stability stable
     */
    readonly numLocalSsds?: number;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    /**
     * @stability stable
     */
    get bootDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set bootDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetBootDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    /**
     * @stability stable
     */
    get bootDiskType(): string;
    /**
     * @stability stable
     */
    set bootDiskType(value: string);
    /**
     * @stability stable
     */
    resetBootDiskType(): void;
    /**
     * @stability stable
     */
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    /**
     * @stability stable
     */
    get numLocalSsds(): number;
    /**
     * @stability stable
     */
    set numLocalSsds(value: number);
    /**
     * @stability stable
     */
    resetNumLocalSsds(): void;
    /**
     * @stability stable
     */
    get numLocalSsdsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig {
    /**
     * Optional.
     *
     * The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#image DataprocWorkflowTemplate#image}
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Optional.
     *
     * The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#machine_type DataprocWorkflowTemplate#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * Optional.
     *
     * The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#num_instances DataprocWorkflowTemplate#num_instances}
     *
     * @stability stable
     */
    readonly numInstances?: number;
    /**
     * Optional.
     *
     * Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#preemptibility DataprocWorkflowTemplate#preemptibility}
     *
     * @stability stable
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#accelerators DataprocWorkflowTemplate#accelerators}
     *
     * @stability stable
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#disk_config DataprocWorkflowTemplate#disk_config}
     *
     * @stability stable
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined);
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    /**
     * @stability stable
     */
    get instanceNames(): string[];
    /**
     * @stability stable
     */
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    managedGroupConfig(index: string): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    /**
     * @stability stable
     */
    get numInstances(): number;
    /**
     * @stability stable
     */
    set numInstances(value: number);
    /**
     * @stability stable
     */
    resetNumInstances(): void;
    /**
     * @stability stable
     */
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    /**
     * @stability stable
     */
    get preemptibility(): string;
    /**
     * @stability stable
     */
    set preemptibility(value: string);
    /**
     * @stability stable
     */
    resetPreemptibility(): void;
    /**
     * @stability stable
     */
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    /**
     * @stability stable
     */
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccelerators(): void;
    /**
     * @stability stable
     */
    get acceleratorsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    /**
     * @stability stable
     */
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference;
    /**
     * @stability stable
     */
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig): void;
    /**
     * @stability stable
     */
    resetDiskConfig(): void;
    /**
     * @stability stable
     */
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedClusterConfig {
    /**
     * Optional.
     *
     * A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see [Dataproc staging bucket](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#staging_bucket DataprocWorkflowTemplate#staging_bucket}
     *
     * @stability stable
     */
    readonly stagingBucket?: string;
    /**
     * Optional.
     *
     * A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#temp_bucket DataprocWorkflowTemplate#temp_bucket}
     *
     * @stability stable
     */
    readonly tempBucket?: string;
    /**
     * autoscaling_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#autoscaling_config DataprocWorkflowTemplate#autoscaling_config}
     *
     * @stability stable
     */
    readonly autoscalingConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig;
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#encryption_config DataprocWorkflowTemplate#encryption_config}
     *
     * @stability stable
     */
    readonly encryptionConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig;
    /**
     * endpoint_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#endpoint_config DataprocWorkflowTemplate#endpoint_config}
     *
     * @stability stable
     */
    readonly endpointConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig;
    /**
     * gce_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#gce_cluster_config DataprocWorkflowTemplate#gce_cluster_config}
     *
     * @stability stable
     */
    readonly gceClusterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig;
    /**
     * initialization_actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#initialization_actions DataprocWorkflowTemplate#initialization_actions}
     *
     * @stability stable
     */
    readonly initializationActions?: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable;
    /**
     * lifecycle_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#lifecycle_config DataprocWorkflowTemplate#lifecycle_config}
     *
     * @stability stable
     */
    readonly lifecycleConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig;
    /**
     * master_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#master_config DataprocWorkflowTemplate#master_config}
     *
     * @stability stable
     */
    readonly masterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig;
    /**
     * secondary_worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#secondary_worker_config DataprocWorkflowTemplate#secondary_worker_config}
     *
     * @stability stable
     */
    readonly secondaryWorkerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig;
    /**
     * security_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#security_config DataprocWorkflowTemplate#security_config}
     *
     * @stability stable
     */
    readonly securityConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig;
    /**
     * software_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#software_config DataprocWorkflowTemplate#software_config}
     *
     * @stability stable
     */
    readonly softwareConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig;
    /**
     * worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#worker_config DataprocWorkflowTemplate#worker_config}
     *
     * @stability stable
     */
    readonly workerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterConfigToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference | DataprocWorkflowTemplatePlacementManagedClusterConfig): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined);
    private _stagingBucket?;
    /**
     * @stability stable
     */
    get stagingBucket(): string;
    /**
     * @stability stable
     */
    set stagingBucket(value: string);
    /**
     * @stability stable
     */
    resetStagingBucket(): void;
    /**
     * @stability stable
     */
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    /**
     * @stability stable
     */
    get tempBucket(): string;
    /**
     * @stability stable
     */
    set tempBucket(value: string);
    /**
     * @stability stable
     */
    resetTempBucket(): void;
    /**
     * @stability stable
     */
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig;
    /**
     * @stability stable
     */
    get autoscalingConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference;
    /**
     * @stability stable
     */
    putAutoscalingConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig): void;
    /**
     * @stability stable
     */
    resetAutoscalingConfig(): void;
    /**
     * @stability stable
     */
    get autoscalingConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig;
    /**
     * @stability stable
     */
    get encryptionConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference;
    /**
     * @stability stable
     */
    putEncryptionConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig): void;
    /**
     * @stability stable
     */
    resetEncryptionConfig(): void;
    /**
     * @stability stable
     */
    get encryptionConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    private _endpointConfig;
    /**
     * @stability stable
     */
    get endpointConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference;
    /**
     * @stability stable
     */
    putEndpointConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig): void;
    /**
     * @stability stable
     */
    resetEndpointConfig(): void;
    /**
     * @stability stable
     */
    get endpointConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    private _gceClusterConfig;
    /**
     * @stability stable
     */
    get gceClusterConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference;
    /**
     * @stability stable
     */
    putGceClusterConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig): void;
    /**
     * @stability stable
     */
    resetGceClusterConfig(): void;
    /**
     * @stability stable
     */
    get gceClusterConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    private _initializationActions?;
    /**
     * @stability stable
     */
    get initializationActions(): DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set initializationActions(value: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInitializationActions(): void;
    /**
     * @stability stable
     */
    get initializationActionsInput(): cdktf.IResolvable | DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | undefined;
    private _lifecycleConfig;
    /**
     * @stability stable
     */
    get lifecycleConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference;
    /**
     * @stability stable
     */
    putLifecycleConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig): void;
    /**
     * @stability stable
     */
    resetLifecycleConfig(): void;
    /**
     * @stability stable
     */
    get lifecycleConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    private _masterConfig;
    /**
     * @stability stable
     */
    get masterConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference;
    /**
     * @stability stable
     */
    putMasterConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig): void;
    /**
     * @stability stable
     */
    resetMasterConfig(): void;
    /**
     * @stability stable
     */
    get masterConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    private _secondaryWorkerConfig;
    /**
     * @stability stable
     */
    get secondaryWorkerConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference;
    /**
     * @stability stable
     */
    putSecondaryWorkerConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig): void;
    /**
     * @stability stable
     */
    resetSecondaryWorkerConfig(): void;
    /**
     * @stability stable
     */
    get secondaryWorkerConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    private _securityConfig;
    /**
     * @stability stable
     */
    get securityConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference;
    /**
     * @stability stable
     */
    putSecurityConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig): void;
    /**
     * @stability stable
     */
    resetSecurityConfig(): void;
    /**
     * @stability stable
     */
    get securityConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    private _softwareConfig;
    /**
     * @stability stable
     */
    get softwareConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference;
    /**
     * @stability stable
     */
    putSoftwareConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig): void;
    /**
     * @stability stable
     */
    resetSoftwareConfig(): void;
    /**
     * @stability stable
     */
    get softwareConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    private _workerConfig;
    /**
     * @stability stable
     */
    get workerConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference;
    /**
     * @stability stable
     */
    putWorkerConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig): void;
    /**
     * @stability stable
     */
    resetWorkerConfig(): void;
    /**
     * @stability stable
     */
    get workerConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacementManagedCluster {
    /**
     * Required.
     *
     * The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cluster_name DataprocWorkflowTemplate#cluster_name}
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Optional.
     *
     * The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#labels DataprocWorkflowTemplate#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#config DataprocWorkflowTemplate#config}
     *
     * @stability stable
     */
    readonly config: DataprocWorkflowTemplatePlacementManagedClusterConfig;
}
export declare function dataprocWorkflowTemplatePlacementManagedClusterToTerraform(struct?: DataprocWorkflowTemplatePlacementManagedClusterOutputReference | DataprocWorkflowTemplatePlacementManagedCluster): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementManagedClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacementManagedCluster | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacementManagedCluster | undefined);
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _config;
    /**
     * @stability stable
     */
    get config(): DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference;
    /**
     * @stability stable
     */
    putConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfig): void;
    /**
     * @stability stable
     */
    get configInput(): DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplatePlacement {
    /**
     * cluster_selector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#cluster_selector DataprocWorkflowTemplate#cluster_selector}
     *
     * @stability stable
     */
    readonly clusterSelector?: DataprocWorkflowTemplatePlacementClusterSelector;
    /**
     * managed_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#managed_cluster DataprocWorkflowTemplate#managed_cluster}
     *
     * @stability stable
     */
    readonly managedCluster?: DataprocWorkflowTemplatePlacementManagedCluster;
}
export declare function dataprocWorkflowTemplatePlacementToTerraform(struct?: DataprocWorkflowTemplatePlacementOutputReference | DataprocWorkflowTemplatePlacement): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplatePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplatePlacement | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplatePlacement | undefined);
    private _clusterSelector;
    /**
     * @stability stable
     */
    get clusterSelector(): DataprocWorkflowTemplatePlacementClusterSelectorOutputReference;
    /**
     * @stability stable
     */
    putClusterSelector(value: DataprocWorkflowTemplatePlacementClusterSelector): void;
    /**
     * @stability stable
     */
    resetClusterSelector(): void;
    /**
     * @stability stable
     */
    get clusterSelectorInput(): DataprocWorkflowTemplatePlacementClusterSelector | undefined;
    private _managedCluster;
    /**
     * @stability stable
     */
    get managedCluster(): DataprocWorkflowTemplatePlacementManagedClusterOutputReference;
    /**
     * @stability stable
     */
    putManagedCluster(value: DataprocWorkflowTemplatePlacementManagedCluster): void;
    /**
     * @stability stable
     */
    resetManagedCluster(): void;
    /**
     * @stability stable
     */
    get managedClusterInput(): DataprocWorkflowTemplatePlacementManagedCluster | undefined;
}
/**
 * @stability stable
 */
export interface DataprocWorkflowTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#create DataprocWorkflowTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template#delete DataprocWorkflowTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function dataprocWorkflowTemplateTimeoutsToTerraform(struct?: DataprocWorkflowTemplateTimeoutsOutputReference | DataprocWorkflowTemplateTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataprocWorkflowTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataprocWorkflowTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataprocWorkflowTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template google_dataproc_workflow_template}.
 *
 * @stability stable
 */
export declare class DataprocWorkflowTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template google_dataproc_workflow_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataprocWorkflowTemplateConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _dagTimeout?;
    /**
     * @stability stable
     */
    get dagTimeout(): string;
    /**
     * @stability stable
     */
    set dagTimeout(value: string);
    /**
     * @stability stable
     */
    resetDagTimeout(): void;
    /**
     * @stability stable
     */
    get dagTimeoutInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _jobs?;
    /**
     * @stability stable
     */
    get jobs(): DataprocWorkflowTemplateJobs[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set jobs(value: DataprocWorkflowTemplateJobs[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get jobsInput(): cdktf.IResolvable | DataprocWorkflowTemplateJobs[] | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): DataprocWorkflowTemplateParameters[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: DataprocWorkflowTemplateParameters[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | DataprocWorkflowTemplateParameters[] | undefined;
    private _placement;
    /**
     * @stability stable
     */
    get placement(): DataprocWorkflowTemplatePlacementOutputReference;
    /**
     * @stability stable
     */
    putPlacement(value: DataprocWorkflowTemplatePlacement): void;
    /**
     * @stability stable
     */
    get placementInput(): DataprocWorkflowTemplatePlacement | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataprocWorkflowTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataprocWorkflowTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataprocWorkflowTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
