import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsManagedZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * A textual description field. Defaults to 'Managed by Terraform'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#description DnsManagedZone#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The DNS name of this managed zone, for instance "example.com.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#dns_name DnsManagedZone#dns_name}
     *
     * @stability stable
     */
    readonly dnsName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#force_destroy DnsManagedZone#force_destroy}.
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * A set of key/value label pairs to assign to this ManagedZone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#labels DnsManagedZone#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * User assigned name for this resource. Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#name DnsManagedZone#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#project DnsManagedZone#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The zone's visibility: public zones are exposed to the Internet, while private zones are visible only to Virtual Private Cloud resources.
     *
     * Default value: "public" Possible values: ["private", "public"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#visibility DnsManagedZone#visibility}
     *
     * @stability stable
     */
    readonly visibility?: string;
    /**
     * dnssec_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#dnssec_config DnsManagedZone#dnssec_config}
     *
     * @stability stable
     */
    readonly dnssecConfig?: DnsManagedZoneDnssecConfig;
    /**
     * forwarding_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#forwarding_config DnsManagedZone#forwarding_config}
     *
     * @stability stable
     */
    readonly forwardingConfig?: DnsManagedZoneForwardingConfig;
    /**
     * peering_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#peering_config DnsManagedZone#peering_config}
     *
     * @stability stable
     */
    readonly peeringConfig?: DnsManagedZonePeeringConfig;
    /**
     * private_visibility_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#private_visibility_config DnsManagedZone#private_visibility_config}
     *
     * @stability stable
     */
    readonly privateVisibilityConfig?: DnsManagedZonePrivateVisibilityConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#timeouts DnsManagedZone#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsManagedZoneTimeouts;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneDnssecConfigDefaultKeySpecs {
    /**
     * String mnemonic specifying the DNSSEC algorithm of this key Possible values: ["ecdsap256sha256", "ecdsap384sha384", "rsasha1", "rsasha256", "rsasha512"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#algorithm DnsManagedZone#algorithm}
     *
     * @stability stable
     */
    readonly algorithm?: string;
    /**
     * Length of the keys in bits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#key_length DnsManagedZone#key_length}
     *
     * @stability stable
     */
    readonly keyLength?: number;
    /**
     * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK).
     *
     * Key signing keys have the Secure Entry
     * Point flag set and, when active, will only be used to sign
     * resource record sets of type DNSKEY. Zone signing keys do
     * not have the Secure Entry Point flag set and will be used
     * to sign all other types of resource record sets. Possible values: ["keySigning", "zoneSigning"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#key_type DnsManagedZone#key_type}
     *
     * @stability stable
     */
    readonly keyType?: string;
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#kind DnsManagedZone#kind}
     *
     * @stability stable
     */
    readonly kind?: string;
}
export declare function dnsManagedZoneDnssecConfigDefaultKeySpecsToTerraform(struct?: DnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DnsManagedZoneDnssecConfig {
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#kind DnsManagedZone#kind}
     *
     * @stability stable
     */
    readonly kind?: string;
    /**
     * Specifies the mechanism used to provide authenticated denial-of-existence responses.
     *
     * non_existence can only be updated when the state is 'off'. Possible values: ["nsec", "nsec3"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#non_existence DnsManagedZone#non_existence}
     *
     * @stability stable
     */
    readonly nonExistence?: string;
    /**
     * Specifies whether DNSSEC is enabled, and what mode it is in Possible values: ["off", "on", "transfer"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#state DnsManagedZone#state}
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * default_key_specs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#default_key_specs DnsManagedZone#default_key_specs}
     *
     * @stability stable
     */
    readonly defaultKeySpecs?: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable;
}
export declare function dnsManagedZoneDnssecConfigToTerraform(struct?: DnsManagedZoneDnssecConfigOutputReference | DnsManagedZoneDnssecConfig): any;
/**
 * @stability stable
 */
export declare class DnsManagedZoneDnssecConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsManagedZoneDnssecConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsManagedZoneDnssecConfig | undefined);
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    resetKind(): void;
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _nonExistence?;
    /**
     * @stability stable
     */
    get nonExistence(): string;
    /**
     * @stability stable
     */
    set nonExistence(value: string);
    /**
     * @stability stable
     */
    resetNonExistence(): void;
    /**
     * @stability stable
     */
    get nonExistenceInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _defaultKeySpecs?;
    /**
     * @stability stable
     */
    get defaultKeySpecs(): DnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set defaultKeySpecs(value: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDefaultKeySpecs(): void;
    /**
     * @stability stable
     */
    get defaultKeySpecsInput(): cdktf.IResolvable | DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneForwardingConfigTargetNameServers {
    /**
     * Forwarding path for this TargetNameServer.
     *
     * If unset or 'default' Cloud DNS will make forwarding
     * decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
     * to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#forwarding_path DnsManagedZone#forwarding_path}
     *
     * @stability stable
     */
    readonly forwardingPath?: string;
    /**
     * IPv4 address of a target name server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#ipv4_address DnsManagedZone#ipv4_address}
     *
     * @stability stable
     */
    readonly ipv4Address: string;
}
export declare function dnsManagedZoneForwardingConfigTargetNameServersToTerraform(struct?: DnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DnsManagedZoneForwardingConfig {
    /**
     * target_name_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#target_name_servers DnsManagedZone#target_name_servers}
     *
     * @stability stable
     */
    readonly targetNameServers: DnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable;
}
export declare function dnsManagedZoneForwardingConfigToTerraform(struct?: DnsManagedZoneForwardingConfigOutputReference | DnsManagedZoneForwardingConfig): any;
/**
 * @stability stable
 */
export declare class DnsManagedZoneForwardingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsManagedZoneForwardingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsManagedZoneForwardingConfig | undefined);
    private _targetNameServers?;
    /**
     * @stability stable
     */
    get targetNameServers(): DnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set targetNameServers(value: DnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get targetNameServersInput(): cdktf.IResolvable | DnsManagedZoneForwardingConfigTargetNameServers[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePeeringConfigTargetNetwork {
    /**
     * The id or fully qualified URL of the VPC network to forward queries to.
     *
     * This should be formatted like 'projects/{project}/global/networks/{network}' or
     * 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#network_url DnsManagedZone#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
export declare function dnsManagedZonePeeringConfigTargetNetworkToTerraform(struct?: DnsManagedZonePeeringConfigTargetNetworkOutputReference | DnsManagedZonePeeringConfigTargetNetwork): any;
/**
 * @stability stable
 */
export declare class DnsManagedZonePeeringConfigTargetNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsManagedZonePeeringConfigTargetNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsManagedZonePeeringConfigTargetNetwork | undefined);
    private _networkUrl?;
    /**
     * @stability stable
     */
    get networkUrl(): string;
    /**
     * @stability stable
     */
    set networkUrl(value: string);
    /**
     * @stability stable
     */
    get networkUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePeeringConfig {
    /**
     * target_network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#target_network DnsManagedZone#target_network}
     *
     * @stability stable
     */
    readonly targetNetwork: DnsManagedZonePeeringConfigTargetNetwork;
}
export declare function dnsManagedZonePeeringConfigToTerraform(struct?: DnsManagedZonePeeringConfigOutputReference | DnsManagedZonePeeringConfig): any;
/**
 * @stability stable
 */
export declare class DnsManagedZonePeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsManagedZonePeeringConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsManagedZonePeeringConfig | undefined);
    private _targetNetwork;
    /**
     * @stability stable
     */
    get targetNetwork(): DnsManagedZonePeeringConfigTargetNetworkOutputReference;
    /**
     * @stability stable
     */
    putTargetNetwork(value: DnsManagedZonePeeringConfigTargetNetwork): void;
    /**
     * @stability stable
     */
    get targetNetworkInput(): DnsManagedZonePeeringConfigTargetNetwork | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePrivateVisibilityConfigNetworks {
    /**
     * The id or fully qualified URL of the VPC network to bind to. This should be formatted like 'projects/{project}/global/networks/{network}' or 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#network_url DnsManagedZone#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
export declare function dnsManagedZonePrivateVisibilityConfigNetworksToTerraform(struct?: DnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DnsManagedZonePrivateVisibilityConfig {
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#networks DnsManagedZone#networks}
     *
     * @stability stable
     */
    readonly networks: DnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable;
}
export declare function dnsManagedZonePrivateVisibilityConfigToTerraform(struct?: DnsManagedZonePrivateVisibilityConfigOutputReference | DnsManagedZonePrivateVisibilityConfig): any;
/**
 * @stability stable
 */
export declare class DnsManagedZonePrivateVisibilityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsManagedZonePrivateVisibilityConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsManagedZonePrivateVisibilityConfig | undefined);
    private _networks?;
    /**
     * @stability stable
     */
    get networks(): DnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set networks(value: DnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get networksInput(): cdktf.IResolvable | DnsManagedZonePrivateVisibilityConfigNetworks[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#create DnsManagedZone#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#delete DnsManagedZone#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#update DnsManagedZone#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dnsManagedZoneTimeoutsToTerraform(struct?: DnsManagedZoneTimeoutsOutputReference | DnsManagedZoneTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DnsManagedZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsManagedZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsManagedZoneTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone google_dns_managed_zone}.
 *
 * @stability stable
 */
export declare class DnsManagedZone extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone google_dns_managed_zone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsManagedZoneConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _dnsName?;
    /**
     * @stability stable
     */
    get dnsName(): string;
    /**
     * @stability stable
     */
    set dnsName(value: string);
    /**
     * @stability stable
     */
    get dnsNameInput(): string | undefined;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get nameServers(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    set visibility(value: string);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    private _dnssecConfig;
    /**
     * @stability stable
     */
    get dnssecConfig(): DnsManagedZoneDnssecConfigOutputReference;
    /**
     * @stability stable
     */
    putDnssecConfig(value: DnsManagedZoneDnssecConfig): void;
    /**
     * @stability stable
     */
    resetDnssecConfig(): void;
    /**
     * @stability stable
     */
    get dnssecConfigInput(): DnsManagedZoneDnssecConfig | undefined;
    private _forwardingConfig;
    /**
     * @stability stable
     */
    get forwardingConfig(): DnsManagedZoneForwardingConfigOutputReference;
    /**
     * @stability stable
     */
    putForwardingConfig(value: DnsManagedZoneForwardingConfig): void;
    /**
     * @stability stable
     */
    resetForwardingConfig(): void;
    /**
     * @stability stable
     */
    get forwardingConfigInput(): DnsManagedZoneForwardingConfig | undefined;
    private _peeringConfig;
    /**
     * @stability stable
     */
    get peeringConfig(): DnsManagedZonePeeringConfigOutputReference;
    /**
     * @stability stable
     */
    putPeeringConfig(value: DnsManagedZonePeeringConfig): void;
    /**
     * @stability stable
     */
    resetPeeringConfig(): void;
    /**
     * @stability stable
     */
    get peeringConfigInput(): DnsManagedZonePeeringConfig | undefined;
    private _privateVisibilityConfig;
    /**
     * @stability stable
     */
    get privateVisibilityConfig(): DnsManagedZonePrivateVisibilityConfigOutputReference;
    /**
     * @stability stable
     */
    putPrivateVisibilityConfig(value: DnsManagedZonePrivateVisibilityConfig): void;
    /**
     * @stability stable
     */
    resetPrivateVisibilityConfig(): void;
    /**
     * @stability stable
     */
    get privateVisibilityConfigInput(): DnsManagedZonePrivateVisibilityConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DnsManagedZoneTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsManagedZoneTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsManagedZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
