import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * How to combine the results of multiple conditions to determine if an incident should be opened.
     *
     * Possible values: ["AND", "OR", "AND_WITH_MATCHING_RESOURCE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#combiner MonitoringAlertPolicy#combiner}
     *
     * @stability stable
     */
    readonly combiner: string;
    /**
     * A short name or phrase used to identify the policy in dashboards, notifications, and incidents.
     *
     * To avoid confusion, don't use
     * the same display name for multiple policies in the same project. The
     * name is limited to 512 Unicode characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#display_name MonitoringAlertPolicy#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether or not the policy is enabled. The default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#enabled MonitoringAlertPolicy#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Identifies the notification channels to which notifications should be sent when incidents are opened or closed or when new violations occur on an already opened incident.
     *
     * Each element of this array corresponds
     * to the name field in each of the NotificationChannel objects that are
     * returned from the notificationChannels.list method. The syntax of the
     * entries in this field is
     * 'projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#notification_channels MonitoringAlertPolicy#notification_channels}
     *
     * @stability stable
     */
    readonly notificationChannels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#project MonitoringAlertPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This field is intended to be used for organizing and identifying the AlertPolicy objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#user_labels MonitoringAlertPolicy#user_labels}
     *
     * @stability stable
     */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
     * conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#conditions MonitoringAlertPolicy#conditions}
     *
     * @stability stable
     */
    readonly conditions: MonitoringAlertPolicyConditions[] | cdktf.IResolvable;
    /**
     * documentation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#documentation MonitoringAlertPolicy#documentation}
     *
     * @stability stable
     */
    readonly documentation?: MonitoringAlertPolicyDocumentation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#timeouts MonitoringAlertPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringAlertPolicyTimeouts;
}
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyCreationRecord extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mutateTime(): string;
    /**
     * @stability stable
     */
    get mutatedBy(): string;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionAbsentAggregations {
    /**
     * The alignment period for per-time series alignment.
     *
     * If present,
     * alignmentPeriod must be at least
     * 60 seconds. After per-time series
     * alignment, each time series will
     * contain data points only on the
     * period boundaries. If
     * perSeriesAligner is not specified
     * or equals ALIGN_NONE, then this
     * field is ignored. If
     * perSeriesAligner is specified and
     * does not equal ALIGN_NONE, then
     * this field must be defined;
     * otherwise an error is returned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#alignment_period MonitoringAlertPolicy#alignment_period}
     *
     * @stability stable
     */
    readonly alignmentPeriod?: string;
    /**
     * The approach to be used to combine time series.
     *
     * Not all reducer
     * functions may be applied to all
     * time series, depending on the
     * metric type and the value type of
     * the original time series.
     * Reduction may change the metric
     * type of value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
     *
     * @stability stable
     */
    readonly crossSeriesReducer?: string;
    /**
     * The set of fields to preserve when crossSeriesReducer is specified.
     *
     * The groupByFields determine how
     * the time series are partitioned
     * into subsets prior to applying the
     * aggregation function. Each subset
     * contains time series that have the
     * same value for each of the
     * grouping fields. Each individual
     * time series is a member of exactly
     * one subset. The crossSeriesReducer
     * is applied to each subset of time
     * series. It is not possible to
     * reduce across different resource
     * types, so this field implicitly
     * contains resource.type. Fields not
     * specified in groupByFields are
     * aggregated away. If groupByFields
     * is not specified and all the time
     * series have the same resource
     * type, then the time series are
     * aggregated into a single output
     * time series. If crossSeriesReducer
     * is not defined, this field is
     * ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#group_by_fields MonitoringAlertPolicy#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The approach to be used to align individual time series.
     *
     * Not all
     * alignment functions may be applied
     * to all time series, depending on
     * the metric type and value type of
     * the original time series.
     * Alignment may change the metric
     * type or the value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
     *
     * @stability stable
     */
    readonly perSeriesAligner?: string;
}
export declare function monitoringAlertPolicyConditionsConditionAbsentAggregationsToTerraform(struct?: MonitoringAlertPolicyConditionsConditionAbsentAggregations | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionAbsentTrigger {
    /**
     * The absolute number of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#count MonitoringAlertPolicy#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The percentage of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#percent MonitoringAlertPolicy#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
export declare function monitoringAlertPolicyConditionsConditionAbsentTriggerToTerraform(struct?: MonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference | MonitoringAlertPolicyConditionsConditionAbsentTrigger): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _percent?;
    /**
     * @stability stable
     */
    get percent(): number;
    /**
     * @stability stable
     */
    set percent(value: number);
    /**
     * @stability stable
     */
    resetPercent(): void;
    /**
     * @stability stable
     */
    get percentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionAbsent {
    /**
     * The amount of time that a time series must fail to report new data to be considered failing.
     *
     * Currently, only values that are a
     * multiple of a minute--e.g. 60s, 120s, or 300s
     * --are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#duration MonitoringAlertPolicy#duration}
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * A filter that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the MetricService.ListTimeSeries request (that call is useful to verify the time series that will be retrieved / processed) and must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#filter MonitoringAlertPolicy#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#aggregations MonitoringAlertPolicy#aggregations}
     *
     * @stability stable
     */
    readonly aggregations?: MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#trigger MonitoringAlertPolicy#trigger}
     *
     * @stability stable
     */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionAbsentTrigger;
}
export declare function monitoringAlertPolicyConditionsConditionAbsentToTerraform(struct?: MonitoringAlertPolicyConditionsConditionAbsentOutputReference | MonitoringAlertPolicyConditionsConditionAbsent): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyConditionsConditionAbsentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyConditionsConditionAbsent | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyConditionsConditionAbsent | undefined);
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    private _aggregations?;
    /**
     * @stability stable
     */
    get aggregations(): MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set aggregations(value: MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAggregations(): void;
    /**
     * @stability stable
     */
    get aggregationsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | undefined;
    private _trigger;
    /**
     * @stability stable
     */
    get trigger(): MonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference;
    /**
     * @stability stable
     */
    putTrigger(value: MonitoringAlertPolicyConditionsConditionAbsentTrigger): void;
    /**
     * @stability stable
     */
    resetTrigger(): void;
    /**
     * @stability stable
     */
    get triggerInput(): MonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger {
    /**
     * The absolute number of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#count MonitoringAlertPolicy#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The percentage of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#percent MonitoringAlertPolicy#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
export declare function monitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerToTerraform(struct?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference | MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _percent?;
    /**
     * @stability stable
     */
    get percent(): number;
    /**
     * @stability stable
     */
    set percent(value: number);
    /**
     * @stability stable
     */
    resetPercent(): void;
    /**
     * @stability stable
     */
    get percentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage {
    /**
     * The amount of time that a time series must violate the threshold to be considered failing.
     *
     * Currently, only values that are a
     * multiple of a minute--e.g., 0, 60, 120, or
     * 300 seconds--are supported. If an invalid
     * value is given, an error will be returned.
     * When choosing a duration, it is useful to
     * keep in mind the frequency of the underlying
     * time series data (which may also be affected
     * by any alignments specified in the
     * aggregations field); a good duration is long
     * enough so that a single outlier does not
     * generate spurious alerts, but short enough
     * that unhealthy states are detected and
     * alerted on quickly.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#duration MonitoringAlertPolicy#duration}
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * Monitoring Query Language query that outputs a boolean stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#query MonitoringAlertPolicy#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#trigger MonitoringAlertPolicy#trigger}
     *
     * @stability stable
     */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger;
}
export declare function monitoringAlertPolicyConditionsConditionMonitoringQueryLanguageToTerraform(struct?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference | MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined);
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _trigger;
    /**
     * @stability stable
     */
    get trigger(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference;
    /**
     * @stability stable
     */
    putTrigger(value: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): void;
    /**
     * @stability stable
     */
    resetTrigger(): void;
    /**
     * @stability stable
     */
    get triggerInput(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThresholdAggregations {
    /**
     * The alignment period for per-time series alignment.
     *
     * If present,
     * alignmentPeriod must be at least
     * 60 seconds. After per-time series
     * alignment, each time series will
     * contain data points only on the
     * period boundaries. If
     * perSeriesAligner is not specified
     * or equals ALIGN_NONE, then this
     * field is ignored. If
     * perSeriesAligner is specified and
     * does not equal ALIGN_NONE, then
     * this field must be defined;
     * otherwise an error is returned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#alignment_period MonitoringAlertPolicy#alignment_period}
     *
     * @stability stable
     */
    readonly alignmentPeriod?: string;
    /**
     * The approach to be used to combine time series.
     *
     * Not all reducer
     * functions may be applied to all
     * time series, depending on the
     * metric type and the value type of
     * the original time series.
     * Reduction may change the metric
     * type of value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
     *
     * @stability stable
     */
    readonly crossSeriesReducer?: string;
    /**
     * The set of fields to preserve when crossSeriesReducer is specified.
     *
     * The groupByFields determine how
     * the time series are partitioned
     * into subsets prior to applying the
     * aggregation function. Each subset
     * contains time series that have the
     * same value for each of the
     * grouping fields. Each individual
     * time series is a member of exactly
     * one subset. The crossSeriesReducer
     * is applied to each subset of time
     * series. It is not possible to
     * reduce across different resource
     * types, so this field implicitly
     * contains resource.type. Fields not
     * specified in groupByFields are
     * aggregated away. If groupByFields
     * is not specified and all the time
     * series have the same resource
     * type, then the time series are
     * aggregated into a single output
     * time series. If crossSeriesReducer
     * is not defined, this field is
     * ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#group_by_fields MonitoringAlertPolicy#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The approach to be used to align individual time series.
     *
     * Not all
     * alignment functions may be applied
     * to all time series, depending on
     * the metric type and value type of
     * the original time series.
     * Alignment may change the metric
     * type or the value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
     *
     * @stability stable
     */
    readonly perSeriesAligner?: string;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdAggregationsToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdAggregations | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations {
    /**
     * The alignment period for per-time series alignment.
     *
     * If present,
     * alignmentPeriod must be at least
     * 60 seconds. After per-time series
     * alignment, each time series will
     * contain data points only on the
     * period boundaries. If
     * perSeriesAligner is not specified
     * or equals ALIGN_NONE, then this
     * field is ignored. If
     * perSeriesAligner is specified and
     * does not equal ALIGN_NONE, then
     * this field must be defined;
     * otherwise an error is returned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#alignment_period MonitoringAlertPolicy#alignment_period}
     *
     * @stability stable
     */
    readonly alignmentPeriod?: string;
    /**
     * The approach to be used to combine time series.
     *
     * Not all reducer
     * functions may be applied to all
     * time series, depending on the
     * metric type and the value type of
     * the original time series.
     * Reduction may change the metric
     * type of value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
     *
     * @stability stable
     */
    readonly crossSeriesReducer?: string;
    /**
     * The set of fields to preserve when crossSeriesReducer is specified.
     *
     * The groupByFields determine how
     * the time series are partitioned
     * into subsets prior to applying the
     * aggregation function. Each subset
     * contains time series that have the
     * same value for each of the
     * grouping fields. Each individual
     * time series is a member of exactly
     * one subset. The crossSeriesReducer
     * is applied to each subset of time
     * series. It is not possible to
     * reduce across different resource
     * types, so this field implicitly
     * contains resource.type. Fields not
     * specified in groupByFields are
     * aggregated away. If groupByFields
     * is not specified and all the time
     * series have the same resource
     * type, then the time series are
     * aggregated into a single output
     * time series. If crossSeriesReducer
     * is not defined, this field is
     * ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#group_by_fields MonitoringAlertPolicy#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The approach to be used to align individual time series.
     *
     * Not all
     * alignment functions may be applied
     * to all time series, depending on
     * the metric type and value type of
     * the original time series.
     * Alignment may change the metric
     * type or the value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
     *
     * @stability stable
     */
    readonly perSeriesAligner?: string;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThresholdTrigger {
    /**
     * The absolute number of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#count MonitoringAlertPolicy#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The percentage of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#percent MonitoringAlertPolicy#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdTriggerToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference | MonitoringAlertPolicyConditionsConditionThresholdTrigger): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _percent?;
    /**
     * @stability stable
     */
    get percent(): number;
    /**
     * @stability stable
     */
    set percent(value: number);
    /**
     * @stability stable
     */
    resetPercent(): void;
    /**
     * @stability stable
     */
    get percentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThreshold {
    /**
     * The comparison to apply between the time series (indicated by filter and aggregation) and the threshold (indicated by threshold_value).
     *
     * The comparison is applied
     * on each time series, with the time series on
     * the left-hand side and the threshold on the
     * right-hand side. Only COMPARISON_LT and
     * COMPARISON_GT are supported currently. Possible values: ["COMPARISON_GT", "COMPARISON_GE", "COMPARISON_LT", "COMPARISON_LE", "COMPARISON_EQ", "COMPARISON_NE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#comparison MonitoringAlertPolicy#comparison}
     *
     * @stability stable
     */
    readonly comparison: string;
    /**
     * A filter that identifies a time series that should be used as the denominator of a ratio that will be compared with the threshold.
     *
     * If
     * a denominator_filter is specified, the time
     * series specified by the filter field will be
     * used as the numerator.The filter is similar
     * to the one that is specified in the
     * MetricService.ListTimeSeries request (that
     * call is useful to verify the time series
     * that will be retrieved / processed) and must
     * specify the metric type and optionally may
     * contain restrictions on resource type,
     * resource labels, and metric labels. This
     * field may not exceed 2048 Unicode characters
     * in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#denominator_filter MonitoringAlertPolicy#denominator_filter}
     *
     * @stability stable
     */
    readonly denominatorFilter?: string;
    /**
     * The amount of time that a time series must violate the threshold to be considered failing.
     *
     * Currently, only values that are a
     * multiple of a minute--e.g., 0, 60, 120, or
     * 300 seconds--are supported. If an invalid
     * value is given, an error will be returned.
     * When choosing a duration, it is useful to
     * keep in mind the frequency of the underlying
     * time series data (which may also be affected
     * by any alignments specified in the
     * aggregations field); a good duration is long
     * enough so that a single outlier does not
     * generate spurious alerts, but short enough
     * that unhealthy states are detected and
     * alerted on quickly.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#duration MonitoringAlertPolicy#duration}
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * A filter that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the MetricService.ListTimeSeries request (that call is useful to verify the time series that will be retrieved / processed) and must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#filter MonitoringAlertPolicy#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * A value against which to compare the time series.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#threshold_value MonitoringAlertPolicy#threshold_value}
     *
     * @stability stable
     */
    readonly thresholdValue?: number;
    /**
     * aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#aggregations MonitoringAlertPolicy#aggregations}
     *
     * @stability stable
     */
    readonly aggregations?: MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable;
    /**
     * denominator_aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#denominator_aggregations MonitoringAlertPolicy#denominator_aggregations}
     *
     * @stability stable
     */
    readonly denominatorAggregations?: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#trigger MonitoringAlertPolicy#trigger}
     *
     * @stability stable
     */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionThresholdTrigger;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdOutputReference | MonitoringAlertPolicyConditionsConditionThreshold): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyConditionsConditionThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyConditionsConditionThreshold | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyConditionsConditionThreshold | undefined);
    private _comparison?;
    /**
     * @stability stable
     */
    get comparison(): string;
    /**
     * @stability stable
     */
    set comparison(value: string);
    /**
     * @stability stable
     */
    get comparisonInput(): string | undefined;
    private _denominatorFilter?;
    /**
     * @stability stable
     */
    get denominatorFilter(): string;
    /**
     * @stability stable
     */
    set denominatorFilter(value: string);
    /**
     * @stability stable
     */
    resetDenominatorFilter(): void;
    /**
     * @stability stable
     */
    get denominatorFilterInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    private _thresholdValue?;
    /**
     * @stability stable
     */
    get thresholdValue(): number;
    /**
     * @stability stable
     */
    set thresholdValue(value: number);
    /**
     * @stability stable
     */
    resetThresholdValue(): void;
    /**
     * @stability stable
     */
    get thresholdValueInput(): number | undefined;
    private _aggregations?;
    /**
     * @stability stable
     */
    get aggregations(): MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set aggregations(value: MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAggregations(): void;
    /**
     * @stability stable
     */
    get aggregationsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | undefined;
    private _denominatorAggregations?;
    /**
     * @stability stable
     */
    get denominatorAggregations(): MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set denominatorAggregations(value: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDenominatorAggregations(): void;
    /**
     * @stability stable
     */
    get denominatorAggregationsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | undefined;
    private _trigger;
    /**
     * @stability stable
     */
    get trigger(): MonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference;
    /**
     * @stability stable
     */
    putTrigger(value: MonitoringAlertPolicyConditionsConditionThresholdTrigger): void;
    /**
     * @stability stable
     */
    resetTrigger(): void;
    /**
     * @stability stable
     */
    get triggerInput(): MonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditions {
    /**
     * A short name or phrase used to identify the condition in dashboards, notifications, and incidents.
     *
     * To avoid confusion, don't use the same
     * display name for multiple conditions in the same
     * policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#display_name MonitoringAlertPolicy#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * condition_absent block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#condition_absent MonitoringAlertPolicy#condition_absent}
     *
     * @stability stable
     */
    readonly conditionAbsent?: MonitoringAlertPolicyConditionsConditionAbsent;
    /**
     * condition_monitoring_query_language block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#condition_monitoring_query_language MonitoringAlertPolicy#condition_monitoring_query_language}
     *
     * @stability stable
     */
    readonly conditionMonitoringQueryLanguage?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage;
    /**
     * condition_threshold block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#condition_threshold MonitoringAlertPolicy#condition_threshold}
     *
     * @stability stable
     */
    readonly conditionThreshold?: MonitoringAlertPolicyConditionsConditionThreshold;
}
export declare function monitoringAlertPolicyConditionsToTerraform(struct?: MonitoringAlertPolicyConditions | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyDocumentation {
    /**
     * The text of the documentation, interpreted according to mimeType.
     *
     * The content may not exceed 8,192 Unicode characters and may not
     * exceed more than 10,240 bytes when encoded in UTF-8 format,
     * whichever is smaller.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#content MonitoringAlertPolicy#content}
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * The format of the content field. Presently, only the value "text/markdown" is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#mime_type MonitoringAlertPolicy#mime_type}
     *
     * @stability stable
     */
    readonly mimeType?: string;
}
export declare function monitoringAlertPolicyDocumentationToTerraform(struct?: MonitoringAlertPolicyDocumentationOutputReference | MonitoringAlertPolicyDocumentation): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyDocumentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyDocumentation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyDocumentation | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _mimeType?;
    /**
     * @stability stable
     */
    get mimeType(): string;
    /**
     * @stability stable
     */
    set mimeType(value: string);
    /**
     * @stability stable
     */
    resetMimeType(): void;
    /**
     * @stability stable
     */
    get mimeTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#create MonitoringAlertPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#delete MonitoringAlertPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#update MonitoringAlertPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitoringAlertPolicyTimeoutsToTerraform(struct?: MonitoringAlertPolicyTimeoutsOutputReference | MonitoringAlertPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringAlertPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringAlertPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy google_monitoring_alert_policy}.
 *
 * @stability stable
 */
export declare class MonitoringAlertPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy google_monitoring_alert_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringAlertPolicyConfig);
    private _combiner?;
    /**
     * @stability stable
     */
    get combiner(): string;
    /**
     * @stability stable
     */
    set combiner(value: string);
    /**
     * @stability stable
     */
    get combinerInput(): string | undefined;
    /**
     * @stability stable
     */
    creationRecord(index: string): MonitoringAlertPolicyCreationRecord;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationChannels?;
    /**
     * @stability stable
     */
    get notificationChannels(): string[];
    /**
     * @stability stable
     */
    set notificationChannels(value: string[]);
    /**
     * @stability stable
     */
    resetNotificationChannels(): void;
    /**
     * @stability stable
     */
    get notificationChannelsInput(): string[] | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _userLabels?;
    /**
     * @stability stable
     */
    get userLabels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set userLabels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetUserLabels(): void;
    /**
     * @stability stable
     */
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _conditions?;
    /**
     * @stability stable
     */
    get conditions(): MonitoringAlertPolicyConditions[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set conditions(value: MonitoringAlertPolicyConditions[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get conditionsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditions[] | undefined;
    private _documentation;
    /**
     * @stability stable
     */
    get documentation(): MonitoringAlertPolicyDocumentationOutputReference;
    /**
     * @stability stable
     */
    putDocumentation(value: MonitoringAlertPolicyDocumentation): void;
    /**
     * @stability stable
     */
    resetDocumentation(): void;
    /**
     * @stability stable
     */
    get documentationInput(): MonitoringAlertPolicyDocumentation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringAlertPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringAlertPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringAlertPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
