import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringMetricDescriptorConfig extends cdktf.TerraformMetaArguments {
    /**
     * A detailed description of the metric, which can be used in documentation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#description MonitoringMetricDescriptor#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     *
     * Use sentence case without an ending period, for example "Request count".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#display_name MonitoringMetricDescriptor#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The launch stage of the metric definition. Possible values: ["LAUNCH_STAGE_UNSPECIFIED", "UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#launch_stage MonitoringMetricDescriptor#launch_stage}
     *
     * @stability stable
     */
    readonly launchStage?: string;
    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     *
     * Some combinations of metricKind and valueType might not be supported. Possible values: ["METRIC_KIND_UNSPECIFIED", "GAUGE", "DELTA", "CUMULATIVE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#metric_kind MonitoringMetricDescriptor#metric_kind}
     *
     * @stability stable
     */
    readonly metricKind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#project MonitoringMetricDescriptor#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The metric type, including its DNS name prefix.
     *
     * The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#type MonitoringMetricDescriptor#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * The units in which the metric value is reported.
     *
     * It is only applicable if the
     * valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
     * the stored metric values.
     *
     * Different systems may scale the values to be more easily displayed (so a value of
     * 0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
     * 3.5MBy). However, if the unit is KBy, then the value of the metric is always in
     * thousands of bytes, no matter how it may be displayed.
     *
     * If you want a custom metric to record the exact number of CPU-seconds used by a job,
     * you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
     * 1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
     * 12005.
     *
     * Alternatively, if you want a custom metric to record data in a more granular way, you
     * can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
     * 12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
     * The supported units are a subset of The Unified Code for Units of Measure standard.
     * More info can be found in the API documentation
     * (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#unit MonitoringMetricDescriptor#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     *
     * Some combinations of metricKind and valueType might not be supported. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#value_type MonitoringMetricDescriptor#value_type}
     *
     * @stability stable
     */
    readonly valueType: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#labels MonitoringMetricDescriptor#labels}
     *
     * @stability stable
     */
    readonly labels?: MonitoringMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#metadata MonitoringMetricDescriptor#metadata}
     *
     * @stability stable
     */
    readonly metadata?: MonitoringMetricDescriptorMetadata;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#timeouts MonitoringMetricDescriptor#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringMetricDescriptorTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringMetricDescriptorLabels {
    /**
     * A human-readable description for the label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#description MonitoringMetricDescriptor#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The key for this label.
     *
     * The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#key MonitoringMetricDescriptor#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["STRING", "BOOL", "INT64"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#value_type MonitoringMetricDescriptor#value_type}
     *
     * @stability stable
     */
    readonly valueType?: string;
}
export declare function monitoringMetricDescriptorLabelsToTerraform(struct?: MonitoringMetricDescriptorLabels | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MonitoringMetricDescriptorMetadata {
    /**
     * The delay of data points caused by ingestion.
     *
     * Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In '[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#ingest_delay MonitoringMetricDescriptor#ingest_delay}
     *
     * @stability stable
     */
    readonly ingestDelay?: string;
    /**
     * The sampling period of metric data points.
     *
     * For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In '[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#sample_period MonitoringMetricDescriptor#sample_period}
     *
     * @stability stable
     */
    readonly samplePeriod?: string;
}
export declare function monitoringMetricDescriptorMetadataToTerraform(struct?: MonitoringMetricDescriptorMetadataOutputReference | MonitoringMetricDescriptorMetadata): any;
/**
 * @stability stable
 */
export declare class MonitoringMetricDescriptorMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringMetricDescriptorMetadata | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringMetricDescriptorMetadata | undefined);
    private _ingestDelay?;
    /**
     * @stability stable
     */
    get ingestDelay(): string;
    /**
     * @stability stable
     */
    set ingestDelay(value: string);
    /**
     * @stability stable
     */
    resetIngestDelay(): void;
    /**
     * @stability stable
     */
    get ingestDelayInput(): string | undefined;
    private _samplePeriod?;
    /**
     * @stability stable
     */
    get samplePeriod(): string;
    /**
     * @stability stable
     */
    set samplePeriod(value: string);
    /**
     * @stability stable
     */
    resetSamplePeriod(): void;
    /**
     * @stability stable
     */
    get samplePeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringMetricDescriptorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#create MonitoringMetricDescriptor#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#delete MonitoringMetricDescriptor#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#update MonitoringMetricDescriptor#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitoringMetricDescriptorTimeoutsToTerraform(struct?: MonitoringMetricDescriptorTimeoutsOutputReference | MonitoringMetricDescriptorTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitoringMetricDescriptorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringMetricDescriptorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringMetricDescriptorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor google_monitoring_metric_descriptor}.
 *
 * @stability stable
 */
export declare class MonitoringMetricDescriptor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor google_monitoring_metric_descriptor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringMetricDescriptorConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _launchStage?;
    /**
     * @stability stable
     */
    get launchStage(): string;
    /**
     * @stability stable
     */
    set launchStage(value: string);
    /**
     * @stability stable
     */
    resetLaunchStage(): void;
    /**
     * @stability stable
     */
    get launchStageInput(): string | undefined;
    private _metricKind?;
    /**
     * @stability stable
     */
    get metricKind(): string;
    /**
     * @stability stable
     */
    set metricKind(value: string);
    /**
     * @stability stable
     */
    get metricKindInput(): string | undefined;
    /**
     * @stability stable
     */
    get monitoredResourceTypes(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string;
    /**
     * @stability stable
     */
    set unit(value: string);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
    private _valueType?;
    /**
     * @stability stable
     */
    get valueType(): string;
    /**
     * @stability stable
     */
    set valueType(value: string);
    /**
     * @stability stable
     */
    get valueTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): MonitoringMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: MonitoringMetricDescriptorLabels[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | MonitoringMetricDescriptorLabels[] | undefined;
    private _metadata;
    /**
     * @stability stable
     */
    get metadata(): MonitoringMetricDescriptorMetadataOutputReference;
    /**
     * @stability stable
     */
    putMetadata(value: MonitoringMetricDescriptorMetadata): void;
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): MonitoringMetricDescriptorMetadata | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringMetricDescriptorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringMetricDescriptorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringMetricDescriptorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
