import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringSloConfig extends cdktf.TerraformMetaArguments {
    /**
     * A calendar period, semantically "since the start of the current <calendarPeriod>". Possible values: ["DAY", "WEEK", "FORTNIGHT", "MONTH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#calendar_period MonitoringSlo#calendar_period}
     *
     * @stability stable
     */
    readonly calendarPeriod?: string;
    /**
     * Name used for UI elements listing this SLO.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#display_name MonitoringSlo#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The fraction of service that must be good in order for this objective to be met.
     *
     * 0 < goal <= 0.999
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#goal MonitoringSlo#goal}
     *
     * @stability stable
     */
    readonly goal: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#project MonitoringSlo#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A rolling time period, semantically "in the past X days". Must be between 1 to 30 days, inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#rolling_period_days MonitoringSlo#rolling_period_days}
     *
     * @stability stable
     */
    readonly rollingPeriodDays?: number;
    /**
     * ID of the service to which this SLO belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#service MonitoringSlo#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#slo_id MonitoringSlo#slo_id}
     *
     * @stability stable
     */
    readonly sloId?: string;
    /**
     * basic_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#basic_sli MonitoringSlo#basic_sli}
     *
     * @stability stable
     */
    readonly basicSli?: MonitoringSloBasicSli;
    /**
     * request_based_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#request_based_sli MonitoringSlo#request_based_sli}
     *
     * @stability stable
     */
    readonly requestBasedSli?: MonitoringSloRequestBasedSli;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#timeouts MonitoringSlo#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringSloTimeouts;
    /**
     * windows_based_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#windows_based_sli MonitoringSlo#windows_based_sli}
     *
     * @stability stable
     */
    readonly windowsBasedSli?: MonitoringSloWindowsBasedSli;
}
/**
 * @stability stable
 */
export interface MonitoringSloBasicSliAvailability {
    /**
     * Whether an availability SLI is enabled or not. Must be set to true. Defaults to 'true'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#enabled MonitoringSlo#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitoringSloBasicSliAvailabilityToTerraform(struct?: MonitoringSloBasicSliAvailabilityOutputReference | MonitoringSloBasicSliAvailability): any;
/**
 * @stability stable
 */
export declare class MonitoringSloBasicSliAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloBasicSliAvailability | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloBasicSliAvailability | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloBasicSliLatency {
    /**
     * A duration string, e.g. 10s. Good service is defined to be the count of requests made to this service that return in no more than threshold.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#threshold MonitoringSlo#threshold}
     *
     * @stability stable
     */
    readonly threshold: string;
}
export declare function monitoringSloBasicSliLatencyToTerraform(struct?: MonitoringSloBasicSliLatencyOutputReference | MonitoringSloBasicSliLatency): any;
/**
 * @stability stable
 */
export declare class MonitoringSloBasicSliLatencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloBasicSliLatency | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloBasicSliLatency | undefined);
    private _threshold?;
    /**
     * @stability stable
     */
    get threshold(): string;
    /**
     * @stability stable
     */
    set threshold(value: string);
    /**
     * @stability stable
     */
    get thresholdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloBasicSli {
    /**
     * An optional set of locations to which this SLI is relevant.
     *
     * Telemetry from other locations will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * locations in which the Service has activity. For service types
     * that don't support breaking down by location, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#location MonitoringSlo#location}
     *
     * @stability stable
     */
    readonly location?: string[];
    /**
     * An optional set of RPCs to which this SLI is relevant.
     *
     * Telemetry from other methods will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * the Service's methods. For service types that don't support
     * breaking down by method, setting this field will result in an
     * error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#method MonitoringSlo#method}
     *
     * @stability stable
     */
    readonly method?: string[];
    /**
     * The set of API versions to which this SLI is relevant.
     *
     * Telemetry from other API versions will not be used to
     * calculate performance for this SLI. If omitted,
     * this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#version MonitoringSlo#version}
     *
     * @stability stable
     */
    readonly version?: string[];
    /**
     * availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#availability MonitoringSlo#availability}
     *
     * @stability stable
     */
    readonly availability?: MonitoringSloBasicSliAvailability;
    /**
     * latency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#latency MonitoringSlo#latency}
     *
     * @stability stable
     */
    readonly latency?: MonitoringSloBasicSliLatency;
}
export declare function monitoringSloBasicSliToTerraform(struct?: MonitoringSloBasicSliOutputReference | MonitoringSloBasicSli): any;
/**
 * @stability stable
 */
export declare class MonitoringSloBasicSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloBasicSli | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloBasicSli | undefined);
    private _location?;
    /**
     * @stability stable
     */
    get location(): string[];
    /**
     * @stability stable
     */
    set location(value: string[]);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string[] | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string[];
    /**
     * @stability stable
     */
    set method(value: string[]);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string[] | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string[];
    /**
     * @stability stable
     */
    set version(value: string[]);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string[] | undefined;
    private _availability;
    /**
     * @stability stable
     */
    get availability(): MonitoringSloBasicSliAvailabilityOutputReference;
    /**
     * @stability stable
     */
    putAvailability(value: MonitoringSloBasicSliAvailability): void;
    /**
     * @stability stable
     */
    resetAvailability(): void;
    /**
     * @stability stable
     */
    get availabilityInput(): MonitoringSloBasicSliAvailability | undefined;
    private _latency;
    /**
     * @stability stable
     */
    get latency(): MonitoringSloBasicSliLatencyOutputReference;
    /**
     * @stability stable
     */
    putLatency(value: MonitoringSloBasicSliLatency): void;
    /**
     * @stability stable
     */
    resetLatency(): void;
    /**
     * @stability stable
     */
    get latencyInput(): MonitoringSloBasicSliLatency | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSliDistributionCutRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
export declare function monitoringSloRequestBasedSliDistributionCutRangeToTerraform(struct?: MonitoringSloRequestBasedSliDistributionCutRangeOutputReference | MonitoringSloRequestBasedSliDistributionCutRange): any;
/**
 * @stability stable
 */
export declare class MonitoringSloRequestBasedSliDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloRequestBasedSliDistributionCutRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloRequestBasedSliDistributionCutRange | undefined);
    private _max?;
    /**
     * @stability stable
     */
    get max(): number;
    /**
     * @stability stable
     */
    set max(value: number);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): number | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): number;
    /**
     * @stability stable
     */
    set min(value: number);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSliDistributionCut {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) aggregating values to quantify the good service provided.
     *
     * Must have ValueType = DISTRIBUTION and
     * MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_filter MonitoringSlo#distribution_filter}
     *
     * @stability stable
     */
    readonly distributionFilter: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloRequestBasedSliDistributionCutRange;
}
export declare function monitoringSloRequestBasedSliDistributionCutToTerraform(struct?: MonitoringSloRequestBasedSliDistributionCutOutputReference | MonitoringSloRequestBasedSliDistributionCut): any;
/**
 * @stability stable
 */
export declare class MonitoringSloRequestBasedSliDistributionCutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloRequestBasedSliDistributionCut | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloRequestBasedSliDistributionCut | undefined);
    private _distributionFilter?;
    /**
     * @stability stable
     */
    get distributionFilter(): string;
    /**
     * @stability stable
     */
    set distributionFilter(value: string);
    /**
     * @stability stable
     */
    get distributionFilterInput(): string | undefined;
    private _range;
    /**
     * @stability stable
     */
    get range(): MonitoringSloRequestBasedSliDistributionCutRangeOutputReference;
    /**
     * @stability stable
     */
    putRange(value: MonitoringSloRequestBasedSliDistributionCutRange): void;
    /**
     * @stability stable
     */
    get rangeInput(): MonitoringSloRequestBasedSliDistributionCutRange | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSliGoodTotalRatio {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying bad service provided, either demanded service that was not provided or demanded service that was of inadequate quality.
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#bad_service_filter MonitoringSlo#bad_service_filter}
     *
     * @stability stable
     */
    readonly badServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_service_filter MonitoringSlo#good_service_filter}
     *
     * @stability stable
     */
    readonly goodServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying total demanded service.
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#total_service_filter MonitoringSlo#total_service_filter}
     *
     * @stability stable
     */
    readonly totalServiceFilter?: string;
}
export declare function monitoringSloRequestBasedSliGoodTotalRatioToTerraform(struct?: MonitoringSloRequestBasedSliGoodTotalRatioOutputReference | MonitoringSloRequestBasedSliGoodTotalRatio): any;
/**
 * @stability stable
 */
export declare class MonitoringSloRequestBasedSliGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloRequestBasedSliGoodTotalRatio | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloRequestBasedSliGoodTotalRatio | undefined);
    private _badServiceFilter?;
    /**
     * @stability stable
     */
    get badServiceFilter(): string;
    /**
     * @stability stable
     */
    set badServiceFilter(value: string);
    /**
     * @stability stable
     */
    resetBadServiceFilter(): void;
    /**
     * @stability stable
     */
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    /**
     * @stability stable
     */
    get goodServiceFilter(): string;
    /**
     * @stability stable
     */
    set goodServiceFilter(value: string);
    /**
     * @stability stable
     */
    resetGoodServiceFilter(): void;
    /**
     * @stability stable
     */
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    /**
     * @stability stable
     */
    get totalServiceFilter(): string;
    /**
     * @stability stable
     */
    set totalServiceFilter(value: string);
    /**
     * @stability stable
     */
    resetTotalServiceFilter(): void;
    /**
     * @stability stable
     */
    get totalServiceFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSli {
    /**
     * distribution_cut block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_cut MonitoringSlo#distribution_cut}
     *
     * @stability stable
     */
    readonly distributionCut?: MonitoringSloRequestBasedSliDistributionCut;
    /**
     * good_total_ratio block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_total_ratio MonitoringSlo#good_total_ratio}
     *
     * @stability stable
     */
    readonly goodTotalRatio?: MonitoringSloRequestBasedSliGoodTotalRatio;
}
export declare function monitoringSloRequestBasedSliToTerraform(struct?: MonitoringSloRequestBasedSliOutputReference | MonitoringSloRequestBasedSli): any;
/**
 * @stability stable
 */
export declare class MonitoringSloRequestBasedSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloRequestBasedSli | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloRequestBasedSli | undefined);
    private _distributionCut;
    /**
     * @stability stable
     */
    get distributionCut(): MonitoringSloRequestBasedSliDistributionCutOutputReference;
    /**
     * @stability stable
     */
    putDistributionCut(value: MonitoringSloRequestBasedSliDistributionCut): void;
    /**
     * @stability stable
     */
    resetDistributionCut(): void;
    /**
     * @stability stable
     */
    get distributionCutInput(): MonitoringSloRequestBasedSliDistributionCut | undefined;
    private _goodTotalRatio;
    /**
     * @stability stable
     */
    get goodTotalRatio(): MonitoringSloRequestBasedSliGoodTotalRatioOutputReference;
    /**
     * @stability stable
     */
    putGoodTotalRatio(value: MonitoringSloRequestBasedSliGoodTotalRatio): void;
    /**
     * @stability stable
     */
    resetGoodTotalRatio(): void;
    /**
     * @stability stable
     */
    get goodTotalRatioInput(): MonitoringSloRequestBasedSliGoodTotalRatio | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#create MonitoringSlo#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#delete MonitoringSlo#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#update MonitoringSlo#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitoringSloTimeoutsToTerraform(struct?: MonitoringSloTimeoutsOutputReference | MonitoringSloTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitoringSloTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability {
    /**
     * Whether an availability SLI is enabled or not. Must be set to 'true. Defaults to 'true'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#enabled MonitoringSlo#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency {
    /**
     * A duration string, e.g. 10s. Good service is defined to be the count of requests made to this service that return in no more than threshold.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#threshold MonitoringSlo#threshold}
     *
     * @stability stable
     */
    readonly threshold: string;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined);
    private _threshold?;
    /**
     * @stability stable
     */
    get threshold(): string;
    /**
     * @stability stable
     */
    set threshold(value: string);
    /**
     * @stability stable
     */
    get thresholdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance {
    /**
     * An optional set of locations to which this SLI is relevant.
     *
     * Telemetry from other locations will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * locations in which the Service has activity. For service types
     * that don't support breaking down by location, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#location MonitoringSlo#location}
     *
     * @stability stable
     */
    readonly location?: string[];
    /**
     * An optional set of RPCs to which this SLI is relevant.
     *
     * Telemetry from other methods will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * the Service's methods. For service types that don't support
     * breaking down by method, setting this field will result in an
     * error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#method MonitoringSlo#method}
     *
     * @stability stable
     */
    readonly method?: string[];
    /**
     * The set of API versions to which this SLI is relevant.
     *
     * Telemetry from other API versions will not be used to
     * calculate performance for this SLI. If omitted,
     * this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#version MonitoringSlo#version}
     *
     * @stability stable
     */
    readonly version?: string[];
    /**
     * availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#availability MonitoringSlo#availability}
     *
     * @stability stable
     */
    readonly availability?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability;
    /**
     * latency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#latency MonitoringSlo#latency}
     *
     * @stability stable
     */
    readonly latency?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined);
    private _location?;
    /**
     * @stability stable
     */
    get location(): string[];
    /**
     * @stability stable
     */
    set location(value: string[]);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string[] | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string[];
    /**
     * @stability stable
     */
    set method(value: string[]);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string[] | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string[];
    /**
     * @stability stable
     */
    set version(value: string[]);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string[] | undefined;
    private _availability;
    /**
     * @stability stable
     */
    get availability(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference;
    /**
     * @stability stable
     */
    putAvailability(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability): void;
    /**
     * @stability stable
     */
    resetAvailability(): void;
    /**
     * @stability stable
     */
    get availabilityInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    private _latency;
    /**
     * @stability stable
     */
    get latency(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference;
    /**
     * @stability stable
     */
    putLatency(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency): void;
    /**
     * @stability stable
     */
    resetLatency(): void;
    /**
     * @stability stable
     */
    get latencyInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined);
    private _max?;
    /**
     * @stability stable
     */
    get max(): number;
    /**
     * @stability stable
     */
    set max(value: number);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): number | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): number;
    /**
     * @stability stable
     */
    set min(value: number);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) aggregating values to quantify the good service provided.
     *
     * Must have ValueType = DISTRIBUTION and
     * MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_filter MonitoringSlo#distribution_filter}
     *
     * @stability stable
     */
    readonly distributionFilter: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined);
    private _distributionFilter?;
    /**
     * @stability stable
     */
    get distributionFilter(): string;
    /**
     * @stability stable
     */
    set distributionFilter(value: string);
    /**
     * @stability stable
     */
    get distributionFilterInput(): string | undefined;
    private _range;
    /**
     * @stability stable
     */
    get range(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference;
    /**
     * @stability stable
     */
    putRange(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): void;
    /**
     * @stability stable
     */
    get rangeInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying bad service provided, either demanded service that was not provided or demanded service that was of inadequate quality. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#bad_service_filter MonitoringSlo#bad_service_filter}
     *
     * @stability stable
     */
    readonly badServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying good service provided. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_service_filter MonitoringSlo#good_service_filter}
     *
     * @stability stable
     */
    readonly goodServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying total demanded service. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#total_service_filter MonitoringSlo#total_service_filter}
     *
     * @stability stable
     */
    readonly totalServiceFilter?: string;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined);
    private _badServiceFilter?;
    /**
     * @stability stable
     */
    get badServiceFilter(): string;
    /**
     * @stability stable
     */
    set badServiceFilter(value: string);
    /**
     * @stability stable
     */
    resetBadServiceFilter(): void;
    /**
     * @stability stable
     */
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    /**
     * @stability stable
     */
    get goodServiceFilter(): string;
    /**
     * @stability stable
     */
    set goodServiceFilter(value: string);
    /**
     * @stability stable
     */
    resetGoodServiceFilter(): void;
    /**
     * @stability stable
     */
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    /**
     * @stability stable
     */
    get totalServiceFilter(): string;
    /**
     * @stability stable
     */
    set totalServiceFilter(value: string);
    /**
     * @stability stable
     */
    resetTotalServiceFilter(): void;
    /**
     * @stability stable
     */
    get totalServiceFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance {
    /**
     * distribution_cut block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_cut MonitoringSlo#distribution_cut}
     *
     * @stability stable
     */
    readonly distributionCut?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut;
    /**
     * good_total_ratio block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_total_ratio MonitoringSlo#good_total_ratio}
     *
     * @stability stable
     */
    readonly goodTotalRatio?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined);
    private _distributionCut;
    /**
     * @stability stable
     */
    get distributionCut(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference;
    /**
     * @stability stable
     */
    putDistributionCut(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut): void;
    /**
     * @stability stable
     */
    resetDistributionCut(): void;
    /**
     * @stability stable
     */
    get distributionCutInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    private _goodTotalRatio;
    /**
     * @stability stable
     */
    get goodTotalRatio(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference;
    /**
     * @stability stable
     */
    putGoodTotalRatio(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio): void;
    /**
     * @stability stable
     */
    resetGoodTotalRatio(): void;
    /**
     * @stability stable
     */
    get goodTotalRatioInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThreshold {
    /**
     * If window performance >= threshold, the window is counted as good.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#threshold MonitoringSlo#threshold}
     *
     * @stability stable
     */
    readonly threshold?: number;
    /**
     * basic_sli_performance block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#basic_sli_performance MonitoringSlo#basic_sli_performance}
     *
     * @stability stable
     */
    readonly basicSliPerformance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance;
    /**
     * performance block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#performance MonitoringSlo#performance}
     *
     * @stability stable
     */
    readonly performance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThreshold): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined);
    private _threshold?;
    /**
     * @stability stable
     */
    get threshold(): number;
    /**
     * @stability stable
     */
    set threshold(value: number);
    /**
     * @stability stable
     */
    resetThreshold(): void;
    /**
     * @stability stable
     */
    get thresholdInput(): number | undefined;
    private _basicSliPerformance;
    /**
     * @stability stable
     */
    get basicSliPerformance(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference;
    /**
     * @stability stable
     */
    putBasicSliPerformance(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance): void;
    /**
     * @stability stable
     */
    resetBasicSliPerformance(): void;
    /**
     * @stability stable
     */
    get basicSliPerformanceInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    private _performance;
    /**
     * @stability stable
     */
    get performance(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference;
    /**
     * @stability stable
     */
    putPerformance(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance): void;
    /**
     * @stability stable
     */
    resetPerformance(): void;
    /**
     * @stability stable
     */
    get performanceInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricMeanInRangeRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
export declare function monitoringSloWindowsBasedSliMetricMeanInRangeRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference | MonitoringSloWindowsBasedSliMetricMeanInRangeRange): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined);
    private _max?;
    /**
     * @stability stable
     */
    get max(): number;
    /**
     * @stability stable
     */
    set max(value: number);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): number | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): number;
    /**
     * @stability stable
     */
    set min(value: number);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricMeanInRange {
    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE. Mean value 'X' should satisfy 'range.min <= X <= range.max' under good service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#time_series MonitoringSlo#time_series}
     *
     * @stability stable
     */
    readonly timeSeries: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloWindowsBasedSliMetricMeanInRangeRange;
}
export declare function monitoringSloWindowsBasedSliMetricMeanInRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference | MonitoringSloWindowsBasedSliMetricMeanInRange): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliMetricMeanInRange | undefined);
    private _timeSeries?;
    /**
     * @stability stable
     */
    get timeSeries(): string;
    /**
     * @stability stable
     */
    set timeSeries(value: string);
    /**
     * @stability stable
     */
    get timeSeriesInput(): string | undefined;
    private _range;
    /**
     * @stability stable
     */
    get range(): MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference;
    /**
     * @stability stable
     */
    putRange(value: MonitoringSloWindowsBasedSliMetricMeanInRangeRange): void;
    /**
     * @stability stable
     */
    get rangeInput(): MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricSumInRangeRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
export declare function monitoringSloWindowsBasedSliMetricSumInRangeRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference | MonitoringSloWindowsBasedSliMetricSumInRangeRange): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined);
    private _max?;
    /**
     * @stability stable
     */
    get max(): number;
    /**
     * @stability stable
     */
    set max(value: number);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): number | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): number;
    /**
     * @stability stable
     */
    set min(value: number);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricSumInRange {
    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality. The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE.
     *
     * Summed value 'X' should satisfy
     * 'range.min <= X <= range.max' for a good window.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#time_series MonitoringSlo#time_series}
     *
     * @stability stable
     */
    readonly timeSeries: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloWindowsBasedSliMetricSumInRangeRange;
}
export declare function monitoringSloWindowsBasedSliMetricSumInRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference | MonitoringSloWindowsBasedSliMetricSumInRange): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSliMetricSumInRange | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSliMetricSumInRange | undefined);
    private _timeSeries?;
    /**
     * @stability stable
     */
    get timeSeries(): string;
    /**
     * @stability stable
     */
    set timeSeries(value: string);
    /**
     * @stability stable
     */
    get timeSeriesInput(): string | undefined;
    private _range;
    /**
     * @stability stable
     */
    get range(): MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference;
    /**
     * @stability stable
     */
    putRange(value: MonitoringSloWindowsBasedSliMetricSumInRangeRange): void;
    /**
     * @stability stable
     */
    get rangeInput(): MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSli {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) with ValueType = BOOL. The window is good if any true values appear in the window. One of 'good_bad_metric_filter', 'good_total_ratio_threshold', 'metric_mean_in_range', 'metric_sum_in_range' must be set for 'windows_based_sli'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_bad_metric_filter MonitoringSlo#good_bad_metric_filter}
     *
     * @stability stable
     */
    readonly goodBadMetricFilter?: string;
    /**
     * Duration over which window quality is evaluated, given as a duration string "{X}s" representing X seconds.
     *
     * Must be an
     * integer fraction of a day and at least 60s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#window_period MonitoringSlo#window_period}
     *
     * @stability stable
     */
    readonly windowPeriod?: string;
    /**
     * good_total_ratio_threshold block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_total_ratio_threshold MonitoringSlo#good_total_ratio_threshold}
     *
     * @stability stable
     */
    readonly goodTotalRatioThreshold?: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold;
    /**
     * metric_mean_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#metric_mean_in_range MonitoringSlo#metric_mean_in_range}
     *
     * @stability stable
     */
    readonly metricMeanInRange?: MonitoringSloWindowsBasedSliMetricMeanInRange;
    /**
     * metric_sum_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#metric_sum_in_range MonitoringSlo#metric_sum_in_range}
     *
     * @stability stable
     */
    readonly metricSumInRange?: MonitoringSloWindowsBasedSliMetricSumInRange;
}
export declare function monitoringSloWindowsBasedSliToTerraform(struct?: MonitoringSloWindowsBasedSliOutputReference | MonitoringSloWindowsBasedSli): any;
/**
 * @stability stable
 */
export declare class MonitoringSloWindowsBasedSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringSloWindowsBasedSli | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringSloWindowsBasedSli | undefined);
    private _goodBadMetricFilter?;
    /**
     * @stability stable
     */
    get goodBadMetricFilter(): string;
    /**
     * @stability stable
     */
    set goodBadMetricFilter(value: string);
    /**
     * @stability stable
     */
    resetGoodBadMetricFilter(): void;
    /**
     * @stability stable
     */
    get goodBadMetricFilterInput(): string | undefined;
    private _windowPeriod?;
    /**
     * @stability stable
     */
    get windowPeriod(): string;
    /**
     * @stability stable
     */
    set windowPeriod(value: string);
    /**
     * @stability stable
     */
    resetWindowPeriod(): void;
    /**
     * @stability stable
     */
    get windowPeriodInput(): string | undefined;
    private _goodTotalRatioThreshold;
    /**
     * @stability stable
     */
    get goodTotalRatioThreshold(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference;
    /**
     * @stability stable
     */
    putGoodTotalRatioThreshold(value: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold): void;
    /**
     * @stability stable
     */
    resetGoodTotalRatioThreshold(): void;
    /**
     * @stability stable
     */
    get goodTotalRatioThresholdInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    private _metricMeanInRange;
    /**
     * @stability stable
     */
    get metricMeanInRange(): MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference;
    /**
     * @stability stable
     */
    putMetricMeanInRange(value: MonitoringSloWindowsBasedSliMetricMeanInRange): void;
    /**
     * @stability stable
     */
    resetMetricMeanInRange(): void;
    /**
     * @stability stable
     */
    get metricMeanInRangeInput(): MonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    private _metricSumInRange;
    /**
     * @stability stable
     */
    get metricSumInRange(): MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference;
    /**
     * @stability stable
     */
    putMetricSumInRange(value: MonitoringSloWindowsBasedSliMetricSumInRange): void;
    /**
     * @stability stable
     */
    resetMetricSumInRange(): void;
    /**
     * @stability stable
     */
    get metricSumInRangeInput(): MonitoringSloWindowsBasedSliMetricSumInRange | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo google_monitoring_slo}.
 *
 * @stability stable
 */
export declare class MonitoringSlo extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo google_monitoring_slo} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringSloConfig);
    private _calendarPeriod?;
    /**
     * @stability stable
     */
    get calendarPeriod(): string;
    /**
     * @stability stable
     */
    set calendarPeriod(value: string);
    /**
     * @stability stable
     */
    resetCalendarPeriod(): void;
    /**
     * @stability stable
     */
    get calendarPeriodInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _goal?;
    /**
     * @stability stable
     */
    get goal(): number;
    /**
     * @stability stable
     */
    set goal(value: number);
    /**
     * @stability stable
     */
    get goalInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _rollingPeriodDays?;
    /**
     * @stability stable
     */
    get rollingPeriodDays(): number;
    /**
     * @stability stable
     */
    set rollingPeriodDays(value: number);
    /**
     * @stability stable
     */
    resetRollingPeriodDays(): void;
    /**
     * @stability stable
     */
    get rollingPeriodDaysInput(): number | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _sloId?;
    /**
     * @stability stable
     */
    get sloId(): string;
    /**
     * @stability stable
     */
    set sloId(value: string);
    /**
     * @stability stable
     */
    resetSloId(): void;
    /**
     * @stability stable
     */
    get sloIdInput(): string | undefined;
    private _basicSli;
    /**
     * @stability stable
     */
    get basicSli(): MonitoringSloBasicSliOutputReference;
    /**
     * @stability stable
     */
    putBasicSli(value: MonitoringSloBasicSli): void;
    /**
     * @stability stable
     */
    resetBasicSli(): void;
    /**
     * @stability stable
     */
    get basicSliInput(): MonitoringSloBasicSli | undefined;
    private _requestBasedSli;
    /**
     * @stability stable
     */
    get requestBasedSli(): MonitoringSloRequestBasedSliOutputReference;
    /**
     * @stability stable
     */
    putRequestBasedSli(value: MonitoringSloRequestBasedSli): void;
    /**
     * @stability stable
     */
    resetRequestBasedSli(): void;
    /**
     * @stability stable
     */
    get requestBasedSliInput(): MonitoringSloRequestBasedSli | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringSloTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringSloTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringSloTimeouts | undefined;
    private _windowsBasedSli;
    /**
     * @stability stable
     */
    get windowsBasedSli(): MonitoringSloWindowsBasedSliOutputReference;
    /**
     * @stability stable
     */
    putWindowsBasedSli(value: MonitoringSloWindowsBasedSli): void;
    /**
     * @stability stable
     */
    resetWindowsBasedSli(): void;
    /**
     * @stability stable
     */
    get windowsBasedSliInput(): MonitoringSloWindowsBasedSli | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
