import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectUsageExportBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * The bucket to store reports in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket#bucket_name ProjectUsageExportBucket#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * A prefix for the reports, for instance, the project name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket#prefix ProjectUsageExportBucket#prefix}
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * The project to set the export bucket on. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket#project ProjectUsageExportBucket#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket#timeouts ProjectUsageExportBucket#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectUsageExportBucketTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectUsageExportBucketTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket#create ProjectUsageExportBucket#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket#delete ProjectUsageExportBucket#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function projectUsageExportBucketTimeoutsToTerraform(struct?: ProjectUsageExportBucketTimeoutsOutputReference | ProjectUsageExportBucketTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ProjectUsageExportBucketTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectUsageExportBucketTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectUsageExportBucketTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket google_project_usage_export_bucket}.
 *
 * @stability stable
 */
export declare class ProjectUsageExportBucket extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket google_project_usage_export_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectUsageExportBucketConfig);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _prefix?;
    /**
     * @stability stable
     */
    get prefix(): string;
    /**
     * @stability stable
     */
    set prefix(value: string);
    /**
     * @stability stable
     */
    resetPrefix(): void;
    /**
     * @stability stable
     */
    get prefixInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ProjectUsageExportBucketTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ProjectUsageExportBucketTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectUsageExportBucketTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
