import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecretManagerSecretVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * The current state of the SecretVersion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#enabled SecretManagerSecretVersion#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Secret Manager secret resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#secret SecretManagerSecretVersion#secret}
     *
     * @stability stable
     */
    readonly secret: string;
    /**
     * The secret data. Must be no larger than 64KiB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#secret_data SecretManagerSecretVersion#secret_data}
     *
     * @stability stable
     */
    readonly secretData: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#timeouts SecretManagerSecretVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecretManagerSecretVersionTimeouts;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#create SecretManagerSecretVersion#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version#delete SecretManagerSecretVersion#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function secretManagerSecretVersionTimeoutsToTerraform(struct?: SecretManagerSecretVersionTimeoutsOutputReference | SecretManagerSecretVersionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretVersionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version google_secret_manager_secret_version}.
 *
 * @stability stable
 */
export declare class SecretManagerSecretVersion extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version google_secret_manager_secret_version} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretVersionConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get destroyTime(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): string;
    /**
     * @stability stable
     */
    set secret(value: string);
    /**
     * @stability stable
     */
    get secretInput(): string | undefined;
    private _secretData?;
    /**
     * @stability stable
     */
    get secretData(): string;
    /**
     * @stability stable
     */
    set secretData(value: string);
    /**
     * @stability stable
     */
    get secretDataInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecretManagerSecretVersionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecretManagerSecretVersionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecretManagerSecretVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
