import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The MySQL, PostgreSQL or SQL Server (beta) version to use.
     *
     * Supported values include MYSQL_5_6, MYSQL_5_7, MYSQL_8_0, POSTGRES_9_6, POSTGRES_10, POSTGRES_11, POSTGRES_12, POSTGRES_13, SQLSERVER_2017_STANDARD, SQLSERVER_2017_ENTERPRISE, SQLSERVER_2017_EXPRESS, SQLSERVER_2017_WEB. Database Version Policies includes an up-to-date reference of supported versions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#database_version SqlDatabaseInstance#database_version}
     *
     * @stability stable
     */
    readonly databaseVersion?: string;
    /**
     * Used to block Terraform from deleting a SQL Instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#deletion_protection SqlDatabaseInstance#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The name of the instance that will act as the master in the replication setup.
     *
     * Note, this requires the master to have binary_log_enabled set, as well as existing backups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#master_instance_name SqlDatabaseInstance#master_instance_name}
     *
     * @stability stable
     */
    readonly masterInstanceName?: string;
    /**
     * The name of the instance.
     *
     * If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#name SqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#project SqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region the instance will sit in.
     *
     * Note, Cloud SQL is not available in all regions. A valid region must be provided to use this resource. If a region is not provided in the resource definition, the provider region will be used instead, but this will be an apply-time error for instances if the provider region is not supported with Cloud SQL. If you choose not to provide the region argument for this resource, make sure you understand this.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#region SqlDatabaseInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#root_password SqlDatabaseInstance#root_password}
     *
     * @stability stable
     */
    readonly rootPassword?: string;
    /**
     * clone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#clone SqlDatabaseInstance#clone}
     *
     * @stability stable
     */
    readonly clone?: SqlDatabaseInstanceClone;
    /**
     * replica_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#replica_configuration SqlDatabaseInstance#replica_configuration}
     *
     * @stability stable
     */
    readonly replicaConfiguration?: SqlDatabaseInstanceReplicaConfiguration;
    /**
     * restore_backup_context block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#restore_backup_context SqlDatabaseInstance#restore_backup_context}
     *
     * @stability stable
     */
    readonly restoreBackupContext?: SqlDatabaseInstanceRestoreBackupContext;
    /**
     * settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#settings SqlDatabaseInstance#settings}
     *
     * @stability stable
     */
    readonly settings?: SqlDatabaseInstanceSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#timeouts SqlDatabaseInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlDatabaseInstanceTimeouts;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get timeToRetire(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceClone {
    /**
     * The timestamp of the point in time that should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#point_in_time SqlDatabaseInstance#point_in_time}
     *
     * @stability stable
     */
    readonly pointInTime?: string;
    /**
     * The name of the instance from which the point in time should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#source_instance_name SqlDatabaseInstance#source_instance_name}
     *
     * @stability stable
     */
    readonly sourceInstanceName: string;
}
export declare function sqlDatabaseInstanceCloneToTerraform(struct?: SqlDatabaseInstanceCloneOutputReference | SqlDatabaseInstanceClone): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceCloneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceClone | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceClone | undefined);
    private _pointInTime?;
    /**
     * @stability stable
     */
    get pointInTime(): string;
    /**
     * @stability stable
     */
    set pointInTime(value: string);
    /**
     * @stability stable
     */
    resetPointInTime(): void;
    /**
     * @stability stable
     */
    get pointInTimeInput(): string | undefined;
    private _sourceInstanceName?;
    /**
     * @stability stable
     */
    get sourceInstanceName(): string;
    /**
     * @stability stable
     */
    set sourceInstanceName(value: string);
    /**
     * @stability stable
     */
    get sourceInstanceNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceReplicaConfiguration {
    /**
     * PEM representation of the trusted CA's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ca_certificate SqlDatabaseInstance#ca_certificate}
     *
     * @stability stable
     */
    readonly caCertificate?: string;
    /**
     * PEM representation of the replica's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#client_certificate SqlDatabaseInstance#client_certificate}
     *
     * @stability stable
     */
    readonly clientCertificate?: string;
    /**
     * PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#client_key SqlDatabaseInstance#client_key}
     *
     * @stability stable
     */
    readonly clientKey?: string;
    /**
     * The number of seconds between connect retries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#connect_retry_interval SqlDatabaseInstance#connect_retry_interval}
     *
     * @stability stable
     */
    readonly connectRetryInterval?: number;
    /**
     * Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#dump_file_path SqlDatabaseInstance#dump_file_path}
     *
     * @stability stable
     */
    readonly dumpFilePath?: string;
    /**
     * Specifies if the replica is the failover target.
     *
     * If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#failover_target SqlDatabaseInstance#failover_target}
     *
     * @stability stable
     */
    readonly failoverTarget?: boolean | cdktf.IResolvable;
    /**
     * Time in ms between replication heartbeats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#master_heartbeat_period SqlDatabaseInstance#master_heartbeat_period}
     *
     * @stability stable
     */
    readonly masterHeartbeatPeriod?: number;
    /**
     * Password for the replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#password SqlDatabaseInstance#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Permissible ciphers for use in SSL encryption.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ssl_cipher SqlDatabaseInstance#ssl_cipher}
     *
     * @stability stable
     */
    readonly sslCipher?: string;
    /**
     * Username for replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#username SqlDatabaseInstance#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * True if the master's common name value is checked during the SSL handshake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#verify_server_certificate SqlDatabaseInstance#verify_server_certificate}
     *
     * @stability stable
     */
    readonly verifyServerCertificate?: boolean | cdktf.IResolvable;
}
export declare function sqlDatabaseInstanceReplicaConfigurationToTerraform(struct?: SqlDatabaseInstanceReplicaConfigurationOutputReference | SqlDatabaseInstanceReplicaConfiguration): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceReplicaConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceReplicaConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceReplicaConfiguration | undefined);
    private _caCertificate?;
    /**
     * @stability stable
     */
    get caCertificate(): string;
    /**
     * @stability stable
     */
    set caCertificate(value: string);
    /**
     * @stability stable
     */
    resetCaCertificate(): void;
    /**
     * @stability stable
     */
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    set clientCertificate(value: string);
    /**
     * @stability stable
     */
    resetClientCertificate(): void;
    /**
     * @stability stable
     */
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    set clientKey(value: string);
    /**
     * @stability stable
     */
    resetClientKey(): void;
    /**
     * @stability stable
     */
    get clientKeyInput(): string | undefined;
    private _connectRetryInterval?;
    /**
     * @stability stable
     */
    get connectRetryInterval(): number;
    /**
     * @stability stable
     */
    set connectRetryInterval(value: number);
    /**
     * @stability stable
     */
    resetConnectRetryInterval(): void;
    /**
     * @stability stable
     */
    get connectRetryIntervalInput(): number | undefined;
    private _dumpFilePath?;
    /**
     * @stability stable
     */
    get dumpFilePath(): string;
    /**
     * @stability stable
     */
    set dumpFilePath(value: string);
    /**
     * @stability stable
     */
    resetDumpFilePath(): void;
    /**
     * @stability stable
     */
    get dumpFilePathInput(): string | undefined;
    private _failoverTarget?;
    /**
     * @stability stable
     */
    get failoverTarget(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set failoverTarget(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFailoverTarget(): void;
    /**
     * @stability stable
     */
    get failoverTargetInput(): boolean | cdktf.IResolvable | undefined;
    private _masterHeartbeatPeriod?;
    /**
     * @stability stable
     */
    get masterHeartbeatPeriod(): number;
    /**
     * @stability stable
     */
    set masterHeartbeatPeriod(value: number);
    /**
     * @stability stable
     */
    resetMasterHeartbeatPeriod(): void;
    /**
     * @stability stable
     */
    get masterHeartbeatPeriodInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sslCipher?;
    /**
     * @stability stable
     */
    get sslCipher(): string;
    /**
     * @stability stable
     */
    set sslCipher(value: string);
    /**
     * @stability stable
     */
    resetSslCipher(): void;
    /**
     * @stability stable
     */
    get sslCipherInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _verifyServerCertificate?;
    /**
     * @stability stable
     */
    get verifyServerCertificate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set verifyServerCertificate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVerifyServerCertificate(): void;
    /**
     * @stability stable
     */
    get verifyServerCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceRestoreBackupContext {
    /**
     * The ID of the backup run to restore from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#backup_run_id SqlDatabaseInstance#backup_run_id}
     *
     * @stability stable
     */
    readonly backupRunId: number;
    /**
     * The ID of the instance that the backup was taken from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#instance_id SqlDatabaseInstance#instance_id}
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * The full project ID of the source instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#project SqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
}
export declare function sqlDatabaseInstanceRestoreBackupContextToTerraform(struct?: SqlDatabaseInstanceRestoreBackupContextOutputReference | SqlDatabaseInstanceRestoreBackupContext): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceRestoreBackupContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceRestoreBackupContext | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceRestoreBackupContext | undefined);
    private _backupRunId?;
    /**
     * @stability stable
     */
    get backupRunId(): number;
    /**
     * @stability stable
     */
    set backupRunId(value: number);
    /**
     * @stability stable
     */
    get backupRunIdInput(): number | undefined;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    set instanceId(value: string);
    /**
     * @stability stable
     */
    resetInstanceId(): void;
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings {
    /**
     * Number of backups to retain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#retained_backups SqlDatabaseInstance#retained_backups}
     *
     * @stability stable
     */
    readonly retainedBackups: number;
    /**
     * The unit that 'retainedBackups' represents. Defaults to COUNT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#retention_unit SqlDatabaseInstance#retention_unit}
     *
     * @stability stable
     */
    readonly retentionUnit?: string;
}
export declare function sqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsToTerraform(struct?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference | SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined);
    private _retainedBackups?;
    /**
     * @stability stable
     */
    get retainedBackups(): number;
    /**
     * @stability stable
     */
    set retainedBackups(value: number);
    /**
     * @stability stable
     */
    get retainedBackupsInput(): number | undefined;
    private _retentionUnit?;
    /**
     * @stability stable
     */
    get retentionUnit(): string;
    /**
     * @stability stable
     */
    set retentionUnit(value: string);
    /**
     * @stability stable
     */
    resetRetentionUnit(): void;
    /**
     * @stability stable
     */
    get retentionUnitInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsBackupConfiguration {
    /**
     * True if binary logging is enabled.
     *
     * If settings.backup_configuration.enabled is false, this must be as well. Cannot be used with Postgres.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#binary_log_enabled SqlDatabaseInstance#binary_log_enabled}
     *
     * @stability stable
     */
    readonly binaryLogEnabled?: boolean | cdktf.IResolvable;
    /**
     * True if backup configuration is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#enabled SqlDatabaseInstance#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Location of the backup configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#location SqlDatabaseInstance#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * True if Point-in-time recovery is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#point_in_time_recovery_enabled SqlDatabaseInstance#point_in_time_recovery_enabled}
     *
     * @stability stable
     */
    readonly pointInTimeRecoveryEnabled?: boolean | cdktf.IResolvable;
    /**
     * HH:MM format time indicating when backup configuration starts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#start_time SqlDatabaseInstance#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * The number of days of transaction logs we retain for point in time restore, from 1-7.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#transaction_log_retention_days SqlDatabaseInstance#transaction_log_retention_days}
     *
     * @stability stable
     */
    readonly transactionLogRetentionDays?: number;
    /**
     * backup_retention_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#backup_retention_settings SqlDatabaseInstance#backup_retention_settings}
     *
     * @stability stable
     */
    readonly backupRetentionSettings?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings;
}
export declare function sqlDatabaseInstanceSettingsBackupConfigurationToTerraform(struct?: SqlDatabaseInstanceSettingsBackupConfigurationOutputReference | SqlDatabaseInstanceSettingsBackupConfiguration): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsBackupConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettingsBackupConfiguration | undefined);
    private _binaryLogEnabled?;
    /**
     * @stability stable
     */
    get binaryLogEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set binaryLogEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBinaryLogEnabled(): void;
    /**
     * @stability stable
     */
    get binaryLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _pointInTimeRecoveryEnabled?;
    /**
     * @stability stable
     */
    get pointInTimeRecoveryEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set pointInTimeRecoveryEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPointInTimeRecoveryEnabled(): void;
    /**
     * @stability stable
     */
    get pointInTimeRecoveryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _transactionLogRetentionDays?;
    /**
     * @stability stable
     */
    get transactionLogRetentionDays(): number;
    /**
     * @stability stable
     */
    set transactionLogRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetTransactionLogRetentionDays(): void;
    /**
     * @stability stable
     */
    get transactionLogRetentionDaysInput(): number | undefined;
    private _backupRetentionSettings;
    /**
     * @stability stable
     */
    get backupRetentionSettings(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference;
    /**
     * @stability stable
     */
    putBackupRetentionSettings(value: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings): void;
    /**
     * @stability stable
     */
    resetBackupRetentionSettings(): void;
    /**
     * @stability stable
     */
    get backupRetentionSettingsInput(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsDatabaseFlags {
    /**
     * Name of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#name SqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Value of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#value SqlDatabaseInstance#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function sqlDatabaseInstanceSettingsDatabaseFlagsToTerraform(struct?: SqlDatabaseInstanceSettingsDatabaseFlags | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsInsightsConfig {
    /**
     * True if Query Insights feature is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#query_insights_enabled SqlDatabaseInstance#query_insights_enabled}
     *
     * @stability stable
     */
    readonly queryInsightsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#query_string_length SqlDatabaseInstance#query_string_length}
     *
     * @stability stable
     */
    readonly queryStringLength?: number;
    /**
     * True if Query Insights will record application tags from query when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#record_application_tags SqlDatabaseInstance#record_application_tags}
     *
     * @stability stable
     */
    readonly recordApplicationTags?: boolean | cdktf.IResolvable;
    /**
     * True if Query Insights will record client address when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#record_client_address SqlDatabaseInstance#record_client_address}
     *
     * @stability stable
     */
    readonly recordClientAddress?: boolean | cdktf.IResolvable;
}
export declare function sqlDatabaseInstanceSettingsInsightsConfigToTerraform(struct?: SqlDatabaseInstanceSettingsInsightsConfigOutputReference | SqlDatabaseInstanceSettingsInsightsConfig): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsInsightsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettingsInsightsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettingsInsightsConfig | undefined);
    private _queryInsightsEnabled?;
    /**
     * @stability stable
     */
    get queryInsightsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set queryInsightsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetQueryInsightsEnabled(): void;
    /**
     * @stability stable
     */
    get queryInsightsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringLength?;
    /**
     * @stability stable
     */
    get queryStringLength(): number;
    /**
     * @stability stable
     */
    set queryStringLength(value: number);
    /**
     * @stability stable
     */
    resetQueryStringLength(): void;
    /**
     * @stability stable
     */
    get queryStringLengthInput(): number | undefined;
    private _recordApplicationTags?;
    /**
     * @stability stable
     */
    get recordApplicationTags(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set recordApplicationTags(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRecordApplicationTags(): void;
    /**
     * @stability stable
     */
    get recordApplicationTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _recordClientAddress?;
    /**
     * @stability stable
     */
    get recordClientAddress(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set recordClientAddress(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRecordClientAddress(): void;
    /**
     * @stability stable
     */
    get recordClientAddressInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#expiration_time SqlDatabaseInstance#expiration_time}.
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#name SqlDatabaseInstance#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#value SqlDatabaseInstance#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function sqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksToTerraform(struct?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsIpConfiguration {
    /**
     * Whether this Cloud SQL instance should be assigned a public IPV4 address.
     *
     * At least ipv4_enabled must be enabled or a private_network must be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ipv4_enabled SqlDatabaseInstance#ipv4_enabled}
     *
     * @stability stable
     */
    readonly ipv4Enabled?: boolean | cdktf.IResolvable;
    /**
     * The VPC network from which the Cloud SQL instance is accessible for private IP.
     *
     * For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#private_network SqlDatabaseInstance#private_network}
     *
     * @stability stable
     */
    readonly privateNetwork?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#require_ssl SqlDatabaseInstance#require_ssl}.
     *
     * @stability stable
     */
    readonly requireSsl?: boolean | cdktf.IResolvable;
    /**
     * authorized_networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#authorized_networks SqlDatabaseInstance#authorized_networks}
     *
     * @stability stable
     */
    readonly authorizedNetworks?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | cdktf.IResolvable;
}
export declare function sqlDatabaseInstanceSettingsIpConfigurationToTerraform(struct?: SqlDatabaseInstanceSettingsIpConfigurationOutputReference | SqlDatabaseInstanceSettingsIpConfiguration): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettingsIpConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettingsIpConfiguration | undefined);
    private _ipv4Enabled?;
    /**
     * @stability stable
     */
    get ipv4Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipv4Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpv4Enabled(): void;
    /**
     * @stability stable
     */
    get ipv4EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateNetwork?;
    /**
     * @stability stable
     */
    get privateNetwork(): string;
    /**
     * @stability stable
     */
    set privateNetwork(value: string);
    /**
     * @stability stable
     */
    resetPrivateNetwork(): void;
    /**
     * @stability stable
     */
    get privateNetworkInput(): string | undefined;
    private _requireSsl?;
    /**
     * @stability stable
     */
    get requireSsl(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireSsl(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireSsl(): void;
    /**
     * @stability stable
     */
    get requireSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizedNetworks?;
    /**
     * @stability stable
     */
    get authorizedNetworks(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set authorizedNetworks(value: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAuthorizedNetworks(): void;
    /**
     * @stability stable
     */
    get authorizedNetworksInput(): cdktf.IResolvable | SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsLocationPreference {
    /**
     * A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#follow_gae_application SqlDatabaseInstance#follow_gae_application}
     *
     * @stability stable
     */
    readonly followGaeApplication?: string;
    /**
     * The preferred compute engine zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#zone SqlDatabaseInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
export declare function sqlDatabaseInstanceSettingsLocationPreferenceToTerraform(struct?: SqlDatabaseInstanceSettingsLocationPreferenceOutputReference | SqlDatabaseInstanceSettingsLocationPreference): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsLocationPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettingsLocationPreference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettingsLocationPreference | undefined);
    private _followGaeApplication?;
    /**
     * @stability stable
     */
    get followGaeApplication(): string;
    /**
     * @stability stable
     */
    set followGaeApplication(value: string);
    /**
     * @stability stable
     */
    resetFollowGaeApplication(): void;
    /**
     * @stability stable
     */
    get followGaeApplicationInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsMaintenanceWindow {
    /**
     * Day of week (1-7), starting on Monday.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#day SqlDatabaseInstance#day}
     *
     * @stability stable
     */
    readonly day?: number;
    /**
     * Hour of day (0-23), ignored if day not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#hour SqlDatabaseInstance#hour}
     *
     * @stability stable
     */
    readonly hour?: number;
    /**
     * Receive updates earlier (canary) or later (stable).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#update_track SqlDatabaseInstance#update_track}
     *
     * @stability stable
     */
    readonly updateTrack?: string;
}
export declare function sqlDatabaseInstanceSettingsMaintenanceWindowToTerraform(struct?: SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference | SqlDatabaseInstanceSettingsMaintenanceWindow): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettingsMaintenanceWindow | undefined);
    private _day?;
    /**
     * @stability stable
     */
    get day(): number;
    /**
     * @stability stable
     */
    set day(value: number);
    /**
     * @stability stable
     */
    resetDay(): void;
    /**
     * @stability stable
     */
    get dayInput(): number | undefined;
    private _hour?;
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    set hour(value: number);
    /**
     * @stability stable
     */
    resetHour(): void;
    /**
     * @stability stable
     */
    get hourInput(): number | undefined;
    private _updateTrack?;
    /**
     * @stability stable
     */
    get updateTrack(): string;
    /**
     * @stability stable
     */
    set updateTrack(value: string);
    /**
     * @stability stable
     */
    resetUpdateTrack(): void;
    /**
     * @stability stable
     */
    get updateTrackInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettings {
    /**
     * This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#activation_policy SqlDatabaseInstance#activation_policy}
     *
     * @stability stable
     */
    readonly activationPolicy?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see https://cloud.google.com/sql/docs/mysql/deprecation-notice for information on how to upgrade to Second Generation instances. A list of Google App Engine project names that are allowed to access this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#authorized_gae_applications SqlDatabaseInstance#authorized_gae_applications}
     *
     * @stability stable
     */
    readonly authorizedGaeApplications?: string[];
    /**
     * The availability type of the Cloud SQL instance, high availability (REGIONAL) or single zone (ZONAL).
     *
     * For MySQL instances, ensure that
     * settings.backup_configuration.enabled and
     * settings.backup_configuration.binary_log_enabled are both set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#availability_type SqlDatabaseInstance#availability_type}
     *
     * @stability stable
     */
    readonly availabilityType?: string;
    /**
     * The name of server instance collation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#collation SqlDatabaseInstance#collation}
     *
     * @stability stable
     */
    readonly collation?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Specific to read instances, indicates when crash-safe replication flags are enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#crash_safe_replication SqlDatabaseInstance#crash_safe_replication}
     *
     * @stability stable
     */
    readonly crashSafeReplication?: boolean | cdktf.IResolvable;
    /**
     * Configuration to increase storage size automatically.
     *
     * Note that future terraform apply calls will attempt to resize the disk to the value specified in disk_size - if this is set, do not set disk_size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_autoresize SqlDatabaseInstance#disk_autoresize}
     *
     * @stability stable
     */
    readonly diskAutoresize?: boolean | cdktf.IResolvable;
    /**
     * The maximum size, in GB, to which storage capacity can be automatically increased.
     *
     * The default value is 0, which specifies that there is no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_autoresize_limit SqlDatabaseInstance#disk_autoresize_limit}
     *
     * @stability stable
     */
    readonly diskAutoresizeLimit?: number;
    /**
     * The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_size SqlDatabaseInstance#disk_size}
     *
     * @stability stable
     */
    readonly diskSize?: number;
    /**
     * The type of data disk: PD_SSD or PD_HDD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_type SqlDatabaseInstance#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * Pricing plan for this instance, can only be PER_USE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#pricing_plan SqlDatabaseInstance#pricing_plan}
     *
     * @stability stable
     */
    readonly pricingPlan?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Replication type for this instance, can be one of ASYNCHRONOUS or SYNCHRONOUS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#replication_type SqlDatabaseInstance#replication_type}
     *
     * @stability stable
     */
    readonly replicationType?: string;
    /**
     * The machine type to use.
     *
     * See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#tier SqlDatabaseInstance#tier}
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * A set of key/value user label pairs to assign to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#user_labels SqlDatabaseInstance#user_labels}
     *
     * @stability stable
     */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
     * backup_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#backup_configuration SqlDatabaseInstance#backup_configuration}
     *
     * @stability stable
     */
    readonly backupConfiguration?: SqlDatabaseInstanceSettingsBackupConfiguration;
    /**
     * database_flags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#database_flags SqlDatabaseInstance#database_flags}
     *
     * @stability stable
     */
    readonly databaseFlags?: SqlDatabaseInstanceSettingsDatabaseFlags[] | cdktf.IResolvable;
    /**
     * insights_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#insights_config SqlDatabaseInstance#insights_config}
     *
     * @stability stable
     */
    readonly insightsConfig?: SqlDatabaseInstanceSettingsInsightsConfig;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ip_configuration SqlDatabaseInstance#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration?: SqlDatabaseInstanceSettingsIpConfiguration;
    /**
     * location_preference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#location_preference SqlDatabaseInstance#location_preference}
     *
     * @stability stable
     */
    readonly locationPreference?: SqlDatabaseInstanceSettingsLocationPreference;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#maintenance_window SqlDatabaseInstance#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: SqlDatabaseInstanceSettingsMaintenanceWindow;
}
export declare function sqlDatabaseInstanceSettingsToTerraform(struct?: SqlDatabaseInstanceSettingsOutputReference | SqlDatabaseInstanceSettings): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceSettings | undefined);
    private _activationPolicy?;
    /**
     * @stability stable
     */
    get activationPolicy(): string;
    /**
     * @stability stable
     */
    set activationPolicy(value: string);
    /**
     * @stability stable
     */
    resetActivationPolicy(): void;
    /**
     * @stability stable
     */
    get activationPolicyInput(): string | undefined;
    private _authorizedGaeApplications?;
    /**
     * @stability stable
     */
    get authorizedGaeApplications(): string[];
    /**
     * @stability stable
     */
    set authorizedGaeApplications(value: string[]);
    /**
     * @stability stable
     */
    resetAuthorizedGaeApplications(): void;
    /**
     * @stability stable
     */
    get authorizedGaeApplicationsInput(): string[] | undefined;
    private _availabilityType?;
    /**
     * @stability stable
     */
    get availabilityType(): string;
    /**
     * @stability stable
     */
    set availabilityType(value: string);
    /**
     * @stability stable
     */
    resetAvailabilityType(): void;
    /**
     * @stability stable
     */
    get availabilityTypeInput(): string | undefined;
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    set collation(value: string);
    /**
     * @stability stable
     */
    resetCollation(): void;
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    private _crashSafeReplication?;
    /**
     * @stability stable
     */
    get crashSafeReplication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set crashSafeReplication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCrashSafeReplication(): void;
    /**
     * @stability stable
     */
    get crashSafeReplicationInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresize?;
    /**
     * @stability stable
     */
    get diskAutoresize(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set diskAutoresize(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDiskAutoresize(): void;
    /**
     * @stability stable
     */
    get diskAutoresizeInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresizeLimit?;
    /**
     * @stability stable
     */
    get diskAutoresizeLimit(): number;
    /**
     * @stability stable
     */
    set diskAutoresizeLimit(value: number);
    /**
     * @stability stable
     */
    resetDiskAutoresizeLimit(): void;
    /**
     * @stability stable
     */
    get diskAutoresizeLimitInput(): number | undefined;
    private _diskSize?;
    /**
     * @stability stable
     */
    get diskSize(): number;
    /**
     * @stability stable
     */
    set diskSize(value: number);
    /**
     * @stability stable
     */
    resetDiskSize(): void;
    /**
     * @stability stable
     */
    get diskSizeInput(): number | undefined;
    private _diskType?;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    set diskType(value: string);
    /**
     * @stability stable
     */
    resetDiskType(): void;
    /**
     * @stability stable
     */
    get diskTypeInput(): string | undefined;
    private _pricingPlan?;
    /**
     * @stability stable
     */
    get pricingPlan(): string;
    /**
     * @stability stable
     */
    set pricingPlan(value: string);
    /**
     * @stability stable
     */
    resetPricingPlan(): void;
    /**
     * @stability stable
     */
    get pricingPlanInput(): string | undefined;
    private _replicationType?;
    /**
     * @stability stable
     */
    get replicationType(): string;
    /**
     * @stability stable
     */
    set replicationType(value: string);
    /**
     * @stability stable
     */
    resetReplicationType(): void;
    /**
     * @stability stable
     */
    get replicationTypeInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _userLabels?;
    /**
     * @stability stable
     */
    get userLabels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set userLabels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetUserLabels(): void;
    /**
     * @stability stable
     */
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get version(): number;
    private _backupConfiguration;
    /**
     * @stability stable
     */
    get backupConfiguration(): SqlDatabaseInstanceSettingsBackupConfigurationOutputReference;
    /**
     * @stability stable
     */
    putBackupConfiguration(value: SqlDatabaseInstanceSettingsBackupConfiguration): void;
    /**
     * @stability stable
     */
    resetBackupConfiguration(): void;
    /**
     * @stability stable
     */
    get backupConfigurationInput(): SqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    private _databaseFlags?;
    /**
     * @stability stable
     */
    get databaseFlags(): SqlDatabaseInstanceSettingsDatabaseFlags[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set databaseFlags(value: SqlDatabaseInstanceSettingsDatabaseFlags[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDatabaseFlags(): void;
    /**
     * @stability stable
     */
    get databaseFlagsInput(): cdktf.IResolvable | SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined;
    private _insightsConfig;
    /**
     * @stability stable
     */
    get insightsConfig(): SqlDatabaseInstanceSettingsInsightsConfigOutputReference;
    /**
     * @stability stable
     */
    putInsightsConfig(value: SqlDatabaseInstanceSettingsInsightsConfig): void;
    /**
     * @stability stable
     */
    resetInsightsConfig(): void;
    /**
     * @stability stable
     */
    get insightsConfigInput(): SqlDatabaseInstanceSettingsInsightsConfig | undefined;
    private _ipConfiguration;
    /**
     * @stability stable
     */
    get ipConfiguration(): SqlDatabaseInstanceSettingsIpConfigurationOutputReference;
    /**
     * @stability stable
     */
    putIpConfiguration(value: SqlDatabaseInstanceSettingsIpConfiguration): void;
    /**
     * @stability stable
     */
    resetIpConfiguration(): void;
    /**
     * @stability stable
     */
    get ipConfigurationInput(): SqlDatabaseInstanceSettingsIpConfiguration | undefined;
    private _locationPreference;
    /**
     * @stability stable
     */
    get locationPreference(): SqlDatabaseInstanceSettingsLocationPreferenceOutputReference;
    /**
     * @stability stable
     */
    putLocationPreference(value: SqlDatabaseInstanceSettingsLocationPreference): void;
    /**
     * @stability stable
     */
    resetLocationPreference(): void;
    /**
     * @stability stable
     */
    get locationPreferenceInput(): SqlDatabaseInstanceSettingsLocationPreference | undefined;
    private _maintenanceWindow;
    /**
     * @stability stable
     */
    get maintenanceWindow(): SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference;
    /**
     * @stability stable
     */
    putMaintenanceWindow(value: SqlDatabaseInstanceSettingsMaintenanceWindow): void;
    /**
     * @stability stable
     */
    resetMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get maintenanceWindowInput(): SqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#create SqlDatabaseInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#delete SqlDatabaseInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#update SqlDatabaseInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sqlDatabaseInstanceTimeoutsToTerraform(struct?: SqlDatabaseInstanceTimeoutsOutputReference | SqlDatabaseInstanceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance google_sql_database_instance}.
 *
 * @stability stable
 */
export declare class SqlDatabaseInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance google_sql_database_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: SqlDatabaseInstanceConfig);
    /**
     * @stability stable
     */
    get connectionName(): string;
    private _databaseVersion?;
    /**
     * @stability stable
     */
    get databaseVersion(): string;
    /**
     * @stability stable
     */
    set databaseVersion(value: string);
    /**
     * @stability stable
     */
    resetDatabaseVersion(): void;
    /**
     * @stability stable
     */
    get databaseVersionInput(): string | undefined;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get firstIpAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    ipAddress(index: string): SqlDatabaseInstanceIpAddress;
    private _masterInstanceName?;
    /**
     * @stability stable
     */
    get masterInstanceName(): string;
    /**
     * @stability stable
     */
    set masterInstanceName(value: string);
    /**
     * @stability stable
     */
    resetMasterInstanceName(): void;
    /**
     * @stability stable
     */
    get masterInstanceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _rootPassword?;
    /**
     * @stability stable
     */
    get rootPassword(): string;
    /**
     * @stability stable
     */
    set rootPassword(value: string);
    /**
     * @stability stable
     */
    resetRootPassword(): void;
    /**
     * @stability stable
     */
    get rootPasswordInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    serverCaCert(index: string): SqlDatabaseInstanceServerCaCert;
    /**
     * @stability stable
     */
    get serviceAccountEmailAddress(): string;
    private _clone;
    /**
     * @stability stable
     */
    get clone(): SqlDatabaseInstanceCloneOutputReference;
    /**
     * @stability stable
     */
    putClone(value: SqlDatabaseInstanceClone): void;
    /**
     * @stability stable
     */
    resetClone(): void;
    /**
     * @stability stable
     */
    get cloneInput(): SqlDatabaseInstanceClone | undefined;
    private _replicaConfiguration;
    /**
     * @stability stable
     */
    get replicaConfiguration(): SqlDatabaseInstanceReplicaConfigurationOutputReference;
    /**
     * @stability stable
     */
    putReplicaConfiguration(value: SqlDatabaseInstanceReplicaConfiguration): void;
    /**
     * @stability stable
     */
    resetReplicaConfiguration(): void;
    /**
     * @stability stable
     */
    get replicaConfigurationInput(): SqlDatabaseInstanceReplicaConfiguration | undefined;
    private _restoreBackupContext;
    /**
     * @stability stable
     */
    get restoreBackupContext(): SqlDatabaseInstanceRestoreBackupContextOutputReference;
    /**
     * @stability stable
     */
    putRestoreBackupContext(value: SqlDatabaseInstanceRestoreBackupContext): void;
    /**
     * @stability stable
     */
    resetRestoreBackupContext(): void;
    /**
     * @stability stable
     */
    get restoreBackupContextInput(): SqlDatabaseInstanceRestoreBackupContext | undefined;
    private _settings;
    /**
     * @stability stable
     */
    get settings(): SqlDatabaseInstanceSettingsOutputReference;
    /**
     * @stability stable
     */
    putSettings(value: SqlDatabaseInstanceSettings): void;
    /**
     * @stability stable
     */
    resetSettings(): void;
    /**
     * @stability stable
     */
    get settingsInput(): SqlDatabaseInstanceSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlDatabaseInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlDatabaseInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlDatabaseInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
