# VibroMAF - Vibrotactile Multi-Method Assessment Fusion

[![Actions Status](https://github.com/hofbi/vibromaf/workflows/CI/badge.svg)](https://github.com/hofbi/vibromaf)
[![Actions Status](https://github.com/hofbi/vibromaf/workflows/Docs/badge.svg)](https://hofbi.github.io/vibromaf)
[![Actions Status](https://github.com/hofbi/vibromaf/workflows/CodeQL/badge.svg)](https://github.com/hofbi/vibromaf)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![PyPI](https://img.shields.io/pypi/v/vibromaf)](https://pypi.org/project/vibromaf/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/vibromaf)](https://pypi.org/project/vibromaf/)
[![PyPI - License](https://img.shields.io/pypi/l/vibromaf)](https://pypi.org/project/vibromaf/)

## Vibrotactile Quality Metrics

This package provides implementations of existing vibrotactile quality metrics and machine learning approach that fuses the individual metric scores into a single final quality score.

## Installation

Install `vibromaf` from [PyPI](https://pypi.org/project/vibromaf):

```shell
pip install vibromaf
```

For development versions and alternative installations see the [installation documentation](https://hofbi.github.io/vibromaf/installation/).

## Usage

* [Get Started](https://hofbi.github.io/vibromaf/get-started/)
* [Full Documentation](https://hofbi.github.io/vibromaf/)

## Citation

If you use this work, please cite our paper ([PDF](https://www.researchgate.net/publication/357556145_Automated_Quality_Assessment_for_Compressed_Vibrotactile_Signals_Using_Multi-Method_Assessment_Fusion))

```tex
@inproceedings{noll_vibromaf,
  author    = {Noll, Andreas and  Hofbauer, Markus and  Muschter, Evelyn and  Li, Shu-Chen and  Steinbach, Eckehard},
  booktitle = {IEEE Haptics Symposium 2022},
  title     = {Automated Quality Assessment for Compressed Vibrotactile Signals Using Multi-Method Assessment Fusion},
  year      = {2022},
  volume    = {},
  number    = {},
  address   = {Santa Barabara, California, USA},
  doi       = {}
}
```

## Contribute

See our [CONTRIBUTING.md](CONTRIBUTING.md)
