import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBucketAclConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket it applies to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#bucket StorageBucketAcl#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Configure this ACL to be the default ACL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#default_acl StorageBucketAcl#default_acl}
     *
     * @stability stable
     */
    readonly defaultAcl?: string;
    /**
     * The canned GCS ACL to apply. Must be set if role_entity is not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#predefined_acl StorageBucketAcl#predefined_acl}
     *
     * @stability stable
     */
    readonly predefinedAcl?: string;
    /**
     * List of role/entity pairs in the form ROLE:entity.
     *
     * See GCS Bucket ACL documentation  for more details. Must be set if predefined_acl is not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#role_entity StorageBucketAcl#role_entity}
     *
     * @stability stable
     */
    readonly roleEntity?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html google_storage_bucket_acl}.
 *
 * @stability stable
 */
export declare class StorageBucketAcl extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html google_storage_bucket_acl} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBucketAclConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _defaultAcl?;
    /**
     * @stability stable
     */
    get defaultAcl(): string;
    /**
     * @stability stable
     */
    set defaultAcl(value: string);
    /**
     * @stability stable
     */
    resetDefaultAcl(): void;
    /**
     * @stability stable
     */
    get defaultAclInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _predefinedAcl?;
    /**
     * @stability stable
     */
    get predefinedAcl(): string;
    /**
     * @stability stable
     */
    set predefinedAcl(value: string);
    /**
     * @stability stable
     */
    resetPredefinedAcl(): void;
    /**
     * @stability stable
     */
    get predefinedAclInput(): string | undefined;
    private _roleEntity?;
    /**
     * @stability stable
     */
    get roleEntity(): string[];
    /**
     * @stability stable
     */
    set roleEntity(value: string[]);
    /**
     * @stability stable
     */
    resetRoleEntity(): void;
    /**
     * @stability stable
     */
    get roleEntityInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
