# Generated by Django 3.1rc1 on 2020-08-04 05:54

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('simple_locations', '0007_area_geom_can_be_blank'),
    ]

    operations = [
        migrations.CreateModel(
            name='AreaProfile',
            fields=[
                ('date_created', models.DateField(auto_now_add=True, null=True, verbose_name='Date Created')),
                ('date_modified', models.DateField(blank=True, null=True, verbose_name='Last Modified')),
                ('area', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='simple_locations.area')),
                ('description', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='IndicatorMeasureSchema',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('schema', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='AreaIndicator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateField(auto_now_add=True, null=True, verbose_name='Date Created')),
                ('date_modified', models.DateField(blank=True, null=True, verbose_name='Last Modified')),
                ('name', models.TextField()),
                ('measure', models.CharField(choices=[('U', 'Units'), ('P', 'Percentages'), ('N', 'Nominal'), ('O', 'Ordinal'), ('Q', 'Qualitative')], default='U', help_text='Define the unit of measure in which the value is reported.', max_length=2)),
                ('value', models.JSONField()),
                ('dimensions', models.JSONField(help_text='A category used for disaggregating the result by gender, age, etc.')),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simple_locations.area')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
