# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['gully']
setup_kwargs = {
    'name': 'gully',
    'version': '0.3.1',
    'description': 'Simple real time data stream manipulation.',
    'long_description': '# Gully\n\n[![PyPI version](https://img.shields.io/pypi/v/gully?color=informational&style=flat-square)](https://pypi.python.org/pypi/gully/)\n[![PyPI license](https://img.shields.io/pypi/l/gully?style=flat-square&color=orange)](https://lbesson.mit-license.org/)\n\nGully is a simple framework for manipulating asynchronous streams of data.\n\n## Installation\n```shell\npip install gully\n```\n\n## Usage\n```python\nimport asyncio\nimport gully\n\nasync def observer(item):\n    print(item)\n    \nasync def main():\n    stream = gully.Gully()\n    stream.watch(observer)\n    stream.add_filter(lambda item: item == "foobar")\n    stream.add_mapping(lambda item: item.upper())\n    await stream.push("foobar")\n    await stream.push("baz")\n    await stream.push("foobar")\n\nasyncio.run(main())\n```\n*Output*\n```\nFOOBAR\nFOOBAR\n```\n## Documentation\n\n### gully.Gully(watch: Sequence[Gully] = None, *, filters: Sequence[Callable], mappings: Sequence[Callable], max_size: int = -1, loop: EventLoop = None)\n\nGully is a stream. It can observe other gullies, and it can be observed by coroutines. Any number of gullies can be passed as args, the new gully will observe them to aggregate their pushes. By default gullies will retain an unlimited history of their pushes, this can be changed by setting the `max_size` keyword arg to any value greater than 0. \n\n- `property Gully.loop: asyncio.AbstractEventLoop` This is the loop that the gully will use to run observers.\n\n- `property Gully.history: gully.HistoryView` The current history of pushes to the gully. This is a view that cannot be set to. It is restricted by the `max_size` setting that was given to the gully.\n\n- `property Gully.pipeline: gully.Pipeline` The pipeline that is run when pushing a new item into the gully. The gully will only ever call the pipeline with a single argument, so all steps added to the pipeline must support only receiving a single argument.\n\n**`method Gully.push(value: Any)`**\n\nPushes a value into the gully. This will run the pipeline to map and filter the value. It will only add it to the history and call the observers if a filter doesn\'t reject the value.\n\n**`method Gully.watch(callback: Callable[[Any], Awaitable[None]])`**\n\nRegisters a coroutine to observe new values that are pushed into the gully.\n\n**`method Gully.filter(*predicates: Callable[[Any], bool], max_size: int = -1) -> Gully`**\n\nBranches the gully into a new gully which uses the given filter predicates. The branched gully can have a custom `max_size` set.\n\n**`method Gully.map(mapping: Callable[[Any], Any], max_size: int = -1) -> Gully`**\n\nBranches the gully into a new gully which uses the given mapping callbacks. The branched gully can have a custom `max_size` set.\n\n**`method Gully.add_filter(*predicates: Callable[[Any], Any])`**\n\nAdds the given filter predicates to the gully pipeline. These cannot be removed, use the filter method to create a new gully that has the desired filter predicates if they need to be disabled later.\n\nThis wraps each filter predicate in a function that will raise `NotAFilterMatch` if the filter predicate returns `False`. This will cause the pipeline to stop and push will ignore the current item, not adding it to the history and not calling the observers.\n\n**`method Gully.add_mapping(*mappings: Callable[[Any], Any])`**\n\nAdds the given mapping callbacks to the gully pipeline. These cannot be removed, use the map method to create a new gully that has the desired mapping callbacks if they need to be disabled later.\n\n**`method Gully.stop_watching(callback: Union[Callable, Observer])`**\n\nRemoves an observer from the gully. This will accept either the original callback, or an observer object that wraps that callback.\n\n### gully.Observable(gully.Gully)\n\nSimple wrapper for callback coroutines. This allows the observer to be enabled or disabled. The observer must be provided a start function that enables the callback to observer new events, and a stop function that disables it.\n\nThis can be used as a stand-in for the callback in sets/dictionaries keys or when stopping a watcher on a gully object.\n\n### gully.Pipeline\n\nA simple action pipeline that allows steps to be run in order.\n\n**`method Pipeline.add(*steps: Callable[[Any], Any])`**\n\nAdds any number of steps to the pipeline.\n\n**`method Pipeline.run(item: Any, *args, **kwargs)`**\n\nRuns the pipeline. It will replace the first argument passed with the return from prior steps.\n',
    'author': 'Zech Zimmerman',
    'author_email': 'hi@zech.codes',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ZechCodes/gully',
    'py_modules': modules,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
