# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['webauthn_rp']

package_data = \
{'': ['*']}

install_requires = \
['cbor2>=5.2.0,<6.0.0', 'cryptography>=3.4.7,<4.0.0', 'pyasn1>=0.4.8,<1.0.0']

setup_kwargs = {
    'name': 'webauthn-rp',
    'version': '0.0.11',
    'description': 'WebAuthn-RP is a Python 3 library to manage credentials that conform to the Web Authentication specification.',
    'long_description': '<p align="center">\n<br />\n<img src="https://raw.githubusercontent.com/enceladus-rex/webauthn-rp/master/docs/source/_static/webauthn-rp-logo.png" />\n</p>\n<br />\n<hr />\n\n<span>\n    <img src="https://img.shields.io/travis/com/enceladus-rex/webauthn-rp/master.svg" />\n    <img src="https://img.shields.io/readthedocs/webauthn-rp/latest.svg" />\n    <img src="https://img.shields.io/codecov/c/github/enceladus-rex/webauthn-rp/master.svg" />\n    <img src="https://img.shields.io/lgtm/grade/python/github/enceladus-rex/webauthn-rp.svg" />\n    <img src="https://img.shields.io/lgtm/alerts/github/enceladus-rex/webauthn-rp.svg" />\n</span>\n<br />\n<br />\n\nWebAuthn-RP is a Python 3 library to manage credentials that conform to the \n[Web Authentication specification](https://www.w3.org/TR/webauthn/).\n\nThe following is an overview and some highlights of the library. To see the autogenerated docs and\nthe getting started guide (which covers the Flask example under `/examples/flask`)\nplease visit the [readthedocs](https://webauthn-rp.readthedocs.io/en/latest/) page.\n\n### Overview\n\nThe aim of this project is to enable Relying Parties to easily use public key credentials\nin Python backend web applications. Support is only for Python 3.x considering that \nPython 2.x reached its end of life in early 2020. This allows for the use of many \nfeatures of Python 3 such as built-in type hinting and static type checking with mypy.\n\nThe general flow diagram for web authentication is shown in the diagrams below (from the spec):\n\n<p align="center">\n    <img src="https://raw.githubusercontent.com/enceladus-rex/webauthn-rp/master/docs/source/_static/webauthn-registration-flow-01.svg" align="center" width="750px" alt="WebAuthn Registration Flow" />\n    <h4 align="center">WebAuthn Registration Flow (Figure 1 of WebAuthn Standard)</h4>\n</p>\n\nIn the case of registration, the Relying Party server must send a challenge along with\ninformation about the user that is to be registered and the specific Relying Party to\nwhich that user is associated. This library is meant to aid in the generation of messages\nused in step 1 and the validation performed in step 6. Steps 0 and 5 are typically\nhandled by an application-specific client library while the routing and parsing operations\nof steps 1 and 6 will need to be managed by the application-specific backend although\nsome utilities are provided. Steps 2, 3, and 4, however, are completely managed by the\nbrowser and authenticator and are not part of this library. In fact, they are\nmostly covered by a different specification (the Client To Authenticator Protocol, or CTAP).\n\nAuthentication is very much like registration, however some of the message formats are\ndifferent and consequently the parsing and validation operations as well. The steps\nand how they are handled mirror those of the registration flow:\n\n<p align="center">\n    <img src="https://raw.githubusercontent.com/enceladus-rex/webauthn-rp/master/docs/source/_static/webauthn-authentication-flow-01.svg" align="center" width="750px" alt="WebAuthn Registration Flow" />\n    <h4 align="center">WebAuthn Authentication Flow (Figure 2 of WebAuthn Standard)</h4>\n</p>\n\nThe WebAuthn specification is designed for modern browsers and so most of the data\ntypes and functions have JavaScript and JSON in mind. Although all of the necessary\ndata types are provided as Python objects in the `types` module, these objects need\nto be convertable into JSON for use in the browser. The `jsonify` function provided \nin the `converters` module does this for all available data types and\nallows one to work directly with typed Python objects. There is also a `parsers` module that provides functions\nthat can take JSON objects of specific types of data and parse them into their \nPython object counterparts. Note that given JSON cannot represent raw bytes\ndirectly, bytes are base64 encoded when converted into JSON and base64 decoded\nwhen being parsed from JSON. This becomes important when passing data\nto the browser API functions described below because there, JavaScript ArrayBuffers\nare expected in place of base64 encoded strings.\n\nBoth the registration and authentication ceremonies have corresponding API functions\navailable in the browser as part of the `Navigator` interface. The available\nfunctions are `navigator.credentials.create` and `navigator.credentials.get` \nrespectively. These functions take a single options argument which corresponds to \nthe data types `CredentialCreationOptions` and `CredentialRequestOptions` \nrespectively. These data types have a number of configurable options that may \nneed to be set using nested objects. To simply their construction there are\nbuilder classes available which can also provide a way to encapsulate\nshared options across different users (see the `builders` module).\n\nAll of this is summarized in the following two tables which describe\nsome of the different functions and types that\'ll need to be considered\nwhen performing user registration and user authentication.\n\n<table align="center">\n    <caption>\n        <strong>User Registration Ceremony</strong>\n    </caption>\n    <tr>\n        <td><i>WebAuthn Browser API Function</i></td>\n        <td>navigator.credentials.create</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Options Python Data Type</i></td>\n        <td>webauthn_rp.types.CredentialCreationOptions</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Options Builder</i></td>\n        <td>webauthn_rp.builders.CredentialCreationOptionsBuilder</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Options JSON Converter</i></td>\n        <td>webauthn_rp.converters.jsonify</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Public Key Credential Parser</i></td>\n        <td>webauthn_rp.parsers.parse_public_key_credential</td>\n    </tr>\n</table>\n\n<table align="center">\n    <caption>\n        <strong>User Authentication Ceremony</strong>\n    </caption>\n    <tr>\n        <td><i>WebAuthn Browser API Function</i></td>\n        <td>navigator.credentials.get</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Options Python Data Type</i></td>\n        <td>webauthn_rp.types.CredentialRequestOptions</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Options Builder</i></td>\n        <td>webauthn_rp.builders.CredentialRequestOptionsBuilder</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Options JSON Converter</i></td>\n        <td>webauthn_rp.converters.jsonify</td>\n    </tr>\n    <tr>\n        <td><i>WebAuthn-RP Public Key Credential Parser</i></td>\n        <td>webauthn_rp.parsers.parse_public_key_credential</td>\n    </tr>\n</table>\n\nNote that `parse_public_key_credential` takes a `Dict` type corresponding to\na JSON-encoded version of the public key credential JavaScript object returned by the \nWebAuthn browser function. Data that was originally bytes is expected to have been \nencoded using standard base64. Please see the Flask example `app.html` file to\nsee how this conversion is done in JavaScript.\n\n### Examples\n\nAs mentioned, the [readthedocs](https://webauthn-rp.readthedocs.io/en/latest/) page has\na getting started guide that goes into depth with the Flask example, however, if you want\nto be able to directly run the example from this GitHub repository follow these steps\nafter cloning this project locally:\n\n1. Make sure you have a version of Python >= 3.6.1.\n2. Install poetry by following the [guide](https://python-poetry.org/docs/#installation).\n3. Open a poetry shell and install the dependencies from the project root using:\n    \n    ```bash\n    $ poetry shell\n    $ poetry install\n    $ pip install Flask Flask-SQLAlchemy\n    ```\n\n4. Run the Flask example from the root using::\n    \n    ```bash\n    $ python -m examples.flask.app\n    ```\n\n5. Open a browser to `localhost:5000` and register a credential to a username.\n6. Authenticate using the same username and credential.\n7. Exit the example program.\n\n\n### References\n\n* [WebAuthn Standard](https://www.w3.org/TR/webauthn/)\n* [WebAuthn Browser API](https://developer.mozilla.org/en-US/docs/Web/API/Web_Authentication_API)\n* [Navigator Interface](https://developer.mozilla.org/en-US/docs/Web/API/Navigator)\n',
    'author': 'enceladus-rex',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/enceladus-rex/webauthn-rp',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
